/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.lang.aidl.AidlFileType;
import com.android.tools.idea.lang.rs.AndroidRenderscriptFileType;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.compiler.AndroidAutogeneratorMode;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.ModuleSourceAutogenerating;
import org.jetbrains.android.compiler.tools.AndroidIdl;
import org.jetbrains.android.compiler.tools.AndroidRenderscript;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidAutogenerator {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.AndroidAutogenerator");

    private AndroidAutogenerator() {
    }

    private static boolean toRun(@NotNull AndroidAutogeneratorMode mode, @NotNull AndroidFacet facet, @Nullable ModuleSourceAutogenerating autogenerating, boolean force) {
        if (mode == null) {
            AndroidAutogenerator.$$$reportNull$$$0(0);
        }
        if (facet == null) {
            AndroidAutogenerator.$$$reportNull$$$0(1);
        }
        if (autogenerating == null || !AndroidAutogenerator.supportsAutogeneration(facet)) {
            return false;
        }
        if (!force && !facet.getProperties().ENABLE_SOURCES_AUTOGENERATION) {
            return false;
        }
        switch (mode) {
            case AAPT: 
            case AIDL: 
            case RENDERSCRIPT: 
            case BUILDCONFIG: {
                return true;
            }
        }
        LOG.error("Unknown autogenerator mode " + (Object)((Object)mode));
        return false;
    }

    public static boolean supportsAutogeneration(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidAutogenerator.$$$reportNull$$$0(2);
        }
        return !facet.requiresAndroidModel();
    }

    public static void run(@NotNull AndroidAutogeneratorMode mode, @NotNull AndroidFacet facet, @NotNull CompileContext context, boolean force) {
        ModuleSourceAutogenerating autogenerating;
        if (mode == null) {
            AndroidAutogenerator.$$$reportNull$$$0(3);
        }
        if (facet == null) {
            AndroidAutogenerator.$$$reportNull$$$0(4);
        }
        if (context == null) {
            AndroidAutogenerator.$$$reportNull$$$0(5);
        }
        if (!AndroidAutogenerator.toRun(mode, facet, autogenerating = ModuleSourceAutogenerating.getInstance(facet), force)) {
            return;
        }
        HashSet obsoleteFiles = new HashSet(autogenerating.getAutogeneratedFiles(mode));
        switch (mode) {
            case AAPT: {
                AndroidAutogenerator.runAapt(facet, autogenerating, context, force);
                break;
            }
            case AIDL: {
                AndroidAutogenerator.runAidl(facet, autogenerating, context);
                break;
            }
            case RENDERSCRIPT: {
                AndroidAutogenerator.runRenderscript(facet, autogenerating, context);
                break;
            }
            case BUILDCONFIG: {
                AndroidAutogenerator.runBuildConfigGenerator(facet, autogenerating, context);
                break;
            }
            default: {
                LOG.error("Unknown mode" + (Object)((Object)mode));
            }
        }
        obsoleteFiles.removeAll(autogenerating.getAutogeneratedFiles(mode));
        for (String path : obsoleteFiles) {
            File file = new File(path);
            if (!file.isFile()) continue;
            FileUtil.delete((File)file);
            CompilerUtil.refreshIOFile((File)file);
        }
    }

    private static void runBuildConfigGenerator(final @NotNull AndroidFacet facet, @NotNull ModuleSourceAutogenerating autogenerating, final @NotNull CompileContext context) {
        if (facet == null) {
            AndroidAutogenerator.$$$reportNull$$$0(6);
        }
        if (autogenerating == null) {
            AndroidAutogenerator.$$$reportNull$$$0(7);
        }
        if (context == null) {
            AndroidAutogenerator.$$$reportNull$$$0(8);
        }
        final Module module = facet.getModule();
        BuildconfigAutogenerationItem item = (BuildconfigAutogenerationItem)ApplicationManager.getApplication().runReadAction((Computable)new Computable<BuildconfigAutogenerationItem>(){

            @Nullable
            public BuildconfigAutogenerationItem compute() {
                if (module.isDisposed() || module.getProject().isDisposed()) {
                    return null;
                }
                String sourceRootPath = AndroidRootUtil.getBuildconfigGenSourceRootPath(facet);
                if (sourceRootPath == null) {
                    return null;
                }
                VirtualFile manifestFile = AndroidRootUtil.getManifestFileForCompiler(facet);
                if (manifestFile == null) {
                    context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.manifest.not.found", module.getName()), null, -1, -1);
                    return null;
                }
                Manifest manifest = AndroidUtils.loadDomElement(module, manifestFile, Manifest.class);
                if (manifest == null) {
                    context.addMessage(CompilerMessageCategory.ERROR, "Cannot parse file", manifestFile.getUrl(), -1, -1);
                    return null;
                }
                String packageName = (String)manifest.getPackage().getValue();
                if (packageName != null) {
                    packageName = packageName.trim();
                }
                if (packageName == null || packageName.length() <= 0) {
                    context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("package.not.found.error", new Object[0]), manifestFile.getUrl(), -1, -1);
                    return null;
                }
                if (!AndroidUtils.isValidAndroidPackageName(packageName)) {
                    context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("not.valid.package.name.error", packageName), manifestFile.getUrl(), -1, -1);
                    return null;
                }
                return new BuildconfigAutogenerationItem(packageName, FileUtil.toSystemDependentName((String)sourceRootPath));
            }
        });
        if (item == null) {
            return;
        }
        try {
            AndroidAutogenerator.generateStubClass(item.myPackage, new File(item.mySourceRootOsPath), "BuildConfig", "  public final static boolean DEBUG = Boolean.parseBoolean(null);\n");
            VirtualFile genSourceRoot = LocalFileSystem.getInstance().findFileByPath(item.mySourceRootOsPath);
            if (genSourceRoot != null) {
                genSourceRoot.refresh(false, true);
            }
            autogenerating.clearAutogeneratedFiles(AndroidAutogeneratorMode.BUILDCONFIG);
            VirtualFile genFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(item.mySourceRootOsPath + '/' + item.myPackage.replace('.', '/') + '/' + "BuildConfig.java");
            if (genFile != null && genFile.exists()) {
                autogenerating.markFileAutogenerated(AndroidAutogeneratorMode.BUILDCONFIG, genFile);
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    if (module.getProject().isDisposed()) {
                        return;
                    }
                    context.addMessage(CompilerMessageCategory.ERROR, "I/O error: " + e.getMessage(), null, -1, -1);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runAapt(final @NotNull AndroidFacet facet, @NotNull ModuleSourceAutogenerating autogenerating, final @NotNull CompileContext context, boolean force) {
        VirtualFile genFile;
        if (facet == null) {
            AndroidAutogenerator.$$$reportNull$$$0(9);
        }
        if (autogenerating == null) {
            AndroidAutogenerator.$$$reportNull$$$0(10);
        }
        if (context == null) {
            AndroidAutogenerator.$$$reportNull$$$0(11);
        }
        final Module module = facet.getModule();
        AptAutogenerationItem item = (AptAutogenerationItem)ApplicationManager.getApplication().runReadAction((Computable)new Computable<AptAutogenerationItem>(){

            @Nullable
            public AptAutogenerationItem compute() {
                if (module.isDisposed() || module.getProject().isDisposed()) {
                    return null;
                }
                VirtualFile manifestFile = AndroidRootUtil.getManifestFileForCompiler(facet);
                if (manifestFile == null) {
                    context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.manifest.not.found", module.getName()), null, -1, -1);
                    return null;
                }
                Manifest manifest = AndroidUtils.loadDomElement(module, manifestFile, Manifest.class);
                if (manifest == null) {
                    context.addMessage(CompilerMessageCategory.ERROR, "Cannot parse file", manifestFile.getUrl(), -1, -1);
                    return null;
                }
                String packageName = (String)manifest.getPackage().getValue();
                if (packageName != null) {
                    packageName = packageName.trim();
                }
                if (packageName == null || packageName.length() <= 0) {
                    context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("package.not.found.error", new Object[0]), manifestFile.getUrl(), -1, -1);
                    return null;
                }
                if (!AndroidUtils.isValidAndroidPackageName(packageName)) {
                    context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("not.valid.package.name.error", packageName), manifestFile.getUrl(), -1, -1);
                    return null;
                }
                String sourceRootPath = AndroidRootUtil.getAptGenSourceRootPath(facet);
                if (sourceRootPath == null) {
                    context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.apt.gen.not.specified", module.getName()), null, -1, -1);
                    return null;
                }
                HashMap genFilePath2Package = new HashMap();
                String packageDir = packageName.replace('.', '/') + '/';
                genFilePath2Package.put(packageDir + "Manifest.java", packageName);
                genFilePath2Package.put(packageDir + "R.java", packageName);
                return new AptAutogenerationItem(packageName, sourceRootPath, (Map)genFilePath2Package);
            }
        });
        if (item == null) {
            return;
        }
        if (force) {
            HashSet filesToCheck = new HashSet();
            for (String string : item.myGenFileRelPath2package.keySet()) {
                String genFileFullPath = item.myOutputDirOsPath + '/' + string;
                if (!new File(genFileFullPath).exists() || (genFile = LocalFileSystem.getInstance().findFileByPath(genFileFullPath)) == null) continue;
                filesToCheck.add(genFile);
            }
            if (!AndroidAutogenerator.ensureFilesWritable(module.getProject(), (Collection<VirtualFile>)filesToCheck)) {
                return;
            }
        }
        File tempOutDir = null;
        try {
            tempOutDir = FileUtil.createTempDirectory((String)"android_apt_autogeneration", (String)"tmp");
            AndroidAutogenerator.generateStubClasses(item.myPackage, tempOutDir, "R", "Manifest");
            for (String string : item.myGenFileRelPath2package.keySet()) {
                File srcFile = new File(tempOutDir.getPath() + '/' + string);
                if (!srcFile.isFile()) continue;
                final File dstFile = new File(item.myOutputDirOsPath + '/' + string);
                if (dstFile.exists()) {
                    if (!force) continue;
                    if (!FileUtil.delete((File)dstFile)) {
                        ApplicationManager.getApplication().runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                if (module.isDisposed() || module.getProject().isDisposed()) {
                                    return;
                                }
                                context.addMessage(CompilerMessageCategory.ERROR, "Cannot delete " + FileUtil.toSystemDependentName((String)dstFile.getPath()), null, -1, -1);
                            }
                        });
                    }
                }
                FileUtil.rename((File)srcFile, (File)dstFile);
            }
            for (Map.Entry entry : item.myGenFileRelPath2package.entrySet()) {
                String path = item.myOutputDirOsPath + '/' + (String)entry.getKey();
                String aPackage = (String)entry.getValue();
                File file = new File(path);
                CompilerUtil.refreshIOFile((File)file);
                AndroidAutogenerator.removeAllFilesWithSameName(module, file, item.myOutputDirOsPath);
                AndroidAutogenerator.removeDuplicateClasses(module, aPackage, file, item.myOutputDirOsPath);
            }
            VirtualFile genSourceRoot = LocalFileSystem.getInstance().findFileByPath(item.myOutputDirOsPath);
            if (genSourceRoot != null) {
                genSourceRoot.refresh(false, true);
            }
            autogenerating.clearAutogeneratedFiles(AndroidAutogeneratorMode.AAPT);
            for (String relPath : item.myGenFileRelPath2package.keySet()) {
                genFile = LocalFileSystem.getInstance().findFileByPath(item.myOutputDirOsPath + '/' + relPath);
                if (genFile == null || !genFile.exists()) continue;
                autogenerating.markFileAutogenerated(AndroidAutogeneratorMode.AAPT, genFile);
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    if (module.getProject().isDisposed()) {
                        return;
                    }
                    context.addMessage(CompilerMessageCategory.ERROR, "I/O error: " + e.getMessage(), null, -1, -1);
                }
            });
        }
        finally {
            if (tempOutDir != null) {
                FileUtil.delete((File)tempOutDir);
            }
        }
    }

    private static void generateStubClasses(@NotNull String aPackage, @NotNull File outputDir, String ... classNames) throws IOException {
        if (aPackage == null) {
            AndroidAutogenerator.$$$reportNull$$$0(12);
        }
        if (outputDir == null) {
            AndroidAutogenerator.$$$reportNull$$$0(13);
        }
        if (classNames == null) {
            AndroidAutogenerator.$$$reportNull$$$0(14);
        }
        assert (!aPackage.isEmpty());
        for (String className : classNames) {
            AndroidAutogenerator.generateStubClass(aPackage, outputDir, className, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateStubClass(String aPackage, File outputDir, String className, String content) throws IOException {
        File packageDir = new File(outputDir.getPath() + '/' + aPackage.replace('.', '/'));
        if (!packageDir.exists() && !packageDir.mkdirs()) {
            throw new IOException("Cannot create directory " + FileUtil.toSystemDependentName((String)packageDir.getPath()));
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File(packageDir, className + ".java")));){
            writer.write("/*___Generated_by_IDEA___*/\n\npackage " + aPackage + ";\n\n/* This stub is only used by the IDE. It is NOT the " + className + " class actually packed into the APK */\npublic final class " + className + " {\n" + content + "}");
        }
    }

    private static void patchAndMarkGeneratedFile(@NotNull AndroidFacet facet, @NotNull ModuleSourceAutogenerating autogenerating, @NotNull AndroidAutogeneratorMode mode, @NotNull VirtualFile vFile) throws IOException {
        if (facet == null) {
            AndroidAutogenerator.$$$reportNull$$$0(15);
        }
        if (autogenerating == null) {
            AndroidAutogenerator.$$$reportNull$$$0(16);
        }
        if (mode == null) {
            AndroidAutogenerator.$$$reportNull$$$0(17);
        }
        if (vFile == null) {
            AndroidAutogenerator.$$$reportNull$$$0(18);
        }
        File file = new File(vFile.getPath());
        String fileText = FileUtil.loadFile((File)file);
        FileUtil.writeToFile((File)file, (String)("/*___Generated_by_IDEA___*/\n\n" + fileText));
        autogenerating.markFileAutogenerated(mode, vFile);
    }

    private static void removeAllFilesWithSameName(final @NotNull Module module, final @NotNull File file, @NotNull String directoryPath) {
        if (module == null) {
            AndroidAutogenerator.$$$reportNull$$$0(19);
        }
        if (file == null) {
            AndroidAutogenerator.$$$reportNull$$$0(20);
        }
        if (directoryPath == null) {
            AndroidAutogenerator.$$$reportNull$$$0(21);
        }
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        VirtualFile genDir = LocalFileSystem.getInstance().findFileByPath(directoryPath);
        if (vFile == null || genDir == null) {
            return;
        }
        Collection files2 = (Collection)DumbService.getInstance((Project)module.getProject()).runReadActionInSmartMode((Computable)new Computable<Collection<VirtualFile>>(){

            @Nullable
            public Collection<VirtualFile> compute() {
                if (module.isDisposed() || module.getProject().isDisposed()) {
                    return null;
                }
                return FilenameIndex.getVirtualFilesByName((Project)module.getProject(), (String)file.getName(), (GlobalSearchScope)module.getModuleScope(false));
            }
        });
        if (files2 == null) {
            return;
        }
        final ArrayList<VirtualFile> filesToDelete = new ArrayList<VirtualFile>();
        for (VirtualFile f : files2) {
            if (Comparing.equal((Object)f, (Object)vFile) || !VfsUtilCore.isAncestor((VirtualFile)genDir, (VirtualFile)f, (boolean)true)) continue;
            filesToDelete.add(f);
        }
        if (filesToDelete.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        for (VirtualFile f : filesToDelete) {
                            if (!f.isValid() || !f.exists()) continue;
                            try {
                                f.delete((Object)module.getProject());
                            }
                            catch (IOException e) {
                                LOG.debug((Throwable)e);
                            }
                        }
                    }
                });
            }
        });
    }

    private static void runAidl(final @NotNull AndroidFacet facet, @NotNull ModuleSourceAutogenerating autogenerating, final @NotNull CompileContext context) {
        if (facet == null) {
            AndroidAutogenerator.$$$reportNull$$$0(22);
        }
        if (autogenerating == null) {
            AndroidAutogenerator.$$$reportNull$$$0(23);
        }
        if (context == null) {
            AndroidAutogenerator.$$$reportNull$$$0(24);
        }
        final Module module = facet.getModule();
        ModuleCompileScope moduleCompileScope = new ModuleCompileScope(module, false);
        VirtualFile[] files2 = moduleCompileScope.getFiles((FileType)AidlFileType.INSTANCE, true);
        ArrayList<IdlAutogenerationItem> items2 = new ArrayList<IdlAutogenerationItem>();
        for (final VirtualFile file : files2) {
            IdlAutogenerationItem item = (IdlAutogenerationItem)ApplicationManager.getApplication().runReadAction((Computable)new Computable<IdlAutogenerationItem>(){

                @Nullable
                public IdlAutogenerationItem compute() {
                    if (module.isDisposed() || module.getProject().isDisposed()) {
                        return null;
                    }
                    IAndroidTarget target = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidTarget();
                    if (target == null) {
                        context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.specify.platform", module.getName()), null, -1, -1);
                        return null;
                    }
                    String packageName = AndroidUtils.computePackageName(module, file);
                    if (packageName == null) {
                        context.addMessage(CompilerMessageCategory.ERROR, "Cannot compute package for file", file.getUrl(), -1, -1);
                        return null;
                    }
                    String sourceRootPath = AndroidRootUtil.getAidlGenSourceRootPath(facet);
                    if (sourceRootPath == null) {
                        context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.apt.gen.not.specified", module.getName()), null, -1, -1);
                        return null;
                    }
                    VirtualFile[] sourceRoots = AndroidAutogenerator.getSourceRootsForModuleAndDependencies(module, false);
                    String[] sourceRootOsPaths = AndroidCompileUtil.toOsPaths(sourceRoots);
                    String outFileOsPath = FileUtil.toSystemDependentName((String)(sourceRootPath + '/' + packageName.replace('.', '/') + '/' + file.getNameWithoutExtension() + ".java"));
                    return new IdlAutogenerationItem(file, target, outFileOsPath, sourceRootOsPaths, sourceRootPath, packageName);
                }
            });
            if (item == null) continue;
            items2.add(item);
        }
        HashSet filesToCheck = new HashSet();
        for (IdlAutogenerationItem item : items2) {
            if (!new File(FileUtil.toSystemDependentName((String)item.myFile.getPath())).exists()) continue;
            filesToCheck.add(item.myFile);
        }
        if (!AndroidAutogenerator.ensureFilesWritable(module.getProject(), (Collection<VirtualFile>)filesToCheck)) {
            return;
        }
        autogenerating.clearAutogeneratedFiles(AndroidAutogeneratorMode.AIDL);
        for (IdlAutogenerationItem item : items2) {
            VirtualFile file;
            file = item.myFile;
            String fileOsPath = FileUtil.toSystemDependentName((String)file.getPath());
            try {
                VirtualFile outFile;
                final Map messages = AndroidCompileUtil.toCompilerMessageCategoryKeys(AndroidIdl.execute((IAndroidTarget)item.myTarget, (String)fileOsPath, (String)item.myOutFileOsPath, (String[])item.mySourceRootOsPaths));
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        if (module.getProject().isDisposed()) {
                            return;
                        }
                        for (CompilerMessageCategory category : messages.keySet()) {
                            List messageList = (List)messages.get(category);
                            for (String message : messageList) {
                                context.addMessage(category, message, file.getUrl(), -1, -1);
                            }
                        }
                    }
                });
                AndroidAutogenerator.removeDuplicateClasses(module, item.myPackage, new File(item.myOutFileOsPath), item.myOutDirOsPath);
                VirtualFile genDir = LocalFileSystem.getInstance().findFileByPath(item.myOutDirOsPath);
                if (genDir != null) {
                    genDir.refresh(false, true);
                }
                if ((outFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(item.myOutFileOsPath)) == null || !outFile.exists()) continue;
                AndroidAutogenerator.patchAndMarkGeneratedFile(facet, autogenerating, AndroidAutogeneratorMode.AIDL, outFile);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        if (module.getProject().isDisposed()) {
                            return;
                        }
                        context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), file.getUrl(), -1, -1);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runRenderscript(final @NotNull AndroidFacet facet, @NotNull ModuleSourceAutogenerating autogenerating, final @NotNull CompileContext context) {
        if (facet == null) {
            AndroidAutogenerator.$$$reportNull$$$0(25);
        }
        if (autogenerating == null) {
            AndroidAutogenerator.$$$reportNull$$$0(26);
        }
        if (context == null) {
            AndroidAutogenerator.$$$reportNull$$$0(27);
        }
        final Module module = facet.getModule();
        ModuleCompileScope moduleCompileScope = new ModuleCompileScope(module, false);
        VirtualFile[] files2 = moduleCompileScope.getFiles((FileType)AndroidRenderscriptFileType.INSTANCE, true);
        autogenerating.clearAutogeneratedFiles(AndroidAutogeneratorMode.RENDERSCRIPT);
        for (final VirtualFile file : files2) {
            RenderscriptAutogenerationItem item = (RenderscriptAutogenerationItem)ApplicationManager.getApplication().runReadAction((Computable)new Computable<RenderscriptAutogenerationItem>(){

                @Nullable
                public RenderscriptAutogenerationItem compute() {
                    AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
                    if (platform == null) {
                        context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.specify.platform", module.getName()), null, -1, -1);
                        return null;
                    }
                    IAndroidTarget target = platform.getTarget();
                    String sdkLocation = platform.getSdkData().getPath();
                    String packageName = AndroidUtils.computePackageName(module, file);
                    if (packageName == null) {
                        context.addMessage(CompilerMessageCategory.ERROR, "Cannot compute package for file", file.getUrl(), -1, -1);
                        return null;
                    }
                    String resourceDirPath = AndroidRootUtil.getResourceDirPath(facet);
                    assert (resourceDirPath != null);
                    String sourceRootPath = AndroidRootUtil.getRenderscriptGenSourceRootPath(facet);
                    if (sourceRootPath == null) {
                        return null;
                    }
                    String rawDirPath = resourceDirPath + '/' + "raw";
                    return new RenderscriptAutogenerationItem(sdkLocation, target, sourceRootPath, rawDirPath);
                }
            });
            if (item == null) continue;
            File tempOutDir = null;
            try {
                tempOutDir = FileUtil.createTempDirectory((String)"android_renderscript_autogeneration", (String)"tmp");
                VirtualFile vTempOutDir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempOutDir);
                String depFolderPath = vTempOutDir != null ? AndroidAutogenerator.getDependencyFolder(context.getProject(), file, vTempOutDir) : null;
                final Map messages = AndroidCompileUtil.toCompilerMessageCategoryKeys(AndroidRenderscript.execute((String)item.mySdkLocation, (IAndroidTarget)item.myTarget, (String)file.getPath(), (String)tempOutDir.getPath(), (String)depFolderPath, (String)item.myRawDirPath));
                if (((List)messages.get(CompilerMessageCategory.ERROR)).isEmpty()) {
                    ArrayList newFiles = new ArrayList();
                    AndroidCommonUtils.moveAllFiles((File)tempOutDir, (File)new File(item.myGenDirPath), newFiles);
                    for (File newFile : newFiles) {
                        VirtualFile newVFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(newFile);
                        if (newVFile == null) continue;
                        AndroidAutogenerator.patchAndMarkGeneratedFile(facet, autogenerating, AndroidAutogeneratorMode.RENDERSCRIPT, newVFile);
                    }
                    File bcFile = new File(item.myRawDirPath, FileUtil.getNameWithoutExtension((String)file.getName()) + ".bc");
                    VirtualFile vBcFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(bcFile);
                    if (vBcFile != null) {
                        autogenerating.markFileAutogenerated(AndroidAutogeneratorMode.RENDERSCRIPT, vBcFile);
                    }
                }
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        if (module.getProject().isDisposed()) {
                            return;
                        }
                        for (CompilerMessageCategory category : messages.keySet()) {
                            List messageList = (List)messages.get(category);
                            for (String message : messageList) {
                                context.addMessage(category, message, file.getUrl(), -1, -1);
                            }
                        }
                    }
                });
                VirtualFile genDir = LocalFileSystem.getInstance().findFileByPath(item.myGenDirPath);
                if (genDir == null) continue;
                genDir.refresh(false, true);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        if (module.getProject().isDisposed()) {
                            return;
                        }
                        context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), file.getUrl(), -1, -1);
                    }
                });
            }
            finally {
                if (tempOutDir != null) {
                    FileUtil.delete((File)tempOutDir);
                }
            }
        }
    }

    private static boolean ensureFilesWritable(final @NotNull Project project, final @NotNull Collection<VirtualFile> filesToCheck) {
        if (project == null) {
            AndroidAutogenerator.$$$reportNull$$$0(28);
        }
        if (filesToCheck == null) {
            AndroidAutogenerator.$$$reportNull$$$0(29);
        }
        if (filesToCheck.isEmpty()) {
            return true;
        }
        final boolean[] run2 = new boolean[]{false};
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                run2[0] = !project.isDisposed() && ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])filesToCheck.toArray(VirtualFile.EMPTY_ARRAY));
            }
        });
        return run2[0];
    }

    private static void removeDuplicateClasses(final @NotNull Module module, final @NotNull String aPackage, final @NotNull File generatedFile, final @NotNull String sourceRootPath) {
        if (module == null) {
            AndroidAutogenerator.$$$reportNull$$$0(30);
        }
        if (aPackage == null) {
            AndroidAutogenerator.$$$reportNull$$$0(31);
        }
        if (generatedFile == null) {
            AndroidAutogenerator.$$$reportNull$$$0(32);
        }
        if (sourceRootPath == null) {
            AndroidAutogenerator.$$$reportNull$$$0(33);
        }
        if (generatedFile.exists()) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    if (module.getProject().isDisposed() || module.isDisposed()) {
                        return;
                    }
                    String className = FileUtil.getNameWithoutExtension((File)generatedFile);
                    AndroidCompileUtil.removeDuplicatingClasses(module, aPackage, className, generatedFile, sourceRootPath);
                }
            });
        }
    }

    private static void fillSourceRoots(@NotNull Module module, @NotNull Set<Module> visited, @NotNull Set<VirtualFile> result2, boolean includingTests) {
        if (module == null) {
            AndroidAutogenerator.$$$reportNull$$$0(34);
        }
        if (visited == null) {
            AndroidAutogenerator.$$$reportNull$$$0(35);
        }
        if (result2 == null) {
            AndroidAutogenerator.$$$reportNull$$$0(36);
        }
        visited.add(module);
        AndroidFacet facet = AndroidFacet.getInstance(module);
        VirtualFile resDir = facet != null ? AndroidRootUtil.getResourceDir(facet) : null;
        ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
        for (VirtualFile virtualFile : manager.getSourceRoots(includingTests)) {
            if (Comparing.equal((Object)resDir, (Object)virtualFile)) continue;
            result2.add(virtualFile);
        }
        for (VirtualFile virtualFile : manager.getOrderEntries()) {
            Module depModule;
            ModuleOrderEntry moduleOrderEntry;
            DependencyScope scope;
            if (!(virtualFile instanceof ModuleOrderEntry) || (scope = (moduleOrderEntry = (ModuleOrderEntry)virtualFile).getScope()) != DependencyScope.COMPILE || (depModule = moduleOrderEntry.getModule()) == null || visited.contains(depModule)) continue;
            AndroidAutogenerator.fillSourceRoots(depModule, visited, result2, false);
        }
    }

    @NotNull
    public static VirtualFile[] getSourceRootsForModuleAndDependencies(@NotNull Module module, boolean includingTests) {
        if (module == null) {
            AndroidAutogenerator.$$$reportNull$$$0(37);
        }
        HashSet result2 = new HashSet();
        AndroidAutogenerator.fillSourceRoots(module, (Set<Module>)new HashSet(), (Set<VirtualFile>)result2, includingTests);
        VirtualFile[] virtualFileArray = VfsUtil.toVirtualFileArray((Collection)result2);
        if (virtualFileArray == null) {
            AndroidAutogenerator.$$$reportNull$$$0(38);
        }
        return virtualFileArray;
    }

    @Nullable
    static String getDependencyFolder(@NotNull Project project, @NotNull VirtualFile sourceFile, @NotNull VirtualFile genFolder) {
        ProjectFileIndex index;
        VirtualFile sourceRoot;
        if (project == null) {
            AndroidAutogenerator.$$$reportNull$$$0(39);
        }
        if (sourceFile == null) {
            AndroidAutogenerator.$$$reportNull$$$0(40);
        }
        if (genFolder == null) {
            AndroidAutogenerator.$$$reportNull$$$0(41);
        }
        if ((sourceRoot = (index = ProjectRootManager.getInstance((Project)project).getFileIndex()).getSourceRootForFile(sourceFile)) == null) {
            return null;
        }
        VirtualFile parent = sourceFile.getParent();
        if (Comparing.equal((Object)parent, (Object)sourceRoot)) {
            return genFolder.getPath();
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)sourceFile.getParent(), (VirtualFile)sourceRoot, (char)'/');
        assert (relativePath != null);
        return genFolder.getPath() + '/' + relativePath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 15: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 10: 
            case 16: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autogenerating";
                break;
            }
            case 12: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classNames";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 19: 
            case 30: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryPath";
                break;
            }
            case 28: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToCheck";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedFile";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRootPath";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/compiler/AndroidAutogenerator";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/compiler/AndroidAutogenerator";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRootsForModuleAndDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toRun";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "supportsAutogeneration";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runBuildConfigGenerator";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runAapt";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generateStubClasses";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "patchAndMarkGeneratedFile";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeAllFilesWithSameName";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "runAidl";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "runRenderscript";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "ensureFilesWritable";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicateClasses";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "fillSourceRoots";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRootsForModuleAndDependencies";
                break;
            }
            case 38: {
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getDependencyFolder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BuildconfigAutogenerationItem {
        final String myPackage;
        final String mySourceRootOsPath;

        private BuildconfigAutogenerationItem(@NotNull String aPackage, @NotNull String sourceRootOsPath) {
            if (aPackage == null) {
                BuildconfigAutogenerationItem.$$$reportNull$$$0(0);
            }
            if (sourceRootOsPath == null) {
                BuildconfigAutogenerationItem.$$$reportNull$$$0(1);
            }
            this.myPackage = aPackage;
            this.mySourceRootOsPath = sourceRootOsPath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "aPackage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sourceRootOsPath";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/android/compiler/AndroidAutogenerator$BuildconfigAutogenerationItem";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RenderscriptAutogenerationItem {
        final String mySdkLocation;
        final IAndroidTarget myTarget;
        final String myGenDirPath;
        final String myRawDirPath;

        private RenderscriptAutogenerationItem(@NotNull String sdkLocation, @NotNull IAndroidTarget target, @NotNull String genDirPath, @NotNull String rawDirPath) {
            if (sdkLocation == null) {
                RenderscriptAutogenerationItem.$$$reportNull$$$0(0);
            }
            if (target == null) {
                RenderscriptAutogenerationItem.$$$reportNull$$$0(1);
            }
            if (genDirPath == null) {
                RenderscriptAutogenerationItem.$$$reportNull$$$0(2);
            }
            if (rawDirPath == null) {
                RenderscriptAutogenerationItem.$$$reportNull$$$0(3);
            }
            this.mySdkLocation = sdkLocation;
            this.myTarget = target;
            this.myGenDirPath = genDirPath;
            this.myRawDirPath = rawDirPath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sdkLocation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "target";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "genDirPath";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rawDirPath";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/android/compiler/AndroidAutogenerator$RenderscriptAutogenerationItem";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class IdlAutogenerationItem {
        final VirtualFile myFile;
        final IAndroidTarget myTarget;
        final String myOutFileOsPath;
        final String[] mySourceRootOsPaths;
        final String myOutDirOsPath;
        final String myPackage;

        private IdlAutogenerationItem(@NotNull VirtualFile file, @NotNull IAndroidTarget target, @NotNull String outFileOsPath, @NotNull String[] sourceRootOsPaths, @NotNull String outDirOsPath, @NotNull String aPackage) {
            if (file == null) {
                IdlAutogenerationItem.$$$reportNull$$$0(0);
            }
            if (target == null) {
                IdlAutogenerationItem.$$$reportNull$$$0(1);
            }
            if (outFileOsPath == null) {
                IdlAutogenerationItem.$$$reportNull$$$0(2);
            }
            if (sourceRootOsPaths == null) {
                IdlAutogenerationItem.$$$reportNull$$$0(3);
            }
            if (outDirOsPath == null) {
                IdlAutogenerationItem.$$$reportNull$$$0(4);
            }
            if (aPackage == null) {
                IdlAutogenerationItem.$$$reportNull$$$0(5);
            }
            this.myFile = file;
            this.myTarget = target;
            this.myOutFileOsPath = outFileOsPath;
            this.mySourceRootOsPaths = sourceRootOsPaths;
            this.myOutDirOsPath = outDirOsPath;
            this.myPackage = aPackage;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "target";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outFileOsPath";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sourceRootOsPaths";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outDirOsPath";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "aPackage";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/android/compiler/AndroidAutogenerator$IdlAutogenerationItem";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AptAutogenerationItem {
        final String myPackage;
        final String myOutputDirOsPath;
        final Map<String, String> myGenFileRelPath2package;

        private AptAutogenerationItem(@NotNull String aPackage, @NotNull String outputDirOsPath, @NotNull Map<String, String> genFileRelPath2package) {
            if (aPackage == null) {
                AptAutogenerationItem.$$$reportNull$$$0(0);
            }
            if (outputDirOsPath == null) {
                AptAutogenerationItem.$$$reportNull$$$0(1);
            }
            if (genFileRelPath2package == null) {
                AptAutogenerationItem.$$$reportNull$$$0(2);
            }
            this.myPackage = aPackage;
            this.myOutputDirOsPath = outputDirOsPath;
            this.myGenFileRelPath2package = genFileRelPath2package;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "aPackage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outputDirOsPath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "genFileRelPath2package";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/android/compiler/AndroidAutogenerator$AptAutogenerationItem";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

