/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Locale;
import org.jetbrains.android.dom.converters.OnClickConverter;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidCreateOnClickHandlerAction
extends AbstractIntentionAction
implements HighPriorityAction {
    @NotNull
    public String getText() {
        String string = AndroidBundle.message("create.on.click.handler.intention.text", new Object[0]);
        if (string == null) {
            AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(1);
        }
        if (editor == null || !(file instanceof XmlFile)) {
            return false;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return false;
        }
        XmlAttributeValue attrValue = AndroidCreateOnClickHandlerAction.getXmlAttributeValue(file, editor);
        if (attrValue == null) {
            return false;
        }
        PsiElement parent = attrValue.getParent();
        if (!(parent instanceof XmlAttribute)) {
            return false;
        }
        GenericAttributeValue domValue = DomManager.getDomManager((Project)project).getDomElement((XmlAttribute)parent);
        if (domValue == null || !(domValue.getConverter() instanceof OnClickConverter)) {
            return false;
        }
        String methodName = attrValue.getValue();
        return methodName != null && StringUtil.isJavaIdentifier((String)methodName);
    }

    @Nullable
    private static XmlAttributeValue getXmlAttributeValue(PsiFile file, Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        return element != null ? (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttributeValue.class) : null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiClass selectedClass;
        if (project == null) {
            AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(2);
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        assert (facet != null);
        XmlAttributeValue attrValue = AndroidCreateOnClickHandlerAction.getXmlAttributeValue(file, editor);
        assert (attrValue != null);
        String methodName = attrValue.getValue();
        assert (methodName != null);
        GenericAttributeValue domValue = DomManager.getDomManager((Project)project).getDomElement((XmlAttribute)attrValue.getParent());
        assert (domValue != null);
        OnClickConverter converter = (OnClickConverter)domValue.getConverter();
        PsiClass activityBaseClass = JavaPsiFacade.getInstance((Project)project).findClass("android.app.Activity", facet.getModule().getModuleWithDependenciesAndLibrariesScope(false));
        if (activityBaseClass == null) {
            return;
        }
        GlobalSearchScope scope = facet.getModule().getModuleScope(false);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Ref selClassRef = Ref.create();
            ClassInheritorsSearch.search((PsiClass)activityBaseClass, (SearchScope)scope, (boolean)true, (boolean)true, (boolean)false).forEach(psiClass -> {
                if (!psiClass.isInterface() && !psiClass.hasModifierProperty("abstract")) {
                    selClassRef.set(psiClass);
                    return false;
                }
                return true;
            });
            selectedClass = (PsiClass)selClassRef.get();
        } else {
            TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)project).createInheritanceClassChooser("Choose Activity to Create the Method", scope, activityBaseClass, null, aClass -> !converter.findHandlerMethod(aClass, methodName));
            chooser.showDialog();
            selectedClass = chooser.getSelected();
        }
        if (selectedClass != null) {
            AndroidCreateOnClickHandlerAction.addHandlerMethodAndNavigate(project, selectedClass, methodName, converter.getDefaultMethodParameterType(selectedClass));
        }
    }

    @NotNull
    private static String suggestVarName(@NotNull String type) {
        if (type == null) {
            AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(3);
        }
        for (int i = type.length() - 1; i >= 0; --i) {
            char c = type.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            String string = type.substring(i).toLowerCase(Locale.US);
            if (string == null) {
                AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(4);
            }
            return string;
        }
        if ("o" == null) {
            AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(5);
        }
        return "o";
    }

    @Nullable
    public static PsiMethod addHandlerMethod(@NotNull Project project, @NotNull PsiClass psiClass, @NotNull String methodName, @NotNull String methodParamType) {
        PsiFile file;
        if (project == null) {
            AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(6);
        }
        if (psiClass == null) {
            AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(7);
        }
        if (methodName == null) {
            AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(8);
        }
        if (methodParamType == null) {
            AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(9);
        }
        if ((file = psiClass.getContainingFile()) == null) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        String varName = AndroidCreateOnClickHandlerAction.suggestVarName(methodParamType);
        PsiMethod method = (PsiMethod)psiClass.add((PsiElement)factory.createMethodFromText("public void " + methodName + "(" + methodParamType + " " + varName + ") {}", (PsiElement)psiClass));
        PsiMethod method1 = (PsiMethod)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)method);
        method1 = (PsiMethod)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)method1);
        return (PsiMethod)method.replace((PsiElement)method1);
    }

    public static void addHandlerMethodAndNavigate(@NotNull Project project, @NotNull PsiClass psiClass, @NotNull String methodName, @NotNull String methodParamType) {
        if (project == null) {
            AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(10);
        }
        if (psiClass == null) {
            AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(11);
        }
        if (methodName == null) {
            AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(12);
        }
        if (methodParamType == null) {
            AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(13);
        }
        if (!AndroidUtils.isIdentifier(methodName)) {
            Messages.showErrorDialog((Project)project, (String)String.format("%1$s is not a valid Java identifier/method name.", methodName), (String)"Invalid Name");
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            PsiJavaToken lBrace;
            PsiFile javaFile;
            PsiMethod method;
            if (project == null) {
                AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(14);
            }
            if (psiClass == null) {
                AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(15);
            }
            if (methodName == null) {
                AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(16);
            }
            if (methodParamType == null) {
                AndroidCreateOnClickHandlerAction.$$$reportNull$$$0(17);
            }
            if ((method = AndroidCreateOnClickHandlerAction.addHandlerMethod(project, psiClass, methodName, methodParamType)) == null) {
                return;
            }
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                PsiNavigateUtil.navigate((PsiElement)method);
            }
            if ((javaFile = method.getContainingFile()) == null) {
                return;
            }
            Editor javaEditor = PsiUtilBase.findEditor((PsiElement)method);
            if (javaEditor == null) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            if (body != null && (lBrace = body.getLBrace()) != null) {
                javaEditor.getCaretModel().moveToOffset(lBrace.getTextRange().getEndOffset());
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/AndroidCreateOnClickHandlerAction";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 8: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 9: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodParamType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/AndroidCreateOnClickHandlerAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestVarName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "suggestVarName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addHandlerMethod";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addHandlerMethodAndNavigate";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addHandlerMethodAndNavigate$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

