/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.SdkConstants;
import com.android.tools.idea.AndroidTextUtils;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.psi.TagToClassMapper;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomExtension;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.RequiredImpl;
import org.jetbrains.android.dom.Styleable;
import org.jetbrains.android.dom.animation.InterpolatorElement;
import org.jetbrains.android.dom.animation.fileDescriptions.InterpolatorDomFileDescription;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.dom.attrs.StyleableDefinition;
import org.jetbrains.android.dom.attrs.ToolsAttributeUtil;
import org.jetbrains.android.dom.converters.CompositeConverter;
import org.jetbrains.android.dom.converters.ManifestPlaceholderConverter;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.layout.Data;
import org.jetbrains.android.dom.layout.DataBindingElement;
import org.jetbrains.android.dom.layout.Fragment;
import org.jetbrains.android.dom.layout.LayoutElement;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.layout.Tag;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.ManifestElement;
import org.jetbrains.android.dom.manifest.UsesSdk;
import org.jetbrains.android.dom.menu.MenuItem;
import org.jetbrains.android.dom.navigation.NavDestinationElement;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.android.dom.raw.XmlRawResourceElement;
import org.jetbrains.android.dom.xml.AndroidXmlResourcesUtil;
import org.jetbrains.android.dom.xml.Intent;
import org.jetbrains.android.dom.xml.XmlResourceElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.LayoutViewClassUtils;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.SystemResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeProcessingUtil {
    private static final String PREFERENCE_TAG_NAME = "Preference";
    private static final ImmutableSet<String> SIZE_NOT_REQUIRED_TAG_NAMES = ImmutableSet.of((Object)"merge", (Object)"TableRow", (Object)"include", (Object)"requestFocus", (Object)"layout", (Object)"data", (Object[])new String[]{"import", "tag"});
    private static final ImmutableSet<String> SIZE_NOT_REQUIRED_PARENT_TAG_NAMES = ImmutableSet.of((Object)"TableRow", (Object)"TableLayout", (Object)"merge", (Object)"GridLayout", (Object)SdkConstants.FQCN_GRID_LAYOUT_V7.oldName(), (Object)SdkConstants.FQCN_GRID_LAYOUT_V7.newName(), (Object[])new String[]{"android.support.percent.PercentRelativeLayout", "android.support.percent.PercentFrameLayout"});

    private AttributeProcessingUtil() {
    }

    private static Logger getLog() {
        return Logger.getInstance(AttributeProcessingUtil.class);
    }

    public static boolean isLayoutAttributeRequired(@NotNull XmlName attributeName, @NotNull DomElement element) {
        String localName;
        if (attributeName == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(0);
        }
        if (element == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(1);
        }
        if (!"layout_width".equals(localName = attributeName.getLocalName()) && !"layout_height".equals(localName)) {
            return false;
        }
        if ((element instanceof LayoutViewElement || element instanceof Fragment) && "http://schemas.android.com/apk/res/android".equals(attributeName.getNamespaceKey())) {
            String tagName;
            XmlElement xmlElement = element.getXmlElement();
            XmlTag tag = xmlElement instanceof XmlTag ? (XmlTag)xmlElement : null;
            String string = tagName = tag != null ? tag.getName() : null;
            if (!(SIZE_NOT_REQUIRED_TAG_NAMES.contains((Object)tagName) || tag != null && tag.getAttribute("style") != null)) {
                String parentTagName;
                XmlTag parentTag = tag != null ? tag.getParentTag() : null;
                String string2 = parentTagName = parentTag != null ? parentTag.getName() : null;
                if (!SIZE_NOT_REQUIRED_PARENT_TAG_NAMES.contains((Object)parentTagName)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public static String getNamespaceKeyByResourcePackage(@NotNull AndroidFacet facet, @Nullable String resPackage) {
        if (facet == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(2);
        }
        if (resPackage == null) {
            String aPackage;
            if (!((AndroidFacetConfiguration)facet.getConfiguration()).isAppProject() || facet.requiresAndroidModel()) {
                return "http://schemas.android.com/apk/res-auto";
            }
            Manifest manifest = facet.getManifest();
            if (manifest != null && (aPackage = (String)manifest.getPackage().getValue()) != null && !aPackage.isEmpty()) {
                return "http://schemas.android.com/apk/res/" + aPackage;
            }
        } else if (resPackage.equals("android")) {
            return "http://schemas.android.com/apk/res/android";
        }
        return null;
    }

    private static void registerStyleableAttributes(@NotNull DomElement element, @NotNull StyleableDefinition styleable, @Nullable String namespace, @NotNull AttributeProcessor callback, @NotNull Set<XmlName> skippedAttributes) {
        if (element == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(3);
        }
        if (styleable == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(4);
        }
        if (callback == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(5);
        }
        if (skippedAttributes == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(6);
        }
        for (AttributeDefinition attrDef : styleable.getAttributes()) {
            String attrName = attrDef.getName();
            XmlName xmlName = new XmlName(attrName, namespace);
            if (skippedAttributes.contains(xmlName)) continue;
            skippedAttributes.add(xmlName);
            AttributeProcessingUtil.registerAttribute(attrDef, styleable.getName(), namespace, element, callback);
        }
    }

    private static boolean mustBeSoft(@NotNull Converter converter, @NotNull Collection<AttributeFormat> formats) {
        if (converter == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(7);
        }
        if (formats == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(8);
        }
        if (converter instanceof CompositeConverter || converter instanceof ResourceReferenceConverter) {
            return false;
        }
        return formats.size() > 1;
    }

    private static void registerAttribute(@NotNull AttributeDefinition attrDef, @Nullable String parentStyleableName, @Nullable String namespaceKey, @NotNull DomElement element, @NotNull AttributeProcessor callback) {
        XmlName xmlName;
        DomExtension extension;
        if (attrDef == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(9);
        }
        if (element == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(10);
        }
        if (callback == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(11);
        }
        String name = attrDef.getName();
        if (!"http://schemas.android.com/apk/res/android".equals(namespaceKey) && name.startsWith("android:")) {
            name = name.substring("android:".length());
            namespaceKey = "http://schemas.android.com/apk/res/android";
        }
        if ((extension = callback.processAttribute(xmlName = new XmlName(name, namespaceKey), attrDef, parentStyleableName)) == null) {
            return;
        }
        Object converter = AndroidDomUtil.getSpecificConverter(xmlName, element);
        if (converter == null) {
            if ("http://schemas.android.com/tools".equals(namespaceKey)) {
                converter = ToolsAttributeUtil.getConverter(attrDef);
            } else {
                converter = AndroidDomUtil.getConverter(attrDef);
                if (converter != null && element.getParentOfType(Manifest.class, true) != null) {
                    converter = new ManifestPlaceholderConverter((Converter)converter);
                }
            }
        }
        if (converter != null) {
            extension.setConverter(converter, AttributeProcessingUtil.mustBeSoft(converter, attrDef.getFormats()));
        }
        if (element instanceof LayoutElement && AttributeProcessingUtil.isLayoutAttributeRequired(xmlName, element) || element instanceof ManifestElement && AndroidManifestUtils.isRequiredAttribute(xmlName, element)) {
            extension.addCustomAnnotation((Annotation)((Object)new RequiredImpl()));
        }
    }

    private static void registerAttributes(AndroidFacet facet, DomElement element, @NotNull String styleableName, @Nullable String resPackage, AttributeProcessor callback, Set<XmlName> skipNames) {
        ResourceManager manager;
        if (styleableName == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(12);
        }
        if ((manager = ModuleResourceManagers.getInstance(facet).getResourceManager(resPackage)) == null) {
            return;
        }
        AttributeDefinitions attrDefs = manager.getAttributeDefinitions();
        if (attrDefs == null) {
            return;
        }
        String namespace = AttributeProcessingUtil.getNamespaceKeyByResourcePackage(facet, resPackage);
        StyleableDefinition styleable = attrDefs.getStyleableByName(styleableName);
        if (styleable != null) {
            AttributeProcessingUtil.registerStyleableAttributes(element, styleable, namespace, callback, skipNames);
        }
    }

    private static void registerAttributesForClassAndSuperclasses(AndroidFacet facet, DomElement element, PsiClass c, AttributeProcessor callback, Set<XmlName> skipNames) {
        while (c != null) {
            String styleableName = c.getName();
            if (styleableName != null) {
                AttributeProcessingUtil.registerAttributes(facet, element, styleableName, AttributeProcessingUtil.getResourcePackage(c), callback, skipNames);
            }
            for (PsiClass additional : AttributeProcessingUtil.getAdditionalAttributesClasses(facet, c)) {
                String additionalStyleableName = additional.getName();
                if (additionalStyleableName == null) continue;
                AttributeProcessingUtil.registerAttributes(facet, element, additionalStyleableName, AttributeProcessingUtil.getResourcePackage(additional), callback, skipNames);
            }
            c = AttributeProcessingUtil.getSuperclass(c);
        }
    }

    private static Collection<PsiClass> getAdditionalAttributesClasses(@NotNull AndroidFacet facet, @NotNull PsiClass c) {
        if (facet == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(13);
        }
        if (c == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(14);
        }
        if (SdkConstants.CLASS_NESTED_SCROLL_VIEW.isEquals(StringUtil.notNullize((String)c.getQualifiedName()))) {
            return Collections.singleton(AttributeProcessingUtil.getViewClassMap(facet).get("ScrollView"));
        }
        return Collections.emptySet();
    }

    @Nullable
    private static String getResourcePackage(@NotNull PsiClass psiClass) {
        String qualifiedName;
        if (psiClass == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(15);
        }
        return (qualifiedName = psiClass.getQualifiedName()) != null && qualifiedName.startsWith("android.") && !qualifiedName.startsWith("android.support.") && !qualifiedName.startsWith("androidx.") && !qualifiedName.startsWith("android.arch.") ? "android" : null;
    }

    @Nullable
    private static PsiClass getSuperclass(@NotNull PsiClass c) {
        if (c == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(16);
        }
        return (PsiClass)ApplicationManager.getApplication().runReadAction(() -> {
            if (c == null) {
                AttributeProcessingUtil.$$$reportNull$$$0(61);
            }
            return c.isValid() ? c.getSuperClass() : null;
        });
    }

    public static void processXmlAttributes(@NotNull AndroidFacet facet, @NotNull XmlTag tag, @NotNull XmlResourceElement element, @NotNull Set<XmlName> skipAttrNames, @NotNull AttributeProcessor callback) {
        String tagName;
        String styleableName;
        if (facet == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(17);
        }
        if (tag == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(18);
        }
        if (element == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(19);
        }
        if (skipAttrNames == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(20);
        }
        if (callback == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(21);
        }
        if ((styleableName = (String)AndroidXmlResourcesUtil.SPECIAL_STYLEABLE_NAMES.get((Object)(tagName = tag.getName()))) != null) {
            HashSet<XmlName> newSkipAttrNames = new HashSet<XmlName>();
            if (element instanceof Intent) {
                newSkipAttrNames.add(new XmlName("action", "http://schemas.android.com/apk/res/android"));
            }
            AttributeProcessingUtil.registerAttributes(facet, element, styleableName, "android", callback, newSkipAttrNames);
        }
        Map<String, PsiClass> prefClassMap = AttributeProcessingUtil.getPreferencesClassMap(facet);
        String prefClassName = element.getXmlTag().getName();
        PsiClass c = prefClassMap.get(prefClassName);
        AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet, element, c, callback, skipAttrNames);
        String widgetClassName = AndroidTextUtils.trimEndOrNullize((String)prefClassName, (String)PREFERENCE_TAG_NAME);
        if (widgetClassName != null) {
            PsiClass widgetClass = LayoutViewClassUtils.findClassByTagName(facet, widgetClassName, "android.view.View");
            AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet, element, widgetClass, callback, skipAttrNames);
        }
    }

    @NotNull
    public static Map<String, PsiClass> getPreferencesClassMap(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(22);
        }
        Map<String, PsiClass> map2 = AttributeProcessingUtil.getClassMap(facet, "android.preference.Preference");
        if (map2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(23);
        }
        return map2;
    }

    public static Map<String, PsiClass> getViewClassMap(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(24);
        }
        return AttributeProcessingUtil.getClassMap(facet, "android.view.View");
    }

    private static Map<String, PsiClass> getClassMap(@NotNull AndroidFacet facet, @NotNull String className) {
        if (facet == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(25);
        }
        if (className == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(26);
        }
        if (DumbService.isDumb((Project)facet.getModule().getProject())) {
            return Collections.emptyMap();
        }
        return TagToClassMapper.getInstance(facet.getModule()).getClassMap(className);
    }

    private static void registerAttributesFromSuffixedStyleables(@NotNull AndroidFacet facet, @NotNull DomElement element, @NotNull PsiClass psiClass, @NotNull AttributeProcessor callback, @NotNull Set<XmlName> skipAttrNames) {
        String styleableName;
        String viewName;
        if (facet == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(27);
        }
        if (element == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(28);
        }
        if (psiClass == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(29);
        }
        if (callback == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(30);
        }
        if (skipAttrNames == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(31);
        }
        if ((viewName = psiClass.getName()) == null) {
            return;
        }
        switch (viewName) {
            case "ViewGroup": {
                styleableName = "ViewGroup_MarginLayout";
                break;
            }
            case "TableRow": {
                styleableName = "TableRow_Cell";
                break;
            }
            case "CollapsingToolbarLayout": {
                AttributeProcessingUtil.registerAttributes(facet, element, "CollapsingAppBarLayout_LayoutParams", null, callback, skipAttrNames);
                styleableName = viewName + "_Layout";
                break;
            }
            case "CoordinatorLayout": {
                AttributeProcessingUtil.registerAttributes(facet, element, "CoordinatorLayout_LayoutParams", null, callback, skipAttrNames);
                styleableName = viewName + "_Layout";
                break;
            }
            case "AppBarLayout": {
                AttributeProcessingUtil.registerAttributes(facet, element, "AppBarLayout_LayoutParams", null, callback, skipAttrNames);
                styleableName = viewName + "_Layout";
                break;
            }
            default: {
                styleableName = viewName + "_Layout";
            }
        }
        AttributeProcessingUtil.registerAttributes(facet, element, styleableName, AttributeProcessingUtil.getResourcePackage(psiClass), callback, skipAttrNames);
    }

    public static void processNavAttributes(@NotNull AndroidFacet facet, @NotNull XmlTag tag, @NotNull NavDestinationElement element, @NotNull Set<XmlName> skipAttrNames, @NotNull AttributeProcessor callback) {
        if (facet == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(32);
        }
        if (tag == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(33);
        }
        if (element == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(34);
        }
        if (skipAttrNames == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(35);
        }
        if (callback == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(36);
        }
        try {
            NavigationSchema.createIfNecessary(facet);
        }
        catch (ClassNotFoundException e) {
            return;
        }
        NavigationSchema schema = NavigationSchema.get(facet);
        for (PsiClass psiClass : schema.getDestinationClassesByTagSlowly(tag.getName())) {
            AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet, element, psiClass, callback, skipAttrNames);
        }
    }

    public static void processLayoutAttributes(@NotNull AndroidFacet facet, @NotNull XmlTag tag, @NotNull LayoutElement element, @NotNull Set<XmlName> skipAttrNames, @NotNull AttributeProcessor callback) {
        String tagName;
        if (facet == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(37);
        }
        if (tag == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(38);
        }
        if (element == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(39);
        }
        if (skipAttrNames == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(40);
        }
        if (callback == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(41);
        }
        Map<String, PsiClass> map2 = AttributeProcessingUtil.getViewClassMap(facet);
        if (!(element instanceof DataBindingElement)) {
            PsiClass newDrawerLayout;
            PsiClass oldDrawerLayout;
            AttributeProcessingUtil.registerToolsAttribute("targetApi", callback);
            if (tag.getParentTag() == null) {
                AttributeProcessingUtil.registerToolsAttribute("context", callback);
                AttributeProcessingUtil.registerToolsAttribute("menu", callback);
                AttributeProcessingUtil.registerToolsAttribute("actionBarNavMode", callback);
                AttributeProcessingUtil.registerToolsAttribute("showIn", callback);
            }
            PsiClass adapterView = map2.get("AdapterView");
            String psiClass = map2.get(tag.getName());
            if (adapterView != null && psiClass != null && psiClass.isInheritor(adapterView, true)) {
                AttributeProcessingUtil.registerToolsAttribute("listitem", callback);
                AttributeProcessingUtil.registerToolsAttribute("listheader", callback);
                AttributeProcessingUtil.registerToolsAttribute("listfooter", callback);
            }
            if ((oldDrawerLayout = map2.get(SdkConstants.CLASS_DRAWER_LAYOUT.oldName())) != null && psiClass != null && (psiClass.isEquivalentTo((PsiElement)oldDrawerLayout) || psiClass.isInheritor(oldDrawerLayout, true))) {
                AttributeProcessingUtil.registerToolsAttribute("openDrawer", callback);
            }
            if ((newDrawerLayout = map2.get(SdkConstants.CLASS_DRAWER_LAYOUT.newName())) != null && psiClass != null && (psiClass.isEquivalentTo((PsiElement)newDrawerLayout) || psiClass.isInheritor(newDrawerLayout, true))) {
                AttributeProcessingUtil.registerToolsAttribute("openDrawer", callback);
            }
            if (((Boolean)StudioFlags.NELE_MOCKUP_EDITOR.get()).booleanValue()) {
                AttributeProcessingUtil.registerToolsAttribute("mockup", callback);
                AttributeProcessingUtil.registerToolsAttribute("mockup_crop", callback);
                AttributeProcessingUtil.registerToolsAttribute("mockup_opacity", callback);
            }
        }
        if (element instanceof Tag || element instanceof Data) {
            return;
        }
        switch (tagName = tag.getName()) {
            case "fragment": {
                AttributeProcessingUtil.registerToolsAttribute("layout", callback);
                break;
            }
            case "view": {
                for (PsiClass aClass : map2.values()) {
                    String name = aClass.getName();
                    if (name == null) continue;
                    AttributeProcessingUtil.registerAttributes(facet, element, name, AttributeProcessingUtil.getResourcePackage(aClass), callback, skipAttrNames);
                }
                break;
            }
            case "merge": {
                if (tag.getParentTag() == null) {
                    AttributeProcessingUtil.registerToolsAttribute("parentTag", callback);
                }
                AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet, element, map2.get("merge"), callback, skipAttrNames);
                String parentTagName = tag.getAttributeValue("parentTag", "http://schemas.android.com/tools");
                if (parentTagName == null) break;
                AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet, element, map2.get(parentTagName), callback, skipAttrNames);
                break;
            }
            default: {
                PsiClass c = map2.get(tagName);
                AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet, element, c, callback, skipAttrNames);
            }
        }
        if (tagName.equals("merge")) {
            return;
        }
        XmlTag parentTag = tag.getParentTag();
        if (parentTag != null) {
            String parentTagName = parentTag.getName();
            if ("merge".equals(parentTagName)) {
                parentTagName = parentTag.getAttributeValue("parentTag", "http://schemas.android.com/tools");
            }
            if ("layout".equals(parentTagName)) {
                parentTagName = "ViewGroup";
            }
            if (parentTagName != null) {
                PsiClass c = map2.get(parentTagName);
                while (c != null) {
                    AttributeProcessingUtil.registerAttributesFromSuffixedStyleables(facet, element, c, callback, skipAttrNames);
                    c = AttributeProcessingUtil.getSuperclass(c);
                }
                return;
            }
        }
        for (PsiClass c : map2.values()) {
            AttributeProcessingUtil.registerAttributesFromSuffixedStyleables(facet, element, c, callback, skipAttrNames);
        }
    }

    public static void processAttributes(@NotNull AndroidDomElement element, @NotNull AndroidFacet facet, boolean processAllExistingAttrsFirst, @NotNull AttributeProcessor callback) {
        String styleableName;
        AttributeDefinitions definitions;
        HashSet<XmlName> skippedAttributes;
        if (element == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(42);
        }
        if (facet == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(43);
        }
        if (callback == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(44);
        }
        if (DumbService.getInstance((Project)facet.getModule().getProject()).isDumb()) {
            return;
        }
        XmlTag tag = element.getXmlTag();
        Set<XmlName> set = skippedAttributes = processAllExistingAttrsFirst ? AttributeProcessingUtil.registerExistingAttributes(facet, tag, element, callback) : new HashSet<XmlName>();
        if (element instanceof ManifestElement) {
            AttributeProcessingUtil.processManifestAttributes(tag, element, callback);
        } else if (element instanceof LayoutElement) {
            AttributeProcessingUtil.processLayoutAttributes(facet, tag, (LayoutElement)element, skippedAttributes, callback);
        } else if (element instanceof XmlResourceElement) {
            AttributeProcessingUtil.processXmlAttributes(facet, tag, (XmlResourceElement)element, skippedAttributes, callback);
        } else if (element instanceof XmlRawResourceElement) {
            AttributeProcessingUtil.processRawAttributes(tag, callback);
        } else if (element instanceof NavDestinationElement) {
            AttributeProcessingUtil.processNavAttributes(facet, tag, (NavDestinationElement)element, skippedAttributes, callback);
        }
        Styleable styleableAnnotation = (Styleable)element.getAnnotation(Styleable.class);
        if (styleableAnnotation == null) {
            return;
        }
        boolean isSystem = styleableAnnotation.packageName().equals("android");
        if (isSystem) {
            String[] manager = ModuleResourceManagers.getInstance(facet).getSystemResourceManager();
            if (manager == null) {
                return;
            }
            definitions = manager.getAttributeDefinitions();
            if (definitions == null) {
                return;
            }
        } else {
            definitions = ModuleResourceManagers.getInstance(facet).getLocalResourceManager().getAttributeDefinitions();
        }
        if (element instanceof MenuItem) {
            AttributeProcessingUtil.processMenuItemAttributes(facet, element, skippedAttributes, callback);
            return;
        }
        for (String styleableName2 : styleableAnnotation.value()) {
            StyleableDefinition styleable = definitions.getStyleableByName(styleableName2);
            if (styleable != null) {
                AttributeProcessingUtil.registerStyleableAttributes(element, styleable, isSystem ? "http://schemas.android.com/apk/res/android" : "http://schemas.android.com/apk/res-auto", callback, skippedAttributes);
                continue;
            }
            if (!isSystem) continue;
            AttributeProcessingUtil.getLog().warn(String.format("@Styleable(%s) annotation doesn't point to existing styleable", styleableName2));
        }
        if (element instanceof InterpolatorElement && (styleableName = InterpolatorDomFileDescription.getInterpolatorStyleableByTagName(tag.getName())) != null) {
            StyleableDefinition styleable = definitions.getStyleableByName(styleableName);
            if (styleable == null) {
                AttributeProcessingUtil.getLog().warn(String.format("%s doesn't point to existing styleable for interpolator", styleableName));
            } else {
                AttributeProcessingUtil.registerStyleableAttributes(element, styleable, "http://schemas.android.com/apk/res/android", callback, skippedAttributes);
            }
        }
    }

    public static void processRawAttributes(@NotNull XmlTag tag, @NotNull AttributeProcessor callback) {
        if (tag == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(45);
        }
        if (callback == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(46);
        }
        if ("resources".equals(tag.getName())) {
            AttributeProcessingUtil.registerToolsAttribute("shrinkMode", callback);
            AttributeProcessingUtil.registerToolsAttribute("keep", callback);
            AttributeProcessingUtil.registerToolsAttribute("discard", callback);
        }
    }

    public static void processManifestAttributes(@NotNull XmlTag tag, @NotNull AndroidDomElement element, @NotNull AttributeProcessor callback) {
        if (tag == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(47);
        }
        if (element == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(48);
        }
        if (callback == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(49);
        }
        if (tag.getParentTag() != null) {
            AttributeProcessingUtil.registerToolsAttribute("node", callback);
            AttributeProcessingUtil.registerToolsAttribute("strict", callback);
            AttributeProcessingUtil.registerToolsAttribute("remove", callback);
            AttributeProcessingUtil.registerToolsAttribute("replace", callback);
        }
        if (element instanceof UsesSdk) {
            AttributeProcessingUtil.registerToolsAttribute("overrideLibrary", callback);
        }
    }

    private static void processMenuItemAttributes(@NotNull AndroidFacet facet, @NotNull DomElement element, @NotNull Collection<XmlName> skippedAttributes, @NotNull AttributeProcessor callback) {
        SystemResourceManager manager;
        if (facet == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(50);
        }
        if (element == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(51);
        }
        if (skippedAttributes == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(52);
        }
        if (callback == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(53);
        }
        if ((manager = ModuleResourceManagers.getInstance(facet).getSystemResourceManager()) == null) {
            return;
        }
        AttributeDefinitions styleables = ((ResourceManager)manager).getAttributeDefinitions();
        if (styleables == null) {
            return;
        }
        StyleableDefinition styleable = styleables.getStyleableByName("MenuItem");
        if (styleable == null) {
            AttributeProcessingUtil.getLog().warn("No StyleableDefinition for MenuItem");
            return;
        }
        for (AttributeDefinition attribute : styleable.getAttributes()) {
            String name = attribute.getName();
            if (name.equals("showAsAction")) {
                boolean hasAppCompat;
                boolean bl = hasAppCompat = DependencyManagementUtil.dependsOn(facet.getModule(), GoogleMavenArtifactId.APP_COMPAT_V7) || DependencyManagementUtil.dependsOn(facet.getModule(), GoogleMavenArtifactId.ANDROIDX_APP_COMPAT_V7);
                if (hasAppCompat) {
                    if (!skippedAttributes.add(new XmlName(name, "http://schemas.android.com/apk/res-auto"))) continue;
                    AttributeProcessingUtil.registerAttribute(attribute, "MenuItem", "http://schemas.android.com/apk/res-auto", element, callback);
                    continue;
                }
            }
            if (!skippedAttributes.add(new XmlName(name, "http://schemas.android.com/apk/res/android"))) continue;
            AttributeProcessingUtil.registerAttribute(attribute, "MenuItem", "http://schemas.android.com/apk/res/android", element, callback);
        }
    }

    private static void registerToolsAttribute(@NotNull String attributeName, @NotNull AttributeProcessor callback) {
        AttributeDefinition definition;
        if (attributeName == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(54);
        }
        if (callback == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(55);
        }
        if ((definition = ToolsAttributeUtil.getAttrDefByName(attributeName)) != null) {
            XmlName name = new XmlName(attributeName, "http://schemas.android.com/tools");
            DomExtension domExtension = callback.processAttribute(name, definition, null);
            ResolvingConverter converter = ToolsAttributeUtil.getConverter(definition);
            if (domExtension != null && converter != null) {
                domExtension.setConverter((Converter)converter);
            }
        } else {
            AttributeProcessingUtil.getLog().warn("No attribute definition for tools attribute " + attributeName);
        }
    }

    @NotNull
    private static Set<XmlName> registerExistingAttributes(@NotNull AndroidFacet facet, @NotNull XmlTag tag, @NotNull AndroidDomElement element, @NotNull AttributeProcessor callback) {
        XmlAttribute[] attrs;
        if (facet == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(56);
        }
        if (tag == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(57);
        }
        if (element == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(58);
        }
        if (callback == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(59);
        }
        HashSet<XmlName> result2 = new HashSet<XmlName>();
        for (XmlAttribute attr : attrs = tag.getAttributes()) {
            AttributeDefinition attrDef;
            String localName = attr.getLocalName();
            if (localName.endsWith(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED) || "xmlns".equals(attr.getNamespacePrefix()) || (attrDef = AndroidDomUtil.getAttributeDefinition(facet, attr)) == null) continue;
            String namespace = attr.getNamespace();
            result2.add(new XmlName(attr.getLocalName(), attr.getNamespace()));
            AttributeProcessingUtil.registerAttribute(attrDef, null, !namespace.isEmpty() ? namespace : null, element, callback);
        }
        HashSet<XmlName> hashSet = result2;
        if (hashSet == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(60);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 23: 
            case 60: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 23: 
            case 60: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 1: 
            case 3: 
            case 10: 
            case 19: 
            case 28: 
            case 34: 
            case 39: 
            case 42: 
            case 48: 
            case 51: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 13: 
            case 17: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 32: 
            case 37: 
            case 43: 
            case 50: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleable";
                break;
            }
            case 5: 
            case 11: 
            case 21: 
            case 30: 
            case 36: 
            case 41: 
            case 44: 
            case 46: 
            case 49: 
            case 53: 
            case 55: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 6: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skippedAttributes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formats";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrDef";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleableName";
                break;
            }
            case 14: 
            case 16: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 15: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 18: 
            case 33: 
            case 38: 
            case 45: 
            case 47: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 20: 
            case 31: 
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipAttrNames";
                break;
            }
            case 23: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/AttributeProcessingUtil";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/AttributeProcessingUtil";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferencesClassMap";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "registerExistingAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isLayoutAttributeRequired";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceKeyByResourcePackage";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerStyleableAttributes";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mustBeSoft";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerAttribute";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "registerAttributes";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalAttributesClasses";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getResourcePackage";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSuperclass";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processXmlAttributes";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPreferencesClassMap";
                break;
            }
            case 23: 
            case 60: {
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getViewClassMap";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getClassMap";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "registerAttributesFromSuffixedStyleables";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processNavAttributes";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "processLayoutAttributes";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "processAttributes";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "processRawAttributes";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "processManifestAttributes";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "processMenuItemAttributes";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "registerToolsAttribute";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "registerExistingAttributes";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSuperclass$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 23: 
            case 60: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface AttributeProcessor {
        @Nullable
        public DomExtension processAttribute(@NotNull XmlName var1, @NotNull AttributeDefinition var2, @Nullable String var3);
    }
}

