/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.attrs;

import com.android.resources.ResourceType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.dom.converters.PackageClassConverter;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.converters.StaticEnumConverter;
import org.jetbrains.android.dom.converters.TargetApiConverter;
import org.jetbrains.android.dom.converters.ViewClassConverter;
import org.jetbrains.android.dom.converters.ViewGroupClassConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolsAttributeUtil {
    private static final ResolvingConverter LAYOUT_REFERENCE_CONVERTER = new ResourceReferenceConverter(EnumSet.of(ResourceType.LAYOUT));
    private static final ResolvingConverter ACTIVITY_CLASS_CONVERTER = new PackageClassConverter(true, false, "android.app.Activity");
    private static final ResolvingConverter VIEW_CONVERTER = new ViewClassConverter();
    private static final ResolvingConverter VIEW_GROUP_CONVERTER = new ViewGroupClassConverter();
    private static final List<AttributeFormat> NO_FORMATS = Collections.emptyList();
    public static final String ATTR_NODE = "node";
    public static final String ATTR_STRICT = "strict";
    public static final String ATTR_REMOVE = "remove";
    public static final String ATTR_REPLACE = "replace";
    public static final String ATTR_OVERRIDE_LIBRARY = "overrideLibrary";
    private static final ImmutableMap<String, List<AttributeFormat>> ATTRIBUTES = ImmutableMap.builder().put((Object)"actionBarNavMode", Collections.singletonList(AttributeFormat.Flags)).put((Object)"context", (Object)ImmutableList.of((Object)((Object)AttributeFormat.Reference), (Object)((Object)AttributeFormat.String))).put((Object)"ignore", NO_FORMATS).put((Object)"listfooter", Collections.singletonList(AttributeFormat.Reference)).put((Object)"listheader", Collections.singletonList(AttributeFormat.Reference)).put((Object)"listitem", Collections.singletonList(AttributeFormat.Reference)).put((Object)"layout", Collections.singletonList(AttributeFormat.Reference)).put((Object)"locale", NO_FORMATS).put((Object)"menu", NO_FORMATS).put((Object)"mockup", Collections.singletonList(AttributeFormat.String)).put((Object)"mockup_opacity", Collections.singletonList(AttributeFormat.Float)).put((Object)"mockup_crop", Collections.singletonList(AttributeFormat.String)).put((Object)"openDrawer", Collections.singletonList(AttributeFormat.Enum)).put((Object)"parentTag", Collections.singletonList(AttributeFormat.String)).put((Object)"showIn", Collections.singletonList(AttributeFormat.Reference)).put((Object)"targetApi", NO_FORMATS).put((Object)"node", Collections.singletonList(AttributeFormat.Enum)).put((Object)"strict", NO_FORMATS).put((Object)"remove", NO_FORMATS).put((Object)"replace", NO_FORMATS).put((Object)"overrideLibrary", NO_FORMATS).put((Object)"shrinkMode", Collections.singletonList(AttributeFormat.Enum)).put((Object)"keep", NO_FORMATS).put((Object)"discard", NO_FORMATS).put((Object)"useHandler", Collections.singletonList(AttributeFormat.Reference)).put((Object)"srcCompat", Collections.singletonList(AttributeFormat.Reference)).build();
    private static final ImmutableMap<String, ResolvingConverter> CONVERTERS = ImmutableMap.builder().put((Object)"actionBarNavMode", (Object)new StaticEnumConverter("standard", "list", "tabs")).put((Object)"openDrawer", (Object)new StaticEnumConverter("start", "end", "left", "right")).put((Object)"context", (Object)ACTIVITY_CLASS_CONVERTER).put((Object)"listfooter", (Object)LAYOUT_REFERENCE_CONVERTER).put((Object)"listheader", (Object)LAYOUT_REFERENCE_CONVERTER).put((Object)"listitem", (Object)LAYOUT_REFERENCE_CONVERTER).put((Object)"layout", (Object)LAYOUT_REFERENCE_CONVERTER).put((Object)"showIn", (Object)LAYOUT_REFERENCE_CONVERTER).put((Object)"node", (Object)new StaticEnumConverter("merge", "replace", "strict", "merge-only-attributes", "remove", "removeAll")).put((Object)"targetApi", (Object)new TargetApiConverter()).put((Object)"shrinkMode", (Object)new StaticEnumConverter("strict", "safe")).put((Object)"useHandler", (Object)VIEW_CONVERTER).put((Object)"parentTag", (Object)VIEW_GROUP_CONVERTER).build();

    @Nullable
    public static ResolvingConverter getConverter(@NotNull AttributeDefinition attrDef) {
        String name;
        ResolvingConverter converter;
        if (attrDef == null) {
            ToolsAttributeUtil.$$$reportNull$$$0(0);
        }
        return (converter = (ResolvingConverter)CONVERTERS.get((Object)(name = attrDef.getName()))) != null ? converter : AndroidDomUtil.getConverter(attrDef);
    }

    @NotNull
    public static Set<String> getAttributeNames() {
        ImmutableSet immutableSet = ATTRIBUTES.keySet();
        if (immutableSet == null) {
            ToolsAttributeUtil.$$$reportNull$$$0(1);
        }
        return immutableSet;
    }

    @Nullable
    public static AttributeDefinition getAttrDefByName(@NotNull String name) {
        if (name == null) {
            ToolsAttributeUtil.$$$reportNull$$$0(2);
        }
        if (!ATTRIBUTES.containsKey((Object)name)) {
            return null;
        }
        Collection formats = (Collection)ATTRIBUTES.get((Object)name);
        ToolsAttributeDefinition def = new ToolsAttributeDefinition(name);
        def.addFormats(formats);
        return def;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrDef";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/attrs/ToolsAttributeUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/attrs/ToolsAttributeUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConverter";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAttrDefByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ToolsAttributeDefinition
    extends AttributeDefinition {
        public ToolsAttributeDefinition(@NotNull String name) {
            if (name == null) {
                ToolsAttributeDefinition.$$$reportNull$$$0(0);
            }
            super(name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/dom/attrs/ToolsAttributeUtil$ToolsAttributeDefinition", "<init>"));
        }
    }
}

