/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.EnumConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.impl.ConvertContextFactory;
import com.intellij.util.xml.impl.DomCompletionContributor;
import java.util.ArrayList;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

public class AndroidResourceReference
extends AndroidResourceReferenceBase {
    private final GenericDomValue<ResourceValue> myValue;

    public AndroidResourceReference(@NotNull GenericDomValue<ResourceValue> value, @NotNull AndroidFacet facet, @NotNull ResourceValue resourceValue2) {
        if (value == null) {
            AndroidResourceReference.$$$reportNull$$$0(0);
        }
        if (facet == null) {
            AndroidResourceReference.$$$reportNull$$$0(1);
        }
        if (resourceValue2 == null) {
            AndroidResourceReference.$$$reportNull$$$0(2);
        }
        super(value, null, resourceValue2, facet);
        this.myValue = value;
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        Converter converter = WrappingConverter.getDeepestConverter((Converter)this.myValue.getConverter(), this.myValue);
        if ((converter instanceof EnumConverter || converter == AndroidDomUtil.BOOLEAN_CONVERTER) && DomCompletionContributor.isSchemaEnumerated((PsiElement)this.getElement())) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                AndroidResourceReference.$$$reportNull$$$0(3);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        if (converter instanceof ResolvingConverter) {
            ResolvingConverter resolvingConverter = (ResolvingConverter)converter;
            ArrayList<Object> result2 = new ArrayList<Object>();
            ConvertContext convertContext = ConvertContextFactory.createConvertContext(this.myValue);
            for (Object variant : resolvingConverter.getVariants(convertContext)) {
                String name = converter.toString(variant, convertContext);
                if (name == null) continue;
                result2.add(ElementPresentationManager.getInstance().createVariant(variant, name, resolvingConverter.getPsiElement(variant)));
            }
            Object[] objectArray = result2.toArray();
            if (objectArray == null) {
                AndroidResourceReference.$$$reportNull$$$0(4);
            }
            return objectArray;
        }
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            AndroidResourceReference.$$$reportNull$$$0(5);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        if (newElementName.startsWith("@+id/")) {
            newElementName = AndroidResourceUtil.getResourceNameByReferenceText(newElementName);
        }
        ResourceValue value = (ResourceValue)this.myValue.getValue();
        assert (value != null);
        ResourceType resType = value.getType();
        if (resType != null && newElementName != null) {
            ResourceFolderType folderType = AndroidResourceUtil.XML_FILE_RESOURCE_TYPES.get(resType);
            String newResName = folderType != null && newElementName.contains(".") ? AndroidCommonUtils.getResourceName((String)resType.getName(), (String)newElementName) : newElementName;
            ResourceValue newValue = ResourceValue.parse(newResName, true, true, false);
            if (newValue == null || newValue.getPrefix() == '\u0000') {
                newValue = ResourceValue.referenceTo(value.getPrefix(), value.getPackage(), value.getResourceType(), newResName);
            }
            this.myValue.setValue((Object)newValue);
        }
        return this.myValue.getXmlTag();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceValue";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/converters/AndroidResourceReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/converters/AndroidResourceReference";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

