/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.resources.ResourceType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.resources.ResourceNameConverter;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParentStyleConverter
extends ResourceReferenceConverter {
    public ParentStyleConverter() {
        super(ResourceType.STYLE, false, false);
        this.setAllowAttributeReferences(false);
    }

    @Override
    @NotNull
    public PsiReference[] createReferences(GenericDomValue<ResourceValue> value, PsiElement element, ConvertContext context) {
        Object[] refs;
        XmlAttributeValue attributeValue;
        if (element instanceof XmlAttributeValue && (attributeValue = (XmlAttributeValue)element).isValid() && attributeValue.getValue().isEmpty()) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ParentStyleConverter.$$$reportNull$$$0(0);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        Object[] refsFromSuper = super.createReferences(value, element, context);
        ResourceValue resValue = (ResourceValue)value.getValue();
        if (resValue == null || resValue.getPackage() != null) {
            if (refsFromSuper == null) {
                ParentStyleConverter.$$$reportNull$$$0(1);
            }
            return refsFromSuper;
        }
        AndroidFacet facet = AndroidFacet.getInstance(context);
        if (facet != null && (refs = ParentStyleConverter.getReferencesInStyleName(value, facet)).length > 0) {
            PsiReference[] psiReferenceArray = (PsiReference[])ArrayUtil.mergeArrays((Object[])refsFromSuper, (Object[])refs);
            if (psiReferenceArray == null) {
                ParentStyleConverter.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }
        if (refsFromSuper == null) {
            ParentStyleConverter.$$$reportNull$$$0(3);
        }
        return refsFromSuper;
    }

    @NotNull
    private static PsiReference[] getReferencesInStyleName(@NotNull GenericDomValue<?> value, @NotNull AndroidFacet facet) {
        String[] ids;
        String s;
        if (value == null) {
            ParentStyleConverter.$$$reportNull$$$0(4);
        }
        if (facet == null) {
            ParentStyleConverter.$$$reportNull$$$0(5);
        }
        if ((s = value.getStringValue()) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ParentStyleConverter.$$$reportNull$$$0(6);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        int start = 0;
        int idx = s.indexOf(47);
        if (idx >= 0) {
            start = idx + 1;
            s = s.substring(start);
        }
        if ((ids = s.split("\\.")).length < 2) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ParentStyleConverter.$$$reportNull$$$0(7);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList<ResourceNameConverter.MyParentStyleReference> result2 = new ArrayList<ResourceNameConverter.MyParentStyleReference>(ids.length - 1);
        int offset = s.length();
        for (int i = ids.length - 1; i >= 0; --i) {
            String styleName = s.substring(0, offset);
            if (i < ids.length - 1) {
                ResourceValue val = ResourceValue.referenceTo('\u0000', null, ResourceType.STYLE.getName(), styleName);
                result2.add(new ResourceNameConverter.MyParentStyleReference(value, new TextRange(1 + start, 1 + start + offset), val, facet));
            }
            if (ResourceNameConverter.hasExplicitParent(facet, styleName)) break;
            offset = offset - ids[i].length() - 1;
        }
        PsiReference[] psiReferenceArray = result2.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            ParentStyleConverter.$$$reportNull$$$0(8);
        }
        return psiReferenceArray;
    }

    @Override
    public String toString(@Nullable ResourceValue element, ConvertContext context) {
        if (element != null && element.getPrefix() == '@') {
            return element.toString();
        }
        return super.toString(element, context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/converters/ParentStyleConverter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/converters/ParentStyleConverter";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesInStyleName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesInStyleName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

