/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.drawable;

import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.android.dom.drawable.fileDescriptions.AdaptiveIconDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class AndroidDrawableDomUtil {
    private static final String[] DRAWABLE_ROOTS_V1 = new String[]{"selector", "bitmap", "nine-patch", "layer-list", "level-list", "transition", "inset", "clip", "scale", "shape", "animation-list", "animated-rotate", "rotate", "color"};
    private static final String[] DRAWABLE_ROOTS_V16 = new String[]{"drawable"};
    private static final String[] DRAWABLE_ROOTS_V21 = new String[]{"ripple", "animated-selector", "vector", "animated-vector"};

    private AndroidDrawableDomUtil() {
    }

    public static boolean isDrawableResourceFile(@NotNull XmlFile file) {
        if (file == null) {
            AndroidDrawableDomUtil.$$$reportNull$$$0(0);
        }
        return AndroidResourceDomFileDescription.doIsMyFile(file, ResourceFolderType.DRAWABLE);
    }

    @NotNull
    public static List<String> getPossibleRoots(@NotNull AndroidFacet facet, @NotNull ResourceFolderType folderType) {
        if (facet == null) {
            AndroidDrawableDomUtil.$$$reportNull$$$0(1);
        }
        if (folderType == null) {
            AndroidDrawableDomUtil.$$$reportNull$$$0(2);
        }
        AndroidVersion sdkVersion = AndroidModuleInfo.getInstance(facet).getBuildSdkVersion();
        ArrayList<String> result2 = new ArrayList<String>(DRAWABLE_ROOTS_V1.length + DRAWABLE_ROOTS_V16.length + DRAWABLE_ROOTS_V21.length + AdaptiveIconDomFileDescription.TAGS.size());
        if (folderType != ResourceFolderType.MIPMAP) {
            Collections.addAll(result2, DRAWABLE_ROOTS_V1);
            if (sdkVersion == null || sdkVersion.getFeatureLevel() >= 16 || ApplicationManager.getApplication().isUnitTestMode()) {
                Collections.addAll(result2, DRAWABLE_ROOTS_V16);
            }
            if (sdkVersion == null || sdkVersion.getFeatureLevel() >= 21 || ApplicationManager.getApplication().isUnitTestMode()) {
                Collections.addAll(result2, DRAWABLE_ROOTS_V21);
            }
        }
        if (sdkVersion == null || sdkVersion.getFeatureLevel() >= 26 || ApplicationManager.getApplication().isUnitTestMode()) {
            result2.addAll((Collection<String>)AdaptiveIconDomFileDescription.TAGS);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            AndroidDrawableDomUtil.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> getPossibleRoots(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidDrawableDomUtil.$$$reportNull$$$0(4);
        }
        List<String> list = AndroidDrawableDomUtil.getPossibleRoots(facet, ResourceFolderType.DRAWABLE);
        if (list == null) {
            AndroidDrawableDomUtil.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderType";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/drawable/AndroidDrawableDomUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/drawable/AndroidDrawableDomUtil";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isDrawableResourceFile";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleRoots";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

