/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.manifest;

import com.android.tools.idea.res.aar.ProtoXmlPullParser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.XmlName;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.android.dom.manifest.CompatibleScreensScreen;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class AndroidManifestUtils {
    private static final String RES_APK = "res.apk";

    public static String getAarPackageName(@NotNull File aarDir) throws IOException {
        if (aarDir == null) {
            AndroidManifestUtils.$$$reportNull$$$0(0);
        }
        try {
            return AndroidManifestUtils.getPackageNameFromManifestFile(aarDir);
        }
        catch (FileNotFoundException e) {
            File resApkFile = new File(aarDir, RES_APK);
            try (ZipFile zipFile = new ZipFile(resApkFile);){
                String string = AndroidManifestUtils.getPackageNameFromResApk(zipFile);
                return string;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String getPackageNameFromManifestFile(@NotNull File aarDir) throws IOException {
        if (aarDir == null) {
            AndroidManifestUtils.$$$reportNull$$$0(1);
        }
        File manifestFile = new File(aarDir, "AndroidManifest.xml");
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(manifestFile));){
            String string = AndroidManifestUtils.getPackageName(stream);
            return string;
        }
        catch (XmlPullParserException e) {
            throw new IOException("File " + manifestFile.getPath() + " has invalid format");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String getPackageNameFromResApk(@NotNull ZipFile resApk) throws IOException {
        ZipEntry zipEntry;
        if (resApk == null) {
            AndroidManifestUtils.$$$reportNull$$$0(2);
        }
        if ((zipEntry = resApk.getEntry("AndroidManifest.xml")) == null) {
            throw new IOException("\"AndroidManifest.xml\" not found in " + resApk.getName());
        }
        try (BufferedInputStream stream = new BufferedInputStream(resApk.getInputStream(zipEntry));){
            String string = AndroidManifestUtils.getPackageName(stream);
            return string;
        }
        catch (XmlPullParserException e) {
            throw new IOException("Invalid AndroidManifest.xml in " + resApk.getName());
        }
    }

    private static String getPackageName(InputStream stream) throws XmlPullParserException, IOException {
        ProtoXmlPullParser parser;
        stream.mark(1);
        int c = stream.read();
        stream.reset();
        if (c == 10) {
            parser = new ProtoXmlPullParser();
        } else {
            parser = new KXmlParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        }
        parser.setInput(stream, null);
        if (parser.nextTag() == 2) {
            return parser.getAttributeValue(null, "package");
        }
        return null;
    }

    @Nullable
    public static String getPackageName(@NotNull AndroidFacet androidFacet) {
        if (androidFacet == null) {
            AndroidManifestUtils.$$$reportNull$$$0(3);
        }
        return (String)CachedValuesManager.getManager((Project)androidFacet.getModule().getProject()).getCachedValue((UserDataHolder)androidFacet, () -> {
            String packageName;
            Manifest manifest;
            if (androidFacet == null) {
                AndroidManifestUtils.$$$reportNull$$$0(6);
            }
            if ((manifest = androidFacet.getManifest()) != null && !StringUtil.isEmptyOrSpaces((String)(packageName = (String)manifest.getPackage().getValue()))) {
                return CachedValueProvider.Result.create((Object)packageName, (Object[])new Object[]{manifest.getXmlTag()});
            }
            return null;
        });
    }

    public static boolean isRequiredAttribute(@NotNull XmlName attrName, @NotNull DomElement element) {
        if (attrName == null) {
            AndroidManifestUtils.$$$reportNull$$$0(4);
        }
        if (element == null) {
            AndroidManifestUtils.$$$reportNull$$$0(5);
        }
        if (element instanceof CompatibleScreensScreen && "http://schemas.android.com/apk/res/android".equals(attrName.getNamespaceKey())) {
            String localName = attrName.getLocalName();
            return "screenSize".equals(localName) || "screenDensity".equals(localName);
        }
        return false;
    }

    private AndroidManifestUtils() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aarDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resApk";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/dom/manifest/AndroidManifestUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAarPackageName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackageNameFromManifestFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackageNameFromResApk";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackageName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isRequiredAttribute";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getPackageName$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

