/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.navigation;

import com.android.SdkConstants;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.psi.TagToClassMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.navigation.ConcreteDestinationElement;
import org.jetbrains.android.dom.navigation.DeeplinkElement;
import org.jetbrains.android.dom.navigation.NavActionElement;
import org.jetbrains.android.dom.navigation.NavArgumentElement;
import org.jetbrains.android.dom.navigation.NavGraphElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigationSchema
implements Disposable {
    public static final String TAG_ACTION = "action";
    public static final String TAG_ARGUMENT = "argument";
    public static final String ATTR_DESTINATION = "destination";
    public static final String INCLUDE_GRAPH_LABEL = "Include Graph";
    public static final String ACTION_LABEL = "Action";
    private static final String NAVIGATOR_CLASS_NAME = "androidx.navigation.Navigator";
    private static final Map<String, DestinationType> NAV_CLASS_TO_TYPE = ImmutableMap.of((Object)"androidx.navigation.NavGraph", (Object)((Object)DestinationType.NAVIGATION), (Object)"androidx.navigation.fragment.FragmentNavigator.Destination", (Object)((Object)DestinationType.FRAGMENT), (Object)"androidx.navigation.ActivityNavigator.Destination", (Object)((Object)DestinationType.ACTIVITY));
    private static final String ANNOTATION_NAV_TAG_NAME = "androidx.navigation.Navigator.Name";
    public static final String ATTR_NAV_TYPE = "navType";
    public static final String ATTR_POP_UP_TO = "popUpTo";
    public static final String ATTR_POP_UP_TO_INCLUSIVE = "popUpToInclusive";
    public static final String ATTR_SINGLE_TOP = "launchSingleTop";
    public static final String ATTR_ENTER_ANIM = "enterAnim";
    public static final String ATTR_EXIT_ANIM = "exitAnim";
    public static final String ATTR_POP_ENTER_ANIM = "popEnterAnim";
    public static final String ATTR_POP_EXIT_ANIM = "popExitAnim";
    public static final String ATTR_ACTION = "action";
    public static final String ATTR_DATA = "data";
    public static final String ATTR_DATA_PATTERN = "dataPattern";
    public static final Map<String, DestinationType> DESTINATION_SUPERCLASS_TO_TYPE = ImmutableMap.of((Object)"android.app.Activity", (Object)((Object)DestinationType.ACTIVITY), (Object)"android.app.Fragment", (Object)((Object)DestinationType.FRAGMENT), (Object)SdkConstants.CLASS_V4_FRAGMENT.oldName(), (Object)((Object)DestinationType.FRAGMENT), (Object)SdkConstants.CLASS_V4_FRAGMENT.newName(), (Object)((Object)DestinationType.FRAGMENT));
    private static final Map<AndroidFacet, NavigationSchema> ourSchemas = new HashMap<AndroidFacet, NavigationSchema>();
    private Map<DestinationType, String> myTypeToRootTag;
    private Map<String, DestinationType> myTagToDestinationType;
    private Map<PsiClass, String> myNavigatorClassToTag;
    private final AndroidFacet myFacet;
    public static final String ATTR_DEFAULT_VALUE = "defaultValue";
    public static final String NAV_HOST_FRAGMENT = "androidx.navigation.NavHostFragment";

    public static boolean enableNavigationEditor() {
        return (Boolean)StudioFlags.ENABLE_NAV_EDITOR.get();
    }

    @NotNull
    public static synchronized NavigationSchema get(@NotNull AndroidFacet facet) {
        if (facet == null) {
            NavigationSchema.$$$reportNull$$$0(0);
        }
        NavigationSchema result2 = ourSchemas.get((Object)facet);
        Preconditions.checkNotNull((Object)result2, (Object)"NavigationSchema must be created first!");
        NavigationSchema navigationSchema = result2;
        if (navigationSchema == null) {
            NavigationSchema.$$$reportNull$$$0(1);
        }
        return navigationSchema;
    }

    public static synchronized void createIfNecessary(@NotNull AndroidFacet facet) throws ClassNotFoundException {
        NavigationSchema result2;
        if (facet == null) {
            NavigationSchema.$$$reportNull$$$0(2);
        }
        if ((result2 = ourSchemas.get((Object)facet)) == null) {
            result2 = new NavigationSchema(facet);
            result2.init();
            Disposer.register((Disposable)facet, (Disposable)result2);
            ourSchemas.put(facet, result2);
        }
    }

    private NavigationSchema(@NotNull AndroidFacet facet) {
        if (facet == null) {
            NavigationSchema.$$$reportNull$$$0(3);
        }
        this.myTypeToRootTag = ImmutableMap.of((Object)((Object)DestinationType.FRAGMENT), (Object)"fragment", (Object)((Object)DestinationType.ACTIVITY), (Object)"activity", (Object)((Object)DestinationType.NAVIGATION), (Object)"navigation");
        this.myFacet = facet;
    }

    public void dispose() {
        ApplicationManager.getApplication().invokeLater(() -> ourSchemas.remove((Object)this.myFacet));
    }

    @NotNull
    private static DestinationType getType(@NotNull PsiClass subNav, @NotNull PsiClass navigatorRoot, PsiTypeParameter destinationTypeParam) {
        PsiType resolved;
        if (subNav == null) {
            NavigationSchema.$$$reportNull$$$0(4);
        }
        if (navigatorRoot == null) {
            NavigationSchema.$$$reportNull$$$0(5);
        }
        if ((resolved = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)navigatorRoot, (PsiClassType)PsiTypesUtil.getClassType((PsiClass)subNav)).substitute(destinationTypeParam)) == null) {
            DestinationType destinationType = DestinationType.OTHER;
            if (destinationType == null) {
                NavigationSchema.$$$reportNull$$$0(6);
            }
            return destinationType;
        }
        DestinationType destinationType = NAV_CLASS_TO_TYPE.getOrDefault(resolved.getCanonicalText(), DestinationType.OTHER);
        if (destinationType == null) {
            NavigationSchema.$$$reportNull$$$0(7);
        }
        return destinationType;
    }

    @Nullable
    private static String getTagAttributeValue(@NotNull PsiClass subNav) {
        PsiAnnotation annotation;
        if (subNav == null) {
            NavigationSchema.$$$reportNull$$$0(8);
        }
        return (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)subNav, (String[])new String[]{ANNOTATION_NAV_TAG_NAME})) == null ? null : AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, (String)"value");
    }

    private void init() throws ClassNotFoundException {
        Project project = this.myFacet.getModule().getProject();
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass navigatorRoot = javaPsiFacade.findClass(NAVIGATOR_CLASS_NAME, GlobalSearchScope.allScope((Project)project));
        if (navigatorRoot == null) {
            Logger.getInstance(this.getClass()).warn("Navigator class not found.");
            throw new ClassNotFoundException(NAVIGATOR_CLASS_NAME);
        }
        PsiTypeParameter destinationTypeParam = navigatorRoot.getTypeParameters()[0];
        HashMap<String, DestinationType> tagToType = new HashMap<String, DestinationType>();
        HashMap<PsiClass, String> classToTag = new HashMap<PsiClass, String>();
        for (PsiClass navClass : this.getClassMap(NAVIGATOR_CLASS_NAME).values()) {
            if (navClass.equals(navigatorRoot)) continue;
            DestinationType type = NavigationSchema.getType(navClass, navigatorRoot, destinationTypeParam);
            String tag = NavigationSchema.getTagAttributeValue(navClass);
            if (tag == null) continue;
            if (tagToType.getOrDefault(tag, type) != type) {
                Logger.getInstance(NavigationSchema.class).warn("Multiple destination types for tag " + navClass);
            }
            tagToType.put(tag, type);
            classToTag.put(navClass, tag);
        }
        tagToType.put("include", DestinationType.NAVIGATION);
        this.myNavigatorClassToTag = classToTag;
        this.myTagToDestinationType = tagToType;
    }

    @NotNull
    public Multimap<Class<? extends AndroidDomElement>, String> getDestinationSubtags(@NotNull String tagName) {
        if (tagName == null) {
            NavigationSchema.$$$reportNull$$$0(9);
        }
        if (tagName.equals("action")) {
            ImmutableSetMultimap immutableSetMultimap = ImmutableSetMultimap.of(NavArgumentElement.class, (Object)TAG_ARGUMENT);
            if (immutableSetMultimap == null) {
                NavigationSchema.$$$reportNull$$$0(10);
            }
            return immutableSetMultimap;
        }
        DestinationType type = this.getDestinationType(tagName);
        if (type == null || tagName.equals("include")) {
            ImmutableListMultimap immutableListMultimap = ImmutableListMultimap.of();
            if (immutableListMultimap == null) {
                NavigationSchema.$$$reportNull$$$0(11);
            }
            return immutableListMultimap;
        }
        HashMultimap result2 = HashMultimap.create();
        if (type == DestinationType.NAVIGATION) {
            this.myTagToDestinationType.forEach((arg_0, arg_1) -> NavigationSchema.lambda$getDestinationSubtags$1((Multimap)result2, arg_0, arg_1));
        }
        if (type != DestinationType.ACTIVITY) {
            result2.put(NavActionElement.class, (Object)"action");
        }
        result2.put(DeeplinkElement.class, (Object)"deepLink");
        result2.put(NavArgumentElement.class, (Object)TAG_ARGUMENT);
        HashMultimap hashMultimap = result2;
        if (hashMultimap == null) {
            NavigationSchema.$$$reportNull$$$0(12);
        }
        return hashMultimap;
    }

    @Nullable
    public DestinationType getDestinationType(@NotNull String tag) {
        if (tag == null) {
            NavigationSchema.$$$reportNull$$$0(13);
        }
        return this.myTagToDestinationType.get(tag);
    }

    @Nullable
    public String getDefaultTag(@NotNull DestinationType type) {
        if (type == null) {
            NavigationSchema.$$$reportNull$$$0(14);
        }
        return this.myTypeToRootTag.get((Object)type);
    }

    @Nullable
    public String getTagForComponentSuperclass(@NotNull String superclassName) {
        DestinationType type;
        if (superclassName == null) {
            NavigationSchema.$$$reportNull$$$0(15);
        }
        if ((type = DESTINATION_SUPERCLASS_TO_TYPE.get(superclassName)) != null) {
            return this.getDefaultTag(type);
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public String findTagForComponent(@Nullable PsiClass layoutClass) {
        while (layoutClass != null) {
            String tag;
            String qName = layoutClass.getQualifiedName();
            if (qName != null && (tag = this.getTagForComponentSuperclass(qName)) != null) {
                return tag;
            }
            layoutClass = layoutClass.getSuperClass();
        }
        return null;
    }

    @NotNull
    public static List<String> getPossibleRootsMaybeWithoutSchema(@NotNull AndroidFacet facet) {
        if (facet == null) {
            NavigationSchema.$$$reportNull$$$0(16);
        }
        Application application = ApplicationManager.getApplication();
        AtomicReference result2 = new AtomicReference();
        application.invokeAndWait(() -> {
            if (facet == null) {
                NavigationSchema.$$$reportNull$$$0(31);
            }
            application.runReadAction(() -> {
                if (facet == null) {
                    NavigationSchema.$$$reportNull$$$0(32);
                }
                try {
                    NavigationSchema.createIfNecessary(facet);
                    result2.set(NavigationSchema.get(facet).getPossibleRoots());
                }
                catch (ClassNotFoundException e) {
                    result2.set(ImmutableList.of((Object)"navigation"));
                }
            });
        });
        List list = (List)result2.get();
        if (list == null) {
            NavigationSchema.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    public List<String> getPossibleRoots() {
        List<String> list = this.myTagToDestinationType.keySet().stream().filter(tag -> this.myTagToDestinationType.get(tag) == DestinationType.NAVIGATION).collect(Collectors.toList());
        if (list == null) {
            NavigationSchema.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    public String getTag(@NotNull PsiClass navigatorClass) {
        if (navigatorClass == null) {
            NavigationSchema.$$$reportNull$$$0(19);
        }
        String string = this.myNavigatorClassToTag.get(navigatorClass);
        if (string == null) {
            NavigationSchema.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Nullable
    public DestinationType getTypeForNavigatorClass(@NotNull PsiClass navigatorClass) {
        String tag;
        if (navigatorClass == null) {
            NavigationSchema.$$$reportNull$$$0(21);
        }
        return (tag = this.myNavigatorClassToTag.get(navigatorClass)) == null ? null : this.myTagToDestinationType.get(tag);
    }

    @NotNull
    public Set<PsiClass> getDestinationClassesByTagSlowly(@NotNull String tagName) {
        if (tagName == null) {
            NavigationSchema.$$$reportNull$$$0(22);
        }
        Set<PsiClass> set = this.myNavigatorClassToTag.keySet().stream().filter(c -> {
            if (tagName == null) {
                NavigationSchema.$$$reportNull$$$0(30);
            }
            return this.myNavigatorClassToTag.get(c).equals(tagName);
        }).collect(Collectors.toSet());
        if (set == null) {
            NavigationSchema.$$$reportNull$$$0(23);
        }
        return set;
    }

    public Map<String, DestinationType> getTagTypeMap() {
        return Collections.unmodifiableMap(this.myTagToDestinationType);
    }

    public Map<PsiClass, String> getNavigatorClassTagMap() {
        return Collections.unmodifiableMap(this.myNavigatorClassToTag);
    }

    @NotNull
    private Map<String, PsiClass> getClassMap(@NotNull String className) {
        Map<String, PsiClass> result2;
        if (className == null) {
            NavigationSchema.$$$reportNull$$$0(24);
        }
        if ((result2 = TagToClassMapper.getInstance(this.myFacet.getModule()).getClassMap(className)).isEmpty()) {
            throw new RuntimeException(className + " not found");
        }
        Map<String, PsiClass> map2 = result2;
        if (map2 == null) {
            NavigationSchema.$$$reportNull$$$0(25);
        }
        return map2;
    }

    @NotNull
    public String getTagLabel(@NotNull String tag) {
        if (tag == null) {
            NavigationSchema.$$$reportNull$$$0(26);
        }
        String string = this.getTagLabel(tag, false);
        if (string == null) {
            NavigationSchema.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public String getTagLabel(@NotNull String tag, boolean isRoot) {
        if (tag == null) {
            NavigationSchema.$$$reportNull$$$0(28);
        }
        String text = null;
        if ("include".equals(tag)) {
            text = INCLUDE_GRAPH_LABEL;
        } else if ("action".equals(tag)) {
            text = ACTION_LABEL;
        } else {
            DestinationType type = this.getDestinationType(tag);
            if (type == DestinationType.NAVIGATION) {
                text = isRoot ? "Root Graph" : "Nested Graph";
            } else if (type == DestinationType.FRAGMENT) {
                text = "Fragment";
            } else if (type == DestinationType.ACTIVITY) {
                text = "Activity";
            }
            if (type == DestinationType.OTHER) {
                text = tag;
            } else if (type != null && !tag.equals(this.getDefaultTag(type))) {
                text = text + " (" + tag + ")";
            }
        }
        assert (text != null);
        String string = text;
        if (string == null) {
            NavigationSchema.$$$reportNull$$$0(29);
        }
        return string;
    }

    private static /* synthetic */ void lambda$getDestinationSubtags$1(Multimap result2, String key, DestinationType value) {
        result2.put(value == DestinationType.NAVIGATION ? NavGraphElement.class : ConcreteDestinationElement.class, (Object)key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/navigation/NavigationSchema";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subNav";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatorRoot";
                break;
            }
            case 9: 
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 13: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superclassName";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatorClass";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/navigation/NavigationSchema";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDestinationSubtags";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleRootsMaybeWithoutSchema";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleRoots";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTag";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDestinationClassesByTagSlowly";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassMap";
                break;
            }
            case 27: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 29: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createIfNecessary";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTagAttributeValue";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDestinationSubtags";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDestinationType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTag";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTagForComponentSuperclass";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleRootsMaybeWithoutSchema";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTag";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForNavigatorClass";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDestinationClassesByTagSlowly";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getClassMap";
                break;
            }
            case 26: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getTagLabel";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDestinationClassesByTagSlowly$5";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getPossibleRootsMaybeWithoutSchema$3";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum DestinationType {
        NAVIGATION,
        FRAGMENT,
        ACTIVITY,
        OTHER;

    }
}

