/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.structure.resources;

import com.android.resources.ResourceType;
import com.google.common.collect.Lists;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.dom.structure.StructureUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceStructureViewBuilder
extends TreeBasedStructureViewBuilder {
    private final DomFileElement<Resources> myResources;

    public ResourceStructureViewBuilder(@NotNull DomFileElement<Resources> resources) {
        if (resources == null) {
            ResourceStructureViewBuilder.$$$reportNull$$$0(0);
        }
        this.myResources = resources;
    }

    @NotNull
    public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
        StructureViewModelBase structureViewModelBase = new StructureViewModelBase((PsiFile)this.myResources.getFile(), (StructureViewTreeElement)new Root(this.myResources));
        if (structureViewModelBase == null) {
            ResourceStructureViewBuilder.$$$reportNull$$$0(1);
        }
        return structureViewModelBase;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resources";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/structure/resources/ResourceStructureViewBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/structure/resources/ResourceStructureViewBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createStructureViewModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Leaf
    extends PsiTreeElementBase<PsiElement> {
        private final String myName;
        private final ResourceType myResourceType;

        protected Leaf(@NotNull PsiElement psiElement, @NotNull String name, @NotNull ResourceType resourceType) {
            if (psiElement == null) {
                Leaf.$$$reportNull$$$0(0);
            }
            if (name == null) {
                Leaf.$$$reportNull$$$0(1);
            }
            if (resourceType == null) {
                Leaf.$$$reportNull$$$0(2);
            }
            super(psiElement);
            this.myName = name;
            this.myResourceType = resourceType;
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                Leaf.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Nullable
        public String getPresentableText() {
            return this.myResourceType.getDisplayName() + " - " + this.myName;
        }

        public String toString() {
            return this.getPresentableText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/dom/structure/resources/ResourceStructureViewBuilder$Leaf";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/dom/structure/resources/ResourceStructureViewBuilder$Leaf";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildrenBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Root
    extends PsiTreeElementBase<PsiElement> {
        private final DomFileElement<Resources> myResources;

        Root(@NotNull DomFileElement<Resources> resources) {
            if (resources == null) {
                Root.$$$reportNull$$$0(0);
            }
            super((PsiElement)resources.getXmlElement());
            this.myResources = resources;
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            final ArrayList result2 = Lists.newArrayList();
            DomElementVisitor visitor = new DomElementVisitor(){

                public void visitResourceElement(ResourceElement element) {
                    ResourceType type = AndroidResourceUtil.getType(element.getXmlTag());
                    String name = (String)element.getName().getValue();
                    XmlElement xmlElement = element.getXmlElement();
                    if (name != null && type != null && xmlElement != null) {
                        result2.add(new Leaf((PsiElement)xmlElement, name, type));
                    }
                }

                public void visitDomElement(DomElement element) {
                }
            };
            StructureUtils.acceptChildrenInOrder(this.myResources.getRootElement(), visitor);
            ArrayList arrayList = result2;
            if (arrayList == null) {
                Root.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        @NotNull
        public String getPresentableText() {
            String string = String.format("Resources file '%s'", this.myResources.getFile().getName());
            if (string == null) {
                Root.$$$reportNull$$$0(2);
            }
            return string;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getPresentableText());
            builder.append('\n');
            for (StructureViewTreeElement child : this.getChildrenBase()) {
                builder.append("  ").append(child.toString()).append('\n');
            }
            return builder.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resources";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/dom/structure/resources/ResourceStructureViewBuilder$Root";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/dom/structure/resources/ResourceStructureViewBuilder$Root";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildrenBase";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

