/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.util.PropertiesFiles;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.OrderedSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.AndroidDexCompiler;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRootUtil {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.facet.AndroidRootUtil");
    @NonNls
    public static final String DEFAULT_PROPERTIES_FILE_NAME = "default.properties";

    private AndroidRootUtil() {
    }

    @Deprecated
    @Nullable
    public static VirtualFile getManifestFile(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidRootUtil.$$$reportNull$$$0(0);
        }
        if (facet.requiresAndroidModel()) {
            return facet.getMainIdeaSourceProvider().getManifestFile();
        }
        return AndroidRootUtil.getFileByRelativeModulePath(facet.getModule(), facet.getProperties().MANIFEST_FILE_RELATIVE_PATH, true);
    }

    @Nullable
    public static VirtualFile getPrimaryManifestFile(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidRootUtil.$$$reportNull$$$0(1);
        }
        return facet.getMainIdeaSourceProvider().getManifestFile();
    }

    @Nullable
    public static VirtualFile getCustomManifestFileForCompiler(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidRootUtil.$$$reportNull$$$0(2);
        }
        return AndroidRootUtil.getFileByRelativeModulePath(facet.getModule(), facet.getProperties().CUSTOM_COMPILER_MANIFEST, false);
    }

    @Nullable
    public static VirtualFile getManifestFileForCompiler(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidRootUtil.$$$reportNull$$$0(3);
        }
        return facet.getProperties().USE_CUSTOM_COMPILER_MANIFEST ? AndroidRootUtil.getCustomManifestFileForCompiler(facet) : AndroidRootUtil.getPrimaryManifestFile(facet);
    }

    @Deprecated
    @Nullable
    public static VirtualFile getResourceDir(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidRootUtil.$$$reportNull$$$0(4);
        }
        return ResourceFolderManager.getInstance(facet).getPrimaryFolder();
    }

    @Nullable
    private static String suggestResourceDirPath(@NotNull AndroidFacet facet) {
        Module module;
        VirtualFile[] contentRoots;
        if (facet == null) {
            AndroidRootUtil.$$$reportNull$$$0(5);
        }
        if ((contentRoots = ModuleRootManager.getInstance((Module)(module = facet.getModule())).getContentRoots()).length == 0) {
            return null;
        }
        VirtualFile root = contentRoots[0];
        if (contentRoots.length > 1) {
            String moduleFileParentDirPath = FileUtil.toSystemIndependentName((String)new File(module.getModuleFilePath()).getParent());
            VirtualFile moduleFileParentDir = LocalFileSystem.getInstance().findFileByPath(moduleFileParentDirPath);
            if (moduleFileParentDir != null) {
                for (VirtualFile contentRoot : contentRoots) {
                    if (!Comparing.equal((Object)contentRoot, (Object)moduleFileParentDir)) continue;
                    root = contentRoot;
                }
            }
        }
        return root.getPath() + facet.getProperties().RES_FOLDER_RELATIVE_PATH;
    }

    @Nullable
    public static String getResourceDirPath(@NotNull AndroidFacet facet) {
        VirtualFile resourceDir;
        if (facet == null) {
            AndroidRootUtil.$$$reportNull$$$0(6);
        }
        return (resourceDir = AndroidRootUtil.getResourceDir(facet)) != null ? resourceDir.getPath() : AndroidRootUtil.suggestResourceDirPath(facet);
    }

    @Nullable
    public static VirtualFile getFileByRelativeModulePath(Module module, String relativePath, boolean lookInContentRoot) {
        if (module.isDisposed() || relativePath == null || relativePath.isEmpty()) {
            return null;
        }
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        String moduleDirPath = new File(module.getModuleFilePath()).getParent();
        if (moduleDirPath != null) {
            String absPath = FileUtil.toSystemIndependentName((String)(moduleDirPath + relativePath));
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(absPath);
            if (file != null) {
                return file;
            }
        }
        if (lookInContentRoot) {
            for (VirtualFile contentRoot : contentRoots) {
                String absPath = FileUtil.toSystemIndependentName((String)(contentRoot.getPath() + relativePath));
                VirtualFile file = LocalFileSystem.getInstance().findFileByPath(absPath);
                if (file == null) continue;
                return file;
            }
        }
        return null;
    }

    @Nullable
    public static VirtualFile getAssetsDir(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidRootUtil.$$$reportNull$$$0(7);
        }
        return AndroidRootUtil.getFileByRelativeModulePath(facet.getModule(), facet.getProperties().ASSETS_FOLDER_RELATIVE_PATH, false);
    }

    @Nullable
    public static VirtualFile getLibsDir(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidRootUtil.$$$reportNull$$$0(8);
        }
        return AndroidRootUtil.getFileByRelativeModulePath(facet.getModule(), facet.getProperties().LIBS_FOLDER_RELATIVE_PATH, false);
    }

    @Nullable
    public static VirtualFile getAidlGenDir(@NotNull AndroidFacet facet) {
        String genPath;
        if (facet == null) {
            AndroidRootUtil.$$$reportNull$$$0(9);
        }
        return (genPath = AndroidRootUtil.getAidlGenSourceRootPath(facet)) != null ? LocalFileSystem.getInstance().findFileByPath(genPath) : null;
    }

    @Nullable
    public static VirtualFile getAaptGenDir(@NotNull AndroidFacet facet) {
        String genPath;
        if (facet == null) {
            AndroidRootUtil.$$$reportNull$$$0(10);
        }
        return (genPath = AndroidRootUtil.getAptGenSourceRootPath(facet)) != null ? LocalFileSystem.getInstance().findFileByPath(genPath) : null;
    }

    @Nullable
    public static VirtualFile getRenderscriptGenDir(@NotNull AndroidFacet facet) {
        String path;
        if (facet == null) {
            AndroidRootUtil.$$$reportNull$$$0(11);
        }
        return (path = AndroidRootUtil.getRenderscriptGenSourceRootPath(facet)) != null ? LocalFileSystem.getInstance().findFileByPath(path) : null;
    }

    @Nullable
    public static VirtualFile getBuildconfigGenDir(@NotNull AndroidFacet facet) {
        String path;
        if (facet == null) {
            AndroidRootUtil.$$$reportNull$$$0(12);
        }
        return (path = AndroidRootUtil.getBuildconfigGenSourceRootPath(facet)) != null ? LocalFileSystem.getInstance().findFileByPath(path) : null;
    }

    @Nullable
    public static VirtualFile getStandardGenDir(@NotNull Module module) {
        if (module == null) {
            AndroidRootUtil.$$$reportNull$$$0(13);
        }
        return AndroidRootUtil.getFileByRelativeModulePath(module, "/gen", false);
    }

    private static void collectClassFilesAndJars(@NotNull VirtualFile root, @NotNull Set<VirtualFile> result2, @NotNull Set<VirtualFile> visited) {
        if (root == null) {
            AndroidRootUtil.$$$reportNull$$$0(14);
        }
        if (result2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(15);
        }
        if (visited == null) {
            AndroidRootUtil.$$$reportNull$$$0(16);
        }
        if (!visited.add(root)) {
            return;
        }
        for (VirtualFile child : root.getChildren()) {
            if (!child.exists()) continue;
            if (child.isDirectory()) {
                AndroidRootUtil.collectClassFilesAndJars(child, result2, visited);
                continue;
            }
            if (!"jar".equals(child.getExtension()) && !"class".equals(child.getExtension())) continue;
            if (child.getFileSystem() instanceof JarFileSystem) {
                VirtualFile localFile = JarFileSystem.getInstance().getVirtualFileForJar(child);
                if (localFile == null) continue;
                result2.add(localFile);
                continue;
            }
            result2.add(child);
        }
    }

    private static void fillExternalLibrariesAndModules(@NotNull Module module, @NotNull Set<VirtualFile> outputDirs, @NotNull Set<Module> visited, @Nullable Set<VirtualFile> libraries, boolean exportedLibrariesOnly, boolean recursive) {
        if (module == null) {
            AndroidRootUtil.$$$reportNull$$$0(17);
        }
        if (outputDirs == null) {
            AndroidRootUtil.$$$reportNull$$$0(18);
        }
        if (visited == null) {
            AndroidRootUtil.$$$reportNull$$$0(19);
        }
        if (!visited.add(module)) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (module == null) {
                AndroidRootUtil.$$$reportNull$$$0(49);
            }
            if (outputDirs == null) {
                AndroidRootUtil.$$$reportNull$$$0(50);
            }
            if (visited == null) {
                AndroidRootUtil.$$$reportNull$$$0(51);
            }
            ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
            for (OrderEntry entry : manager.getOrderEntries()) {
                Module depModule;
                if (!(entry instanceof ExportableOrderEntry) || ((ExportableOrderEntry)entry).getScope() != DependencyScope.COMPILE) continue;
                if (libraries != null && entry instanceof LibraryOrderEntry) {
                    LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)entry;
                    Library library = libraryOrderEntry.getLibrary();
                    if (library == null || exportedLibrariesOnly && !libraryOrderEntry.isExported()) continue;
                    for (VirtualFile file : library.getFiles(OrderRootType.CLASSES)) {
                        if (!file.exists()) continue;
                        if (file.getFileType() instanceof ArchiveFileType) {
                            if (file.getFileSystem() instanceof JarFileSystem) {
                                VirtualFile localFile = JarFileSystem.getInstance().getVirtualFileForJar(file);
                                if (localFile == null) continue;
                                libraries.add(localFile);
                                continue;
                            }
                            libraries.add(file);
                            continue;
                        }
                        if (!file.isDirectory() || file.getFileSystem() instanceof JarFileSystem) continue;
                        AndroidRootUtil.collectClassFilesAndJars(file, libraries, new HashSet<VirtualFile>());
                    }
                    continue;
                }
                if (!(entry instanceof ModuleOrderEntry) || (depModule = ((ModuleOrderEntry)entry).getModule()) == null) continue;
                AndroidFacet facet = AndroidFacet.getInstance(depModule);
                boolean libraryProject = facet != null && ((AndroidFacetConfiguration)facet.getConfiguration()).isLibraryProject();
                CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)depModule);
                if (extension != null) {
                    VirtualFile classDir = extension.getCompilerOutputPath();
                    if (libraryProject) {
                        VirtualFile packedClassesJar;
                        VirtualFile tmpArtifactsDir = AndroidDexCompiler.getOutputDirectoryForDex(depModule);
                        if (tmpArtifactsDir != null && (packedClassesJar = tmpArtifactsDir.findChild("classes.jar")) != null) {
                            outputDirs.add(packedClassesJar);
                        }
                    } else if (facet == null && !outputDirs.contains(classDir) && classDir != null && classDir.exists()) {
                        outputDirs.add(classDir);
                    }
                }
                if (!recursive) continue;
                AndroidRootUtil.fillExternalLibrariesAndModules(depModule, outputDirs, visited, libraries, !libraryProject || exportedLibrariesOnly, true);
            }
        });
    }

    @NotNull
    public static List<VirtualFile> getExternalLibraries(Module module) {
        HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
        OrderedSet libs = new OrderedSet();
        boolean recursive = !AndroidMavenUtil.isMavenizedModule(module);
        AndroidRootUtil.fillExternalLibrariesAndModules(module, files2, new HashSet<Module>(), (Set<VirtualFile>)libs, false, recursive);
        AndroidRootUtil.addAnnotationsJar(module, (OrderedSet<VirtualFile>)libs);
        OrderedSet orderedSet = libs;
        if (orderedSet == null) {
            AndroidRootUtil.$$$reportNull$$$0(20);
        }
        return orderedSet;
    }

    private static void addAnnotationsJar(@NotNull Module module, @NotNull OrderedSet<VirtualFile> libs) {
        Sdk sdk;
        if (module == null) {
            AndroidRootUtil.$$$reportNull$$$0(21);
        }
        if (libs == null) {
            AndroidRootUtil.$$$reportNull$$$0(22);
        }
        if ((sdk = ModuleRootManager.getInstance((Module)module).getSdk()) == null || !AndroidSdks.getInstance().isAndroidSdk(sdk)) {
            return;
        }
        String sdkHomePath = sdk.getHomePath();
        if (sdkHomePath == null) {
            return;
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform != null && platform.needToAddAnnotationsJarToClasspath()) {
            String annotationsJarPath = FileUtil.toSystemIndependentName((String)sdkHomePath) + "/tools/support/annotations.jar";
            VirtualFile annotationsJar = LocalFileSystem.getInstance().findFileByPath(annotationsJarPath);
            if (annotationsJar != null) {
                libs.add((Object)annotationsJar);
            }
        }
    }

    @NotNull
    public static Set<VirtualFile> getDependentModules(@NotNull Module module, @NotNull VirtualFile moduleOutputDir) {
        if (module == null) {
            AndroidRootUtil.$$$reportNull$$$0(23);
        }
        if (moduleOutputDir == null) {
            AndroidRootUtil.$$$reportNull$$$0(24);
        }
        HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
        AndroidRootUtil.fillExternalLibrariesAndModules(module, files2, new HashSet<Module>(), null, false, true);
        files2.remove(moduleOutputDir);
        HashSet<VirtualFile> hashSet = files2;
        if (hashSet == null) {
            AndroidRootUtil.$$$reportNull$$$0(25);
        }
        return hashSet;
    }

    @NotNull
    public static VirtualFile[] getResourceOverlayDirs(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidRootUtil.$$$reportNull$$$0(26);
        }
        List overlayFolders = facet.getProperties().RES_OVERLAY_FOLDERS;
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (String overlayFolder : overlayFolders) {
            VirtualFile overlayDir = AndroidRootUtil.getFileByRelativeModulePath(facet.getModule(), overlayFolder, true);
            if (overlayDir == null) continue;
            result2.add(overlayDir);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result2);
        if (virtualFileArray == null) {
            AndroidRootUtil.$$$reportNull$$$0(27);
        }
        return virtualFileArray;
    }

    @Nullable
    public static String getModuleDirPath(Module module) {
        String moduleFilePath = module.getModuleFilePath();
        String moduleDirPath = new File(moduleFilePath).getParent();
        if (moduleDirPath != null) {
            moduleDirPath = FileUtil.toSystemIndependentName((String)moduleDirPath);
        }
        return moduleDirPath;
    }

    @Nullable
    public static String getRenderscriptGenSourceRootPath(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidRootUtil.$$$reportNull$$$0(28);
        }
        return AndroidRootUtil.getAidlGenSourceRootPath(facet);
    }

    @Nullable
    public static String getBuildconfigGenSourceRootPath(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidRootUtil.$$$reportNull$$$0(29);
        }
        return AndroidRootUtil.getAptGenSourceRootPath(facet);
    }

    @Nullable
    public static VirtualFile getMainContentRoot(@NotNull AndroidFacet facet) {
        Module module;
        VirtualFile[] contentRoots;
        if (facet == null) {
            AndroidRootUtil.$$$reportNull$$$0(30);
        }
        if ((contentRoots = ModuleRootManager.getInstance((Module)(module = facet.getModule())).getContentRoots()).length == 0) {
            return null;
        }
        if (contentRoots.length == 1) {
            return contentRoots[0];
        }
        VirtualFile manifestFile = AndroidRootUtil.getPrimaryManifestFile(facet);
        if (manifestFile != null) {
            for (VirtualFile root : contentRoots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)manifestFile, (boolean)true)) continue;
                return root;
            }
        }
        return contentRoots[0];
    }

    @Nullable
    public static Pair<PropertiesFile, VirtualFile> findPropertyFile(@NotNull Module module, @NotNull String propertyFileName) {
        if (module == null) {
            AndroidRootUtil.$$$reportNull$$$0(31);
        }
        if (propertyFileName == null) {
            AndroidRootUtil.$$$reportNull$$$0(32);
        }
        for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            PsiFile psiFile;
            VirtualFile vFile = contentRoot.findChild(propertyFileName);
            if (vFile == null || !((psiFile = AndroidPsiUtils.getPsiFileSafely(module.getProject(), vFile)) instanceof PropertiesFile)) continue;
            return Pair.create((Object)((PropertiesFile)psiFile), (Object)vFile);
        }
        return null;
    }

    @Nullable
    public static Pair<Properties, VirtualFile> readPropertyFile(@NotNull Module module, @NotNull String propertyFileName) {
        if (module == null) {
            AndroidRootUtil.$$$reportNull$$$0(33);
        }
        if (propertyFileName == null) {
            AndroidRootUtil.$$$reportNull$$$0(34);
        }
        for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            Pair<Properties, VirtualFile> result2 = AndroidRootUtil.readPropertyFile(contentRoot, propertyFileName);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    public static Pair<Properties, VirtualFile> readProjectPropertyFile(@NotNull Module module) {
        Pair<Properties, VirtualFile> pair;
        if (module == null) {
            AndroidRootUtil.$$$reportNull$$$0(35);
        }
        return (pair = AndroidRootUtil.readPropertyFile(module, "project.properties")) != null ? pair : AndroidRootUtil.readPropertyFile(module, DEFAULT_PROPERTIES_FILE_NAME);
    }

    @Nullable
    private static Pair<Properties, VirtualFile> readPropertyFile(@NotNull VirtualFile contentRoot, @NotNull String propertyFileName) {
        VirtualFile vFile;
        if (contentRoot == null) {
            AndroidRootUtil.$$$reportNull$$$0(36);
        }
        if (propertyFileName == null) {
            AndroidRootUtil.$$$reportNull$$$0(37);
        }
        if ((vFile = contentRoot.findChild(propertyFileName)) != null) {
            try {
                File file = VfsUtilCore.virtualToIoFile((VirtualFile)vFile);
                Properties properties = PropertiesFiles.getProperties(file);
                return Pair.create((Object)properties, (Object)vFile);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    public static Pair<Properties, VirtualFile> readProjectPropertyFile(@NotNull VirtualFile contentRoot) {
        Pair<Properties, VirtualFile> pair;
        if (contentRoot == null) {
            AndroidRootUtil.$$$reportNull$$$0(38);
        }
        return (pair = AndroidRootUtil.readPropertyFile(contentRoot, "project.properties")) != null ? pair : AndroidRootUtil.readPropertyFile(contentRoot, DEFAULT_PROPERTIES_FILE_NAME);
    }

    @Nullable
    public static Pair<String, VirtualFile> getPropertyValue(@NotNull Module module, @NotNull String propertyFileName, @NotNull String propertyKey) {
        String value;
        Pair<Properties, VirtualFile> pair;
        if (module == null) {
            AndroidRootUtil.$$$reportNull$$$0(39);
        }
        if (propertyFileName == null) {
            AndroidRootUtil.$$$reportNull$$$0(40);
        }
        if (propertyKey == null) {
            AndroidRootUtil.$$$reportNull$$$0(41);
        }
        if ((pair = AndroidRootUtil.readPropertyFile(module, propertyFileName)) != null && (value = ((Properties)pair.first).getProperty(propertyKey)) != null) {
            return Pair.create((Object)value, (Object)pair.second);
        }
        return null;
    }

    @Nullable
    public static Pair<String, VirtualFile> getProjectPropertyValue(@NotNull Module module, @NotNull String propertyName) {
        Pair<String, VirtualFile> result2;
        if (module == null) {
            AndroidRootUtil.$$$reportNull$$$0(42);
        }
        if (propertyName == null) {
            AndroidRootUtil.$$$reportNull$$$0(43);
        }
        return (result2 = AndroidRootUtil.getPropertyValue(module, "project.properties", propertyName)) != null ? result2 : AndroidRootUtil.getPropertyValue(module, DEFAULT_PROPERTIES_FILE_NAME, propertyName);
    }

    @Nullable
    public static String getAptGenSourceRootPath(@NotNull AndroidFacet facet) {
        String path;
        if (facet == null) {
            AndroidRootUtil.$$$reportNull$$$0(44);
        }
        if ((path = facet.getProperties().GEN_FOLDER_RELATIVE_PATH_APT).isEmpty()) {
            return null;
        }
        String moduleDirPath = AndroidRootUtil.getModuleDirPath(facet.getModule());
        return moduleDirPath != null ? moduleDirPath + path : null;
    }

    @Nullable
    public static String getAidlGenSourceRootPath(@NotNull AndroidFacet facet) {
        String path;
        if (facet == null) {
            AndroidRootUtil.$$$reportNull$$$0(45);
        }
        if ((path = facet.getProperties().GEN_FOLDER_RELATIVE_PATH_AIDL).isEmpty()) {
            return null;
        }
        String moduleDirPath = AndroidRootUtil.getModuleDirPath(facet.getModule());
        return moduleDirPath != null ? moduleDirPath + path : null;
    }

    @Nullable
    public static String getApkPath(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidRootUtil.$$$reportNull$$$0(46);
        }
        if (facet.requiresAndroidModel()) {
            AndroidModuleModel androidModuleModel = AndroidModuleModel.get(facet);
            if (androidModuleModel != null) {
                IdeAndroidArtifact mainArtifact = androidModuleModel.getMainArtifact();
                AndroidArtifactOutput output = GradleUtil.getOutput((AndroidArtifact)mainArtifact);
                File outputFile = output.getMainOutputFile().getOutputFile();
                return outputFile.getAbsolutePath();
            }
            return null;
        }
        String path = facet.getProperties().APK_PATH;
        if (path.isEmpty()) {
            return AndroidCompileUtil.getOutputPackage(facet.getModule());
        }
        String moduleDirPath = AndroidRootUtil.getModuleDirPath(facet.getModule());
        return moduleDirPath != null ? FileUtil.toSystemDependentName((String)(moduleDirPath + path)) : null;
    }

    @Nullable
    public static String getPathRelativeToModuleDir(@NotNull Module module, @NotNull String path) {
        String moduleDirPath;
        if (module == null) {
            AndroidRootUtil.$$$reportNull$$$0(47);
        }
        if (path == null) {
            AndroidRootUtil.$$$reportNull$$$0(48);
        }
        if ((moduleDirPath = AndroidRootUtil.getModuleDirPath(module)) == null) {
            return null;
        }
        if (moduleDirPath.equals(path)) {
            return "";
        }
        return FileUtil.getRelativePath((String)moduleDirPath, (String)path, (char)'/');
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 25: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 25: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 13: 
            case 17: 
            case 21: 
            case 23: 
            case 31: 
            case 33: 
            case 35: 
            case 39: 
            case 42: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 16: 
            case 19: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 18: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDirs";
                break;
            }
            case 20: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/facet/AndroidRootUtil";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libs";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleOutputDir";
                break;
            }
            case 32: 
            case 34: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyFileName";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyKey";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/facet/AndroidRootUtil";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalLibraries";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentModules";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceOverlayDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getManifestFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPrimaryManifestFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCustomManifestFileForCompiler";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getManifestFileForCompiler";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getResourceDir";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "suggestResourceDirPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getResourceDirPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAssetsDir";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLibsDir";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAidlGenDir";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAaptGenDir";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRenderscriptGenDir";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getBuildconfigGenDir";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStandardGenDir";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collectClassFilesAndJars";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "fillExternalLibrariesAndModules";
                break;
            }
            case 20: 
            case 25: 
            case 27: {
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotationsJar";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getDependentModules";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getResourceOverlayDirs";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getRenderscriptGenSourceRootPath";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getBuildconfigGenSourceRootPath";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getMainContentRoot";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findPropertyFile";
                break;
            }
            case 33: 
            case 34: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "readPropertyFile";
                break;
            }
            case 35: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "readProjectPropertyFile";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyValue";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getProjectPropertyValue";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getAptGenSourceRootPath";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getAidlGenSourceRootPath";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getApkPath";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getPathRelativeToModuleDir";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fillExternalLibrariesAndModules$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 25: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

