/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.importDependencies;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.importDependencies.ModuleProvidingTask;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

class CreateNewModuleTask
extends ModuleProvidingTask {
    private final Project myProject;
    private final VirtualFile myContentRoot;

    public CreateNewModuleTask(@NotNull Project project, @NotNull VirtualFile contentRoot) {
        if (project == null) {
            CreateNewModuleTask.$$$reportNull$$$0(0);
        }
        if (contentRoot == null) {
            CreateNewModuleTask.$$$reportNull$$$0(1);
        }
        this.myContentRoot = contentRoot;
        this.myProject = project;
    }

    @Override
    public Exception perform() {
        Module depModule = (Module)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Module>(){

            public Module compute() {
                Module depModule = ModuleManager.getInstance((Project)CreateNewModuleTask.this.myProject).newModule(CreateNewModuleTask.this.myContentRoot.getPath() + '/' + CreateNewModuleTask.this.myContentRoot.getName() + ".iml", StdModuleTypes.JAVA.getId());
                ModifiableRootModel model = ModuleRootManager.getInstance((Module)depModule).getModifiableModel();
                model.addContentEntry(CreateNewModuleTask.this.myContentRoot);
                model.commit();
                return depModule;
            }
        });
        if (AndroidFacet.getInstance(depModule) == null) {
            AndroidUtils.addAndroidFacetInWriteAction(depModule, this.myContentRoot, true);
        }
        AndroidSdkUtils.setupAndroidPlatformIfNecessary(depModule, false);
        this.setDepModule(depModule);
        return null;
    }

    @Override
    @NotNull
    public String getTitle() {
        String contentRootPath = FileUtil.toSystemDependentName((String)this.myContentRoot.getPath());
        String string = AndroidBundle.message("android.import.dependencies.new.module.task.title", this.getModuleName(), contentRootPath);
        if (string == null) {
            CreateNewModuleTask.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public String getModuleName() {
        return this.myContentRoot.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateNewModuleTask that = (CreateNewModuleTask)o;
        if (!this.myContentRoot.equals(that.myContentRoot)) {
            return false;
        }
        return this.myProject.equals(that.myProject);
    }

    public int hashCode() {
        int result2 = this.myProject.hashCode();
        result2 = 31 * result2 + this.myContentRoot.hashCode();
        return result2;
    }

    @Override
    @NotNull
    public VirtualFile getContentRoot() {
        VirtualFile virtualFile = this.myContentRoot;
        if (virtualFile == null) {
            CreateNewModuleTask.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/importDependencies/CreateNewModuleTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/importDependencies/CreateNewModuleTask";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

