/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.importDependencies;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import org.jdom.JDOMException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.importDependencies.ModuleProvidingTask;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

class ImportModuleTask
extends ModuleProvidingTask {
    private final Project myProject;
    private final String myModuleFilePath;
    private final VirtualFile myContentRoot;

    public ImportModuleTask(@NotNull Project project, @NotNull String moduleFilePath, @NotNull VirtualFile contentRoot) {
        if (project == null) {
            ImportModuleTask.$$$reportNull$$$0(0);
        }
        if (moduleFilePath == null) {
            ImportModuleTask.$$$reportNull$$$0(1);
        }
        if (contentRoot == null) {
            ImportModuleTask.$$$reportNull$$$0(2);
        }
        this.myModuleFilePath = moduleFilePath;
        this.myContentRoot = contentRoot;
        this.myProject = project;
    }

    @Override
    public Exception perform() {
        final Module[] moduleWrapper = new Module[]{null};
        Exception exception = (Exception)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Exception>(){

            public Exception compute() {
                try {
                    moduleWrapper[0] = ModuleManager.getInstance((Project)ImportModuleTask.this.myProject).loadModule(ImportModuleTask.this.myModuleFilePath);
                }
                catch (InvalidDataException e) {
                    return e;
                }
                catch (IOException e) {
                    return e;
                }
                catch (JDOMException e) {
                    return e;
                }
                catch (ModuleWithNameAlreadyExists e) {
                    return e;
                }
                return null;
            }
        });
        if (exception != null) {
            return exception;
        }
        assert (moduleWrapper[0] != null);
        if (AndroidFacet.getInstance(moduleWrapper[0]) == null) {
            AndroidUtils.addAndroidFacetInWriteAction(moduleWrapper[0], this.myContentRoot, true);
        }
        AndroidSdkUtils.setupAndroidPlatformIfNecessary(moduleWrapper[0], false);
        this.setDepModule(moduleWrapper[0]);
        return null;
    }

    @Override
    @NotNull
    public String getTitle() {
        String string = AndroidBundle.message("android.import.dependencies.import.module.task.title", this.getModuleName(), FileUtil.toSystemDependentName((String)this.myModuleFilePath));
        if (string == null) {
            ImportModuleTask.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public String getModuleName() {
        return FileUtil.getNameWithoutExtension((String)new File(this.myModuleFilePath).getName());
    }

    @Override
    @NotNull
    public VirtualFile getContentRoot() {
        VirtualFile virtualFile = this.myContentRoot;
        if (virtualFile == null) {
            ImportModuleTask.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportModuleTask that = (ImportModuleTask)o;
        if (!this.myContentRoot.equals(that.myContentRoot)) {
            return false;
        }
        if (!this.myModuleFilePath.equals(that.myModuleFilePath)) {
            return false;
        }
        return this.myProject.equals(that.myProject);
    }

    public int hashCode() {
        int result2 = this.myProject.hashCode();
        result2 = 31 * result2 + this.myModuleFilePath.hashCode();
        result2 = 31 * result2 + this.myContentRoot.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFilePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/importDependencies/ImportModuleTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/importDependencies/ImportModuleTask";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

