/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.resources.ResourceFolderType;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomFileDescription;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.AndroidAnyAttributeDescriptor;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.android.dom.AndroidXmlTagDescriptor;
import org.jetbrains.android.dom.manifest.ManifestDomFileDescription;
import org.jetbrains.android.dom.xml.AndroidXmlResourcesUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AndroidUnknownAttributeInspection
extends LocalInspectionTool {
    private static volatile Set<ResourceFolderType> ourSupportedResourceTypes;

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = AndroidBundle.message("android.inspections.group.name", new Object[0]);
        if (string == null) {
            AndroidUnknownAttributeInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = AndroidBundle.message("android.inspections.unknown.attribute.name", new Object[0]);
        if (string == null) {
            AndroidUnknownAttributeInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("AndroidUnknownAttribute" == null) {
            AndroidUnknownAttributeInspection.$$$reportNull$$$0(2);
        }
        return "AndroidUnknownAttribute";
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            AndroidUnknownAttributeInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            AndroidUnknownAttributeInspection.$$$reportNull$$$0(4);
        }
        if (!(file instanceof XmlFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (AndroidUnknownAttributeInspection.isMyFile(facet, (XmlFile)file)) {
            MyVisitor visitor = new MyVisitor(manager, isOnTheFly);
            file.accept((PsiElementVisitor)visitor);
            return visitor.myResult.toArray(ProblemDescriptor.EMPTY_ARRAY);
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    static boolean isMyFile(@NotNull AndroidFacet facet, XmlFile file) {
        ResourceFolderType resourceType;
        if (facet == null) {
            AndroidUnknownAttributeInspection.$$$reportNull$$$0(5);
        }
        if ((resourceType = ModuleResourceManagers.getInstance(facet).getLocalResourceManager().getFileResourceFolderType((PsiFile)file)) != null) {
            if (ourSupportedResourceTypes == null) {
                ourSupportedResourceTypes = EnumSet.noneOf(ResourceFolderType.class);
                for (DomFileDescription description : (DomFileDescription[])DomFileDescription.EP_NAME.getExtensions()) {
                    if (!(description instanceof AndroidResourceDomFileDescription)) continue;
                    ourSupportedResourceTypes.addAll(((AndroidResourceDomFileDescription)description).getResourceTypes());
                }
            }
            if (!ourSupportedResourceTypes.contains(resourceType) || ResourceFolderType.RAW == resourceType) {
                return false;
            }
            if (ResourceFolderType.XML == resourceType) {
                XmlTag rootTag = file.getRootTag();
                return rootTag != null && AndroidXmlResourcesUtil.isSupportedRootTag(facet, rootTag.getName());
            }
            return true;
        }
        return ManifestDomFileDescription.isManifestFile(file, facet);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/inspections/AndroidUnknownAttributeInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/inspections/AndroidUnknownAttributeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isMyFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyVisitor
    extends XmlRecursiveElementVisitor {
        private final InspectionManager myInspectionManager;
        private final boolean myOnTheFly;
        final List<ProblemDescriptor> myResult = new ArrayList<ProblemDescriptor>();

        private MyVisitor(InspectionManager inspectionManager, boolean onTheFly) {
            this.myInspectionManager = inspectionManager;
            this.myOnTheFly = onTheFly;
        }

        public void visitXmlAttribute(XmlAttribute attribute) {
            XmlTag tag;
            String namespace;
            if (!"xmlns".equals(attribute.getNamespacePrefix()) && ("http://schemas.android.com/apk/res/android".equals(namespace = attribute.getNamespace()) || namespace.isEmpty()) && (tag = attribute.getParent()) != null && tag.getDescriptor() instanceof AndroidXmlTagDescriptor && attribute.getDescriptor() instanceof AndroidAnyAttributeDescriptor) {
                PsiElement nameElement;
                ASTNode node = attribute.getNode();
                assert (node != null);
                ASTNode nameNode = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(node);
                PsiElement psiElement = nameElement = nameNode != null ? nameNode.getPsi() : null;
                if (nameElement != null) {
                    this.myResult.add(this.myInspectionManager.createProblemDescriptor(nameElement, AndroidBundle.message("android.inspections.unknown.attribute.message", attribute.getName()), this.myOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                }
            }
        }
    }
}

