/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.resources.Density;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class ConvertToDpQuickFix
implements AndroidLintQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.inspections.lint.ConvertToDpQuickFix");
    private static final Pattern PX_ATTR_VALUE_PATTERN = Pattern.compile("(\\d+)px");
    private static int ourPrevDpi = Density.DEFAULT_DENSITY;

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        String newValue;
        int dpi;
        if (startElement == null) {
            ConvertToDpQuickFix.$$$reportNull$$$0(0);
        }
        if (endElement == null) {
            ConvertToDpQuickFix.$$$reportNull$$$0(1);
        }
        if (context == null) {
            ConvertToDpQuickFix.$$$reportNull$$$0(2);
        }
        if (context instanceof AndroidQuickfixContexts.BatchContext) {
            return;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class);
        ArrayList<Density> densities = new ArrayList<Density>();
        for (Density density : Density.values()) {
            if (!density.isValidValueForDevice()) continue;
            densities.add(density);
        }
        String[] densityPresentableNames = new String[densities.size()];
        String defaultValue = null;
        String initialValue = null;
        for (int i = 0; i < densities.size(); ++i) {
            Density density = (Density)densities.get(i);
            densityPresentableNames[i] = ConvertToDpQuickFix.getLabelForDensity(density);
            int dpi2 = density.getDpiValue();
            if (dpi2 == ourPrevDpi) {
                initialValue = densityPresentableNames[i];
                continue;
            }
            if (dpi2 != Density.DEFAULT_DENSITY) continue;
            defaultValue = densityPresentableNames[i];
        }
        if (initialValue == null) {
            initialValue = defaultValue;
        }
        if (initialValue == null) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            dpi = Density.DEFAULT_DENSITY;
        } else {
            int selectedIndex = Messages.showChooseDialog((String)"What is the screen density the current px value works with?", (String)"Choose density", (String[])densityPresentableNames, initialValue, null);
            if (selectedIndex < 0) {
                return;
            }
            dpi = ((Density)densities.get(selectedIndex)).getDpiValue();
        }
        ourPrevDpi = dpi;
        for (XmlAttribute attribute : tag.getAttributes()) {
            String newValue2;
            String value = attribute.getValue();
            if (value == null || !value.endsWith("px") || (newValue2 = ConvertToDpQuickFix.convertToDp(value, dpi)) == null) continue;
            attribute.setValue(newValue2);
        }
        XmlTagValue tagValueElement = tag.getValue();
        String tagValue = tagValueElement.getText();
        if (tagValue.endsWith("px") && (newValue = ConvertToDpQuickFix.convertToDp(tagValue, dpi)) != null) {
            tagValueElement.setText(newValue);
        }
    }

    private static String convertToDp(String value, int dpi) {
        String newValue = null;
        Matcher matcher = PX_ATTR_VALUE_PATTERN.matcher(value);
        if (matcher.matches()) {
            String numberString = matcher.group(1);
            try {
                int px = Integer.parseInt(numberString);
                int dp = px * 160 / dpi;
                newValue = Integer.toString(dp) + "dp";
            }
            catch (NumberFormatException nufe) {
                LOG.error((Throwable)nufe);
            }
        }
        return newValue;
    }

    @NotNull
    private static String getLabelForDensity(@NotNull Density density) {
        if (density == null) {
            ConvertToDpQuickFix.$$$reportNull$$$0(3);
        }
        String string = String.format("%1$s (%2$d)", density.getShortDisplayValue(), density.getDpiValue());
        if (string == null) {
            ConvertToDpQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            ConvertToDpQuickFix.$$$reportNull$$$0(5);
        }
        if (endElement == null) {
            ConvertToDpQuickFix.$$$reportNull$$$0(6);
        }
        if (contextType == null) {
            ConvertToDpQuickFix.$$$reportNull$$$0(7);
        }
        return contextType != AndroidQuickfixContexts.BatchContext.TYPE && PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class) != null;
    }

    @Override
    @NotNull
    public String getName() {
        String string = AndroidBundle.message("android.lint.fix.convert.to.dp", new Object[0]);
        if (string == null) {
            ConvertToDpQuickFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "density";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/inspections/lint/ConvertToDpQuickFix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/inspections/lint/ConvertToDpQuickFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelForDensity";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLabelForDensity";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

