/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.IncludeReference;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.dom.layout.Include;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.AndroidBaseLayoutRefactoringAction;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidExtractAsIncludeAction
extends AndroidBaseLayoutRefactoringAction {
    @NonNls
    public static final String ACTION_ID = "AndroidExtractAsIncludeAction";
    private final MyTestConfig myTestConfig;

    public AndroidExtractAsIncludeAction() {
        this.myTestConfig = null;
    }

    public AndroidExtractAsIncludeAction(@Nullable MyTestConfig testConfig) {
        this.myTestConfig = testConfig;
    }

    @Override
    protected void doRefactorForTags(@NotNull Project project, @NotNull XmlTag[] tags) {
        if (project == null) {
            AndroidExtractAsIncludeAction.$$$reportNull$$$0(0);
        }
        if (tags == null) {
            AndroidExtractAsIncludeAction.$$$reportNull$$$0(1);
        }
        if (tags.length == 0) {
            return;
        }
        PsiFile file = tags[0].getContainingFile();
        if (file == null) {
            return;
        }
        XmlTag startTag = null;
        XmlTag endTag = null;
        int startOffset = Integer.MAX_VALUE;
        int endOffset = -1;
        for (XmlTag tag : tags) {
            int end;
            TextRange range = tag.getTextRange();
            int start = range.getStartOffset();
            if (start < startOffset) {
                startOffset = start;
                startTag = tag;
            }
            if ((end = range.getEndOffset()) <= endOffset) continue;
            endOffset = end;
            endTag = tag;
        }
        assert (startTag != null && endTag != null);
        this.doRefactorForPsiRange(project, file, (PsiElement)startTag, (PsiElement)endTag);
    }

    @Override
    protected boolean isEnabledForTags(@NotNull XmlTag[] tags) {
        if (tags == null) {
            AndroidExtractAsIncludeAction.$$$reportNull$$$0(2);
        }
        if (tags.length == 0) {
            return false;
        }
        DomManager domManager = DomManager.getDomManager((Project)tags[0].getProject());
        boolean containsViewElement = false;
        for (XmlTag tag : tags) {
            DomElement domElement = domManager.getDomElement(tag);
            if (!AndroidExtractAsIncludeAction.isSuitableDomElement(domElement)) {
                return false;
            }
            if (!(domElement instanceof LayoutViewElement)) continue;
            containsViewElement = true;
        }
        if (!containsViewElement) {
            return false;
        }
        PsiElement parent = tags[0].getParent();
        if (!(parent instanceof XmlTag) || parent.getContainingFile() == null) {
            return false;
        }
        for (int i = 1; i < tags.length; ++i) {
            if (tags[i].getParent() == parent) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void doRefactorForPsiRange(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement from, @NotNull PsiElement to) {
        PsiDirectory dir;
        if (project == null) {
            AndroidExtractAsIncludeAction.$$$reportNull$$$0(3);
        }
        if (file == null) {
            AndroidExtractAsIncludeAction.$$$reportNull$$$0(4);
        }
        if (from == null) {
            AndroidExtractAsIncludeAction.$$$reportNull$$$0(5);
        }
        if (to == null) {
            AndroidExtractAsIncludeAction.$$$reportNull$$$0(6);
        }
        if ((dir = file.getContainingDirectory()) == null) {
            return;
        }
        final AndroidFacet facet = AndroidFacet.getInstance(from);
        assert (facet != null);
        XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)from, XmlTag.class);
        assert (parentTag != null);
        List<XmlTag> tagsInRange = AndroidExtractAsIncludeAction.collectAllTags(from, to);
        assert (!tagsInRange.isEmpty()) : "there is no tag inside the range";
        final String fileName = this.myTestConfig != null ? this.myTestConfig.myLayoutFileName : null;
        String dirName = dir.getName();
        final FolderConfiguration config = !dirName.isEmpty() ? FolderConfiguration.getConfig((String[])dirName.split("-")) : null;
        String title = "Extract Android Layout";
        AsyncResult dataContextAsyncResult = DataManager.getInstance().getDataContextFromFocus();
        dataContextAsyncResult.doWhenDone(dataContext -> {
            if (project == null) {
                AndroidExtractAsIncludeAction.$$$reportNull$$$0(9);
            }
            if (file == null) {
                AndroidExtractAsIncludeAction.$$$reportNull$$$0(10);
            }
            if (from == null) {
                AndroidExtractAsIncludeAction.$$$reportNull$$$0(11);
            }
            if (to == null) {
                AndroidExtractAsIncludeAction.$$$reportNull$$$0(12);
            }
            CommandProcessor.getInstance().executeCommand(project, new Runnable((DataContext)dataContext, file, from, to, parentTag, tagsInRange){
                final /* synthetic */ DataContext val$dataContext;
                final /* synthetic */ PsiFile val$file;
                final /* synthetic */ PsiElement val$from;
                final /* synthetic */ PsiElement val$to;
                final /* synthetic */ XmlTag val$parentTag;
                final /* synthetic */ List val$tagsInRange;
                {
                    this.val$dataContext = dataContext;
                    this.val$file = psiFile;
                    this.val$from = psiElement;
                    this.val$to = psiElement2;
                    this.val$parentTag = xmlTag;
                    this.val$tagsInRange = list;
                }

                @Override
                public void run() {
                    final XmlFile newFile = CreateResourceFileAction.createFileResource(facet, ResourceFolderType.LAYOUT, fileName, "temp_root", config, true, "Extract Android Layout", null, this.val$dataContext);
                    if (newFile != null) {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                AndroidExtractAsIncludeAction.doRefactor(facet, val$file, newFile, val$from, val$to, val$parentTag, val$tagsInRange.size() > 1);
                            }
                        });
                    }
                }
            }, "Extract Android Layout", null, UndoConfirmationPolicy.REQUEST_CONFIRMATION);
        });
    }

    private static void doRefactor(AndroidFacet facet, PsiFile file, XmlFile newFile, PsiElement from, PsiElement to, XmlTag parentTag, boolean wrapWithMerge) {
        Project project = facet.getModule().getProject();
        String textToExtract = file.getText().substring(from.getTextRange().getStartOffset(), to.getTextRange().getEndOffset());
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = documentManager.getDocument((PsiFile)newFile);
        assert (document != null);
        document.setText((CharSequence)("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n" + (wrapWithMerge ? "<merge>\n" + textToExtract + "\n</merge>" : textToExtract)));
        documentManager.commitDocument(document);
        HashSet unknownPrefixes = new HashSet();
        newFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor((Set)unknownPrefixes){
            final /* synthetic */ Set val$unknownPrefixes;
            {
                this.val$unknownPrefixes = set;
            }

            public void visitXmlTag(XmlTag tag) {
                super.visitXmlTag(tag);
                String prefix = tag.getNamespacePrefix();
                if (!this.val$unknownPrefixes.contains(prefix) && tag.getNamespace().isEmpty()) {
                    this.val$unknownPrefixes.add(prefix);
                }
            }

            public void visitXmlAttribute(XmlAttribute attribute) {
                String prefix = attribute.getNamespacePrefix();
                if (!this.val$unknownPrefixes.contains(prefix) && attribute.getNamespace().isEmpty()) {
                    this.val$unknownPrefixes.add(prefix);
                }
            }
        });
        XmlTag rootTag = newFile.getRootTag();
        assert (rootTag != null);
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)project);
        XmlAttribute[] attributes = rootTag.getAttributes();
        XmlAttribute firstAttribute = attributes.length > 0 ? attributes[0] : null;
        for (String prefix : unknownPrefixes) {
            String namespace = parentTag.getNamespaceByPrefix(prefix);
            String xmlNsAttrName = "xmlns:" + prefix;
            if (namespace.isEmpty() || rootTag.getAttribute(xmlNsAttrName) != null) continue;
            XmlAttribute xmlnsAttr = elementFactory.createXmlAttribute(xmlNsAttrName, namespace);
            if (firstAttribute != null) {
                rootTag.addBefore((PsiElement)xmlnsAttr, (PsiElement)firstAttribute);
                continue;
            }
            rootTag.add((PsiElement)xmlnsAttr);
        }
        String includingLayout = "@layout/" + ResourceHelper.getResourceName(file);
        IncludeReference.setIncludingLayout(project, newFile, includingLayout);
        String resourceName = AndroidCommonUtils.getResourceName((String)ResourceType.LAYOUT.getName(), (String)newFile.getName());
        XmlTag includeTag = elementFactory.createTagFromText((CharSequence)("<include layout=\"@layout/" + resourceName + "\"/>"));
        parentTag.addAfter((PsiElement)includeTag, to);
        parentTag.deleteChildRange(from, to);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        codeStyleManager.reformat((PsiElement)newFile);
    }

    @NotNull
    private static List<XmlTag> collectAllTags(PsiElement from, PsiElement to) {
        PsiElement e;
        ArrayList<XmlTag> result2 = new ArrayList<XmlTag>();
        for (e = from; e != null; e = e.getNextSibling()) {
            if (e instanceof XmlTag) {
                result2.add((XmlTag)e);
            }
            if (e == to) break;
        }
        assert (e != null) : "invalid range";
        ArrayList<XmlTag> arrayList = result2;
        if (arrayList == null) {
            AndroidExtractAsIncludeAction.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Override
    protected boolean isEnabledForPsiRange(@NotNull PsiElement from, @Nullable PsiElement to) {
        if (from == null) {
            AndroidExtractAsIncludeAction.$$$reportNull$$$0(8);
        }
        DomManager domManager = DomManager.getDomManager((Project)from.getProject());
        boolean containsViewElement = false;
        for (PsiElement e = from; e != null; e = e.getNextSibling()) {
            if (e instanceof XmlTag) {
                DomElement domElement = domManager.getDomElement((XmlTag)e);
                if (!AndroidExtractAsIncludeAction.isSuitableDomElement(domElement)) {
                    return false;
                }
                if (domElement instanceof LayoutViewElement) {
                    containsViewElement = true;
                }
            }
            if (e == to) break;
        }
        return containsViewElement;
    }

    private static boolean isSuitableDomElement(DomElement element) {
        return element instanceof LayoutViewElement || element instanceof Include;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/refactoring/AndroidExtractAsIncludeAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/refactoring/AndroidExtractAsIncludeAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllTags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doRefactorForTags";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledForTags";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doRefactorForPsiRange";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledForPsiRange";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doRefactorForPsiRange$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyTestConfig {
        private final String myLayoutFileName;

        MyTestConfig(@NotNull String layoutFileName) {
            if (layoutFileName == null) {
                MyTestConfig.$$$reportNull$$$0(0);
            }
            this.myLayoutFileName = layoutFileName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutFileName", "org/jetbrains/android/refactoring/AndroidExtractAsIncludeAction$MyTestConfig", "<init>"));
        }
    }
}

