/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.dom.resources.StyleItem;
import org.jetbrains.android.refactoring.AndroidBaseLayoutRefactoringAction;
import org.jetbrains.android.refactoring.AndroidFindStyleApplicationsAction;
import org.jetbrains.android.refactoring.ExtractStyleDialog;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidExtractStyleAction
extends AndroidBaseLayoutRefactoringAction {
    @NonNls
    public static final String ACTION_ID = "AndroidExtractStyleAction";
    private static String[] NON_EXTRACTABLE_ATTRIBUTES = new String[]{"id", "text", "hint", "src", "onClick"};
    private final MyTestConfig myTestConfig;

    public AndroidExtractStyleAction() {
        this.myTestConfig = null;
    }

    public AndroidExtractStyleAction(@NotNull MyTestConfig testConfig) {
        if (testConfig == null) {
            AndroidExtractStyleAction.$$$reportNull$$$0(0);
        }
        this.myTestConfig = testConfig;
    }

    @Override
    protected boolean isEnabledForTags(@NotNull XmlTag[] tags) {
        if (tags == null) {
            AndroidExtractStyleAction.$$$reportNull$$$0(1);
        }
        return tags.length == 1 && AndroidExtractStyleAction.doIsEnabled(tags[0]);
    }

    public static boolean doIsEnabled(@NotNull XmlTag tag) {
        if (tag == null) {
            AndroidExtractStyleAction.$$$reportNull$$$0(2);
        }
        return AndroidExtractStyleAction.getLayoutViewElement(tag) != null && !AndroidExtractStyleAction.getExtractableAttributes(tag).isEmpty();
    }

    @Nullable
    public static String doExtractStyle(@NotNull Module module, final @NotNull XmlTag viewTag, final boolean addStyleAttributeToTag, @Nullable MyTestConfig testConfig) {
        AndroidFindStyleApplicationsAction.MyStyleData createdStyleData;
        XmlTag createdStyleTag;
        String styleName;
        List<Object> styledAttributes;
        VirtualFile chosenDirectory;
        boolean searchStyleApplications;
        String parentStyle;
        PsiFile file;
        if (module == null) {
            AndroidExtractStyleAction.$$$reportNull$$$0(3);
        }
        if (viewTag == null) {
            AndroidExtractStyleAction.$$$reportNull$$$0(4);
        }
        if ((file = viewTag.getContainingFile()) == null) {
            return null;
        }
        String dialogTitle = AndroidBundle.message("android.extract.style.title", new Object[0]);
        final String fileName = AndroidResourceUtil.getDefaultResourceFileName(ResourceType.STYLE);
        assert (fileName != null);
        final List<String> dirNames = Collections.singletonList(ResourceFolderType.VALUES.getName());
        List<XmlAttribute> extractableAttributes = AndroidExtractStyleAction.getExtractableAttributes(viewTag);
        final Project project = module.getProject();
        if (extractableAttributes.isEmpty()) {
            AndroidUtils.reportError(project, "The tag doesn't contain any attributes that can be extracted", dialogTitle);
            return null;
        }
        LayoutViewElement viewElement = AndroidExtractStyleAction.getLayoutViewElement(viewTag);
        assert (viewElement != null);
        final ResourceValue parentStyleValue = (ResourceValue)viewElement.getStyle().getValue();
        boolean supportImplicitParent = false;
        if (parentStyleValue != null) {
            parentStyle = parentStyleValue.getResourceName();
            if (ResourceType.STYLE != parentStyleValue.getType() || parentStyle == null || parentStyle.isEmpty()) {
                AndroidUtils.reportError(project, "Invalid parent style reference " + parentStyleValue.toString(), dialogTitle);
                return null;
            }
            supportImplicitParent = parentStyleValue.getPackage() == null;
        } else {
            parentStyle = null;
        }
        if (testConfig == null) {
            ExtractStyleDialog dialog = new ExtractStyleDialog(module, fileName, supportImplicitParent ? parentStyle : null, dirNames, extractableAttributes);
            dialog.setTitle(dialogTitle);
            if (!dialog.showAndGet()) {
                return null;
            }
            searchStyleApplications = dialog.isToSearchStyleApplications();
            chosenDirectory = dialog.getResourceDirectory();
            if (chosenDirectory == null) {
                AndroidUtils.reportError(project, AndroidBundle.message("check.resource.dir.error", module.getName()));
                return null;
            }
            styledAttributes = dialog.getStyledAttributes();
            styleName = dialog.getStyleName();
        } else {
            testConfig.validate(extractableAttributes);
            chosenDirectory = testConfig.getResourceDirectory();
            styleName = testConfig.getStyleName();
            HashSet attrsToExtract = new HashSet(Arrays.asList(testConfig.getAttributesToExtract()));
            styledAttributes = new ArrayList();
            for (XmlAttribute attribute : extractableAttributes) {
                if (!attrsToExtract.contains(attribute.getName())) continue;
                styledAttributes.add(attribute);
            }
            searchStyleApplications = false;
        }
        final boolean[] success = new boolean[]{false};
        final Ref createdStyleRef = Ref.create();
        final boolean finalSupportImplicitParent = supportImplicitParent;
        new WriteCommandAction(project, "Extract Android Style '" + styleName + "'", new PsiFile[]{file}){

            protected void run(@NotNull Result result2) throws Throwable {
                ArrayList attributesToDelete;
                if (result2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!AndroidResourceUtil.createValueResource(project, chosenDirectory, styleName, null, ResourceType.STYLE, fileName, dirNames, new Processor<ResourceElement>(attributesToDelete = new ArrayList()){
                    final /* synthetic */ List val$attributesToDelete;
                    {
                        this.val$attributesToDelete = list;
                    }

                    public boolean process(ResourceElement element) {
                        assert (element instanceof Style);
                        Style style = (Style)element;
                        createdStyleRef.set((Object)style);
                        for (XmlAttribute attribute : styledAttributes) {
                            if (!"http://schemas.android.com/apk/res/android".equals(attribute.getNamespace())) continue;
                            StyleItem item = style.addItem();
                            item.getName().setStringValue("android:" + attribute.getLocalName());
                            item.setStringValue(attribute.getValue());
                            this.val$attributesToDelete.add(attribute);
                        }
                        if (!(parentStyleValue == null || finalSupportImplicitParent && styleName.startsWith(parentStyle + "."))) {
                            String aPackage = parentStyleValue.getPackage();
                            style.getParentStyle().setStringValue((aPackage != null ? aPackage + ":" : "") + parentStyle);
                        }
                        return true;
                    }
                })) {
                    return;
                }
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        for (XmlAttribute attribute : attributesToDelete) {
                            attribute.delete();
                        }
                        if (addStyleAttributeToTag) {
                            LayoutViewElement viewElement = AndroidBaseLayoutRefactoringAction.getLayoutViewElement(viewTag);
                            assert (viewElement != null);
                            viewElement.getStyle().setStringValue("@style/" + styleName);
                        }
                    }
                });
                success[0] = true;
            }

            protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/android/refactoring/AndroidExtractStyleAction$1", "run"));
            }
        }.execute();
        if (!success[0]) {
            return null;
        }
        Style createdStyle = (Style)createdStyleRef.get();
        XmlTag xmlTag = createdStyleTag = createdStyle != null ? createdStyle.getXmlTag() : null;
        if (createdStyleTag != null && (createdStyleData = AndroidFindStyleApplicationsAction.getStyleData(createdStyleTag)) != null && searchStyleApplications) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    AndroidFindStyleApplicationsAction.doRefactoringForTag(createdStyleTag, createdStyleData, file, null);
                }
            });
        }
        return styleName;
    }

    @NotNull
    static List<XmlAttribute> getExtractableAttributes(@NotNull XmlTag viewTag) {
        if (viewTag == null) {
            AndroidExtractStyleAction.$$$reportNull$$$0(5);
        }
        ArrayList<XmlAttribute> extractableAttributes = new ArrayList<XmlAttribute>();
        for (XmlAttribute attribute : viewTag.getAttributes()) {
            if (!AndroidExtractStyleAction.canBeExtracted(attribute)) continue;
            extractableAttributes.add(attribute);
        }
        ArrayList<XmlAttribute> arrayList = extractableAttributes;
        if (arrayList == null) {
            AndroidExtractStyleAction.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static boolean canBeExtracted(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            AndroidExtractStyleAction.$$$reportNull$$$0(7);
        }
        if (!"http://schemas.android.com/apk/res/android".equals(attribute.getNamespace())) {
            return false;
        }
        String name = attribute.getLocalName();
        if (ArrayUtilRt.find((Object[])NON_EXTRACTABLE_ATTRIBUTES, (Object)name) >= 0) {
            return false;
        }
        return !name.startsWith("style");
    }

    @Override
    protected void doRefactorForTags(@NotNull Project project, @NotNull XmlTag[] tags) {
        if (project == null) {
            AndroidExtractStyleAction.$$$reportNull$$$0(8);
        }
        if (tags == null) {
            AndroidExtractStyleAction.$$$reportNull$$$0(9);
        }
        assert (tags.length == 1);
        XmlTag tag = tags[0];
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)tag);
        assert (module != null);
        AndroidExtractStyleAction.doExtractStyle(module, tag, true, this.myTestConfig);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testConfig";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewTag";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/refactoring/AndroidExtractStyleAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/refactoring/AndroidExtractStyleAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtractableAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledForTags";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doIsEnabled";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doExtractStyle";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExtractableAttributes";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canBeExtracted";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doRefactorForTags";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyTestConfig {
        private final String myStyleName;
        private final String[] myAttributesToExtract;
        private VirtualFile myResourceDirectory;

        MyTestConfig(@NotNull VirtualFile resourceDirectory, @NotNull String styleName, @NotNull String[] attributesToExtract) {
            if (resourceDirectory == null) {
                MyTestConfig.$$$reportNull$$$0(0);
            }
            if (styleName == null) {
                MyTestConfig.$$$reportNull$$$0(1);
            }
            if (attributesToExtract == null) {
                MyTestConfig.$$$reportNull$$$0(2);
            }
            this.myResourceDirectory = resourceDirectory;
            this.myStyleName = styleName;
            this.myAttributesToExtract = attributesToExtract;
        }

        @NotNull
        public String getStyleName() {
            String string = this.myStyleName;
            if (string == null) {
                MyTestConfig.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String[] getAttributesToExtract() {
            if (this.myAttributesToExtract == null) {
                MyTestConfig.$$$reportNull$$$0(4);
            }
            return this.myAttributesToExtract;
        }

        public void validate(@NotNull List<XmlAttribute> extractableAttributes) {
            if (extractableAttributes == null) {
                MyTestConfig.$$$reportNull$$$0(5);
            }
        }

        public VirtualFile getResourceDirectory() {
            return this.myResourceDirectory;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceDirectory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "styleName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributesToExtract";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/refactoring/AndroidExtractStyleAction$MyTestConfig";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extractableAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/refactoring/AndroidExtractStyleAction$MyTestConfig";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStyleName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributesToExtract";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "validate";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

