/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.dom.resources.ResourcesDomFileDescription;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.AndroidAttributeInfo;
import org.jetbrains.android.refactoring.AndroidBaseXmlRefactoringAction;
import org.jetbrains.android.refactoring.AndroidFindStyleApplicationsDialog;
import org.jetbrains.android.refactoring.AndroidFindStyleApplicationsProcessor;
import org.jetbrains.android.refactoring.AndroidRefactoringUtil;
import org.jetbrains.android.refactoring.StyleRefData;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.ValueResourceInfoImpl;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.ProjectBasedErrorReporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidFindStyleApplicationsAction
extends AndroidBaseXmlRefactoringAction {
    private final MyTestConfig myTestConfig;

    public AndroidFindStyleApplicationsAction() {
        this(null);
    }

    public AndroidFindStyleApplicationsAction(@Nullable MyTestConfig testConfig) {
        this.myTestConfig = testConfig;
    }

    @Override
    protected boolean isEnabledForTags(@NotNull XmlTag[] tags) {
        if (tags == null) {
            AndroidFindStyleApplicationsAction.$$$reportNull$$$0(0);
        }
        if (tags.length != 1) {
            return false;
        }
        MyStyleData data = AndroidFindStyleApplicationsAction.getStyleData(tags[0]);
        return data != null && !data.getStyle().getItems().isEmpty();
    }

    @Override
    protected boolean isMyFile(PsiFile file) {
        return DomManager.getDomManager((Project)file.getProject()).getDomFileDescription((XmlFile)file) instanceof ResourcesDomFileDescription;
    }

    @Override
    protected void doRefactorForTags(@NotNull Project project, @NotNull XmlTag[] tags) {
        if (project == null) {
            AndroidFindStyleApplicationsAction.$$$reportNull$$$0(1);
        }
        if (tags == null) {
            AndroidFindStyleApplicationsAction.$$$reportNull$$$0(2);
        }
        assert (tags.length == 1);
        XmlTag tag = tags[0];
        MyStyleData styleData = AndroidFindStyleApplicationsAction.getStyleData(tag);
        assert (styleData != null);
        AndroidFindStyleApplicationsAction.doRefactoringForTag(tag, styleData, null, this.myTestConfig);
    }

    static void doRefactoringForTag(XmlTag tag, MyStyleData styleData, @Nullable PsiFile context, MyTestConfig testConfig) {
        boolean showModuleRadio;
        VirtualFile contextVFile;
        AndroidFindStyleApplicationsProcessor processor = AndroidFindStyleApplicationsAction.createFindStyleApplicationsProcessor(tag, styleData, context);
        if (processor == null) {
            return;
        }
        Module module = styleData.getFacet().getModule();
        VirtualFile virtualFile = contextVFile = context != null ? context.getVirtualFile() : null;
        if (testConfig != null) {
            processor.configureScope(testConfig.getScope(), contextVFile);
            processor.run();
            return;
        }
        processor.setPreviewUsages(true);
        boolean bl = showModuleRadio = AndroidFindStyleApplicationsProcessor.getAllModulesToScan(module).size() > 1;
        if (showModuleRadio || contextVFile != null) {
            AndroidFindStyleApplicationsDialog dialog = new AndroidFindStyleApplicationsDialog(contextVFile, processor, showModuleRadio);
            dialog.show();
        } else {
            processor.run();
        }
    }

    public static AndroidFindStyleApplicationsProcessor createFindStyleApplicationsProcessor(XmlTag tag, MyStyleData styleData, PsiFile context) {
        ProjectBasedErrorReporter errorReporter = new ProjectBasedErrorReporter(tag.getProject());
        Style style = styleData.getStyle();
        Map<AndroidAttributeInfo, String> attrMap = AndroidRefactoringUtil.computeAttributeMap(style, new ProjectBasedErrorReporter(tag.getProject()), AndroidBundle.message("android.find.style.applications.title", new Object[0]));
        if (attrMap == null || attrMap.isEmpty()) {
            return null;
        }
        AndroidFacet facet = styleData.getFacet();
        StyleRefData parentStyleRef = AndroidRefactoringUtil.getParentStyle(style);
        PsiElement parentStyleAttrName = null;
        if (parentStyleRef != null && (parentStyleAttrName = AndroidFindStyleApplicationsAction.resolveStyleRef(parentStyleRef, facet)) == null) {
            errorReporter.report("Cannot resolve parent style '" + parentStyleRef.getStyleName() + "'", AndroidBundle.message("android.find.style.applications.title", new Object[0]));
            return null;
        }
        return new AndroidFindStyleApplicationsProcessor(styleData.getFacet().getModule(), attrMap, styleData.getName(), tag, styleData.getNameAttrValue(), parentStyleAttrName, context);
    }

    private static PsiElement resolveStyleRef(StyleRefData styleRef, AndroidFacet facet) {
        ResourceManager resourceManager = ModuleResourceManagers.getInstance(facet).getResourceManager(styleRef.getStylePackage());
        if (resourceManager == null) {
            return null;
        }
        List<ValueResourceInfoImpl> infos = resourceManager.findValueResourceInfos(ResourceNamespace.TODO(), ResourceType.STYLE, styleRef.getStyleName(), true, false);
        return infos.size() == 1 ? infos.get(0).computeXmlElement() : null;
    }

    @Nullable
    static MyStyleData getStyleData(@NotNull XmlTag tag) {
        DomElement element;
        if (tag == null) {
            AndroidFindStyleApplicationsAction.$$$reportNull$$$0(3);
        }
        if (!((element = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag)) instanceof Style)) {
            return null;
        }
        Style style = (Style)element;
        GenericAttributeValue<String> styleNameDomAttr = style.getName();
        String styleName = styleNameDomAttr.getStringValue();
        XmlAttributeValue styleNameAttrValue = styleNameDomAttr.getXmlAttributeValue();
        if (styleName == null || styleName.isEmpty() || styleNameAttrValue == null) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)tag);
        if (facet == null) {
            return null;
        }
        return new MyStyleData(style, styleName, facet, styleNameAttrValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/refactoring/AndroidFindStyleApplicationsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForTags";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doRefactorForTags";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getStyleData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class MyTestConfig {
        private final AndroidFindStyleApplicationsProcessor.MyScope myScope;

        MyTestConfig(@NotNull AndroidFindStyleApplicationsProcessor.MyScope scope) {
            if (scope == null) {
                MyTestConfig.$$$reportNull$$$0(0);
            }
            this.myScope = scope;
        }

        @NotNull
        public AndroidFindStyleApplicationsProcessor.MyScope getScope() {
            AndroidFindStyleApplicationsProcessor.MyScope myScope = this.myScope;
            if (myScope == null) {
                MyTestConfig.$$$reportNull$$$0(1);
            }
            return myScope;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/refactoring/AndroidFindStyleApplicationsAction$MyTestConfig";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/refactoring/AndroidFindStyleApplicationsAction$MyTestConfig";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class MyStyleData {
        private final Style myStyle;
        private final String myName;
        private final XmlAttributeValue myNameAttrValue;
        private final AndroidFacet myFacet;

        private MyStyleData(@NotNull Style style, @NotNull String name, @NotNull AndroidFacet facet, @NotNull XmlAttributeValue nameAttrValue) {
            if (style == null) {
                MyStyleData.$$$reportNull$$$0(0);
            }
            if (name == null) {
                MyStyleData.$$$reportNull$$$0(1);
            }
            if (facet == null) {
                MyStyleData.$$$reportNull$$$0(2);
            }
            if (nameAttrValue == null) {
                MyStyleData.$$$reportNull$$$0(3);
            }
            this.myStyle = style;
            this.myName = name;
            this.myFacet = facet;
            this.myNameAttrValue = nameAttrValue;
        }

        @NotNull
        public Style getStyle() {
            Style style = this.myStyle;
            if (style == null) {
                MyStyleData.$$$reportNull$$$0(4);
            }
            return style;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                MyStyleData.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public AndroidFacet getFacet() {
            AndroidFacet androidFacet = this.myFacet;
            if (androidFacet == null) {
                MyStyleData.$$$reportNull$$$0(6);
            }
            return androidFacet;
        }

        @NotNull
        public XmlAttributeValue getNameAttrValue() {
            XmlAttributeValue xmlAttributeValue = this.myNameAttrValue;
            if (xmlAttributeValue == null) {
                MyStyleData.$$$reportNull$$$0(7);
            }
            return xmlAttributeValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "style";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facet";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameAttrValue";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/refactoring/AndroidFindStyleApplicationsAction$MyStyleData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/refactoring/AndroidFindStyleApplicationsAction$MyStyleData";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStyle";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFacet";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameAttrValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

