/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMigration;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.util.containers.HashMap;
import icons.AndroidIcons;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.dom.resources.StyleItem;
import org.jetbrains.android.refactoring.AndroidAttributeInfo;
import org.jetbrains.android.refactoring.StyleRefData;
import org.jetbrains.android.util.ErrorReporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRefactoringUtil {
    private AndroidRefactoringUtil() {
    }

    @Nullable
    static StyleRefData getParentStyle(@NotNull Style style) {
        ResourceValue parentStyleRefValue;
        if (style == null) {
            AndroidRefactoringUtil.$$$reportNull$$$0(0);
        }
        if ((parentStyleRefValue = (ResourceValue)style.getParentStyle().getValue()) != null) {
            String parentStyleName = parentStyleRefValue.getResourceName();
            if (parentStyleName != null) {
                return new StyleRefData(parentStyleName, parentStyleRefValue.getPackage());
            }
        } else {
            int idx;
            String styleName = style.getName().getStringValue();
            if (styleName != null && (idx = styleName.lastIndexOf(46)) > 0) {
                return new StyleRefData(styleName.substring(0, idx), null);
            }
        }
        return null;
    }

    @Nullable
    static Map<AndroidAttributeInfo, String> computeAttributeMap(@NotNull Style style, @NotNull ErrorReporter errorReporter, @NotNull String errorReportTitle) {
        if (style == null) {
            AndroidRefactoringUtil.$$$reportNull$$$0(1);
        }
        if (errorReporter == null) {
            AndroidRefactoringUtil.$$$reportNull$$$0(2);
        }
        if (errorReportTitle == null) {
            AndroidRefactoringUtil.$$$reportNull$$$0(3);
        }
        HashMap attributeValues = new HashMap();
        for (StyleItem item : style.getItems()) {
            String nsPrefix;
            String attributeName = item.getName().getStringValue();
            String attributeValue = item.getStringValue();
            if (attributeName == null || attributeName.length() <= 0 || attributeValue == null) continue;
            int idx = attributeName.indexOf(58);
            String localName = idx >= 0 ? attributeName.substring(idx + 1) : attributeName;
            String string = nsPrefix = idx >= 0 ? attributeName.substring(0, idx) : null;
            if (nsPrefix != null) {
                if (!"android".equals(nsPrefix)) {
                    errorReporter.report(RefactoringBundle.getCannotRefactorMessage((String)("Unknown XML attribute prefix '" + nsPrefix + ":'")), errorReportTitle);
                    return null;
                }
            } else {
                errorReporter.report(RefactoringBundle.getCannotRefactorMessage((String)"The style contains attribute without 'android' prefix."), errorReportTitle);
                return null;
            }
            attributeValues.put(new AndroidAttributeInfo(localName, nsPrefix), attributeValue);
        }
        return attributeValues;
    }

    @NotNull
    static PsiClass findOrCreateClass(@NotNull Project project, @NotNull PsiMigration migration, @NotNull String qName) {
        PsiClass aClass;
        if (project == null) {
            AndroidRefactoringUtil.$$$reportNull$$$0(4);
        }
        if (migration == null) {
            AndroidRefactoringUtil.$$$reportNull$$$0(5);
        }
        if (qName == null) {
            AndroidRefactoringUtil.$$$reportNull$$$0(6);
        }
        if ((aClass = JavaPsiFacade.getInstance((Project)project).findClass(qName, GlobalSearchScope.allScope((Project)project))) == null) {
            aClass = (PsiClass)WriteAction.compute(() -> {
                if (migration == null) {
                    AndroidRefactoringUtil.$$$reportNull$$$0(17);
                }
                if (qName == null) {
                    AndroidRefactoringUtil.$$$reportNull$$$0(18);
                }
                return migration.createClass(qName);
            });
        }
        PsiClass psiClass = aClass;
        if (psiClass == null) {
            AndroidRefactoringUtil.$$$reportNull$$$0(7);
        }
        return psiClass;
    }

    @NotNull
    static PsiPackage findOrCreatePackage(@NotNull Project project, @NotNull PsiMigration migration, @NotNull String qName) {
        PsiPackage aPackage;
        if (project == null) {
            AndroidRefactoringUtil.$$$reportNull$$$0(8);
        }
        if (migration == null) {
            AndroidRefactoringUtil.$$$reportNull$$$0(9);
        }
        if (qName == null) {
            AndroidRefactoringUtil.$$$reportNull$$$0(10);
        }
        if ((aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(qName)) != null) {
            PsiPackage psiPackage = aPackage;
            if (psiPackage == null) {
                AndroidRefactoringUtil.$$$reportNull$$$0(11);
            }
            return psiPackage;
        }
        PsiPackage psiPackage = (PsiPackage)WriteAction.compute(() -> {
            if (migration == null) {
                AndroidRefactoringUtil.$$$reportNull$$$0(15);
            }
            if (qName == null) {
                AndroidRefactoringUtil.$$$reportNull$$$0(16);
            }
            return migration.createPackage(qName);
        });
        if (psiPackage == null) {
            AndroidRefactoringUtil.$$$reportNull$$$0(12);
        }
        return psiPackage;
    }

    static void offerToSync(@NotNull Project project, @NotNull String title) {
        int dialogResult;
        if (project == null) {
            AndroidRefactoringUtil.$$$reportNull$$$0(13);
        }
        if (title == null) {
            AndroidRefactoringUtil.$$$reportNull$$$0(14);
        }
        if ((dialogResult = Messages.showYesNoCancelDialog((Project)project, (String)"A project sync is necessary after the refactoring. Sync the project now?", (String)title, (Icon)AndroidIcons.GradleSync)) == 0) {
            GradleSyncInvoker.Request syncRequest = GradleSyncInvoker.Request.userRequest();
            syncRequest.generateSourcesOnSuccess = true;
            syncRequest.runInBackground = false;
            GradleSyncInvoker.getInstance().requestProjectSync(project, syncRequest);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorReporter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorReportTitle";
                break;
            }
            case 4: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "migration";
                break;
            }
            case 6: 
            case 10: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/refactoring/AndroidRefactoringUtil";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/refactoring/AndroidRefactoringUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateClass";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreatePackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getParentStyle";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeAttributeMap";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateClass";
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreatePackage";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "offerToSync";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findOrCreatePackage$1";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findOrCreateClass$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

