/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.android.tools.idea.ui.GuiTestingService;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.PathUtil;
import com.intellij.util.net.HttpConfigurable;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarFile;
import org.jetbrains.android.refactoring.AppCompatStyleMigration;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppCompatPublicDotTxtLookup {
    private static final String BASE_URL = "https://maven.google.com/com/android/support/appcompat-v7/%1$s/appcompat-v7-%2$s.aar";
    private static final String ANDROIDX_BASE_URL = "https://maven.google.com/androidx/appcompat/appcompat/%1$s/appcompat-%2$s.aar";
    private static final Splitter PUBLIC_TXT_SPLITTER = Splitter.on((char)' ').trimResults();
    private static final String RELATIVE_URI_PATH = "com/android/support/appcompat-v7/%1$s/public.txt";
    private static final String ANDROIDX_RELATIVE_URI_PATH = "androidx/appcompat/appcompat/%1$s/public.txt";
    private static final String RELATIVE_FILE_PATH = "com/android/support/appcompat-v7/%1$s/public.txt".replace('/', File.separatorChar);
    private static final String ANDROIDX_RELATIVE_FILE_PATH = "androidx/appcompat/appcompat/%1$s/public.txt".replace('/', File.separatorChar);

    static AppCompatPublicDotTxtLookup getInstance() {
        return LookupCreator.INSTANCE;
    }

    AppCompatPublicDotTxtLookup() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    AppCompatStyleMigration createAppCompatStyleMigration(@NotNull GoogleMavenArtifactId artifactId, @NotNull String appCompatVersion) {
        if (artifactId == null) {
            AppCompatPublicDotTxtLookup.$$$reportNull$$$0(0);
        }
        if (appCompatVersion == null) {
            AppCompatPublicDotTxtLookup.$$$reportNull$$$0(1);
        }
        HashSet attrSet = Sets.newHashSetWithExpectedSize((int)250);
        HashSet styleSet = Sets.newHashSetWithExpectedSize((int)200);
        try (BufferedReader reader = this.findAppCompatPublicTxt(artifactId, appCompatVersion);){
            String line;
            while ((line = reader.readLine()) != null) {
                List splitList = PUBLIC_TXT_SPLITTER.splitToList((CharSequence)line);
                if (splitList.size() != 2) continue;
                String key = (String)splitList.get(0);
                String value = (String)splitList.get(1);
                if ("attr".equals(key)) {
                    attrSet.add(value);
                    continue;
                }
                if (!"style".equals(key)) continue;
                if (value.contains("_")) {
                    value = value.replace('_', '.');
                }
                styleSet.add(value);
            }
            AppCompatStyleMigration appCompatStyleMigration = new AppCompatStyleMigration(attrSet, styleSet);
            return appCompatStyleMigration;
        }
        catch (IOException e) {
            Logger.getInstance(AppCompatPublicDotTxtLookup.class).warn((Throwable)e);
            return new AppCompatStyleMigration(Collections.emptySet(), Collections.emptySet());
        }
    }

    private File getCacheDir() {
        if (ApplicationManager.getApplication().isUnitTestMode() || GuiTestingService.getInstance().isGuiTestingMode()) {
            return null;
        }
        return new File(PathUtil.getCanonicalPath((String)PathManager.getSystemPath()), "maven.google");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static JarFile findRemoteAppCompatAar(@NotNull GoogleMavenArtifactId artifactId, @NotNull String appCompatVersion) throws IOException {
        JarFile jarFile;
        if (artifactId == null) {
            AppCompatPublicDotTxtLookup.$$$reportNull$$$0(2);
        }
        if (appCompatVersion == null) {
            AppCompatPublicDotTxtLookup.$$$reportNull$$$0(3);
        }
        URLConnection ucon = null;
        BufferedInputStream is = null;
        try {
            String url = String.format(artifactId.isAndroidxLibrary() ? ANDROIDX_BASE_URL : BASE_URL, appCompatVersion, appCompatVersion);
            ucon = HttpConfigurable.getInstance().openConnection(url);
            is = new BufferedInputStream(ucon.getInputStream());
            Path tmpPath = Files.createTempFile("aar_appcompat_cache", null, new FileAttribute[0]);
            tmpPath.toFile().deleteOnExit();
            Files.copy(is, tmpPath, StandardCopyOption.REPLACE_EXISTING);
            jarFile = new JarFile(tmpPath.toFile());
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(is);
            if (ucon instanceof HttpURLConnection) {
                ((HttpURLConnection)ucon).disconnect();
            }
            throw throwable;
        }
        Closeables.closeQuietly((InputStream)is);
        if (ucon instanceof HttpURLConnection) {
            ((HttpURLConnection)ucon).disconnect();
        }
        JarFile jarFile2 = jarFile;
        if (jarFile2 == null) {
            AppCompatPublicDotTxtLookup.$$$reportNull$$$0(4);
        }
        return jarFile2;
    }

    @Nullable
    private static JarFile findLocalAppCompatAar(@NotNull GoogleMavenArtifactId artifactId, @NotNull String appCompatVersion) throws IOException {
        AndroidSdkData sdkData;
        if (artifactId == null) {
            AppCompatPublicDotTxtLookup.$$$reportNull$$$0(5);
        }
        if (appCompatVersion == null) {
            AppCompatPublicDotTxtLookup.$$$reportNull$$$0(6);
        }
        if ((sdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk()) == null) {
            return null;
        }
        GradleCoordinate coordinate = artifactId.getCoordinate(appCompatVersion);
        File appCompatAarFile = RepositoryUrlManager.get().getArchiveForCoordinate(coordinate, sdkData.getLocation(), FileOpUtils.create());
        if (appCompatAarFile == null || !appCompatAarFile.exists()) {
            return null;
        }
        return new JarFile(appCompatAarFile);
    }

    /*
     * Loose catch block
     */
    private static byte[] findEntryRemote(@NotNull GoogleMavenArtifactId artifactId, @NotNull String appCompatVersion) throws IOException {
        JarFile jarFile;
        if (artifactId == null) {
            AppCompatPublicDotTxtLookup.$$$reportNull$$$0(7);
        }
        if (appCompatVersion == null) {
            AppCompatPublicDotTxtLookup.$$$reportNull$$$0(8);
        }
        if ((jarFile = AppCompatPublicDotTxtLookup.findLocalAppCompatAar(artifactId, appCompatVersion)) == null) {
            jarFile = AppCompatPublicDotTxtLookup.findRemoteAppCompatAar(artifactId, appCompatVersion);
        }
        try {
            try (InputStream is = jarFile.getInputStream(jarFile.getEntry("public.txt"));){
                byte[] byArray = ByteStreams.toByteArray((InputStream)is);
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            jarFile.close();
        }
    }

    @NotNull
    private synchronized BufferedReader findAppCompatPublicTxt(@NotNull GoogleMavenArtifactId artifactId, @NotNull String appCompatVersion) throws IOException {
        if (artifactId == null) {
            AppCompatPublicDotTxtLookup.$$$reportNull$$$0(9);
        }
        if (appCompatVersion == null) {
            AppCompatPublicDotTxtLookup.$$$reportNull$$$0(10);
        }
        if (this.getCacheDir() != null) {
            BufferedReader bufferedReader;
            block10: {
                File file = new File(this.getCacheDir(), String.format(artifactId.isAndroidxLibrary() ? ANDROIDX_RELATIVE_FILE_PATH : RELATIVE_FILE_PATH, appCompatVersion));
                if (file.exists()) {
                    BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
                    if (bufferedReader2 == null) {
                        AppCompatPublicDotTxtLookup.$$$reportNull$$$0(11);
                    }
                    return bufferedReader2;
                }
                try {
                    byte[] bytes = AppCompatPublicDotTxtLookup.findEntryRemote(artifactId, appCompatVersion);
                    ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                    if (file.getParentFile().mkdirs()) {
                        in.mark(Integer.MAX_VALUE);
                        Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        in.reset();
                    }
                    if ((bufferedReader = new BufferedReader(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8))) != null) break block10;
                }
                catch (IOException e) {
                    Logger.getInstance(AppCompatPublicDotTxtLookup.class).warn((Throwable)e);
                    BufferedReader bufferedReader3 = AppCompatPublicDotTxtLookup.getPublicTxtAsResource();
                    if (bufferedReader3 == null) {
                        AppCompatPublicDotTxtLookup.$$$reportNull$$$0(13);
                    }
                    return bufferedReader3;
                }
                AppCompatPublicDotTxtLookup.$$$reportNull$$$0(12);
            }
            return bufferedReader;
        }
        BufferedReader bufferedReader = AppCompatPublicDotTxtLookup.getPublicTxtAsResource();
        if (bufferedReader == null) {
            AppCompatPublicDotTxtLookup.$$$reportNull$$$0(14);
        }
        return bufferedReader;
    }

    @NotNull
    private static BufferedReader getPublicTxtAsResource() {
        InputStream is = AppCompatPublicDotTxtLookup.class.getResourceAsStream("/migrateToAppCompat/public.txt");
        if (is == null) {
            throw new AssertionError((Object)"Missing resource migrateToAppCompat/public.txt");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        if (bufferedReader == null) {
            AppCompatPublicDotTxtLookup.$$$reportNull$$$0(15);
        }
        return bufferedReader;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appCompatVersion";
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/refactoring/AppCompatPublicDotTxtLookup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/refactoring/AppCompatPublicDotTxtLookup";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findRemoteAppCompatAar";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findAppCompatPublicTxt";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublicTxtAsResource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAppCompatStyleMigration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findRemoteAppCompatAar";
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findLocalAppCompatAar";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findEntryRemote";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findAppCompatPublicTxt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class LookupCreator {
        static final AppCompatPublicDotTxtLookup INSTANCE = new AppCompatPublicDotTxtLookup();

        private LookupCreator() {
        }
    }
}

