/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.MigrateToAppCompatUsageInfo;
import org.jetbrains.android.refactoring.MigrateToAppCompatUtil;
import org.jetbrains.annotations.NotNull;

class AppCompatStyleMigration {
    private final Set<String> myAppCompatAttributes;
    private final Set<String> myAppCompatStyles;

    AppCompatStyleMigration(Set<String> appCompatAttributes, Set<String> appCompatStyles) {
        this.myAppCompatAttributes = ImmutableSet.copyOf(appCompatAttributes);
        this.myAppCompatStyles = ImmutableSet.copyOf(appCompatStyles);
    }

    private boolean isAppCompatAttribute(String attribute) {
        return this.myAppCompatAttributes.contains(attribute);
    }

    private boolean isAppCompatStyle(String styleName) {
        return this.myAppCompatStyles.contains(styleName);
    }

    @NotNull
    public List<MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo> findStyleElementsToBeModified(@NotNull Project project, @NotNull AndroidFacet facet) {
        ConfigurationManager configManager;
        if (project == null) {
            AppCompatStyleMigration.$$$reportNull$$$0(0);
        }
        if (facet == null) {
            AppCompatStyleMigration.$$$reportNull$$$0(1);
        }
        if ((configManager = ConfigurationManager.getOrCreateInstance(facet.getModule())).getTarget() == null) {
            List<MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo> list = Collections.emptyList();
            if (list == null) {
                AppCompatStyleMigration.$$$reportNull$$$0(2);
            }
            return list;
        }
        AbstractResourceRepository frameworkResources = configManager.getResolverCache().getFrameworkResources(new FolderConfiguration(), configManager.getTarget());
        ArrayList<MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo> result2 = new ArrayList<MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo>();
        if (frameworkResources == null) {
            List<MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo> list = Collections.emptyList();
            if (list == null) {
                AppCompatStyleMigration.$$$reportNull$$$0(3);
            }
            return list;
        }
        this.addStyleUsagesFromManifest(facet, frameworkResources, result2);
        LocalResourceRepository projectResources = ResourceRepositoryManager.getProjectResources(facet);
        this.addUsagesFromStyles(project, frameworkResources, result2, projectResources);
        this.addUsagesFromLayout(project, result2, projectResources);
        ArrayList<MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo> arrayList = result2;
        if (arrayList == null) {
            AppCompatStyleMigration.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private void addUsagesFromLayout(Project project, final List<MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo> result2, LocalResourceRepository projectResources) {
        Set<XmlFile> psiLayoutFiles = MigrateToAppCompatUtil.getPsiFilesOfType(project, projectResources, ResourceType.LAYOUT);
        for (XmlFile layoutFile : psiLayoutFiles) {
            layoutFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                public void visitXmlTag(XmlTag tag) {
                    super.visitXmlTag(tag);
                    XmlAttribute attr = tag.getAttribute("style");
                    AppCompatStyleMigration.this.themeOrStyle2UsageInfo(attr, result2);
                    for (XmlAttribute attribute : tag.getAttributes()) {
                        String attributeValue;
                        if (!"http://schemas.android.com/apk/res/android".equals(attribute.getNamespace()) || (attributeValue = attribute.getValue()) == null) continue;
                        if (attributeValue.startsWith("?") && attributeValue.contains("android:")) {
                            ResourceUrl url = ResourceUrl.parse((String)attributeValue);
                            if (url == null || !url.isFramework() || !AppCompatStyleMigration.this.isAppCompatAttribute(url.name)) continue;
                            ResourceUrl toChange = url.isTheme() ? ResourceUrl.createThemeReference(null, (ResourceType)ResourceType.ATTR, (String)url.name) : ResourceUrl.create(null, (ResourceType)ResourceType.ATTR, (String)url.name);
                            String newResource = toChange.toString();
                            result2.add(new MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo((PsiElement)attribute.getValueElement(), attributeValue, newResource));
                            continue;
                        }
                        if (!attributeValue.startsWith("@") || !attributeValue.contains("android:")) continue;
                        AppCompatStyleMigration.this.themeOrStyle2UsageInfo(attribute, result2);
                    }
                }
            });
        }
    }

    private void themeOrStyle2UsageInfo(XmlAttribute styleAttr, List<MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo> result2) {
        if (styleAttr != null && styleAttr.getValue() != null) {
            String attrValue = styleAttr.getValue();
            ResourceUrl attrRes = ResourceUrl.parse((String)attrValue);
            if (attrRes == null) {
                return;
            }
            if (attrRes.isFramework()) {
                Pair<Boolean, String> converted = AppCompatStyleMigration.replaceStyleNameIfContains(attrRes.name, ".Material");
                if (!((Boolean)converted.first).booleanValue()) {
                    return;
                }
                if (this.isAppCompatStyle((String)converted.second)) {
                    ResourceUrl toChange = ResourceUrl.create(null, (ResourceType)ResourceType.STYLE, (String)((String)converted.second));
                    result2.add(new MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo((PsiElement)styleAttr, styleAttr.getValue(), toChange.toString()));
                }
            }
        }
    }

    private void addUsagesFromStyles(@NotNull Project project, AbstractResourceRepository frameworkResources, List<MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo> result2, LocalResourceRepository projectResources) {
        if (project == null) {
            AppCompatStyleMigration.$$$reportNull$$$0(5);
        }
        Set<XmlFile> xmlFiles = MigrateToAppCompatUtil.getPsiFilesOfType(project, projectResources, ResourceType.STYLE);
        for (XmlFile xmlFile : xmlFiles) {
            XmlTag[] styleTags;
            XmlTag rootTag = xmlFile.getRootTag();
            if (rootTag == null) continue;
            for (XmlTag styleTag : styleTags = rootTag.findSubTags("style")) {
                XmlTag[] items2;
                XmlAttribute parent = styleTag.getAttribute("parent");
                if (parent != null && parent.getValue() != null && parent.getValueElement() != null) {
                    String changeToStyle;
                    String parentValue = parent.getValue();
                    String parentStyle = StringUtil.trimStart((String)parentValue, (String)"android:");
                    if (parentValue.startsWith("android:") && frameworkResources.hasResourceItem(ResourceNamespace.ANDROID, ResourceType.STYLE, parentStyle) && this.isAppCompatStyle(changeToStyle = AppCompatStyleMigration.toAppCompatThemeOrStyleName(parentStyle))) {
                        result2.add(new MigrateToAppCompatUsageInfo.ChangeThemeUsageInfo(parent.getValueElement(), parent.getValue(), changeToStyle));
                    }
                }
                for (XmlTag xmlItemTag : items2 = styleTag.findSubTags("item")) {
                    ResourceUrl attrUrl;
                    XmlTagValue tagValue;
                    String tagValueText;
                    String itemNameNoAndroidPrefix;
                    String itemNameAttr = xmlItemTag.getAttributeValue("name");
                    String string = itemNameNoAndroidPrefix = itemNameAttr == null ? null : StringUtil.trimStart((String)itemNameAttr, (String)"android:");
                    if (itemNameAttr != null && itemNameAttr.startsWith("android:") && frameworkResources.hasResourceItem(ResourceNamespace.ANDROID, ResourceType.ATTR, itemNameNoAndroidPrefix) && this.isAppCompatAttribute(itemNameNoAndroidPrefix)) {
                        result2.add(new MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo((PsiElement)xmlItemTag.getAttribute("name"), itemNameAttr, itemNameNoAndroidPrefix));
                    }
                    if (!frameworkResources.hasResourceItem(tagValueText = (tagValue = xmlItemTag.getValue()).getText()) || (attrUrl = ResourceUrl.parse((String)tagValueText)) == null || !attrUrl.isFramework() || !this.isAppCompatAttribute(attrUrl.name) || xmlItemTag.getValue().getTextElements().length != 1) continue;
                    ResourceUrl changeToStyleAttr = attrUrl.isTheme() ? ResourceUrl.createThemeReference(null, (ResourceType)ResourceType.ATTR, (String)attrUrl.name) : ResourceUrl.create(null, (ResourceType)ResourceType.ATTR, (String)attrUrl.name);
                    String changedStyle = changeToStyleAttr.toString();
                    result2.add(new MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo((PsiElement)xmlItemTag.getValue().getTextElements()[0], tagValueText, changedStyle));
                }
            }
        }
    }

    private void addStyleUsagesFromManifest(@NotNull AndroidFacet facet, AbstractResourceRepository frameworkResources, List<MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo> result2) {
        Manifest manifest;
        if (facet == null) {
            AppCompatStyleMigration.$$$reportNull$$$0(6);
        }
        if ((manifest = facet.getManifest()) != null) {
            XmlTag applicationTag = manifest.getApplication().getXmlTag();
            if (applicationTag != null) {
                XmlAttribute theme = applicationTag.getAttribute("theme", "http://schemas.android.com/apk/res/android");
                this.convertThemeAttr2UsageInfo(theme, frameworkResources, result2);
            }
            List<Activity> activities = manifest.getApplication().getActivities();
            for (Activity activity : activities) {
                XmlAttribute activityTheme = activity.getXmlTag().getAttribute("theme", "http://schemas.android.com/apk/res/android");
                this.convertThemeAttr2UsageInfo(activityTheme, frameworkResources, result2);
            }
        }
    }

    private static String toAppCompatThemeOrStyleName(String themeName) {
        block3: {
            Pair<Boolean, String> result2;
            block2: {
                result2 = AppCompatStyleMigration.replaceStyleNameIfContains(themeName, ".Material");
                if (((Boolean)result2.first).booleanValue()) break block2;
                result2 = AppCompatStyleMigration.replaceStyleNameIfContains(themeName, ".Holo");
                if (!((Boolean)result2.first).booleanValue()) break block3;
            }
            return (String)result2.second;
        }
        return themeName;
    }

    private static Pair<Boolean, String> replaceStyleNameIfContains(@NotNull String originalStyleName, @NotNull String findWithoutTrailingDot) {
        if (originalStyleName == null) {
            AppCompatStyleMigration.$$$reportNull$$$0(7);
        }
        if (findWithoutTrailingDot == null) {
            AppCompatStyleMigration.$$$reportNull$$$0(8);
        }
        if (originalStyleName.endsWith(findWithoutTrailingDot)) {
            return Pair.create((Object)true, (Object)StringUtil.replace((String)originalStyleName, (String)findWithoutTrailingDot, (String)".AppCompat"));
        }
        if (originalStyleName.contains(findWithoutTrailingDot + ".")) {
            return Pair.create((Object)true, (Object)StringUtil.replace((String)originalStyleName, (String)(findWithoutTrailingDot + "."), (String)".AppCompat."));
        }
        return Pair.create((Object)false, null);
    }

    private void convertThemeAttr2UsageInfo(XmlAttribute theme, AbstractResourceRepository frameworkResources, List<MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo> result2) {
        String appCompatThemeName;
        String themeValue;
        ResourceUrl themeUrl;
        if (theme != null && theme.getValueElement() != null && theme.getValue() != null && frameworkResources.hasResourceItem(theme.getValue()) && (themeUrl = ResourceUrl.parse((String)(themeValue = theme.getValue()))) != null && this.isAppCompatStyle(appCompatThemeName = AppCompatStyleMigration.toAppCompatThemeOrStyleName(themeUrl.name))) {
            ResourceUrl changeToStyleAttr = ResourceUrl.create(null, (ResourceType)ResourceType.STYLE, (String)appCompatThemeName);
            result2.add(new MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo((PsiElement)theme.getValueElement(), themeValue, changeToStyleAttr.toString()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/refactoring/AppCompatStyleMigration";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalStyleName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findWithoutTrailingDot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/refactoring/AppCompatStyleMigration";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findStyleElementsToBeModified";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findStyleElementsToBeModified";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addUsagesFromStyles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addStyleUsagesFromManifest";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceStyleNameIfContains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

