/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.resources.ResourceType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.xml.GenericDomValue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.refactoring.ResourceUsageInfo;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/android/refactoring/DomValueUsageInfo;", "Lorg/jetbrains/android/refactoring/ResourceUsageInfo;", "ref", "Lcom/intellij/psi/PsiReference;", "domValue", "Lcom/intellij/util/xml/GenericDomValue;", "Lorg/jetbrains/android/dom/resources/ResourceValue;", "(Lcom/intellij/psi/PsiReference;Lcom/intellij/util/xml/GenericDomValue;)V", "getDomValue", "()Lcom/intellij/util/xml/GenericDomValue;", "name", "", "getName", "()Ljava/lang/String;", "resourceType", "Lcom/android/resources/ResourceType;", "getResourceType", "()Lcom/android/resources/ResourceType;", "intellij.android.core"})
final class DomValueUsageInfo
extends ResourceUsageInfo {
    @NotNull
    private final GenericDomValue<ResourceValue> domValue;

    @Override
    @NotNull
    public ResourceType getResourceType() {
        Object object = this.domValue.getValue();
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"domValue.value!!");
        ResourceType resourceType = ((ResourceValue)object).getType();
        if (resourceType == null) {
            Intrinsics.throwNpe();
        }
        return resourceType;
    }

    @Override
    @NotNull
    public String getName() {
        Object object = this.domValue.getValue();
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"domValue.value!!");
        String string = ((ResourceValue)object).getResourceName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @NotNull
    public final GenericDomValue<ResourceValue> getDomValue() {
        return this.domValue;
    }

    public DomValueUsageInfo(@NotNull PsiReference ref, @NotNull GenericDomValue<ResourceValue> domValue) {
        Intrinsics.checkParameterIsNotNull((Object)ref, (String)"ref");
        Intrinsics.checkParameterIsNotNull(domValue, (String)"domValue");
        PsiElement psiElement = ref.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"ref.element");
        TextRange textRange = ref.getRangeInElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"ref.rangeInElement");
        int n = textRange.getStartOffset();
        TextRange textRange2 = ref.getRangeInElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"ref.rangeInElement");
        super(psiElement, n, textRange2.getEndOffset(), null);
        this.domValue = domValue;
    }
}

