/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.ide.common.repository.GradleVersion;
import com.android.sdklib.AndroidVersion;
import com.android.support.AndroidxMigrationParserKt;
import com.android.support.MigrationParserVisitor;
import com.android.tools.idea.actions.ExportProjectZip;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.util.PairFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.refactoring.AppCompatMigrationEntry;
import org.jetbrains.android.refactoring.MigrateToAndroidxHandler;
import org.jetbrains.android.refactoring.MigrateToAndroidxProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J/\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0003J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/android/refactoring/MigrateToAndroidxHandler;", "Lcom/intellij/refactoring/RefactoringActionHandler;", "()V", "checkRefactoringPrerequisites", "", "project", "Lcom/intellij/openapi/project/Project;", "invoke", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "elements", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "parseMigrationMap", "", "Lorg/jetbrains/android/refactoring/AppCompatMigrationEntry;", "runMigration", "intellij.android.core"})
public final class MigrateToAndroidxHandler
implements RefactoringActionHandler {
    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file, @Nullable DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        PsiElement[] psiElementArray = new PsiElement[1];
        PsiFile psiFile = file;
        if (psiFile == null) {
            Intrinsics.throwNpe();
        }
        psiElementArray[0] = (PsiElement)psiFile;
        this.invoke(project, psiElementArray, dataContext);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @Nullable DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)elements, (String)"elements");
        if (!this.checkRefactoringPrerequisites(project)) {
            return;
        }
        int okCancelResult2 = Messages.showCheckboxMessageDialog((String)"\nBefore proceeding, we recommend that you make a backup of your project.\n\nDepending on your project dependencies, you might need to manually fix\nsome errors after the refactoring in order to successfully compile your project.\n\nDo you want to proceed with the migration?\n", (String)"Migrate to AndroidX", (String[])new String[]{"Cancel", "Migrate"}, (String)"Backup project as Zip file", (boolean)true, (int)0, (int)0, (Icon)Messages.getWarningIcon(), (PairFunction)invoke.okCancelResult.1.INSTANCE);
        switch (okCancelResult2) {
            case 2: {
                return;
            }
            case 0: {
                ExportProjectZip exportZip = new ExportProjectZip();
                DataContext dataContext2 = dataContext;
                if (dataContext2 == null) {
                    dataContext2 = SimpleDataContext.getProjectContext((Project)project);
                }
                DataContext context = dataContext2;
                ActionUtil.invokeAction((AnAction)exportZip, (DataContext)context, (String)"Migrate to AndroidX", null, (Runnable)new Runnable(this, project){
                    final /* synthetic */ MigrateToAndroidxHandler this$0;
                    final /* synthetic */ Project $project;

                    public final void run() {
                        MigrateToAndroidxHandler.access$runMigration(this.this$0, this.$project);
                    }
                    {
                        this.this$0 = migrateToAndroidxHandler;
                        this.$project = project;
                    }
                });
                break;
            }
            default: {
                this.runMigration(project);
            }
        }
    }

    private final void runMigration(Project project) {
        MigrateToAndroidxProcessor processor;
        MigrateToAndroidxProcessor $receiver = processor = new MigrateToAndroidxProcessor(project, this.parseMigrationMap(), null, 4, null);
        $receiver.setPreviewUsages(true);
        $receiver.run();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean checkRefactoringPrerequisites(Project project) {
        boolean supportedGradleVersion;
        boolean bl;
        String gradleVersionString;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        String string;
        Object object;
        Object item$iv$iv;
        Object it;
        Object $receiver$iv$iv2;
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Module[] moduleArray = moduleManager.getModules();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
        Object $receiver$iv2 = moduleArray;
        Object[] objectArray = $receiver$iv2;
        Object[] destination$iv$iv = (Object[])new ArrayList();
        Object $receiver$iv$iv$iv = $receiver$iv$iv2;
        int n = ((void)$receiver$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            AndroidModel androidModel;
            void var9_15;
            void element$iv$iv = var9_15 = $receiver$iv$iv$iv[i];
            Module it2 = (Module)element$iv$iv;
            GradleBuildModel gradleBuildModel = GradleBuildModel.get(it2);
            AndroidModel androidModel2 = gradleBuildModel != null ? gradleBuildModel.android() : null;
            if (androidModel2 == null) continue;
            AndroidModel it$iv$iv = androidModel = androidModel2;
            destination$iv$iv.add(it$iv$iv);
        }
        $receiver$iv2 = (List)destination$iv$iv;
        $receiver$iv$iv2 = $receiver$iv2;
        destination$iv$iv = new ArrayList();
        $receiver$iv$iv$iv = $receiver$iv$iv2;
        Iterator iterator = $receiver$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String $i$a$1$mapNotNull;
            Object element$iv$iv$iv = iterator.next();
            Object t = element$iv$iv$iv;
            it = (AndroidModel)t;
            if (it.compileSdkVersion().toString() == null) continue;
            String it$iv$iv = $i$a$1$mapNotNull;
            destination$iv$iv.add(it$iv$iv);
        }
        $receiver$iv2 = (List)destination$iv$iv;
        $receiver$iv$iv2 = $receiver$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        $receiver$iv$iv$iv = $receiver$iv$iv2.iterator();
        while ($receiver$iv$iv$iv.hasNext()) {
            void it3;
            item$iv$iv = $receiver$iv$iv$iv.next();
            String element$iv$iv$iv = (String)item$iv$iv;
            object = destination$iv$iv;
            string = StringsKt.removePrefix((String)it3, (CharSequence)"android-");
            object.add(string);
        }
        $receiver$iv2 = (List)destination$iv$iv;
        $receiver$iv$iv2 = $receiver$iv2;
        destination$iv$iv = new ArrayList();
        $receiver$iv$iv$iv = $receiver$iv$iv2;
        item$iv$iv = $receiver$iv$iv$iv.iterator();
        while (item$iv$iv.hasNext()) {
            AndroidVersion $i$a$1$let;
            AndroidVersion $i$f$map;
            Object element$iv$iv$iv;
            Object e = element$iv$iv$iv = item$iv$iv.next();
            it = (String)e;
            try {
                $i$f$map = new AndroidVersion((String)it);
            }
            catch (AndroidVersion.AndroidVersionException e2) {
                $i$f$map = null;
            }
            if ($i$f$map == null) continue;
            AndroidVersion it$iv$iv = $i$a$1$let;
            destination$iv$iv.add(it$iv$iv);
        }
        AndroidVersion highestCompileSdkVersion = (AndroidVersion)CollectionsKt.lastOrNull((List)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)));
        boolean supportedCompileSdk = highestCompileSdkVersion != null ? new AndroidVersion(28).compareTo(highestCompileSdkVersion) <= 0 || highestCompileSdkVersion.getCodename() != null : true;
        ModuleManager moduleManager2 = ModuleManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager2, (String)"ModuleManager.getInstance(project)");
        Module[] moduleArray2 = moduleManager2.getModules();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray2, (String)"ModuleManager.getInstance(project).modules");
        destination$iv$iv = moduleArray2;
        $receiver$iv$iv$iv = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList();
        for (void element$iv$iv$iv : $receiver$iv$iv) {
            DependenciesModel dependenciesModel;
            void element$iv$iv = element$iv$iv$iv;
            Module it4 = (Module)element$iv$iv;
            Object object2 = GradleBuildModel.get(it4);
            DependenciesModel dependenciesModel2 = object2 != null && (object2 = object2.buildscript()) != null ? object2.dependencies() : null;
            if (dependenciesModel2 == null) continue;
            DependenciesModel it$iv$iv = dependenciesModel = dependenciesModel2;
            destination$iv$iv2.add(it$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv2;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv2 = new ArrayList();
        for (Object t : $receiver$iv$iv) {
            DependenciesModel it5 = (DependenciesModel)t;
            Iterable list$iv$iv = it5.artifacts();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv2;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv2 = new ArrayList();
        for (Object t : $receiver$iv$iv) {
            ArtifactDependencyModel it6 = (ArtifactDependencyModel)t;
            if (!(Intrinsics.areEqual((Object)it6.name().forceString(), (Object)"gradle") && Intrinsics.areEqual((Object)it6.group().forceString(), (Object)"com.android.tools.build"))) continue;
            destination$iv$iv2.add(t);
        }
        $receiver$iv = (List)destination$iv$iv2;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object t : $receiver$iv$iv) {
            ArtifactDependencyModel it6 = (ArtifactDependencyModel)t;
            object = destination$iv$iv2;
            string = it6.version().getValue(GradlePropertyModel.STRING_TYPE);
            object.add(string);
        }
        String string2 = gradleVersionString = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv2));
        if (string2 != null && !StringsKt.startsWith$default((CharSequence)string2, (char)'$', (boolean)false, (int)2, null)) {
            GradleVersion gradleVersion = GradleVersion.tryParse((String)gradleVersionString);
            bl = gradleVersion != null ? gradleVersion.isAtLeastIncludingPreviews(3, 2, 0) : false;
        } else {
            bl = supportedGradleVersion = true;
        }
        if (supportedCompileSdk && supportedGradleVersion) {
            return true;
        }
        String warningContent = (!supportedCompileSdk ? "You need to have at least have compileSdk 28 set in your module build.gradle to migrate to AndroidX.\n" : "") + (!supportedGradleVersion ? "The gradle plugin version in your project build.gradle file needs to be set to at least com.android.tools.build:gradle:3.2.0 in order to migrate to AndroidX." : "");
        Messages.showErrorDialog((String)warningContent, (String)"Unable to migrate to AndroidX");
        return false;
    }

    private final List<AppCompatMigrationEntry> parseMigrationMap() {
        List classesAndCoordinates = new ArrayList();
        List packages = new ArrayList();
        AndroidxMigrationParserKt.parseMigrationFile((MigrationParserVisitor)new MigrationParserVisitor(classesAndCoordinates, packages){
            final /* synthetic */ List $classesAndCoordinates;
            final /* synthetic */ List $packages;

            public void visitClass(@NotNull String old, @NotNull String string) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)string, (String)"new");
                this.$classesAndCoordinates.add(new AppCompatMigrationEntry.ClassMigrationEntry(old, string));
            }

            public void visitPackage(@NotNull String old, @NotNull String string) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)string, (String)"new");
                this.$packages.add(new AppCompatMigrationEntry.PackageMigrationEntry(old, string));
            }

            public void visitGradleCoordinate(@NotNull String oldGroupName, @NotNull String oldArtifactName, @NotNull String newGroupName, @NotNull String newArtifactName, @NotNull String newBaseVersion) {
                Intrinsics.checkParameterIsNotNull((Object)oldGroupName, (String)"oldGroupName");
                Intrinsics.checkParameterIsNotNull((Object)oldArtifactName, (String)"oldArtifactName");
                Intrinsics.checkParameterIsNotNull((Object)newGroupName, (String)"newGroupName");
                Intrinsics.checkParameterIsNotNull((Object)newArtifactName, (String)"newArtifactName");
                Intrinsics.checkParameterIsNotNull((Object)newBaseVersion, (String)"newBaseVersion");
                this.$classesAndCoordinates.add(new AppCompatMigrationEntry.GradleDependencyMigrationEntry(oldGroupName, oldArtifactName, newGroupName, newArtifactName, newBaseVersion));
            }

            public void visitGradleCoordinateUpgrade(@NotNull String groupName, @NotNull String artifactName, @NotNull String newBaseVersion) {
                Intrinsics.checkParameterIsNotNull((Object)groupName, (String)"groupName");
                Intrinsics.checkParameterIsNotNull((Object)artifactName, (String)"artifactName");
                Intrinsics.checkParameterIsNotNull((Object)newBaseVersion, (String)"newBaseVersion");
                this.$classesAndCoordinates.add(new AppCompatMigrationEntry.UpdateGradleDepedencyVersionMigrationEntry(groupName, artifactName, newBaseVersion));
            }
            {
                this.$classesAndCoordinates = $captured_local_variable$0;
                this.$packages = $captured_local_variable$1;
            }
        });
        List $receiver$iv = packages;
        if ($receiver$iv.size() > 1) {
            List list = $receiver$iv;
            Comparator comparator2 = new Comparator<T>(){

                public final int compare(T a, T b) {
                    AppCompatMigrationEntry.PackageMigrationEntry it = (AppCompatMigrationEntry.PackageMigrationEntry)b;
                    it = (AppCompatMigrationEntry.PackageMigrationEntry)a;
                    Comparable comparable = Integer.valueOf(it.myOldName.length());
                    Integer n = it.myOldName.length();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
                }
            };
            CollectionsKt.sortWith((List)list, (Comparator)comparator2);
        }
        classesAndCoordinates.addAll(packages);
        return classesAndCoordinates;
    }

    public static final /* synthetic */ void access$runMigration(MigrateToAndroidxHandler $this, @NotNull Project project) {
        $this.runMigration(project);
    }
}

