/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.idea.lint.LintIdeClient;
import com.android.tools.idea.lint.LintIdeIssueRegistry;
import com.android.tools.idea.lint.LintIdeRequest;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.lint.checks.AppCompatCustomViewDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.analysis.AnalysisScope;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.android.inspections.lint.ProblemData;
import org.jetbrains.android.refactoring.AppCompatMigrationEntry;
import org.jetbrains.android.refactoring.MigrateToAppCompatUsageInfo;
import org.jetbrains.annotations.NotNull;

class MigrateToAppCompatUtil {
    private MigrateToAppCompatUtil() {
    }

    static List<UsageInfo> findClassUsages(com.intellij.openapi.project.Project project, String qName) {
        PsiClass aClass = JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)project).findClass(qName, GlobalSearchScope.allScope((com.intellij.openapi.project.Project)project));
        return MigrateToAppCompatUtil.findRefs(project, (PsiElement)aClass);
    }

    public static List<UsageInfo> findPackageUsages(com.intellij.openapi.project.Project project, String qName) {
        PsiPackage aPackage = JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)project).findPackage(qName);
        return MigrateToAppCompatUtil.findRefs(project, (PsiElement)aPackage);
    }

    @NotNull
    private static List<UsageInfo> findRefs(com.intellij.openapi.project.Project project, PsiElement element) {
        if (element == null) {
            List<UsageInfo> list = Collections.emptyList();
            if (list == null) {
                MigrateToAppCompatUtil.$$$reportNull$$$0(0);
            }
            return list;
        }
        SmartList results = new SmartList();
        for (PsiReference usage : ReferencesSearch.search((PsiElement)element, (SearchScope)GlobalSearchScope.projectScope((com.intellij.openapi.project.Project)project), (boolean)true)) {
            if (!usage.getElement().isWritable()) continue;
            results.add(new UsageInfo(usage));
        }
        SmartList smartList = results;
        if (smartList == null) {
            MigrateToAppCompatUtil.$$$reportNull$$$0(1);
        }
        return smartList;
    }

    static Collection<PsiReference> findChangeMethodRefs(com.intellij.openapi.project.Project project, AppCompatMigrationEntry.MethodMigrationEntry entry) {
        String psiClass = entry.myOldClassName;
        PsiClass psiLookupClass = JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)project).findClass(psiClass, GlobalSearchScope.allScope((com.intellij.openapi.project.Project)project));
        if (psiLookupClass == null) {
            return Collections.emptyList();
        }
        PsiMethod[] methods = psiLookupClass.findMethodsByName(entry.myOldMethodName, true);
        if (methods.length > 0) {
            ArrayList<PsiReference> refs = new ArrayList<PsiReference>();
            for (PsiMethod method : methods) {
                RenamePsiElementProcessor processor = RenamePsiElementProcessor.forElement((PsiElement)method);
                refs.addAll(processor.findReferences((PsiElement)methods[0], false));
            }
            return refs;
        }
        return Collections.emptyList();
    }

    static List<MigrateToAppCompatUsageInfo.ChangeCustomViewUsageInfo> findCustomViewsUsages(com.intellij.openapi.project.Project project, Module[] modules) {
        PsiManager manager = PsiManager.getInstance((com.intellij.openapi.project.Project)project);
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        Map<Issue, Map<File, List<ProblemData>>> issues = MigrateToAppCompatUtil.computeCustomViewIssuesMap(project, modules);
        Map<File, List<ProblemData>> fileListMap = issues.get(AppCompatCustomViewDetector.ISSUE);
        if (fileListMap == null) {
            return Collections.emptyList();
        }
        ArrayList result2 = Lists.newArrayList();
        Map<PsiFile, List> psiFileListMap = fileListMap.entrySet().stream().filter(e -> fileSystem.findFileByIoFile((File)e.getKey()) != null).collect(Collectors.toMap(e -> manager.findFile(fileSystem.findFileByIoFile((File)e.getKey())), Map.Entry::getValue));
        for (Map.Entry<PsiFile, List> entry : psiFileListMap.entrySet()) {
            PsiFile psiFile = entry.getKey();
            if (!psiFile.isValid()) continue;
            List problemDataList = entry.getValue();
            for (ProblemData problemData : problemDataList) {
                Integer start = problemData.getTextRange().getStartOffset();
                LintFix fix = problemData.getQuickfixData();
                if (!(fix instanceof LintFix.ReplaceString)) continue;
                LintFix.ReplaceString replaceFix = (LintFix.ReplaceString)fix;
                String suggestedSuperClass = replaceFix.replacement;
                PsiElement element = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile, (int)start, PsiElement.class, (boolean)true);
                if (element == null) continue;
                result2.add(new MigrateToAppCompatUsageInfo.ChangeCustomViewUsageInfo(element, suggestedSuperClass));
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static Map<Issue, Map<File, List<ProblemData>>> computeCustomViewIssuesMap(@NotNull com.intellij.openapi.project.Project project, @NotNull Module[] modules) {
        if (project == null) {
            MigrateToAppCompatUtil.$$$reportNull$$$0(2);
        }
        if (modules == null) {
            MigrateToAppCompatUtil.$$$reportNull$$$0(3);
        }
        HashMap map2 = Maps.newHashMap();
        boolean detectorWasEnabled = AppCompatCustomViewDetector.ISSUE.isEnabledByDefault();
        AppCompatCustomViewDetector.ISSUE.setEnabledByDefault(true);
        AnalysisScope scope = new AnalysisScope(project);
        try {
            HashSet<Issue> issues = new HashSet<Issue>(1);
            issues.add(AppCompatCustomViewDetector.ISSUE);
            LintIdeClient client = LintIdeClient.forBatch(project, map2, scope, issues);
            LintIdeRequest request = new LintIdeRequest(client, project, null, (List)Arrays.asList(modules), false){

                @Override
                public Project getMainProject(Project project) {
                    Project mainProject = super.getMainProject(project);
                    return new Project(mainProject.getClient(), mainProject.getDir(), mainProject.getReferenceDir()){

                        public Boolean dependsOn(@NotNull String artifact) {
                            if (artifact == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if ("com.android.support:appcompat-v7".equals(artifact) || "androidx.appcompat:appcompat".equals(artifact)) {
                                return Boolean.TRUE;
                            }
                            return super.dependsOn(artifact);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/android/refactoring/MigrateToAppCompatUtil$1$1", "dependsOn"));
                        }
                    };
                }
            };
            request.setScope(Scope.JAVA_FILE_SCOPE);
            new LintDriver((IssueRegistry)new LintIdeIssueRegistry(), (LintClient)client, (LintRequest)request).analyze();
        }
        finally {
            AppCompatCustomViewDetector.ISSUE.setEnabledByDefault(detectorWasEnabled);
        }
        HashMap hashMap = map2;
        if (hashMap == null) {
            MigrateToAppCompatUtil.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    static Set<XmlFile> getPsiFilesOfType(com.intellij.openapi.project.Project project, AbstractResourceRepository repository, ResourceType resourceType) {
        Collection itemsOfType = repository.getItemsOfType(resourceType);
        return itemsOfType.stream().map(name -> repository.getResourceItem(resourceType, name)).flatMap(Collection::stream).map(item -> LocalResourceRepository.getItemPsiFile(project, item)).filter(f -> f instanceof XmlFile).map(XmlFile.class::cast).collect(Collectors.toSet());
    }

    public static List<UsageInfo> findUsagesOfXmlElements(com.intellij.openapi.project.Project project, Module[] modules, List<AppCompatMigrationEntry.XmlElementMigration> operations, ResourceType resourceType) {
        if (operations.isEmpty()) {
            return Collections.emptyList();
        }
        final ArrayListMultimap tag2XmlOperation = ArrayListMultimap.create();
        for (AppCompatMigrationEntry.XmlElementMigration operation : operations) {
            for (String tagName : operation.applicableTagNames()) {
                tag2XmlOperation.put((Object)tagName, (Object)operation);
            }
        }
        final ArrayList<UsageInfo> usageInfos = new ArrayList<UsageInfo>();
        for (Module module : modules) {
            LocalResourceRepository projectResources = ResourceRepositoryManager.getProjectResources(module);
            if (projectResources == null) continue;
            Set<XmlFile> xmlFiles = MigrateToAppCompatUtil.getPsiFilesOfType(project, projectResources, resourceType);
            for (XmlFile file : xmlFiles) {
                file.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    public void visitXmlTag(XmlTag tag) {
                        super.visitXmlTag(tag);
                        List operations = tag2XmlOperation.get((Object)tag.getName());
                        if (operations != null) {
                            for (AppCompatMigrationEntry.XmlElementMigration operation : operations) {
                                UsageInfo usage = operation.apply(tag);
                                if (usage == null) continue;
                                usageInfos.add(usage);
                            }
                        }
                    }
                });
            }
        }
        tag2XmlOperation.clear();
        return usageInfos;
    }

    public static void removeUnneededUsages(List<UsageInfo> infos) {
        ArrayListMultimap map2 = ArrayListMultimap.create();
        for (UsageInfo usageInfo : infos) {
            if (!(usageInfo instanceof MigrateToAppCompatUsageInfo.ClassMigrationUsageInfo) || usageInfo.getElement() == null || usageInfo.getElement().getContainingFile() == null) continue;
            map2.put((Object)usageInfo.getElement().getContainingFile(), (Object)((MigrateToAppCompatUsageInfo.ClassMigrationUsageInfo)usageInfo));
        }
        SmartList toRemove = new SmartList();
        for (PsiFile file : map2.keySet()) {
            List usages = map2.get((Object)file);
            boolean excludeUsages = usages.stream().allMatch(u -> {
                String qname;
                return u.getElement() != null && u.getElement().getParent() instanceof PsiImportStatement && (qname = ((PsiImportStatement)u.getElement().getParent()).getQualifiedName()) != null && (qname.equals("android.app.Activity") || qname.equals("android.support.v4.app.FragmentActivity"));
            });
            if (!excludeUsages) continue;
            toRemove.addAll(usages);
        }
        infos.removeAll((Collection<?>)toRemove);
    }

    static boolean isKotlinSimpleNameReference(PsiReference reference2) {
        PluginId kotlinPluginId = PluginId.findId((String[])new String[]{"org.jetbrains.kotlin"});
        IdeaPluginDescriptor kotlinPlugin = (IdeaPluginDescriptor)ObjectUtils.notNull((Object)PluginManager.getPlugin((PluginId)kotlinPluginId));
        ClassLoader pluginClassLoader = kotlinPlugin.getPluginClassLoader();
        try {
            Class<?> simpleNameReferenceClass = Class.forName("org.jetbrains.kotlin.idea.references.KtSimpleNameReference", true, pluginClassLoader);
            return simpleNameReferenceClass.isInstance(reference2);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/refactoring/MigrateToAppCompatUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findRefs";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/refactoring/MigrateToAppCompatUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeCustomViewIssuesMap";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeCustomViewIssuesMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

