/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.builder.model.AaptOptions;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMigration;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.migration.PsiMigrationManager;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.Processor;
import com.intellij.util.text.StringKt;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.WrappingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.converters.AndroidResourceReference;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.converters.StyleItemNameConverter;
import org.jetbrains.android.dom.layout.LayoutElement;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.refactoring.AndroidRefactoringUtil;
import org.jetbrains.android.refactoring.CodeUsageInfo;
import org.jetbrains.android.refactoring.DomValueUsageInfo;
import org.jetbrains.android.refactoring.MigrateToResourceNamespacesProcessor;
import org.jetbrains.android.refactoring.ResourceUsageInfo;
import org.jetbrains.android.refactoring.StyleItemUsageInfo;
import org.jetbrains.android.refactoring.XmlAttributeUsageInfo;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u001b\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0014\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\u0018\u0010 \u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\rH\u0002J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\u0015\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0019H\u0014\u00a2\u0006\u0002\u0010$J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0003H\u0002J\b\u0010)\u001a\u00020\rH\u0014J\u001b\u0010*\u001a\u00020\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0014\u00a2\u0006\u0002\u0010+J\u001c\u0010,\u001a\u00020-2\u0012\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190/H\u0014R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00030\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/android/refactoring/MigrateToResourceNamespacesProcessor;", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "invokingFacet", "Lorg/jetbrains/android/facet/AndroidFacet;", "(Lorg/jetbrains/android/facet/AndroidFacet;)V", "allFacets", "", "kotlin.jvm.PlatformType", "elementFactory", "Lcom/intellij/psi/XmlElementFactory;", "inferredNamespaces", "Lcom/google/common/collect/Table;", "Lcom/android/resources/ResourceType;", "", "addXmlnsDeclaration", "", "tag", "Lcom/intellij/psi/xml/XmlTag;", "prefix", "uri", "choosePrefix", "packageName", "createUsageViewDescriptor", "Lcom/intellij/usageView/UsageViewDescriptor;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/usageView/UsageViewDescriptor;", "findCodeUsages", "", "Lorg/jetbrains/android/refactoring/ResourceUsageInfo;", "findManifestUsages", "findOrCreateNamespacePrefix", "inferredPackage", "findResUsages", "findUsages", "()[Lcom/intellij/usageView/UsageInfo;", "findXmlUsages", "xmlFile", "Lcom/intellij/psi/xml/XmlFile;", "currentFacet", "getCommandName", "performRefactoring", "([Lcom/intellij/usageView/UsageInfo;)V", "preprocessUsages", "", "refUsages", "Lcom/intellij/openapi/util/Ref;", "intellij.android.core"})
public final class MigrateToResourceNamespacesProcessor
extends BaseRefactoringProcessor {
    private final List<AndroidFacet> allFacets;
    private final Table<ResourceType, String, String> inferredNamespaces;
    private final XmlElementFactory elementFactory;
    private final AndroidFacet invokingFacet;

    @NotNull
    protected String getCommandName() {
        return "Migrate to resource namespaces";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected UsageInfo[] findUsages() {
        ProgressIndicator progressIndicator;
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
        ProgressIndicator progressIndicator2 = progressIndicator = progressManager.getProgressIndicator();
        Intrinsics.checkExpressionValueIsNotNull((Object)progressIndicator2, (String)"progressIndicator");
        progressIndicator2.setText("Analyzing XML resource files...");
        List result2 = new ArrayList();
        Collection collection = result2;
        Iterable iterable = this.findResUsages();
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        progressIndicator.setText("Analyzing manifest files...");
        collection = result2;
        iterable = this.findManifestUsages();
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        progressIndicator.setText("Analyzing code files...");
        collection = result2;
        iterable = this.findCodeUsages();
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        progressIndicator.setText("Inferring namespaces...");
        progressIndicator.setText2((String)null);
        List leafRepos = new ArrayList();
        ResourceRepositoryManager.getAppResources(this.invokingFacet).getLeafResourceRepositories(leafRepos);
        double total = result2.size();
        Iterable $receiver$iv = result2;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void resourceUsageInfo;
            int n = index$iv++;
            ResourceUsageInfo resourceUsageInfo2 = (ResourceUsageInfo)((Object)item$iv);
            int index = n;
            ProgressManager.checkCanceled();
            this.inferredNamespaces.row((Object)resourceUsageInfo.getResourceType()).computeIfAbsent(resourceUsageInfo.getName(), (Function)new Function<String, String>((ResourceUsageInfo)resourceUsageInfo, this, leafRepos, progressIndicator, total){
                final /* synthetic */ ResourceUsageInfo $resourceUsageInfo;
                final /* synthetic */ MigrateToResourceNamespacesProcessor this$0;
                final /* synthetic */ List $leafRepos$inlined;
                final /* synthetic */ ProgressIndicator $progressIndicator$inlined;
                final /* synthetic */ double $total$inlined;
                {
                    this.$resourceUsageInfo = resourceUsageInfo;
                    this.this$0 = migrateToResourceNamespacesProcessor;
                    this.$leafRepos$inlined = list;
                    this.$progressIndicator$inlined = progressIndicator;
                    this.$total$inlined = d;
                }

                @Nullable
                public final String apply(String it) {
                    for (AbstractResourceRepository repo : this.$leafRepos$inlined) {
                        if (!repo.hasResourceItem(ResourceNamespace.RES_AUTO, this.$resourceUsageInfo.getResourceType(), this.$resourceUsageInfo.getName())) continue;
                        AbstractResourceRepository abstractResourceRepository = repo;
                        if (abstractResourceRepository == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.android.ide.common.resources.SingleNamespaceResourceRepository");
                        }
                        return ((SingleNamespaceResourceRepository)abstractResourceRepository).getPackageName();
                    }
                    return null;
                }
            });
            progressIndicator.setFraction((double)(index + 1) / total);
        }
        Iterable thisCollection$iv = $receiver$iv = (Collection)result2;
        ResourceUsageInfo[] resourceUsageInfoArray = thisCollection$iv.toArray(new ResourceUsageInfo[0]);
        if (resourceUsageInfoArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return resourceUsageInfoArray;
    }

    private final Collection<ResourceUsageInfo> findResUsages() {
        List result2 = new ArrayList();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (AndroidFacet facet : this.allFacets) {
            ResourceRepositoryManager repositoryManager;
            ResourceRepositoryManager resourceRepositoryManager = repositoryManager = ResourceRepositoryManager.getOrCreateInstance(facet);
            Intrinsics.checkExpressionValueIsNotNull((Object)resourceRepositoryManager, (String)"repositoryManager");
            if (Intrinsics.areEqual((Object)resourceRepositoryManager.getNamespacing(), (Object)AaptOptions.Namespacing.DISABLED) ^ true) continue;
            LocalResourceRepository localResourceRepository = repositoryManager.getModuleResources(true);
            if (localResourceRepository == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)localResourceRepository), (String)"repositoryManager.getModuleResources(true)!!");
            for (VirtualFile resourceDir : localResourceRepository.getResourceDirs()) {
                VfsUtil.processFilesRecursively((VirtualFile)resourceDir, (Processor)((Processor)new Processor<VirtualFile>(this, psiManager, result2, facet){
                    final /* synthetic */ MigrateToResourceNamespacesProcessor this$0;
                    final /* synthetic */ PsiManager $psiManager;
                    final /* synthetic */ List $result;
                    final /* synthetic */ AndroidFacet $facet;

                    public final boolean process(VirtualFile vf) {
                        PsiFile psiFile;
                        VirtualFile virtualFile = vf;
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"vf");
                        if (Intrinsics.areEqual((Object)virtualFile.getFileType(), (Object)StdFileTypes.XML) && (psiFile = this.$psiManager.findFile(vf)) instanceof XmlFile) {
                            Collection collection = this.$result;
                            XmlFile xmlFile = (XmlFile)psiFile;
                            AndroidFacet androidFacet = this.$facet;
                            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)androidFacet), (String)"facet");
                            Iterable iterable = MigrateToResourceNamespacesProcessor.access$findXmlUsages(this.this$0, xmlFile, androidFacet);
                            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                        }
                        return true;
                    }
                    {
                        this.this$0 = migrateToResourceNamespacesProcessor;
                        this.$psiManager = psiManager;
                        this.$result = list;
                        this.$facet = androidFacet;
                    }
                }));
            }
        }
        return result2;
    }

    private final Collection<ResourceUsageInfo> findManifestUsages() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        List result2 = new ArrayList();
        for (AndroidFacet facet : this.allFacets) {
            Collection collection = result2;
            List<IdeaSourceProvider> list = IdeaSourceProvider.getCurrentSourceProviders(facet);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"IdeaSourceProvider.getCu\u2026entSourceProviders(facet)");
            Sequence sequence = SequencesKt.flatMap((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)findManifestUsages.1.INSTANCE), (Function1)((Function1)new Function1<VirtualFile, XmlFile>(psiManager){
                final /* synthetic */ PsiManager $psiManager;

                @Nullable
                public final XmlFile invoke(@NotNull VirtualFile it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    PsiFile psiFile = this.$psiManager.findFile(it);
                    if (!(psiFile instanceof XmlFile)) {
                        psiFile = null;
                    }
                    return (XmlFile)psiFile;
                }
                {
                    this.$psiManager = psiManager;
                    super(1);
                }
            })), (Function1)((Function1)new Function1<XmlFile, Sequence<? extends ResourceUsageInfo>>(this, facet){
                final /* synthetic */ MigrateToResourceNamespacesProcessor this$0;
                final /* synthetic */ AndroidFacet $facet;

                @NotNull
                public final Sequence<ResourceUsageInfo> invoke(@NotNull XmlFile it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    AndroidFacet androidFacet = this.$facet;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)androidFacet), (String)"facet");
                    return CollectionsKt.asSequence((Iterable)MigrateToResourceNamespacesProcessor.access$findXmlUsages(this.this$0, it, androidFacet));
                }
                {
                    this.this$0 = migrateToResourceNamespacesProcessor;
                    this.$facet = androidFacet;
                    super(1);
                }
            }));
            CollectionsKt.addAll((Collection)collection, (Sequence)sequence);
        }
        return result2;
    }

    private final Collection<ResourceUsageInfo> findXmlUsages(XmlFile xmlFile, AndroidFacet currentFacet) {
        ProgressIndicator progressIndicator;
        ProgressManager.checkCanceled();
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
        ProgressIndicator progressIndicator2 = progressIndicator = progressManager.getProgressIndicator();
        Intrinsics.checkExpressionValueIsNotNull((Object)progressIndicator2, (String)"progressIndicator");
        VirtualFile virtualFile = xmlFile.getVirtualFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"xmlFile.virtualFile");
        progressIndicator2.setText2(virtualFile.getPath());
        Set result2 = new LinkedHashSet();
        DomManager domManager = DomManager.getDomManager((Project)this.myProject);
        LocalResourceRepository moduleRepo = ResourceRepositoryManager.getModuleResources(currentFacet);
        Function2<ResourceType, String, Boolean> referenceNeedsRewriting$ = new Function2<ResourceType, String, Boolean>(moduleRepo){
            final /* synthetic */ LocalResourceRepository $moduleRepo;

            public final boolean invoke(@NotNull ResourceType resourceType, @NotNull String name) {
                Intrinsics.checkParameterIsNotNull((Object)resourceType, (String)"resourceType");
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                return !this.$moduleRepo.hasResourceItem(ResourceNamespace.RES_AUTO, resourceType, name);
            }
            {
                this.$moduleRepo = localResourceRepository;
                super(2);
            }
        };
        xmlFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(domManager, result2, referenceNeedsRewriting$){
            final /* synthetic */ DomManager $domManager;
            final /* synthetic */ Set $result;
            final /* synthetic */ findXmlUsages.1 $referenceNeedsRewriting$1;

            public void visitXmlTag(@NotNull XmlTag tag) {
                DomElement domElement;
                Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
                DomElement domElement2 = domElement = this.$domManager.getDomElement(tag);
                if (domElement2 instanceof LayoutElement) {
                    XmlAttribute[] xmlAttributeArray = tag.getAttributes();
                    int n = xmlAttributeArray.length;
                    for (int i = 0; i < n; ++i) {
                        XmlAttribute attribute;
                        XmlAttribute xmlAttribute = attribute = xmlAttributeArray[i];
                        Intrinsics.checkExpressionValueIsNotNull((Object)xmlAttribute, (String)"attribute");
                        if (!Intrinsics.areEqual((Object)xmlAttribute.getNamespace(), (Object)"http://schemas.android.com/apk/res-auto")) continue;
                        Collection collection = this.$result;
                        XmlAttributeUsageInfo xmlAttributeUsageInfo = new XmlAttributeUsageInfo(attribute);
                        collection.add(xmlAttributeUsageInfo);
                    }
                } else if (domElement2 instanceof GenericDomValue) {
                    this.handleGenericDomValue((GenericDomValue)domElement);
                }
                super.visitXmlTag(tag);
            }

            public void visitXmlAttribute(@NotNull XmlAttribute attribute) {
                Intrinsics.checkParameterIsNotNull((Object)attribute, (String)"attribute");
                GenericAttributeValue genericAttributeValue = this.$domManager.getDomElement(attribute);
                if (!(genericAttributeValue instanceof GenericDomValue)) {
                    genericAttributeValue = null;
                }
                GenericDomValue genericDomValue = (GenericDomValue)genericAttributeValue;
                if (genericDomValue == null) {
                    return;
                }
                this.handleGenericDomValue(genericDomValue);
                super.visitXmlAttribute(attribute);
            }

            private final void handleGenericDomValue(GenericDomValue<?> domValue) {
                Converter converter = WrappingConverter.getDeepestConverter((Converter)domValue.getConverter(), domValue);
                XmlElement xmlElement = DomUtil.getValueElement(domValue);
                if (xmlElement == null) {
                    return;
                }
                XmlElement psiElement = xmlElement;
                Converter converter2 = converter;
                if (converter2 instanceof ResourceReferenceConverter) {
                    XmlElement xmlElement2 = psiElement;
                    Intrinsics.checkExpressionValueIsNotNull((Object)xmlElement2, (String)"psiElement");
                    for (PsiReference reference2 : xmlElement2.getReferences()) {
                        String name;
                        ResourceType resourceType;
                        ResourceValue resourceValue2;
                        if (!(reference2 instanceof AndroidResourceReference)) continue;
                        ResourceValue resourceValue3 = resourceValue2 = ((AndroidResourceReference)reference2).getResourceValue();
                        Intrinsics.checkExpressionValueIsNotNull((Object)resourceValue3, (String)"resourceValue");
                        if (resourceValue3.getPackage() != null) continue;
                        String string = resourceValue2.getResourceType();
                        if (string != null) {
                            if (StringsKt.startsWith$default((CharSequence)string, (char)'+', (boolean)false, (int)2, null)) {
                                continue;
                            }
                        }
                        if (StringKt.nullize((String)resourceValue2.getResourceName(), (boolean)true) == null) {
                            continue;
                        }
                        if (resourceValue2.getType() == null) {
                            continue;
                        }
                        ResourceType resourceType2 = resourceType;
                        Intrinsics.checkExpressionValueIsNotNull((Object)resourceType2, (String)"resourceType");
                        if (!this.$referenceNeedsRewriting$1.invoke(resourceType2, name)) continue;
                        Collection collection = this.$result;
                        GenericDomValue<?> genericDomValue = domValue;
                        if (genericDomValue == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.xml.GenericDomValue<org.jetbrains.android.dom.resources.ResourceValue>");
                        }
                        DomValueUsageInfo domValueUsageInfo = new DomValueUsageInfo(reference2, genericDomValue);
                        collection.add(domValueUsageInfo);
                    }
                } else if (converter2 instanceof StyleItemNameConverter) {
                    Object object;
                    String p1;
                    String string = domValue.getStringValue();
                    if (string == null || (string = ResourceUrl.parseAttrReference((String)(p1 = (object = string)))) == null) {
                        return;
                    }
                    String url = string;
                    if (((ResourceUrl)url).namespace == null) {
                        ResourceType resourceType = ((ResourceUrl)url).type;
                        Intrinsics.checkExpressionValueIsNotNull((Object)resourceType, (String)"url.type");
                        String string2 = ((ResourceUrl)url).name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"url.name");
                        if (this.$referenceNeedsRewriting$1.invoke(resourceType, string2)) {
                            object = this.$result;
                            StyleItemUsageInfo styleItemUsageInfo = new StyleItemUsageInfo(domValue, (ResourceUrl)url);
                            object.add(styleItemUsageInfo);
                        }
                    }
                }
            }
            {
                this.$domManager = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
                this.$referenceNeedsRewriting$1 = $captured_local_variable$2;
            }
        });
        progressIndicator.setText2((String)null);
        return result2;
    }

    private final Collection<ResourceUsageInfo> findCodeUsages() {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myProject);
        Set result2 = new LinkedHashSet();
        for (AndroidFacet facet : this.allFacets) {
            PsiClass rClass;
            String packageName;
            LocalResourceRepository moduleRepo = ResourceRepositoryManager.getModuleResources(facet);
            if (AndroidManifestUtils.getPackageName(facet) == null) {
                continue;
            }
            String string = AndroidResourceUtil.packageToRClass(packageName);
            AndroidFacet androidFacet = facet;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)androidFacet), (String)"facet");
            Module module = androidFacet.getModule();
            Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"facet.module");
            if (psiFacade.findClass(string, module.getModuleContentScope()) == null) {
                continue;
            }
            Module module2 = facet.getModule();
            Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"facet.module");
            GlobalSearchScope scope = module2.getModuleScope();
            Iterator iterator = ReferencesSearch.search((PsiElement)((PsiElement)rClass), (SearchScope)((SearchScope)scope)).iterator();
            while (iterator.hasNext()) {
                String name;
                ResourceType resourceType;
                PsiReferenceExpression nameRef;
                PsiReferenceExpression typeRef;
                PsiReferenceExpression classRef;
                PsiReference psiReference;
                PsiReference psiReference2 = psiReference = (PsiReference)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiReference2, (String)"psiReference");
                PsiElement psiElement = psiReference2.getElement();
                if (!(psiElement instanceof PsiReferenceExpression)) {
                    psiElement = null;
                }
                if ((PsiReferenceExpression)psiElement == null) {
                    continue;
                }
                PsiElement psiElement2 = classRef.getParent();
                if (!(psiElement2 instanceof PsiReferenceExpression)) {
                    psiElement2 = null;
                }
                if ((PsiReferenceExpression)psiElement2 == null) {
                    continue;
                }
                PsiElement psiElement3 = typeRef.getParent();
                if (!(psiElement3 instanceof PsiReferenceExpression)) {
                    psiElement3 = null;
                }
                if ((PsiReferenceExpression)psiElement3 == null) {
                    continue;
                }
                if (Intrinsics.areEqual((Object)nameRef.getQualifierExpression(), (Object)typeRef) ^ true || Intrinsics.areEqual((Object)typeRef.getQualifierExpression(), (Object)classRef) ^ true) continue;
                if (nameRef.getReferenceName() == null) {
                    continue;
                }
                String string2 = typeRef.getReferenceName();
                if (string2 == null) {
                    continue;
                }
                if (ResourceType.getEnum((String)string2) == null) {
                    continue;
                }
                if (moduleRepo.hasResourceItem(ResourceNamespace.RES_AUTO, resourceType, name)) continue;
                Collection collection = result2;
                PsiElement psiElement4 = (PsiElement)nameRef;
                String string3 = name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"name");
                CodeUsageInfo codeUsageInfo = new CodeUsageInfo(psiElement4, psiReference, resourceType, string3);
                collection.add(codeUsageInfo);
            }
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        Application application;
        Object inferredPackage;
        ProgressIndicator progressIndicator;
        Intrinsics.checkParameterIsNotNull((Object)usages, (String)"usages");
        PsiMigration psiMigration = PsiMigrationManager.getInstance((Project)this.myProject).startMigration();
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
        ProgressIndicator progressIndicator2 = progressIndicator = progressManager.getProgressIndicator();
        Intrinsics.checkExpressionValueIsNotNull((Object)progressIndicator2, (String)"progressIndicator");
        progressIndicator2.setIndeterminate(false);
        progressIndicator.setText("Rewriting resource references...");
        double totalUsages = ((Object[])usages).length;
        Object[] $receiver$iv = usages;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            String prefix;
            Object[] prefix2;
            void usageInfo;
            int n = index$iv++;
            UsageInfo usageInfo2 = (UsageInfo)item$iv;
            int index = n;
            if (!(usageInfo instanceof ResourceUsageInfo)) {
                String string = "Don't know how to handle " + usageInfo.getClass().getName() + '.';
                throw (Throwable)new IllegalStateException(string.toString());
            }
            if ((String)this.inferredNamespaces.get((Object)((ResourceUsageInfo)usageInfo).getResourceType(), (Object)((ResourceUsageInfo)usageInfo).getName()) == null) {
                continue;
            }
            void var14_17 = usageInfo;
            if (var14_17 instanceof DomValueUsageInfo) {
                ResourceValue oldResourceValue;
                XmlTag tag;
                if ((ResourceValue)((DomValueUsageInfo)usageInfo).getDomValue().getValue() == null) {
                    continue;
                }
                if (((DomValueUsageInfo)usageInfo).getDomValue().getXmlTag() == null) {
                    continue;
                }
                prefix2 = this.findOrCreateNamespacePrefix(tag, (String)inferredPackage);
                ResourceValue resourceValue2 = oldResourceValue;
                Intrinsics.checkExpressionValueIsNotNull((Object)resourceValue2, (String)"oldResourceValue");
                ResourceValue newResourceValue = ResourceValue.referenceTo(resourceValue2.getPrefix(), (String)prefix2, oldResourceValue.getResourceType(), oldResourceValue.getResourceName());
                ((DomValueUsageInfo)usageInfo).getDomValue().setValue((Object)newResourceValue);
            } else if (var14_17 instanceof XmlAttributeUsageInfo) {
                Object object;
                block21: {
                    XmlAttribute element;
                    PsiElement psiElement = ((XmlAttributeUsageInfo)usageInfo).getElement();
                    if (!(psiElement instanceof XmlAttribute)) {
                        psiElement = null;
                    }
                    if ((XmlAttribute)psiElement == null) {
                        continue;
                    }
                    XmlTag xmlTag = element.getParent();
                    Intrinsics.checkExpressionValueIsNotNull((Object)xmlTag, (String)"element.parent");
                    prefix = this.findOrCreateNamespacePrefix(xmlTag, (String)inferredPackage);
                    PsiReference[] psiReferenceArray = element.getReferences();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceArray, (String)"element.references");
                    for (Object object2 : prefix2 = (Object[])psiReferenceArray) {
                        PsiReference it = (PsiReference)object2;
                        if (!(it instanceof SchemaPrefixReference)) continue;
                        object = object2;
                        break block21;
                    }
                    object = null;
                }
                PsiReference psiReference = (PsiReference)object;
                if (psiReference != null) {
                    psiReference.handleElementRename(prefix);
                }
            } else if (var14_17 instanceof StyleItemUsageInfo) {
                XmlTag tag;
                if (((StyleItemUsageInfo)usageInfo).getDomValue().getXmlTag() == null) {
                    continue;
                }
                prefix = this.findOrCreateNamespacePrefix(tag, (String)inferredPackage);
                ResourceUrl newUrl = ResourceUrl.create((String)prefix, (ResourceType)ResourceType.ATTR, (String)((StyleItemUsageInfo)usageInfo).getName());
                GenericDomValue<?> genericDomValue = ((StyleItemUsageInfo)usageInfo).getDomValue();
                ResourceUrl resourceUrl = newUrl;
                Intrinsics.checkExpressionValueIsNotNull((Object)resourceUrl, (String)"newUrl");
                genericDomValue.setStringValue(resourceUrl.getQualifiedName());
            } else if (var14_17 instanceof CodeUsageInfo) {
                ((CodeUsageInfo)usageInfo).getClassReference().bindToElement((PsiElement)AndroidRefactoringUtil.findOrCreateClass(this.myProject, psiMigration, AndroidResourceUtil.packageToRClass(inferredPackage)));
            }
            progressIndicator.setFraction((double)(index + 1) / totalUsages);
        }
        psiMigration.finish();
        progressIndicator.setText("Updating Gradle build files...");
        progressIndicator.setFraction(0.0);
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get(this.myProject);
        double totalFacets = this.allFacets.size();
        Iterable $receiver$iv2 = this.allFacets;
        int index$iv2 = 0;
        for (Object item$iv : $receiver$iv2) {
            GradleBuildModel moduleBuildModel;
            void facet;
            int n = index$iv2++;
            inferredPackage = (AndroidFacet)((Object)item$iv);
            int index = n;
            void v12 = facet;
            Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"facet");
            if (projectBuildModel.getModuleBuildModel(v12.getModule()) == null) {
                continue;
            }
            Object object = moduleBuildModel.android();
            if (object != null && (object = object.aaptOptions()) != null && (object = object.namespaced()) != null) {
                object.setValue(true);
            }
            moduleBuildModel.applyChanges();
            progressIndicator.setFraction((double)(index + 1) / totalFacets);
        }
        Application application2 = application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application2, (String)"application");
        if (!application2.isUnitTestMode()) {
            application.invokeLater(new Runnable(this){
                final /* synthetic */ MigrateToResourceNamespacesProcessor this$0;

                public final void run() {
                    AndroidRefactoringUtil.offerToSync(MigrateToResourceNamespacesProcessor.access$getMyProject$p(this.this$0), this.this$0.getCommandName());
                }
                {
                    this.this$0 = migrateToResourceNamespacesProcessor;
                }
            });
        }
    }

    private final String findOrCreateNamespacePrefix(XmlTag tag, String inferredPackage) {
        String string = tag.getPrefixByNamespace("http://schemas.android.com/apk/res/" + inferredPackage);
        if (string == null) {
            PsiElement $receiver$iv;
            XmlDocument xmlDocument;
            MigrateToResourceNamespacesProcessor migrateToResourceNamespacesProcessor;
            MigrateToResourceNamespacesProcessor $receiver = migrateToResourceNamespacesProcessor = this;
            String newPrefix = $receiver.choosePrefix(inferredPackage);
            String string2 = tag.getNamespaceByPrefix(newPrefix);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"tag.getNamespaceByPrefix(newPrefix)");
            CharSequence charSequence = string2;
            if (charSequence.length() > 0) {
                int i = 2;
                while (true) {
                    String string3 = tag.getNamespaceByPrefix(newPrefix + i);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"tag.getNamespaceByPrefix(newPrefix + i)");
                    CharSequence charSequence2 = string3;
                    if (!(charSequence2.length() > 0)) break;
                    ++i;
                }
                newPrefix = newPrefix + i;
            }
            if ((xmlDocument = (XmlDocument)PsiTreeUtilKt.parentOfType((PsiElement)($receiver$iv = (PsiElement)tag), (KClass[])new KClass[]{Reflection.getOrCreateKotlinClass(XmlDocument.class)})) != null && (xmlDocument = xmlDocument.getRootTag()) != null) {
                CharSequence it;
                CharSequence charSequence3 = it = (charSequence = xmlDocument);
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence3, (String)"it");
                $receiver.addXmlnsDeclaration((XmlTag)charSequence3, newPrefix, "http://schemas.android.com/apk/res/" + inferredPackage);
            }
            string = newPrefix;
        }
        return string;
    }

    private final String choosePrefix(String packageName) {
        return StringsKt.substringAfterLast$default((String)packageName, (char)'.', null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void addXmlnsDeclaration(XmlTag tag, String prefix, String uri) {
        Object v3;
        XmlTag xmlTag;
        PsiElement psiElement;
        block1: {
            void $receiver$iv;
            PsiElement psiElement2 = (PsiElement)this.elementFactory.createAttribute("xmlns:" + prefix, uri, (PsiElement)tag);
            XmlAttribute[] xmlAttributeArray = tag.getAttributes();
            Intrinsics.checkExpressionValueIsNotNull((Object)xmlAttributeArray, (String)"tag.attributes");
            Object[] objectArray = xmlAttributeArray;
            psiElement = psiElement2;
            xmlTag = tag;
            for (void element$iv : $receiver$iv) {
                XmlAttribute it;
                XmlAttribute xmlAttribute = it = (XmlAttribute)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)xmlAttribute, (String)"it");
                if (!(Intrinsics.areEqual((Object)xmlAttribute.getNamespacePrefix(), (Object)"xmlns") ^ true)) continue;
                v3 = element$iv;
                break block1;
            }
            v3 = null;
        }
        Object var13_11 = v3;
        xmlTag.addBefore(psiElement, (PsiElement)var13_11);
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        boolean bl;
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull(refUsages, (String)"refUsages");
        Object object = refUsages.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"refUsages.get()");
        Object[] objectArray2 = objectArray = (Object[])object;
        if (!(objectArray2.length == 0)) {
            bl = true;
        } else {
            Messages.showInfoMessage((Project)this.myProject, (String)"No cross-namespace resource references found", (String)"Migrate to resource namespaces");
            bl = false;
        }
        return bl;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        Intrinsics.checkParameterIsNotNull((Object)usages, (String)"usages");
        return (UsageViewDescriptor)new UsageViewDescriptorAdapter(){

            @NotNull
            public PsiElement[] getElements() {
                Intrinsics.checkExpressionValueIsNotNull((Object)PsiElement.EMPTY_ARRAY, (String)"PsiElement.EMPTY_ARRAY");
                return PsiElement.EMPTY_ARRAY;
            }

            @NotNull
            public String getProcessedElementsHeader() {
                return "Resource references to migrate";
            }
        };
    }

    public MigrateToResourceNamespacesProcessor(@NotNull AndroidFacet invokingFacet) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)invokingFacet), (String)"invokingFacet");
        Module module = invokingFacet.getModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"invokingFacet.module");
        super(module.getProject());
        this.invokingFacet = invokingFacet;
        List<AndroidFacet> list = AndroidUtils.getAllAndroidDependencies(this.invokingFacet.getModule(), true);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"AndroidUtils.getAllAndro\u2026vokingFacet.module, true)");
        this.allFacets = CollectionsKt.plus((Collection)list, (Object)((Object)this.invokingFacet));
        Table table2 = Tables.newCustomTable((Map)Maps.newEnumMap(ResourceType.class), (Supplier)inferredNamespaces.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)table2, (String)"Tables.newCustomTable(Ma\u2026apOf<String, String>() })");
        this.inferredNamespaces = table2;
        this.elementFactory = XmlElementFactory.getInstance((Project)this.myProject);
    }

    @NotNull
    public static final /* synthetic */ Collection access$findXmlUsages(MigrateToResourceNamespacesProcessor $this, @NotNull XmlFile xmlFile, @NotNull AndroidFacet currentFacet) {
        return $this.findXmlUsages(xmlFile, currentFacet);
    }

    @NotNull
    public static final /* synthetic */ Project access$getMyProject$p(MigrateToResourceNamespacesProcessor $this) {
        return $this.myProject;
    }
}

