/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.collect.Multimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeDefinitionsImpl;
import org.jetbrains.android.dom.resources.Attr;
import org.jetbrains.android.dom.resources.DeclareStyleable;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.SystemResourceManager;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalResourceManager
extends ResourceManager {
    private AttributeDefinitions myAttrDefs;
    private final AndroidFacet myFacet;

    @Nullable
    public static LocalResourceManager getInstance(@NotNull Module module) {
        AndroidFacet facet;
        if (module == null) {
            LocalResourceManager.$$$reportNull$$$0(0);
        }
        return (facet = AndroidFacet.getInstance(module)) != null ? ModuleResourceManagers.getInstance(facet).getLocalResourceManager() : null;
    }

    @Nullable
    public static LocalResourceManager getInstance(@NotNull PsiElement element) {
        AndroidFacet facet;
        if (element == null) {
            LocalResourceManager.$$$reportNull$$$0(1);
        }
        return (facet = AndroidFacet.getInstance(element)) != null ? ModuleResourceManagers.getInstance(facet).getLocalResourceManager() : null;
    }

    public LocalResourceManager(@NotNull AndroidFacet facet) {
        if (facet == null) {
            LocalResourceManager.$$$reportNull$$$0(2);
        }
        super(facet.getModule().getProject());
        this.myFacet = facet;
    }

    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    @Override
    @NotNull
    protected ResourceNamespace getResourceNamespace() {
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getOrCreateInstance(this.myFacet);
        ResourceNamespace resourceNamespace = repositoryManager.getNamespace();
        if (resourceNamespace == null) {
            LocalResourceManager.$$$reportNull$$$0(3);
        }
        return resourceNamespace;
    }

    @Override
    @NotNull
    public AbstractResourceRepository getResourceRepository() {
        LocalResourceRepository localResourceRepository = ResourceRepositoryManager.getAppResources(this.myFacet);
        if (localResourceRepository == null) {
            LocalResourceManager.$$$reportNull$$$0(4);
        }
        return localResourceRepository;
    }

    @Override
    public boolean isResourceDir(@NotNull VirtualFile dir) {
        if (dir == null) {
            LocalResourceManager.$$$reportNull$$$0(5);
        }
        for (VirtualFile resDir : this.getResourceDirs()) {
            if (!dir.equals(resDir)) continue;
            return true;
        }
        for (VirtualFile dir1 : AndroidRootUtil.getResourceOverlayDirs(this.myFacet)) {
            if (!dir.equals(dir1)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<VirtualFile> getResourceDirs() {
        List<VirtualFile> list = ResourceFolderManager.getInstance(this.myFacet).getFolders();
        if (list == null) {
            LocalResourceManager.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    @NotNull
    public Multimap<String, VirtualFile> getAllResourceDirs() {
        Multimap<String, VirtualFile> multimap = ResourceRepositoryManager.getOrCreateInstance(this.myFacet).getAllResourceDirs();
        if (multimap == null) {
            LocalResourceManager.$$$reportNull$$$0(7);
        }
        return multimap;
    }

    @Override
    @NotNull
    public AttributeDefinitions getAttributeDefinitions() {
        if (this.myAttrDefs == null) {
            SystemResourceManager systemResourceManager = ModuleResourceManagers.getInstance(this.myFacet).getSystemResourceManager();
            AttributeDefinitions systemAttributeDefinitions = systemResourceManager == null ? null : ((ResourceManager)systemResourceManager).getAttributeDefinitions();
            ApplicationManager.getApplication().runReadAction(() -> {
                this.myAttrDefs = new AttributeDefinitionsImpl(systemAttributeDefinitions, this.findValueResourcesByLibraryName());
            });
        }
        AttributeDefinitions attributeDefinitions = this.myAttrDefs;
        if (attributeDefinitions == null) {
            LocalResourceManager.$$$reportNull$$$0(8);
        }
        return attributeDefinitions;
    }

    public void invalidateAttributeDefinitions() {
        this.myAttrDefs = null;
    }

    @NotNull
    public List<Attr> findAttrs(@NotNull String name) {
        if (name == null) {
            LocalResourceManager.$$$reportNull$$$0(9);
        }
        ArrayList<Attr> list = new ArrayList<Attr>();
        for (Pair<Resources, VirtualFile> pair : this.getResourceElements()) {
            Resources res = (Resources)pair.getFirst();
            for (Attr attr : res.getAttrs()) {
                if (!name.equals(attr.getName().getValue())) continue;
                list.add(attr);
            }
            for (DeclareStyleable styleable : res.getDeclareStyleables()) {
                for (Attr attr : styleable.getAttrs()) {
                    if (!name.equals(attr.getName().getValue())) continue;
                    list.add(attr);
                }
            }
        }
        ArrayList<Attr> arrayList = list;
        if (arrayList == null) {
            LocalResourceManager.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    public List<DeclareStyleable> findStyleables(@NotNull String name) {
        if (name == null) {
            LocalResourceManager.$$$reportNull$$$0(11);
        }
        ArrayList<DeclareStyleable> list = new ArrayList<DeclareStyleable>();
        for (Pair<Resources, VirtualFile> pair : this.getResourceElements()) {
            Resources res = (Resources)pair.getFirst();
            for (DeclareStyleable styleable : res.getDeclareStyleables()) {
                if (!name.equals(styleable.getName().getValue())) continue;
                list.add(styleable);
            }
        }
        return list;
    }

    @NotNull
    private List<Pair<Resources, VirtualFile>> getResourceElements() {
        ArrayList<Pair<Resources, VirtualFile>> result2 = new ArrayList<Pair<Resources, VirtualFile>>();
        for (VirtualFile file : this.getAllValueResourceFiles()) {
            Resources element = AndroidUtils.loadDomElement(this.myProject, file, Resources.class);
            if (element == null) continue;
            result2.add((Pair<Resources, VirtualFile>)Pair.create((Object)element, (Object)file));
        }
        ArrayList<Pair<Resources, VirtualFile>> arrayList = result2;
        if (arrayList == null) {
            LocalResourceManager.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    private Set<VirtualFile> getAllValueResourceFiles() {
        HashSet files2 = new HashSet();
        for (VirtualFile valueResourceDir : this.getResourceSubdirs(ResourceFolderType.VALUES)) {
            for (VirtualFile valueResourceFile : valueResourceDir.getChildren()) {
                if (valueResourceFile.isDirectory() || !valueResourceFile.getFileType().equals(StdFileTypes.XML)) continue;
                files2.add(valueResourceFile);
            }
        }
        HashSet hashSet = files2;
        if (hashSet == null) {
            LocalResourceManager.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    @NotNull
    private List<VirtualFile> getResourceSubdirs(@NotNull ResourceFolderType resourceType) {
        if (resourceType == null) {
            LocalResourceManager.$$$reportNull$$$0(14);
        }
        List<VirtualFile> list = AndroidResourceUtil.getResourceSubdirs(resourceType, this.getAllResourceDirs().values());
        if (list == null) {
            LocalResourceManager.$$$reportNull$$$0(15);
        }
        return list;
    }

    public List<Attr> findStyleableAttributesByFieldName(@NotNull String fieldName) {
        int prev;
        if (fieldName == null) {
            LocalResourceManager.$$$reportNull$$$0(16);
        }
        int index = fieldName.lastIndexOf(95);
        while (index != -1 && (prev = fieldName.lastIndexOf(95, index - 1)) != -1 && !Character.isUpperCase(fieldName.charAt(prev + 1))) {
            index = prev;
        }
        if (index == -1) {
            return Collections.emptyList();
        }
        String styleableName = fieldName.substring(0, index);
        String attrName = fieldName.substring(index + 1);
        ArrayList<Attr> list = new ArrayList<Attr>();
        for (Pair<Resources, VirtualFile> pair : this.getResourceElements()) {
            Resources res = (Resources)pair.getFirst();
            for (DeclareStyleable styleable : res.getDeclareStyleables()) {
                if (!styleableName.equals(styleable.getName().getValue())) continue;
                for (Attr attr : styleable.getAttrs()) {
                    if (!attrName.equals(attr.getName().getValue())) continue;
                    list.add(attr);
                }
            }
        }
        return list;
    }

    @NotNull
    public List<PsiElement> findResourcesByField(@NotNull PsiField field2) {
        String type;
        if (field2 == null) {
            LocalResourceManager.$$$reportNull$$$0(17);
        }
        if ((type = AndroidResourceUtil.getResourceClassName(field2)) == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                LocalResourceManager.$$$reportNull$$$0(18);
            }
            return list;
        }
        String fieldName = field2.getName();
        if (fieldName == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                LocalResourceManager.$$$reportNull$$$0(19);
            }
            return list;
        }
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance((PsiElement)field2);
        if (repositoryManager == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                LocalResourceManager.$$$reportNull$$$0(20);
            }
            return list;
        }
        ResourceNamespace namespace = repositoryManager.getNamespace();
        List<PsiElement> list = this.findResourcesByFieldName(namespace, type, fieldName);
        if (list == null) {
            LocalResourceManager.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    public List<PsiElement> findResourcesByFieldName(@NotNull ResourceNamespace namespace, @NotNull String resClassName, @NotNull String fieldName) {
        ResourceFolderType folderType;
        if (namespace == null) {
            LocalResourceManager.$$$reportNull$$$0(22);
        }
        if (resClassName == null) {
            LocalResourceManager.$$$reportNull$$$0(23);
        }
        if (fieldName == null) {
            LocalResourceManager.$$$reportNull$$$0(24);
        }
        ArrayList<PsiElement> targets = new ArrayList<PsiElement>();
        if (resClassName.equals(ResourceType.ID.getName())) {
            targets.addAll(this.findIdDeclarations(namespace, fieldName));
        }
        if ((folderType = ResourceFolderType.getTypeByName((String)resClassName)) != null) {
            targets.addAll(this.findResourceFiles(folderType, fieldName, false, true));
        }
        for (ResourceElement element : this.findValueResources(namespace, resClassName, fieldName, false)) {
            targets.add((PsiElement)element.getName().getXmlAttributeValue());
        }
        if (resClassName.equals(ResourceType.ATTR.getName())) {
            for (Attr attr : this.findAttrs(fieldName)) {
                targets.add((PsiElement)attr.getName().getXmlAttributeValue());
            }
        } else if (resClassName.equals(ResourceType.STYLEABLE.getName())) {
            for (DeclareStyleable styleable : this.findStyleables(fieldName)) {
                targets.add((PsiElement)styleable.getName().getXmlAttributeValue());
            }
            for (Attr attr : this.findStyleableAttributesByFieldName(fieldName)) {
                targets.add((PsiElement)attr.getName().getXmlAttributeValue());
            }
        }
        ArrayList<PsiElement> arrayList = targets;
        if (arrayList == null) {
            LocalResourceManager.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @Deprecated
    @NotNull
    public List<PsiElement> findResourcesByFieldName(@NotNull String resClassName, @NotNull String fieldName) {
        if (resClassName == null) {
            LocalResourceManager.$$$reportNull$$$0(26);
        }
        if (fieldName == null) {
            LocalResourceManager.$$$reportNull$$$0(27);
        }
        List<PsiElement> list = this.findResourcesByFieldName(this.getResourceNamespace(), resClassName, fieldName);
        if (list == null) {
            LocalResourceManager.$$$reportNull$$$0(28);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/resourceManagers/LocalResourceManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 16: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/resourceManagers/LocalResourceManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceNamespace";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceRepository";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceDirs";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllResourceDirs";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDefinitions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findAttrs";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceElements";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllValueResourceFiles";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceSubdirs";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findResourcesByField";
                break;
            }
            case 25: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "findResourcesByFieldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 28: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isResourceDir";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findAttrs";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findStyleables";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getResourceSubdirs";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findStyleableAttributesByFieldName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findResourcesByField";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findResourcesByFieldName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

