/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.res.ResourceHelper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.wrappers.FileResourceElementWrapper;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.android.resourceManagers.ValueResourceInfoImpl;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceManager {
    protected final Project myProject;

    protected ResourceManager(@NotNull Project project) {
        if (project == null) {
            ResourceManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @Deprecated
    @NotNull
    protected abstract ResourceNamespace getResourceNamespace();

    @NotNull
    public abstract AbstractResourceRepository getResourceRepository();

    @NotNull
    public abstract Multimap<String, VirtualFile> getAllResourceDirs();

    @NotNull
    public abstract List<VirtualFile> getResourceDirs();

    public abstract boolean isResourceDir(@NotNull VirtualFile var1);

    @Nullable
    public abstract AttributeDefinitions getAttributeDefinitions();

    private void processFileResources(@NotNull Multimap<String, VirtualFile> resDirs, @NotNull ResourceFolderType folderType, @NotNull FileResourceProcessor processor) {
        if (resDirs == null) {
            ResourceManager.$$$reportNull$$$0(1);
        }
        if (folderType == null) {
            ResourceManager.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            ResourceManager.$$$reportNull$$$0(3);
        }
        for (Map.Entry entry : resDirs.asMap().entrySet()) {
            for (VirtualFile resSubdir : AndroidResourceUtil.getResourceSubdirs(folderType, (Collection)entry.getValue())) {
                ResourceFolderType resType = ResourceFolderType.getFolderType((String)resSubdir.getName());
                if (resType == null) continue;
                assert (folderType.equals((Object)resType));
                String resTypeName = resType.getName();
                for (VirtualFile resFile : resSubdir.getChildren()) {
                    String resName = AndroidCommonUtils.getResourceName((String)resTypeName, (String)resFile.getName());
                    if (resFile.isDirectory() || !this.isResourcePublic(resTypeName, resName)) continue;
                    processor.process(resFile, resName, (String)entry.getKey());
                }
            }
        }
    }

    @NotNull
    private Multimap<String, VirtualFile> getResourceDirsByLibraryName(boolean withDependencies) {
        Multimap<String, VirtualFile> resDirs;
        if (withDependencies) {
            resDirs = this.getAllResourceDirs();
        } else {
            resDirs = HashMultimap.create();
            resDirs.putAll(null, this.getResourceDirs());
        }
        Multimap<String, VirtualFile> multimap = resDirs;
        if (multimap == null) {
            ResourceManager.$$$reportNull$$$0(4);
        }
        return multimap;
    }

    public boolean isResourcePublic(@NotNull String type, @NotNull String name) {
        if (type == null) {
            ResourceManager.$$$reportNull$$$0(5);
        }
        if (name == null) {
            ResourceManager.$$$reportNull$$$0(6);
        }
        return true;
    }

    @NotNull
    public List<PsiFile> findResourceFiles(@NotNull ResourceFolderType resourceType) {
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(7);
        }
        List<PsiFile> list = this.findResourceFiles(resourceType, null, true, true);
        if (list == null) {
            ResourceManager.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public List<PsiFile> findResourceFiles(@NotNull ResourceFolderType resourceFolderType, @Nullable String resName1, boolean distinguishDelimitersInName, boolean withDependencies) {
        if (resourceFolderType == null) {
            ResourceManager.$$$reportNull$$$0(9);
        }
        ArrayList<PsiFile> result2 = new ArrayList<PsiFile>();
        this.processFileResources(this.getResourceDirsByLibraryName(withDependencies), resourceFolderType, (resFile, resName, libraryName) -> {
            PsiFile file;
            if ((resName1 == null || AndroidUtils.equal(resName1, resName, distinguishDelimitersInName)) && (file = AndroidPsiUtils.getPsiFileSafely(this.myProject, resFile)) != null) {
                result2.add(file);
            }
        });
        ArrayList<PsiFile> arrayList = result2;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    protected final Multimap<String, XmlFile> findValueResourcesByLibraryName() {
        HashMultimap result2 = HashMultimap.create();
        this.processFileResources(this.getAllResourceDirs(), ResourceFolderType.VALUES, (arg_0, arg_1, arg_2) -> this.lambda$findValueResourcesByLibraryName$1((Multimap)result2, arg_0, arg_1, arg_2));
        HashMultimap hashMultimap = result2;
        if (hashMultimap == null) {
            ResourceManager.$$$reportNull$$$0(11);
        }
        return hashMultimap;
    }

    @Nullable
    public String getValueResourceType(@NotNull XmlTag tag) {
        ResourceFolderType fileResType;
        if (tag == null) {
            ResourceManager.$$$reportNull$$$0(12);
        }
        if (ResourceFolderType.VALUES == (fileResType = this.getFileResourceFolderType(tag.getContainingFile()))) {
            return tag.getName();
        }
        return null;
    }

    @Nullable
    public ResourceFolderType getFileResourceFolderType(@NotNull PsiFile file) {
        if (file == null) {
            ResourceManager.$$$reportNull$$$0(13);
        }
        return (ResourceFolderType)ApplicationManager.getApplication().runReadAction(() -> {
            PsiDirectory dir;
            if (file == null) {
                ResourceManager.$$$reportNull$$$0(60);
            }
            if ((dir = file.getContainingDirectory()) == null) {
                return null;
            }
            PsiDirectory possibleResDir = dir.getParentDirectory();
            if (possibleResDir == null || !this.isResourceDir(possibleResDir.getVirtualFile())) {
                return null;
            }
            return ResourceFolderType.getFolderType((String)dir.getName());
        });
    }

    @Nullable
    public String getFileResourceType(@NotNull PsiFile file) {
        ResourceFolderType folderType;
        if (file == null) {
            ResourceManager.$$$reportNull$$$0(14);
        }
        return (folderType = this.getFileResourceFolderType(file)) == null ? null : folderType.getName();
    }

    @NotNull
    private Collection<AbstractResourceRepository> getLeafResourceRepositories() {
        ArrayList<AbstractResourceRepository> result2 = new ArrayList<AbstractResourceRepository>();
        this.getResourceRepository().getLeafResourceRepositories(result2);
        ArrayList<AbstractResourceRepository> arrayList = result2;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    public List<XmlAttributeValue> findIdDeclarations(@NotNull ResourceNamespace namespace, @NotNull String id) {
        if (namespace == null) {
            ResourceManager.$$$reportNull$$$0(16);
        }
        if (id == null) {
            ResourceManager.$$$reportNull$$$0(17);
        }
        if (!this.isResourcePublic(ResourceType.ID.getName(), id)) {
            List<XmlAttributeValue> list = Collections.emptyList();
            if (list == null) {
                ResourceManager.$$$reportNull$$$0(18);
            }
            return list;
        }
        Set<VirtualFile> files2 = this.getFilesDeclaringId(namespace, id);
        List<XmlAttributeValue> list = this.findIdUsagesFromFiles(files2, (Predicate<XmlAttributeValue>)((Predicate)attributeValue -> {
            if (id == null) {
                ResourceManager.$$$reportNull$$$0(59);
            }
            if (AndroidResourceUtil.isIdDeclaration(attributeValue)) {
                String idInAttr = AndroidResourceUtil.getResourceNameByReferenceText(attributeValue.getValue());
                return id.equals(idInAttr);
            }
            return false;
        }));
        if (list == null) {
            ResourceManager.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    public List<XmlAttributeValue> findConstraintReferencedIds(@NotNull ResourceNamespace namespace, @NotNull String id) {
        if (namespace == null) {
            ResourceManager.$$$reportNull$$$0(20);
        }
        if (id == null) {
            ResourceManager.$$$reportNull$$$0(21);
        }
        if (!this.isResourcePublic(ResourceType.ID.getName(), id)) {
            List<XmlAttributeValue> list = Collections.emptyList();
            if (list == null) {
                ResourceManager.$$$reportNull$$$0(22);
            }
            return list;
        }
        Set<VirtualFile> files2 = this.getFilesDeclaringId(namespace, id);
        List<XmlAttributeValue> list = this.findIdUsagesFromFiles(files2, (Predicate<XmlAttributeValue>)((Predicate)attributeValue -> {
            String ids;
            if (id == null) {
                ResourceManager.$$$reportNull$$$0(57);
            }
            if (AndroidResourceUtil.isConstraintReferencedIds(attributeValue) && (ids = attributeValue.getValue()) != null) {
                return Arrays.stream(ids.split(",")).anyMatch(s -> {
                    if (id == null) {
                        ResourceManager.$$$reportNull$$$0(58);
                    }
                    return s.equals(id);
                });
            }
            return false;
        }));
        if (list == null) {
            ResourceManager.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    private Set<VirtualFile> getFilesDeclaringId(@NotNull ResourceNamespace namespace, @NotNull String id) {
        if (namespace == null) {
            ResourceManager.$$$reportNull$$$0(24);
        }
        if (id == null) {
            ResourceManager.$$$reportNull$$$0(25);
        }
        HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
        for (AbstractResourceRepository repository : this.getLeafResourceRepositories()) {
            List items2 = repository.getResourceItems(namespace, ResourceType.ID, id);
            for (ResourceItem item : items2) {
                VirtualFile file = ResourceHelper.getSourceAsVirtualFile(item);
                if (file == null) continue;
                files2.add(file);
            }
        }
        HashSet<VirtualFile> hashSet = files2;
        if (hashSet == null) {
            ResourceManager.$$$reportNull$$$0(26);
        }
        return hashSet;
    }

    private List<XmlAttributeValue> findIdUsagesFromFiles(@NotNull Set<VirtualFile> fileSet, final @NotNull Predicate<XmlAttributeValue> condition) {
        if (fileSet == null) {
            ResourceManager.$$$reportNull$$$0(27);
        }
        if (condition == null) {
            ResourceManager.$$$reportNull$$$0(28);
        }
        final ArrayList<XmlAttributeValue> usages = new ArrayList<XmlAttributeValue>();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (VirtualFile file : fileSet) {
            PsiFile psiFile;
            if (!fileSet.contains(file) || !((psiFile = psiManager.findFile(file)) instanceof XmlFile)) continue;
            psiFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                public void visitXmlAttributeValue(XmlAttributeValue attributeValue) {
                    if (condition.apply((Object)attributeValue)) {
                        usages.add(attributeValue);
                    }
                }
            });
        }
        return usages;
    }

    public List<ResourceElement> findValueResources(@NotNull ResourceNamespace namespace, @NotNull String resType, @NotNull String resName) {
        if (namespace == null) {
            ResourceManager.$$$reportNull$$$0(29);
        }
        if (resType == null) {
            ResourceManager.$$$reportNull$$$0(30);
        }
        if (resName == null) {
            ResourceManager.$$$reportNull$$$0(31);
        }
        return this.findValueResources(namespace, resType, resName, true);
    }

    @NotNull
    public List<ResourceElement> findValueResources(@NotNull ResourceNamespace namespace, @NotNull String resourceType, @NotNull String resourceName, boolean distinguishDelimitersInName) {
        if (namespace == null) {
            ResourceManager.$$$reportNull$$$0(32);
        }
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(33);
        }
        if (resourceName == null) {
            ResourceManager.$$$reportNull$$$0(34);
        }
        List<ValueResourceInfoImpl> resources = this.findValueResourceInfos(namespace, resourceType, resourceName, distinguishDelimitersInName, false);
        ArrayList<ResourceElement> result2 = new ArrayList<ResourceElement>();
        for (ValueResourceInfoImpl resource : resources) {
            ResourceElement domElement = resource.computeDomElement();
            if (domElement == null) continue;
            result2.add(domElement);
        }
        ArrayList<ResourceElement> arrayList = result2;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(35);
        }
        return arrayList;
    }

    @Deprecated
    public void collectLazyResourceElements(@NotNull String resType, @NotNull String resName, boolean withAttrs, @NotNull PsiElement context, @NotNull Collection<PsiElement> elements) {
        if (resType == null) {
            ResourceManager.$$$reportNull$$$0(36);
        }
        if (resName == null) {
            ResourceManager.$$$reportNull$$$0(37);
        }
        if (context == null) {
            ResourceManager.$$$reportNull$$$0(38);
        }
        if (elements == null) {
            ResourceManager.$$$reportNull$$$0(39);
        }
        this.collectLazyResourceElements(this.getResourceNamespace(), resType, resName, withAttrs, context, elements);
    }

    public void collectLazyResourceElements(@NotNull ResourceNamespace namespace, @NotNull String resType, @NotNull String resName, boolean withAttrs, @NotNull PsiElement context, @NotNull Collection<PsiElement> elements) {
        ResourceFolderType folderType;
        if (namespace == null) {
            ResourceManager.$$$reportNull$$$0(40);
        }
        if (resType == null) {
            ResourceManager.$$$reportNull$$$0(41);
        }
        if (resName == null) {
            ResourceManager.$$$reportNull$$$0(42);
        }
        if (context == null) {
            ResourceManager.$$$reportNull$$$0(43);
        }
        if (elements == null) {
            ResourceManager.$$$reportNull$$$0(44);
        }
        List<ValueResourceInfoImpl> valueResources = this.findValueResourceInfos(namespace, resType, resName, false, withAttrs);
        for (ValueResourceInfo valueResourceInfo : valueResources) {
            elements.add((PsiElement)new LazyValueResourceElementWrapper(valueResourceInfo, context));
        }
        if (resType.equals("id")) {
            elements.addAll(this.findIdDeclarations(namespace, resName));
        }
        if (elements.isEmpty() && (folderType = ResourceFolderType.getTypeByName((String)resType)) != null) {
            for (PsiFile file : this.findResourceFiles(folderType, resName, false, true)) {
                elements.add(new FileResourceElementWrapper(file));
            }
        }
    }

    @NotNull
    public List<ValueResourceInfoImpl> findValueResourceInfos(@NotNull ResourceNamespace namespace, @NotNull String resourceType, @NotNull String resourceName, boolean distinguishDelimitersInName, boolean searchAttrs) {
        ResourceType type;
        if (namespace == null) {
            ResourceManager.$$$reportNull$$$0(45);
        }
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(46);
        }
        if (resourceName == null) {
            ResourceManager.$$$reportNull$$$0(47);
        }
        ResourceType resourceType2 = type = resourceType.startsWith("+") ? ResourceType.ID : ResourceType.getEnum((String)resourceType);
        if (type == null) {
            List<ValueResourceInfoImpl> list = Collections.emptyList();
            if (list == null) {
                ResourceManager.$$$reportNull$$$0(48);
            }
            return list;
        }
        List<ValueResourceInfoImpl> list = this.findValueResourceInfos(namespace, type, resourceName, distinguishDelimitersInName, searchAttrs);
        if (list == null) {
            ResourceManager.$$$reportNull$$$0(49);
        }
        return list;
    }

    @NotNull
    public List<ValueResourceInfoImpl> findValueResourceInfos(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType, @NotNull String resourceName, boolean distinguishDelimitersInName, boolean searchAttrs) {
        if (namespace == null) {
            ResourceManager.$$$reportNull$$$0(50);
        }
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(51);
        }
        if (resourceName == null) {
            ResourceManager.$$$reportNull$$$0(52);
        }
        if (!(AndroidResourceUtil.VALUE_RESOURCE_TYPES.contains(resourceType) || resourceType == ResourceType.ATTR && searchAttrs)) {
            List<ValueResourceInfoImpl> list = Collections.emptyList();
            if (list == null) {
                ResourceManager.$$$reportNull$$$0(53);
            }
            return list;
        }
        ArrayList<ValueResourceInfoImpl> result2 = new ArrayList<ValueResourceInfoImpl>();
        for (AbstractResourceRepository repository : this.getLeafResourceRepositories()) {
            List items2 = distinguishDelimitersInName ? repository.getResourceItems(namespace, resourceType, resourceName) : repository.getResourceItems(namespace, resourceType, item -> {
                if (resourceName == null) {
                    ResourceManager.$$$reportNull$$$0(56);
                }
                return AndroidUtils.equal(resourceName, item.getName(), false);
            });
            for (ResourceItem item2 : items2) {
                VirtualFile file = ResourceHelper.getSourceAsVirtualFile(item2);
                if (file == null || !ResourceManager.isValueResourceFile(file)) continue;
                result2.add(new ValueResourceInfoImpl(item2, file, this.myProject));
            }
        }
        ArrayList<ValueResourceInfoImpl> arrayList = result2;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(54);
        }
        return arrayList;
    }

    private static boolean isValueResourceFile(@NotNull VirtualFile file) {
        if (file == null) {
            ResourceManager.$$$reportNull$$$0(55);
        }
        return ResourceFolderType.getFolderType((String)file.getParent().getName()) == ResourceFolderType.VALUES;
    }

    private /* synthetic */ void lambda$findValueResourcesByLibraryName$1(Multimap result2, VirtualFile resFile, String resName, String libraryName) {
        PsiFile file = AndroidPsiUtils.getPsiFileSafely(this.myProject, resFile);
        if (file instanceof XmlFile) {
            result2.put((Object)libraryName, (Object)((XmlFile)file));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 26: 
            case 35: 
            case 48: 
            case 49: 
            case 53: 
            case 54: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 26: 
            case 35: 
            case 48: 
            case 49: 
            case 53: 
            case 54: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resDirs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 26: 
            case 35: 
            case 48: 
            case 49: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/resourceManagers/ResourceManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: 
            case 33: 
            case 46: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceFolderType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 13: 
            case 14: 
            case 55: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: 
            case 20: 
            case 24: 
            case 29: 
            case 32: 
            case 40: 
            case 45: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 17: 
            case 21: 
            case 25: 
            case 57: 
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSet";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 30: 
            case 36: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resType";
                break;
            }
            case 31: 
            case 37: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resName";
                break;
            }
            case 34: 
            case 47: 
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 38: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 39: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/resourceManagers/ResourceManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceDirsByLibraryName";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findResourceFiles";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findValueResourcesByLibraryName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeafResourceRepositories";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findIdDeclarations";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findConstraintReferencedIds";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesDeclaringId";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "findValueResources";
                break;
            }
            case 48: 
            case 49: 
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "findValueResourceInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processFileResources";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 26: 
            case 35: 
            case 48: 
            case 49: 
            case 53: 
            case 54: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isResourcePublic";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findResourceFiles";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getValueResourceType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFileResourceFolderType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFileResourceType";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findIdDeclarations";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findConstraintReferencedIds";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getFilesDeclaringId";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findIdUsagesFromFiles";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findValueResources";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "collectLazyResourceElements";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "findValueResourceInfos";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isValueResourceFile";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findValueResourceInfos$6";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findConstraintReferencedIds$5";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$4";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findIdDeclarations$3";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFileResourceFolderType$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 26: 
            case 35: 
            case 48: 
            case 49: 
            case 53: 
            case 54: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface FileResourceProcessor {
        public void process(@NotNull VirtualFile var1, @NotNull String var2, @Nullable String var3);
    }
}

