/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.LocalResourceRepository;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import org.jetbrains.android.dom.resources.Item;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ValueResourceInfoImpl
implements ValueResourceInfo {
    private final ResourceItem myResource;
    private final VirtualFile myFile;
    private final Project myProject;

    ValueResourceInfoImpl(@NotNull ResourceItem resourceItem, @NotNull VirtualFile file, @NotNull Project project) {
        if (resourceItem == null) {
            ValueResourceInfoImpl.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ValueResourceInfoImpl.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ValueResourceInfoImpl.$$$reportNull$$$0(2);
        }
        this.myResource = resourceItem;
        this.myFile = file;
        this.myProject = project;
    }

    @Override
    @NotNull
    public VirtualFile getContainingFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            ValueResourceInfoImpl.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myResource.getName();
        if (string == null) {
            ValueResourceInfoImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public ResourceType getType() {
        ResourceType resourceType = this.myResource.getType();
        if (resourceType == null) {
            ValueResourceInfoImpl.$$$reportNull$$$0(5);
        }
        return resourceType;
    }

    @Override
    public XmlAttributeValue computeXmlElement() {
        ResourceElement resDomElement = this.computeDomElement();
        return resDomElement != null ? resDomElement.getName().getXmlAttributeValue() : null;
    }

    @Nullable
    public ResourceElement computeDomElement() {
        String resType;
        PsiFile file = PsiManager.getInstance((Project)this.myProject).findFile(this.myFile);
        if (!(file instanceof XmlFile)) {
            return null;
        }
        XmlTag tag = LocalResourceRepository.getItemTag(this.myProject, this.myResource);
        if (tag == null) {
            return null;
        }
        DomElement domElement = DomManager.getDomManager((Project)this.myProject).getDomElement(tag);
        if (!(domElement instanceof ResourceElement)) {
            return null;
        }
        String string = resType = domElement instanceof Item ? ((Item)domElement).getType().getStringValue() : AndroidCommonUtils.getResourceTypeByTagName((String)tag.getName());
        if (!this.getType().getName().equals(resType)) {
            return null;
        }
        ResourceElement resDomElement = (ResourceElement)domElement;
        String resName = ((ResourceElement)domElement).getName().getStringValue();
        return this.getName().equals(resName) ? resDomElement : null;
    }

    @Override
    public int compareTo(@NotNull ValueResourceInfo other) {
        int delta;
        if (other == null) {
            ValueResourceInfoImpl.$$$reportNull$$$0(6);
        }
        if ((delta = AndroidResourceUtil.compareResourceFiles(this.myFile, other.getContainingFile())) != 0) {
            return delta;
        }
        delta = this.getType().compareTo((Enum)other.getType());
        if (delta != 0) {
            return delta;
        }
        return this.getName().compareTo(other.getName());
    }

    public String toString() {
        return "ANDROID_RESOURCE: " + this.getType() + ", " + this.getName() + ", " + this.myFile.getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceItem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/resourceManagers/ValueResourceInfoImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/resourceManagers/ValueResourceInfoImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

