/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.Jdks;
import com.android.tools.idea.sdk.SdkPaths;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.google.common.collect.Lists;
import com.intellij.CommonBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.JavaDependentSdkType;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import icons.AndroidIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.android.sdk.AndroidNewSdkDialog;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkConfigurable;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.sdk.MessageBuildingSdkLog;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdkType
extends JavaDependentSdkType
implements JavaSdkType {
    @NonNls
    public static final String SDK_NAME = "Android SDK";
    @NonNls
    public static final String DEFAULT_EXTERNAL_DOCUMENTATION_PATH = "developer.android.com/reference/";
    @NonNls
    public static final String DEFAULT_EXTERNAL_DOCUMENTATION_URL = "http://developer.android.com/reference/";

    public AndroidSdkType() {
        super(SDK_NAME);
    }

    @Nullable
    public String getBinPath(@NotNull Sdk sdk) {
        Sdk internalJavaSdk;
        if (sdk == null) {
            AndroidSdkType.$$$reportNull$$$0(0);
        }
        return (internalJavaSdk = AndroidSdkType.getInternalJavaSdk(sdk)) == null ? null : JavaSdk.getInstance().getBinPath(internalJavaSdk);
    }

    @Nullable
    public String getToolsPath(@NotNull Sdk sdk) {
        Sdk jdk;
        if (sdk == null) {
            AndroidSdkType.$$$reportNull$$$0(1);
        }
        if ((jdk = AndroidSdkType.getInternalJavaSdk(sdk)) != null && jdk.getVersionString() != null) {
            return JavaSdk.getInstance().getToolsPath(jdk);
        }
        return null;
    }

    @Nullable
    public String getVMExecutablePath(@NotNull Sdk sdk) {
        Sdk internalJavaSdk;
        if (sdk == null) {
            AndroidSdkType.$$$reportNull$$$0(2);
        }
        return (internalJavaSdk = AndroidSdkType.getInternalJavaSdk(sdk)) == null ? null : JavaSdk.getInstance().getVMExecutablePath(internalJavaSdk);
    }

    @Nullable
    public String suggestHomePath() {
        return null;
    }

    public boolean isValidSdkHome(@Nullable String path) {
        if (StringUtil.isEmpty((String)path)) {
            return false;
        }
        File sdkPath = FilePaths.toSystemDependentPath((String)path);
        return SdkPaths.validateAndroidSdk((File)sdkPath, (boolean)false).success;
    }

    public String getVersionString(@NotNull Sdk sdk) {
        Sdk internalJavaSdk;
        if (sdk == null) {
            AndroidSdkType.$$$reportNull$$$0(3);
        }
        return (internalJavaSdk = AndroidSdkType.getInternalJavaSdk(sdk)) != null ? internalJavaSdk.getVersionString() : null;
    }

    @NotNull
    public String suggestSdkName(String currentSdkName, String sdkHome) {
        if (SDK_NAME == null) {
            AndroidSdkType.$$$reportNull$$$0(4);
        }
        return SDK_NAME;
    }

    public boolean setupSdkPaths(@NotNull Sdk sdk, @NotNull SdkModel sdkModel) {
        Sdk[] sdks;
        if (sdk == null) {
            AndroidSdkType.$$$reportNull$$$0(5);
        }
        if (sdkModel == null) {
            AndroidSdkType.$$$reportNull$$$0(6);
        }
        ArrayList javaSdks = Lists.newArrayList();
        for (Sdk jdk : sdks = sdkModel.getSdks()) {
            if (!Jdks.getInstance().isApplicableJdk(jdk)) continue;
            javaSdks.add(jdk.getName());
        }
        if (javaSdks.isEmpty()) {
            Messages.showErrorDialog((String)AndroidBundle.message("no.jdk.for.android.found.error", new Object[0]), (String)"No Java SDK Found");
            return false;
        }
        MessageBuildingSdkLog log = new MessageBuildingSdkLog();
        AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdk);
        if (sdkData == null) {
            String errorMessage = !log.getErrorMessage().isEmpty() ? log.getErrorMessage() : AndroidBundle.message("cannot.parse.sdk.error", new Object[0]);
            Messages.showErrorDialog((String)errorMessage, (String)"SDK Parsing Error");
            return false;
        }
        IAndroidTarget[] targets = sdkData.getTargets();
        if (targets.length == 0) {
            if (Messages.showOkCancelDialog((String)AndroidBundle.message("no.android.targets.error", new Object[0]), (String)CommonBundle.getErrorTitle(), (String)"Open SDK Manager", (String)Messages.CANCEL_BUTTON, (Icon)Messages.getErrorIcon()) == 0) {
                SdkQuickfixUtils.showAndroidSdkManager();
            }
            return false;
        }
        String[] targetNames = new String[targets.length];
        String newestPlatform = null;
        AndroidVersion version2 = null;
        for (int i = 0; i < targets.length; ++i) {
            String targetName;
            IAndroidTarget target = targets[i];
            targetNames[i] = targetName = AndroidSdkUtils.getTargetPresentableName(target);
            if (!target.isPlatform() || version2 != null && target.getVersion().compareTo(version2) <= 0) continue;
            newestPlatform = targetName;
            version2 = target.getVersion();
        }
        AndroidNewSdkDialog dialog = new AndroidNewSdkDialog(null, javaSdks, (String)javaSdks.get(0), Arrays.asList(targetNames), newestPlatform != null ? newestPlatform : targetNames[0]);
        if (!dialog.showAndGet()) {
            return false;
        }
        String name = (String)javaSdks.get(dialog.getSelectedJavaSdkIndex());
        Sdk jdk = sdkModel.findSdk(name);
        IAndroidTarget target = targets[dialog.getSelectedTargetIndex()];
        String sdkName = AndroidSdks.getInstance().chooseNameForNewLibrary(target);
        AndroidSdks.getInstance().setUpSdk(sdk, target, sdkName, Arrays.asList(sdks), jdk);
        return true;
    }

    @NotNull
    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            AndroidSdkType.$$$reportNull$$$0(7);
        }
        if (sdkModificator == null) {
            AndroidSdkType.$$$reportNull$$$0(8);
        }
        AndroidSdkConfigurable androidSdkConfigurable = new AndroidSdkConfigurable(sdkModel, sdkModificator);
        if (androidSdkConfigurable == null) {
            AndroidSdkType.$$$reportNull$$$0(9);
        }
        return androidSdkConfigurable;
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData data, @NotNull Element e) {
        if (data == null) {
            AndroidSdkType.$$$reportNull$$$0(10);
        }
        if (e == null) {
            AndroidSdkType.$$$reportNull$$$0(11);
        }
        if (data instanceof AndroidSdkAdditionalData) {
            ((AndroidSdkAdditionalData)data).save(e);
        }
    }

    @NotNull
    public SdkAdditionalData loadAdditionalData(@NotNull Sdk currentSdk, @NotNull Element additional) {
        if (currentSdk == null) {
            AndroidSdkType.$$$reportNull$$$0(12);
        }
        if (additional == null) {
            AndroidSdkType.$$$reportNull$$$0(13);
        }
        AndroidSdkAdditionalData androidSdkAdditionalData = new AndroidSdkAdditionalData(currentSdk, additional);
        if (androidSdkAdditionalData == null) {
            AndroidSdkType.$$$reportNull$$$0(14);
        }
        return androidSdkAdditionalData;
    }

    @NotNull
    public String getPresentableName() {
        String string = AndroidBundle.message("android.sdk.presentable.name", new Object[0]);
        if (string == null) {
            AndroidSdkType.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AndroidIcons.Android;
        if (icon == null) {
            AndroidSdkType.$$$reportNull$$$0(16);
        }
        return icon;
    }

    @NotNull
    public Icon getIconForAddAction() {
        Icon icon = this.getIcon();
        if (icon == null) {
            AndroidSdkType.$$$reportNull$$$0(17);
        }
        return icon;
    }

    @NotNull
    public String getDefaultDocumentationUrl(@NotNull Sdk sdk) {
        if (sdk == null) {
            AndroidSdkType.$$$reportNull$$$0(18);
        }
        if (DEFAULT_EXTERNAL_DOCUMENTATION_URL == null) {
            AndroidSdkType.$$$reportNull$$$0(19);
        }
        return DEFAULT_EXTERNAL_DOCUMENTATION_URL;
    }

    public boolean isRootTypeApplicable(@NotNull OrderRootType type) {
        if (type == null) {
            AndroidSdkType.$$$reportNull$$$0(20);
        }
        return type == OrderRootType.CLASSES || type == OrderRootType.SOURCES || type == JavadocOrderRootType.getInstance() || type == AnnotationOrderRootType.getInstance();
    }

    @Nullable
    private static Sdk getInternalJavaSdk(@NotNull Sdk sdk) {
        AndroidSdkAdditionalData data;
        if (sdk == null) {
            AndroidSdkType.$$$reportNull$$$0(21);
        }
        return (data = AndroidSdks.getInstance().getAndroidSdkAdditionalData(sdk)) != null ? data.getJavaSdk() : null;
    }

    public static AndroidSdkType getInstance() {
        return (AndroidSdkType)SdkType.findInstance(AndroidSdkType.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 4: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/sdk/AndroidSdkType";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSdk";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additional";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/sdk/AndroidSdkType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestSdkName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdditionalDataConfigurable";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAdditionalData";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconForAddAction";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultDocumentationUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBinPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getToolsPath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVMExecutablePath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVersionString";
                break;
            }
            case 4: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setupSdkPaths";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalDataConfigurable";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "saveAdditionalData";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadAdditionalData";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultDocumentationUrl";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isRootTypeApplicable";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getInternalJavaSdk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

