/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.LayoutLibraryLoader;
import com.android.tools.idea.layoutlib.RenderingException;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.res.FrameworkResourceRepository;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.NanoXmlUtil;
import gnu.trove.TIntObjectHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeDefinitionsImpl;
import org.jetbrains.android.resourceManagers.FilteredAttributeDefinitions;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.StudioEmbeddedRenderTarget;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidTargetData {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.sdk.AndroidTargetData");
    private final AndroidSdkData mySdkData;
    private final IAndroidTarget myTarget;
    private volatile AttributeDefinitionsImpl myAttrDefs;
    private volatile LayoutLibrary myLayoutLibrary;
    private final Object myPublicResourceCacheLock;
    private volatile Map<String, Set<String>> myPublicResourceCache;
    private TIntObjectHashMap<String> myPublicResourceIdMap;
    private volatile MyStaticConstantsData myStaticConstantsData;
    private FrameworkResourceRepository myFrameworkResources;

    public AndroidTargetData(@NotNull AndroidSdkData sdkData, @NotNull IAndroidTarget target) {
        if (sdkData == null) {
            AndroidTargetData.$$$reportNull$$$0(0);
        }
        if (target == null) {
            AndroidTargetData.$$$reportNull$$$0(1);
        }
        this.myPublicResourceCacheLock = new Object();
        this.mySdkData = sdkData;
        this.myTarget = target;
    }

    @Nullable
    public AttributeDefinitions getPublicAttrDefs(@NotNull Project project) {
        AttributeDefinitionsImpl attrDefs;
        if (project == null) {
            AndroidTargetData.$$$reportNull$$$0(2);
        }
        return (attrDefs = this.getAllAttrDefs(project)) != null ? new PublicAttributeDefinitions(attrDefs) : null;
    }

    @Nullable
    public AttributeDefinitionsImpl getAllAttrDefs(@NotNull Project project) {
        if (project == null) {
            AndroidTargetData.$$$reportNull$$$0(3);
        }
        if (this.myAttrDefs == null) {
            ApplicationManager.getApplication().runReadAction(() -> {
                if (project == null) {
                    AndroidTargetData.$$$reportNull$$$0(13);
                }
                String attrsPath = FileUtil.toSystemIndependentName((String)this.myTarget.getPath(8));
                String attrsManifestPath = FileUtil.toSystemIndependentName((String)this.myTarget.getPath(9));
                XmlFile[] files2 = AndroidTargetData.findXmlFiles(project, attrsPath, attrsManifestPath);
                if (files2 != null) {
                    this.myAttrDefs = new AttributeDefinitionsImpl(files2);
                }
            });
        }
        return this.myAttrDefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Map<String, Set<String>> getPublicResourceCache() {
        Object object = this.myPublicResourceCacheLock;
        synchronized (object) {
            if (this.myPublicResourceCache == null) {
                this.parsePublicResCache();
            }
            return this.myPublicResourceCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public TIntObjectHashMap<String> getPublicIdMap() {
        Object object = this.myPublicResourceCacheLock;
        synchronized (object) {
            if (this.myPublicResourceIdMap == null) {
                this.parsePublicResCache();
            }
            return this.myPublicResourceIdMap;
        }
    }

    public boolean isResourcePublic(@NotNull String type, @NotNull String name) {
        Map<String, Set<String>> publicResourceCache;
        if (type == null) {
            AndroidTargetData.$$$reportNull$$$0(4);
        }
        if (name == null) {
            AndroidTargetData.$$$reportNull$$$0(5);
        }
        if ((publicResourceCache = this.getPublicResourceCache()) == null) {
            return false;
        }
        Set<String> set = publicResourceCache.get(type);
        return set != null && set.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePublicResCache() {
        String resDirPath = this.myTarget.getPath(11);
        String publicXmlPath = resDirPath + '/' + "values" + "/public.xml";
        VirtualFile publicXml = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)publicXmlPath));
        if (publicXml != null) {
            try {
                MyPublicResourceCacheBuilder builder = new MyPublicResourceCacheBuilder();
                NanoXmlUtil.parse((InputStream)publicXml.getInputStream(), (IXMLBuilder)builder);
                Object object = this.myPublicResourceCacheLock;
                synchronized (object) {
                    this.myPublicResourceCache = builder.getPublicResourceCache();
                    this.myPublicResourceIdMap = builder.getIdMap();
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Nullable
    public synchronized LayoutLibrary getLayoutLibrary(@NotNull Project project) throws RenderingException, IOException {
        if (project == null) {
            AndroidTargetData.$$$reportNull$$$0(6);
        }
        if (this.myLayoutLibrary == null) {
            AttributeDefinitionsImpl attrDefs;
            IAndroidTarget target;
            AndroidTargetData targetData;
            if (this.myTarget instanceof CompatibilityRenderTarget && (targetData = this.mySdkData.getTargetData(target = ((CompatibilityRenderTarget)this.myTarget).getRenderTarget())) != this) {
                this.myLayoutLibrary = targetData.getLayoutLibrary(project);
                return this.myLayoutLibrary;
            }
            if (!(this.myTarget instanceof StudioEmbeddedRenderTarget)) {
                LOG.warn("Rendering will not use the StudioEmbeddedRenderTarget");
            }
            if ((attrDefs = this.getAllAttrDefs(project)) == null) {
                return null;
            }
            this.myLayoutLibrary = LayoutLibraryLoader.load((IAndroidTarget)this.myTarget, attrDefs.getEnumMap());
        }
        return this.myLayoutLibrary;
    }

    public void clearLayoutBitmapCache(Module module) {
        if (this.myLayoutLibrary != null) {
            this.myLayoutLibrary.clearCaches((Object)module);
        }
    }

    @NotNull
    public IAndroidTarget getTarget() {
        IAndroidTarget iAndroidTarget = this.myTarget;
        if (iAndroidTarget == null) {
            AndroidTargetData.$$$reportNull$$$0(7);
        }
        return iAndroidTarget;
    }

    @Nullable
    private static XmlFile[] findXmlFiles(@NotNull Project project, String ... paths) {
        if (project == null) {
            AndroidTargetData.$$$reportNull$$$0(8);
        }
        if (paths == null) {
            AndroidTargetData.$$$reportNull$$$0(9);
        }
        XmlFile[] xmlFiles = new XmlFile[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            PsiFile psiFile;
            String path = paths[i];
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
            PsiFile psiFile2 = psiFile = file != null ? AndroidPsiUtils.getPsiFileSafely(project, file) : null;
            if (psiFile == null) {
                LOG.info("File " + path + " is not found");
                return null;
            }
            if (!(psiFile instanceof XmlFile)) {
                LOG.info("File " + path + "  is not an xml psiFile");
                return null;
            }
            xmlFiles[i] = (XmlFile)psiFile;
        }
        return xmlFiles;
    }

    @NotNull
    public synchronized MyStaticConstantsData getStaticConstantsData() {
        if (this.myStaticConstantsData == null) {
            this.myStaticConstantsData = new MyStaticConstantsData();
        }
        MyStaticConstantsData myStaticConstantsData = this.myStaticConstantsData;
        if (myStaticConstantsData == null) {
            AndroidTargetData.$$$reportNull$$$0(10);
        }
        return myStaticConstantsData;
    }

    @Nullable
    public synchronized AbstractResourceRepository getFrameworkResources(boolean withLocale) {
        if (this.myFrameworkResources != null && withLocale && !this.myFrameworkResources.isWithLocaleResources()) {
            this.myFrameworkResources = null;
        }
        if (this.myFrameworkResources == null) {
            File resFolder = this.myTarget.getFile(11);
            if (!resFolder.isDirectory()) {
                LOG.error(AndroidBundle.message("android.directory.cannot.be.found.error", resFolder.getPath()));
                return null;
            }
            this.myFrameworkResources = FrameworkResourceRepository.create(resFolder, withLocale, true);
        }
        return this.myFrameworkResources;
    }

    @Nullable
    public static AndroidTargetData getTargetData(@NotNull IAndroidTarget target, @NotNull Module module) {
        AndroidPlatform platform;
        if (target == null) {
            AndroidTargetData.$$$reportNull$$$0(11);
        }
        if (module == null) {
            AndroidTargetData.$$$reportNull$$$0(12);
        }
        return (platform = AndroidPlatform.getInstance(module)) != null ? platform.getSdkData().getTargetData(target) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkData";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/sdk/AndroidTargetData";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/sdk/AndroidTargetData";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticConstantsData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPublicAttrDefs";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllAttrDefs";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isResourcePublic";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLayoutLibrary";
                break;
            }
            case 7: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findXmlFiles";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTargetData";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAllAttrDefs$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class MyStaticConstantsData {
        private final Set<String> myActivityActions = this.collectValues(14);
        private final Set<String> myServiceActions = this.collectValues(16);
        private final Set<String> myReceiverActions = this.collectValues(15);
        private final Set<String> myCategories = this.collectValues(17);

        private MyStaticConstantsData() {
        }

        @Nullable
        public Set<String> getActivityActions() {
            return this.myActivityActions;
        }

        @Nullable
        public Set<String> getServiceActions() {
            return this.myServiceActions;
        }

        @Nullable
        public Set<String> getReceiverActions() {
            return this.myReceiverActions;
        }

        @Nullable
        public Set<String> getCategories() {
            return this.myCategories;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Nullable
        private Set<String> collectValues(int pathId) {
            try (BufferedReader reader = new BufferedReader(new FileReader(AndroidTargetData.this.myTarget.getPath(pathId)));){
                String line;
                HashSet<String> result2 = new HashSet<String>();
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    result2.add(line);
                }
                HashSet<String> hashSet = result2;
                return hashSet;
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    static class MyPublicResourceCacheBuilder
    extends NanoXmlUtil.IXMLBuilderAdapter {
        private final Map<String, Set<String>> myResult = new HashMap<String, Set<String>>();
        private final TIntObjectHashMap<String> myIdMap = new TIntObjectHashMap(3000);
        private String myName;
        private String myType;
        private int myId;
        private boolean inGroup;

        MyPublicResourceCacheBuilder() {
        }

        public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) {
            if ("public".equals(name) && this.myName != null && this.myType != null) {
                Set<String> set = this.myResult.get(this.myType);
                if (set == null) {
                    set = new HashSet<String>();
                    this.myResult.put(this.myType, set);
                }
                set.add(this.myName);
                if (this.myId != 0) {
                    this.myIdMap.put(this.myId, (Object)("@android:" + this.myType + "/" + this.myName));
                    if (this.inGroup) {
                        ++this.myId;
                    }
                }
            }
        }

        public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) {
            switch (key) {
                case "name": {
                    this.myName = value;
                    break;
                }
                case "type": {
                    this.myType = value;
                    break;
                }
                case "first-id": 
                case "id": {
                    try {
                        this.myId = Integer.decode(value);
                        break;
                    }
                    catch (NumberFormatException e) {
                        this.myId = 0;
                    }
                }
            }
        }

        public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) {
            if (!this.inGroup) {
                this.myType = null;
                this.myId = 0;
            }
            if ("public-group".equals(name)) {
                this.inGroup = true;
            }
            this.myName = null;
        }

        public void endElement(String name, String nsPrefix, String nsURI) {
            if ("public-group".equals(name)) {
                this.inGroup = false;
            }
        }

        public Map<String, Set<String>> getPublicResourceCache() {
            return this.myResult;
        }

        public TIntObjectHashMap<String> getIdMap() {
            return this.myIdMap;
        }
    }

    private class PublicAttributeDefinitions
    extends FilteredAttributeDefinitions {
        protected PublicAttributeDefinitions(AttributeDefinitions wrappee) {
            if (wrappee == null) {
                PublicAttributeDefinitions.$$$reportNull$$$0(0);
            }
            super(wrappee);
        }

        @Override
        protected boolean isAttributeAcceptable(@NotNull String name) {
            if (name == null) {
                PublicAttributeDefinitions.$$$reportNull$$$0(1);
            }
            return AndroidTargetData.this.isResourcePublic(ResourceType.ATTR.getName(), name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrappee";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/sdk/AndroidTargetData$PublicAttributeDefinitions";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAttributeAcceptable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

