/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.SdkConstants;
import com.android.builder.model.AaptOptions;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.LogAnonymizerUtil;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.ClassJarProvider;
import com.android.tools.idea.rendering.RenderClassLoader;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceClassRegistry;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.utils.SdkUtils;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.uipreview.RecyclerViewHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleClassLoader
extends RenderClassLoader {
    private static final Logger LOG = Logger.getInstance(ModuleClassLoader.class);
    private final WeakReference<Module> myModuleReference;
    private final LayoutLibrary myLibrary;
    private Map<String, VirtualFile> myClassFiles;
    private Map<String, ClassModificationTimestamp> myClassFilesLastModified;
    private static final Pattern RESOURCE_CLASS_NAME = Pattern.compile(".+\\.R(\\$[^.]+)?$");
    private static Map<Module, ModuleClassLoader> ourCache = ContainerUtil.createWeakMap();

    private ModuleClassLoader(@NotNull LayoutLibrary library, @NotNull Module module) {
        if (library == null) {
            ModuleClassLoader.$$$reportNull$$$0(0);
        }
        if (module == null) {
            ModuleClassLoader.$$$reportNull$$$0(1);
        }
        super(library.getClassLoader(), library.getApiLevel());
        this.myLibrary = library;
        this.myModuleReference = new WeakReference<Module>(module);
        ModuleClassLoader.getLibraryJarFiles(ModuleClassLoader.getExternalLibraries(module)).forEach(jarFile -> {
            if (module == null) {
                ModuleClassLoader.$$$reportNull$$$0(20);
            }
            ModuleClassLoader.registerLibraryResourceFiles(module, jarFile);
        });
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        block15: {
            block14: {
                if (ModuleClassLoader.LOG.isDebugEnabled()) {
                    ModuleClassLoader.LOG.debug(String.format("findClass(%s)", new Object[]{name}));
                }
                module = (Module)this.myModuleReference.get();
                try {
                    if (this.myInsideJarClassLoader || module == null || !ModuleClassLoader.isResourceClassName(name)) ** GOTO lbl38
                    facet = AndroidFacet.getInstance(module);
                    if (facet == null) ** GOTO lbl36
                    repositoryManager = ResourceRepositoryManager.getOrCreateInstance(facet);
                    data = ResourceClassRegistry.get(module.getProject()).findClassDefinition(name, repositoryManager);
                    if (data == null) break block14;
                    data = this.convertClass(data);
                    if (ModuleClassLoader.LOG.isDebugEnabled()) {
                        ModuleClassLoader.LOG.debug("  Defining class from AAR registry");
                    }
                    v0 = this.defineClassAndPackage(name, data, 0, data.length);
                }
                catch (ClassNotFoundException e) {
                    clazz = null;
                    if ("com.android.layoutlib.bridge.android.support.Adapter".equals(name)) {
                        clazz = RecyclerViewHelper.getAdapterClass(DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_V7), DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_VIEW_HOLDER), DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_ADAPTER));
                    }
                    if ("com.android.layoutlib.bridge.android.support.Adapter$ViewHolder".equals(name)) {
                        clazz = RecyclerViewHelper.getViewHolder(DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_V7), DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_VIEW_HOLDER), DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_ADAPTER));
                    }
                    if (clazz != null) {
                        if (ModuleClassLoader.LOG.isDebugEnabled()) {
                            ModuleClassLoader.LOG.debug("  Defining RecyclerView helper class");
                        }
                        v1 = this.defineClassAndPackage(name, clazz, 0, clazz.length);
                        if (v1 == null) {
                            ModuleClassLoader.$$$reportNull$$$0(4);
                        }
                        return v1;
                    }
                    ModuleClassLoader.LOG.debug((Throwable)e);
                    throw e;
                }
                if (v0 == null) {
                    ModuleClassLoader.$$$reportNull$$$0(2);
                }
                return v0;
            }
            break block15;
lbl36:
            // 1 sources

            if (ModuleClassLoader.LOG.isDebugEnabled()) {
                ModuleClassLoader.LOG.debug("  LocalResourceRepositoryInstance not found");
            }
        }
        if (ModuleClassLoader.LOG.isDebugEnabled()) {
            ModuleClassLoader.LOG.debug(String.format("  super.findClass(%s)", new Object[]{LogAnonymizerUtil.anonymizeClassName((String)name)}));
        }
        v2 = super.findClass(name);
        if (v2 == null) {
            ModuleClassLoader.$$$reportNull$$$0(3);
        }
        return v2;
    }

    @Nullable
    public static ClassLoader create(IAndroidTarget target, Module module) throws Exception {
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance(module);
        if (androidPlatform == null) {
            return null;
        }
        AndroidTargetData targetData = androidPlatform.getSdkData().getTargetData(target);
        LayoutLibrary library = targetData.getLayoutLibrary(module.getProject());
        if (library == null) {
            return null;
        }
        return ModuleClassLoader.get(library, module);
    }

    @Override
    @NotNull
    protected Class<?> load(String name) throws ClassNotFoundException {
        Module module;
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("load(%s)", LogAnonymizerUtil.anonymizeClassName((String)name)));
        }
        if ((module = (Module)this.myModuleReference.get()) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("  ClassNotFoundException(%s)", name));
            }
            throw new ClassNotFoundException(name);
        }
        Class<?> aClass = this.loadClassFromModuleOrDependency(module, name, new HashSet<Module>());
        if (aClass == null) {
            aClass = this.loadClassFromJar(name);
        }
        if (aClass != null) {
            Class<?> clazz = aClass;
            if (clazz == null) {
                ModuleClassLoader.$$$reportNull$$$0(5);
            }
            return clazz;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("  ClassNotFoundException(%s)", LogAnonymizerUtil.anonymizeClassName((String)name)));
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        boolean loadFromProject = name.startsWith("android.support.constraint.solver");
        if (loadFromProject) {
            try {
                Class<?> loadedClass = this.findLoadedClass(name);
                if (loadedClass != null) {
                    return loadedClass;
                }
                return this.load(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.loadClass(name);
    }

    @Nullable
    private Class<?> loadClassFromModuleOrDependency(Module module, String name, Set<Module> visited) {
        Class<?> aClass;
        if (!visited.add(module)) {
            return null;
        }
        if (module.isDisposed()) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("loadClassFromModuleOrDependency(%s, %s)", LogAnonymizerUtil.anonymize((Module)module), LogAnonymizerUtil.anonymizeClassName((String)name)));
        }
        if ((aClass = this.loadClassFromModule(module, name)) != null) {
            return aClass;
        }
        for (Module depModule : ModuleRootManager.getInstance((Module)module).getDependencies(false)) {
            aClass = this.loadClassFromModuleOrDependency(depModule, name, visited);
            if (aClass == null) continue;
            return aClass;
        }
        return null;
    }

    @Nullable
    private Class<?> loadClassFromModule(Module module, String name) {
        AndroidModel androidModel;
        AndroidFacet facet;
        if (module.isDisposed()) {
            return null;
        }
        CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
        if (extension == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("loadClassFromModule(%s, %s)", LogAnonymizerUtil.anonymize((Module)module), LogAnonymizerUtil.anonymizeClassName((String)name)));
        }
        VirtualFile vOutFolder = extension.getCompilerOutputPath();
        VirtualFile classFile = null;
        if (vOutFolder != null) {
            classFile = ClassJarProvider.findClassFileInPath(vOutFolder, name);
        }
        if (classFile == null && (facet = AndroidFacet.getInstance(module)) != null && facet.requiresAndroidModel() && (androidModel = ((AndroidFacetConfiguration)facet.getConfiguration()).getModel()) != null) {
            classFile = androidModel.getClassJarProvider().findModuleClassFile(name, module);
        }
        if (classFile != null) {
            return this.loadClassFile(name, classFile);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("  Class not found");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSourceModified(@NotNull String fqcn, @Nullable Object myCredential) {
        if (fqcn == null) {
            ModuleClassLoader.$$$reportNull$$$0(6);
        }
        if (ModuleClassLoader.isResourceClassName(fqcn)) {
            return false;
        }
        Module module = (Module)this.myModuleReference.get();
        if (module == null) {
            return false;
        }
        VirtualFile classFile = this.getClassFile(fqcn);
        if (classFile == null) {
            return false;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null || ((AndroidFacetConfiguration)facet.getConfiguration()).getModel() == null) {
            return false;
        }
        boolean token = RenderSecurityManager.enterSafeRegion(myCredential);
        try {
            boolean bl = ((AndroidFacetConfiguration)facet.getConfiguration()).getModel().isClassFileOutOfDate(module, fqcn, classFile);
            return bl;
        }
        finally {
            RenderSecurityManager.exitSafeRegion(token);
        }
    }

    private static boolean isResourceClassName(@NotNull String className) {
        if (className == null) {
            ModuleClassLoader.$$$reportNull$$$0(7);
        }
        return RESOURCE_CLASS_NAME.matcher(className).matches();
    }

    @Override
    @Nullable
    protected Class<?> loadClassFile(String fqcn, @NotNull VirtualFile classFile) {
        if (classFile == null) {
            ModuleClassLoader.$$$reportNull$$$0(8);
        }
        if (this.myClassFiles == null) {
            this.myClassFiles = Maps.newHashMap();
            this.myClassFilesLastModified = Maps.newHashMap();
        }
        this.myClassFiles.put(fqcn, classFile);
        this.myClassFilesLastModified.put(fqcn, new ClassModificationTimestamp(classFile.getTimeStamp(), classFile.getLength()));
        return super.loadClassFile(fqcn, classFile);
    }

    @NotNull
    private static Stream<File> getExternalLibraries(Module module) {
        AndroidModel model;
        if (module == null) {
            Stream<File> stream = Stream.empty();
            if (stream == null) {
                ModuleClassLoader.$$$reportNull$$$0(9);
            }
            return stream;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null && facet.requiresAndroidModel() && (model = ((AndroidFacetConfiguration)facet.getConfiguration()).getModel()) != null) {
            Stream<File> stream = model.getClassJarProvider().getModuleExternalLibraries(module).stream();
            if (stream == null) {
                ModuleClassLoader.$$$reportNull$$$0(10);
            }
            return stream;
        }
        Stream<File> stream = AndroidRootUtil.getExternalLibraries(module).stream().map(VfsUtilCore::virtualToIoFile);
        if (stream == null) {
            ModuleClassLoader.$$$reportNull$$$0(11);
        }
        return stream;
    }

    private static void registerLibraryResourceFiles(@NotNull Module module, @NotNull File jarFile) {
        ResourceNamespace resourcesNamespace;
        LocalResourceRepository rClassContents;
        String packageName;
        AndroidFacet facet;
        if (module == null) {
            ModuleClassLoader.$$$reportNull$$$0(12);
        }
        if (jarFile == null) {
            ModuleClassLoader.$$$reportNull$$$0(13);
        }
        if ((facet = AndroidFacet.getInstance(module)) == null) {
            return;
        }
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getOrCreateInstance(facet);
        LocalResourceRepository appResources = repositoryManager.getAppResources(true);
        File resourcesDirectory = null;
        File aarDir = jarFile.getParentFile();
        if (aarDir.getPath().endsWith(".aar") || aarDir.getPath().contains("exploded-aar")) {
            String path;
            if (aarDir.getPath().contains("exploded-aar")) {
                if (aarDir.getPath().endsWith("libs")) {
                    aarDir = aarDir.getParentFile();
                }
                if (aarDir.getPath().endsWith("jars")) {
                    aarDir = aarDir.getParentFile();
                }
            }
            if ((path = aarDir.getPath()).endsWith(".aar") || path.contains("exploded-aar")) {
                resourcesDirectory = aarDir;
            }
        }
        if (resourcesDirectory == null) {
            File manifest;
            File parentFile = aarDir.getParentFile();
            if (parentFile != null && (manifest = new File(parentFile, "AndroidManifest.xml")).exists()) {
                resourcesDirectory = parentFile;
            }
            if (resourcesDirectory == null) {
                return;
            }
        }
        ResourceClassRegistry registry = ResourceClassRegistry.get(module.getProject());
        if (repositoryManager.getNamespacing() == AaptOptions.Namespacing.DISABLED) {
            try {
                packageName = AndroidManifestUtils.getAarPackageName(resourcesDirectory);
                if (packageName == null) {
                    return;
                }
            }
            catch (IOException e) {
                return;
            }
            rClassContents = appResources;
            resourcesNamespace = ResourceNamespace.RES_AUTO;
        } else {
            LocalResourceRepository aarResources = repositoryManager.findRepositoryFor(resourcesDirectory);
            if (!(aarResources instanceof SingleNamespaceResourceRepository)) {
                return;
            }
            rClassContents = aarResources;
            SingleNamespaceResourceRepository resources = (SingleNamespaceResourceRepository)aarResources;
            resourcesNamespace = resources.getNamespace();
            packageName = resources.getPackageName();
        }
        registry.addLibrary(rClassContents, ResourceIdManager.get(module), packageName, resourcesNamespace);
    }

    @NotNull
    private static Stream<File> getLibraryJarFiles(@NotNull Stream<File> externalLibraries) {
        if (externalLibraries == null) {
            ModuleClassLoader.$$$reportNull$$$0(14);
        }
        Stream<File> stream = externalLibraries.filter(vFile -> "jar".equals(Files.getFileExtension((String)vFile.getName()))).filter(File::exists);
        if (stream == null) {
            ModuleClassLoader.$$$reportNull$$$0(15);
        }
        return stream;
    }

    @Override
    protected List<URL> getExternalJars() {
        Module module = (Module)this.myModuleReference.get();
        if (module == null) {
            return Collections.emptyList();
        }
        ArrayList<URL> result2 = new ArrayList<URL>();
        URL customWidgetsUrl = ThemeEditorUtils.getCustomWidgetsJarUrl();
        if (customWidgetsUrl != null) {
            result2.add(customWidgetsUrl);
        }
        ModuleClassLoader.getLibraryJarFiles(ModuleClassLoader.getExternalLibraries(module)).peek(jarFile -> {
            try {
                result2.add(SdkUtils.fileToUrl((File)jarFile));
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
        }).forEach(jarFile -> ModuleClassLoader.registerLibraryResourceFiles(module, jarFile));
        return result2;
    }

    @Nullable
    private VirtualFile getClassFile(@NotNull String className) {
        if (className == null) {
            ModuleClassLoader.$$$reportNull$$$0(16);
        }
        if (this.myClassFiles == null) {
            return null;
        }
        VirtualFile file = this.myClassFiles.get(className);
        if (file == null) {
            return null;
        }
        return file.isValid() ? file : null;
    }

    private boolean isUpToDate() {
        if (this.myClassFiles != null) {
            for (Map.Entry<String, VirtualFile> entry : this.myClassFiles.entrySet()) {
                String className = entry.getKey();
                VirtualFile classFile = entry.getValue();
                if (!classFile.isValid()) {
                    return false;
                }
                ClassModificationTimestamp lastModifiedStamp = this.myClassFilesLastModified.get(className);
                if (lastModifiedStamp == null) continue;
                long loadedModifiedTime = lastModifiedStamp.timestamp;
                long loadedModifiedLength = lastModifiedStamp.length;
                long classFileModifiedTime = classFile.getTimeStamp();
                long classFileModifiedLength = classFile.getLength();
                if ((classFileModifiedTime <= 0L || loadedModifiedTime <= 0L || loadedModifiedTime >= classFileModifiedTime) && loadedModifiedLength == classFileModifiedLength) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static ModuleClassLoader get(@NotNull LayoutLibrary library, @NotNull Module module) {
        ModuleClassLoader loader;
        if (library == null) {
            ModuleClassLoader.$$$reportNull$$$0(17);
        }
        if (module == null) {
            ModuleClassLoader.$$$reportNull$$$0(18);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("ModuleClassLoader.get(%s)", LogAnonymizerUtil.anonymize((Module)module)));
        }
        if ((loader = ourCache.get(module)) != null) {
            if (library != loader.myLibrary) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  Discarding loader because the layout library has changed");
                }
                loader = null;
            } else if (!loader.isUpToDate()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  Discarding loader because some files have changed");
                }
                loader = null;
            } else {
                List<URL> updatedJarDependencies = loader.getExternalJars();
                if (loader.myJarClassLoader != null && !updatedJarDependencies.equals(loader.myJarClassLoader.getUrls())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("  Recreating jar class loader because dependencies have changed.");
                    }
                    loader.myJarClassLoader = loader.createClassLoader(updatedJarDependencies);
                }
            }
        }
        if (loader == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("  New class loader");
            }
            loader = new ModuleClassLoader(library, module);
            ourCache.put(module, loader);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("  Re-used class loader");
        }
        ModuleClassLoader moduleClassLoader = loader;
        if (moduleClassLoader == null) {
            ModuleClassLoader.$$$reportNull$$$0(19);
        }
        return moduleClassLoader;
    }

    public static void clearCache() {
        ourCache.clear();
    }

    public static void clearCache(Module module) {
        ourCache.remove(module);
    }

    public boolean isClassLoaded(String className) {
        return this.findLoadedClass(className) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 1: 
            case 12: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/uipreview/ModuleClassLoader";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqcn";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalLibraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/uipreview/ModuleClassLoader";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findClass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalLibraries";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryJarFiles";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 19: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSourceModified";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isResourceClassName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadClassFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerLibraryResourceFiles";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryJarFiles";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getClassFile";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ClassModificationTimestamp {
        public final long timestamp;
        public final long length;

        public ClassModificationTimestamp(long timestamp, long length) {
            this.timestamp = timestamp;
            this.length = length;
        }
    }
}

