/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.api.execution.internal.ExecuteTaskBuildOperationDetails;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.results.TestListenerInternal;
import org.gradle.api.tasks.testing.TestExecutionException;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.progress.BuildOperationDescriptor;
import org.gradle.internal.progress.BuildOperationListener;
import org.gradle.internal.progress.OperationFinishEvent;
import org.gradle.internal.progress.OperationProgressEvent;
import org.gradle.internal.progress.OperationStartEvent;
import org.gradle.tooling.internal.protocol.events.InternalTestDescriptor;
import org.gradle.tooling.internal.protocol.test.InternalJvmTestRequest;
import org.gradle.tooling.internal.provider.TestExecutionRequestAction;
import org.gradle.tooling.internal.provider.events.DefaultTestDescriptor;

class TestExecutionResultEvaluator
implements TestListenerInternal,
BuildOperationListener {
    private static final String INDENT = "    ";
    private long resultCount;
    private Map<Object, String> runningTasks = Maps.newHashMap();
    private TestExecutionRequestAction internalTestExecutionRequest;
    private List<FailedTest> failedTests = Lists.newArrayList();

    public TestExecutionResultEvaluator(TestExecutionRequestAction internalTestExecutionRequest) {
        this.internalTestExecutionRequest = internalTestExecutionRequest;
    }

    public boolean hasUnmatchedTests() {
        return this.resultCount == 0L;
    }

    public boolean hasFailedTests() {
        return !this.failedTests.isEmpty();
    }

    public void evaluate() {
        if (this.hasUnmatchedTests()) {
            String formattedTestRequest = this.formatInternalTestExecutionRequest();
            throw new TestExecutionException("No matching tests found in any candidate test task.\n" + formattedTestRequest);
        }
        if (this.hasFailedTests()) {
            StringBuilder failedTestsMessage = new StringBuilder("Test failed.\n").append(INDENT).append("Failed tests:");
            for (FailedTest failedTest : this.failedTests) {
                failedTestsMessage.append("\n").append(Strings.repeat((String)INDENT, (int)2)).append(failedTest.getDescription());
            }
            throw new TestExecutionException(failedTestsMessage.toString());
        }
    }

    private String formatInternalTestExecutionRequest() {
        StringBuilder requestDetails = new StringBuilder(INDENT).append("Requested tests:");
        for (InternalTestDescriptor internalTestDescriptor : this.internalTestExecutionRequest.getTestExecutionDescriptors()) {
            requestDetails.append("\n").append(Strings.repeat((String)INDENT, (int)2)).append(internalTestDescriptor.getDisplayName());
            requestDetails.append(" (Task: '").append(((DefaultTestDescriptor)internalTestDescriptor).getTaskPath()).append("')");
        }
        Collection internalJvmTestRequests = this.internalTestExecutionRequest.getInternalJvmTestRequests();
        for (InternalJvmTestRequest internalJvmTestRequest : internalJvmTestRequests) {
            String className = internalJvmTestRequest.getClassName();
            String methodName = internalJvmTestRequest.getMethodName();
            if (methodName == null) {
                requestDetails.append("\n").append(Strings.repeat((String)INDENT, (int)2)).append("Test class ").append(className);
                continue;
            }
            requestDetails.append("\n").append(Strings.repeat((String)INDENT, (int)2)).append("Test method ").append(className).append(".").append(methodName).append("()");
        }
        return requestDetails.toString();
    }

    public void started(TestDescriptorInternal testDescriptor, TestStartEvent startEvent) {
    }

    public void completed(TestDescriptorInternal testDescriptor, TestResult testResult, TestCompleteEvent completeEvent) {
        if (testDescriptor.getParent() == null) {
            this.resultCount += testResult.getTestCount();
        }
        if (!testDescriptor.isComposite() && testResult.getFailedTestCount() != 0L) {
            this.failedTests.add(new FailedTest(testDescriptor.getName(), testDescriptor.getClassName(), this.getTaskPath(testDescriptor)));
        }
    }

    private String getTaskPath(TestDescriptorInternal givenDescriptor) {
        TestDescriptorInternal descriptor = givenDescriptor;
        while (descriptor.getOwnerBuildOperationId() == null && descriptor.getParent() != null) {
            descriptor = descriptor.getParent();
        }
        String taskPath = this.runningTasks.get(descriptor.getOwnerBuildOperationId());
        if (taskPath == null) {
            throw new IllegalStateException("No parent task for test " + givenDescriptor);
        }
        return taskPath;
    }

    public void output(TestDescriptorInternal testDescriptor, TestOutputEvent event) {
    }

    public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
        if (!(buildOperation.getDetails() instanceof ExecuteTaskBuildOperationDetails)) {
            return;
        }
        TaskInternal task = ((ExecuteTaskBuildOperationDetails)buildOperation.getDetails()).getTask();
        this.runningTasks.put(buildOperation.getId(), task.getPath());
    }

    public void progress(BuildOperationDescriptor buildOperation, OperationProgressEvent progressEvent) {
    }

    public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
        if (!(buildOperation.getDetails() instanceof ExecuteTaskBuildOperationDetails)) {
            return;
        }
        this.runningTasks.remove(buildOperation.getId());
    }

    private static class FailedTest {
        final String name;
        final String className;
        final String taskPath;

        public FailedTest(String name, String className, String taskPath) {
            this.name = name;
            this.className = className;
            this.taskPath = taskPath;
        }

        public String getDescription() {
            StringBuilder stringBuilder = new StringBuilder("Test ").append(this.className).append("#").append(this.name).append(" (Task: ").append(this.taskPath).append(")");
            return stringBuilder.toString();
        }
    }
}

