/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.debugger;

import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.debugger.fragments.GroovyCodeFragment;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTraitTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.ClosureSyntheticParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyCodeFragmentFactory
extends CodeFragmentFactory {
    private static final String EVAL_NAME = "_JETGROOVY_EVAL_";
    private static final String IMPORTS = "___$$IMPORTS$$___";
    private static final String TEXT = "___$$TEXT$$___";

    private static String unwrapVals(List<String> vals) {
        return "java.lang.Object[] |vals = new java.lang.Object[]{" + StringUtil.join(vals, (String)",") + "};\njava.lang.Object[] |resVals = new java.lang.Object[" + vals.size() + "];\nfor (int |iii =0; |iii<|vals.length; |iii++){java.lang.Object |o = |vals[|iii];\nif (|o instanceof groovy.lang.Reference) {|o = ((groovy.lang.Reference)|o).get();}\n|resVals[|iii] = |o;}\n";
    }

    public JavaCodeFragment createCodeFragment(TextWithImports textWithImports, PsiElement context, Project project) {
        Pair<Map<String, String>, GroovyFile> pair = GroovyCodeFragmentFactory.externalParameters(textWithImports.getText(), context);
        GroovyFile toEval = (GroovyFile)pair.second;
        Map parameters = (Map)pair.first;
        ArrayList names2 = new ArrayList(parameters.keySet());
        List values = ContainerUtil.map(names2, name -> (String)parameters.get(name));
        String text = toEval.getText();
        String groovyText = StringUtil.join(names2, (String)", ") + "->" + GroovyCodeFragmentFactory.stripImports(text, toEval);
        PsiClass contextClass = PsiUtil.getContextClass(context);
        boolean isStatic = GroovyCodeFragmentFactory.isStaticContext(context);
        StringBuilder javaText = new StringBuilder();
        javaText.append("java.lang.Class |clazz;\n");
        if (!isStatic) {
            javaText.append("java.lang.Object |thiz0;\n");
            PsiFile containingFile = context.getContainingFile();
            if (containingFile.getContext() != null) {
                containingFile = containingFile.getContext().getContainingFile();
            }
            String fileName = containingFile.getOriginalFile().getName();
            String s = StringUtil.escapeStringCharacters((String)Pattern.quote(fileName));
            javaText.append("Class.forName(\"java.lang.StackTraceElement\");\n");
            javaText.append("StackTraceElement[] |trace = new Exception().getStackTrace();\n");
            javaText.append("if (java.util.Arrays.toString(|trace).matches(\"\\\\[([^,()]+\\\\$\\\\$)[A-Za-z0-9]{8}(\\\\.[^,()]+)\\\\(").append(s).append(":\\\\d+\\\\), (\\\\1[A-Za-z0-9]{8}\\\\2\\\\(Unknown Source\\\\), $OR$.+(?:com$OR$org)\\\\.springsource\\\\.loaded\\\\.).+\")) {\n");
            javaText.append("  |thiz0 = thiz;\n");
            javaText.append(" } else {\n");
            if (contextClass instanceof GrTraitTypeDefinition) {
                javaText.append("  |thiz0 = $self;\n");
            } else {
                javaText.append("  |thiz0 = this;\n");
            }
            javaText.append(" }\n");
        }
        if (!isStatic) {
            javaText.append("|clazz = |thiz0.getClass();\n");
        } else {
            assert (contextClass != null);
            javaText.append("|clazz = java.lang.Class.forName(\"").append(ClassUtil.getJVMClassName((PsiClass)contextClass)).append("\");\n");
        }
        javaText.append("final java.lang.ClassLoader |parentLoader = |clazz.getClassLoader();\n   final groovy.lang.GroovyClassLoader |loader = new groovy.lang.GroovyClassLoader(|parentLoader);\n   final java.lang.Class |c = |loader.parseClass(");
        javaText.append("\"___$$IMPORTS$$___class DUMMY").append(" { ").append("public groovy.lang.Closure ").append(EVAL_NAME).append(" = {").append(TEXT).append("}}\"");
        javaText.append(", \"DUMMY.groovy\");\n   int |i;\n   java.lang.reflect.Field[] |fields = |c.getFields();\n   for (int |j = 0; |j < |fields.length; |j++) if (|fields[|j].getName().equals(\"_JETGROOVY_EVAL_\")) {|i = |j; break;}\n   final java.lang.reflect.Field |field = |fields[|i];\n   final java.lang.Object |closure = |field.get(|c.newInstance());\n");
        javaText.append("groovy.lang.ExpandoMetaClass |emc = new groovy.lang.ExpandoMetaClass(|clazz);\n");
        if (!isStatic) {
            javaText.append("|closure.setDelegate(|thiz0);\n");
            javaText.append("|emc.setProperty(\"").append(EVAL_NAME).append("\", |closure);\n");
        } else {
            javaText.append("|emc.getProperty(\"static\").setProperty(\"").append(EVAL_NAME).append("\", |closure);\n");
        }
        javaText.append("|emc.initialize();\n");
        javaText.append(GroovyCodeFragmentFactory.unwrapVals(values));
        if (!isStatic) {
            javaText.append("java.lang.Object |res = ((groovy.lang.MetaClassImpl)|emc).invokeMethod(|thiz0, \"").append(EVAL_NAME).append("\", |resVals);\n");
        } else {
            javaText.append("java.lang.Object |res = ((groovy.lang.MetaClassImpl)|emc).invokeStaticMethod(|clazz, \"").append(EVAL_NAME).append("\", |resVals);\n");
        }
        javaText.append("|res");
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)toEval.getProject()).getElementFactory();
        String hiddenJavaVars = StringUtil.replace((String)javaText.toString(), (String)"|", (String)("_$_" + new Random().nextInt(42))).replaceAll("\\$OR\\$", "|");
        String finalText = StringUtil.replace((String)StringUtil.replace((String)hiddenJavaVars, (String)TEXT, (String)groovyText), (String)IMPORTS, (String)textWithImports.getImports());
        JavaCodeFragment result = JavaCodeFragmentFactory.getInstance((Project)project).createCodeBlockCodeFragment(finalText, null, true);
        if (contextClass != null) {
            result.setThisType((PsiType)factory.createType(contextClass));
        }
        return result;
    }

    public static Pair<Map<String, String>, GroovyFile> externalParameters(String text, @NotNull PsiElement context) {
        if (context == null) {
            GroovyCodeFragmentFactory.$$$reportNull$$$0(0);
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(context.getProject());
        final GroovyFile toEval = factory.createGroovyFile(text, false, context);
        final GrClosableBlock closure = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)context, GrClosableBlock.class);
        THashMap parameters = new THashMap();
        HashMap replacements = new HashMap();
        toEval.accept(new GroovyRecursiveElementVisitor((Map)parameters, replacements, factory){
            final /* synthetic */ Map val$parameters;
            final /* synthetic */ Map val$replacements;
            final /* synthetic */ GroovyPsiElementFactory val$factory;
            {
                this.val$parameters = map2;
                this.val$replacements = map3;
                this.val$factory = groovyPsiElementFactory;
            }

            @Override
            public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
                String name;
                String qName;
                if (referenceExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitReferenceExpression(referenceExpression);
                if (PsiUtil.isThisReference(referenceExpression) || PsiUtil.isSuperReference(referenceExpression)) {
                    this.replaceWithReference(referenceExpression, "delegate");
                    return;
                }
                PsiElement resolved = referenceExpression.resolve();
                if (resolved instanceof PsiMember && (resolved instanceof PsiClass || ((PsiMember)resolved).hasModifierProperty("static")) && (qName = com.intellij.psi.util.PsiUtil.getMemberQualifiedName((PsiMember)((PsiMember)resolved))) != null && qName.contains(".") && !referenceExpression.isQualified()) {
                    this.replaceWithReference(referenceExpression, qName);
                    return;
                }
                if (this.shouldDelegate(referenceExpression, resolved)) {
                    this.replaceWithReference(referenceExpression, "delegate." + referenceExpression.getReferenceName());
                    return;
                }
                if (resolved instanceof GrVariable && !(resolved instanceof GrField) && !PsiTreeUtil.isAncestor((PsiElement)toEval, (PsiElement)resolved, (boolean)false)) {
                    name = ((GrVariable)resolved).getName();
                    if (resolved instanceof ClosureSyntheticParameter && PsiTreeUtil.isAncestor((PsiElement)toEval, (PsiElement)((ClosureSyntheticParameter)resolved).getClosure(), (boolean)false)) {
                        return;
                    }
                    if (resolved instanceof GrBindingVariable && !PsiTreeUtil.isAncestor((PsiElement)resolved.getContainingFile(), (PsiElement)toEval, (boolean)false)) {
                        return;
                    }
                    String value = closure != null && PsiTreeUtil.findCommonParent((PsiElement)resolved, (PsiElement)closure) != closure && !(resolved instanceof ClosureSyntheticParameter) ? "this." + name : name;
                    this.val$parameters.put(name, value);
                    return;
                }
                if (resolved instanceof PsiLocalVariable || resolved instanceof PsiParameter && !(resolved instanceof GrParameter)) {
                    name = referenceExpression.getReferenceName();
                    this.val$parameters.put(name, name);
                }
            }

            private boolean shouldDelegate(GrReferenceExpression referenceExpression, @Nullable PsiElement resolved) {
                if (referenceExpression.isQualified()) {
                    return false;
                }
                if (resolved instanceof GrField) {
                    return true;
                }
                if (resolved instanceof PsiMethod) {
                    String methodName = ((PsiMethod)resolved).getName();
                    return closure != null && ("getDelegate".equals(methodName) || "getOwner".equals(methodName)) || "call".equals(methodName);
                }
                return false;
            }

            private void replaceWithReference(GrExpression expr, String exprText) {
                this.val$replacements.put(expr, exprText);
            }

            @Override
            public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement refElement) {
                String qName;
                PsiElement resolved;
                if (refElement == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitCodeReferenceElement(refElement);
                if (refElement.getQualifier() == null && (resolved = refElement.resolve()) instanceof PsiClass && (qName = ((PsiClass)resolved).getQualifiedName()) != null) {
                    int dotIndex = qName.lastIndexOf(".");
                    if (dotIndex < 0) {
                        return;
                    }
                    String packageName = qName.substring(0, dotIndex);
                    refElement.setQualifier(this.val$factory.createReferenceElementFromText(packageName));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "refElement";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/groovy/debugger/GroovyCodeFragmentFactory$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCodeReferenceElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        for (GrExpression expression : replacements.keySet()) {
            expression.replaceWithExpression(factory.createExpressionFromText((CharSequence)replacements.get(expression)), false);
        }
        return Pair.create((Object)parameters, (Object)toEval);
    }

    private static String stripImports(String text, GroovyFile toEval) {
        GrImportStatement[] imports2 = toEval.getImportStatements();
        for (int i = imports2.length - 1; i >= 0; --i) {
            TextRange range = imports2[i].getTextRange();
            text = text.substring(0, range.getStartOffset()) + text.substring(range.getEndOffset(), text.length());
        }
        return StringUtil.escapeStringCharacters((String)text);
    }

    public JavaCodeFragment createPresentationCodeFragment(TextWithImports item, PsiElement context, Project project) {
        GroovyCodeFragment result = new GroovyCodeFragment(project, item.getText());
        result.setContext(context);
        return result;
    }

    private static boolean isStaticContext(PsiElement context) {
        for (PsiElement parent = context; parent != null; parent = parent.getContext()) {
            if (parent instanceof PsiMember) {
                return ((PsiMember)parent).hasModifierProperty("static");
            }
            if (parent instanceof GroovyFile && parent.isPhysical()) {
                return false;
            }
            if (!(parent instanceof GrClosableBlock)) continue;
            return false;
        }
        return false;
    }

    public boolean isContextAccepted(PsiElement context) {
        if (context == null) {
            return false;
        }
        if (context.getLanguage().equals((Object)GroovyLanguage.INSTANCE)) {
            return true;
        }
        Project project = context.getProject();
        if (DumbService.isDumb((Project)project)) {
            return false;
        }
        return JavaPsiFacade.getInstance((Project)project).findClass("org.codehaus.groovy.control.CompilationUnit", context.getResolveScope()) != null;
    }

    @NotNull
    public LanguageFileType getFileType() {
        GroovyFileType groovyFileType = GroovyFileType.GROOVY_FILE_TYPE;
        if (groovyFileType == null) {
            GroovyCodeFragmentFactory.$$$reportNull$$$0(1);
        }
        return groovyFileType;
    }

    public EvaluatorBuilder getEvaluatorBuilder() {
        return EvaluatorBuilderImpl.getInstance();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/debugger/GroovyCodeFragmentFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/debugger/GroovyCodeFragmentFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "externalParameters";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

