/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.EmptyGroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class LiteralConstructorReference
extends PsiReferenceBase.Poly<GrListOrMap> {
    public LiteralConstructorReference(@NotNull GrListOrMap element) {
        if (element == null) {
            LiteralConstructorReference.$$$reportNull$$$0(0);
        }
        super((PsiElement)element, TextRange.from((int)0, (int)0), false);
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return this.getElement();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            LiteralConstructorReference.$$$reportNull$$$0(1);
        }
        return this.getElement();
    }

    @Nullable
    public PsiClassType getConstructedClassType() {
        return (PsiClassType)CachedValuesManager.getCachedValue((PsiElement)this.getElement(), () -> CachedValueProvider.Result.create((Object)this.inferConversionType(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private PsiClassType inferConversionType() {
        PsiType ownType;
        PsiType unboxed;
        GrListOrMap listOrMap = (GrListOrMap)this.getElement();
        PsiClassType conversionType = LiteralConstructorReference.getTargetConversionType(listOrMap);
        if (conversionType == null) {
            return null;
        }
        if (listOrMap.isEmpty() && (PsiType.BOOLEAN.equals((Object)(unboxed = TypesUtil.unboxPrimitiveTypeWrapper((PsiType)conversionType))) || PsiType.CHAR.equals((Object)unboxed))) {
            return null;
        }
        PsiType type = listOrMap.getType();
        Object object = ownType = type instanceof PsiClassType ? ((PsiClassType)type).rawType() : type;
        if (ownType != null && TypesUtil.isAssignableWithoutConversions((PsiType)conversionType.rawType(), ownType, listOrMap)) {
            return null;
        }
        PsiClass resolved = conversionType.resolve();
        if (resolved != null) {
            if (InheritanceUtil.isInheritor((PsiClass)resolved, (String)"java.util.Set")) {
                return null;
            }
            if (InheritanceUtil.isInheritor((PsiClass)resolved, (String)"java.util.List")) {
                return null;
            }
        }
        return conversionType;
    }

    @Nullable
    public static PsiClassType getTargetConversionType(@NotNull GrExpression expression) {
        if (expression == null) {
            LiteralConstructorReference.$$$reportNull$$$0(2);
        }
        PsiElement parent = PsiUtil.skipParentheses(expression.getParent(), true);
        PsiType type = null;
        if (parent instanceof GrSafeCastExpression) {
            type = ((GrSafeCastExpression)parent).getType();
        } else if (parent instanceof GrAssignmentExpression && PsiTreeUtil.isAncestor((PsiElement)((GrAssignmentExpression)parent).getRValue(), (PsiElement)expression, (boolean)false)) {
            PsiElement lValue = PsiUtil.skipParentheses(((GrAssignmentExpression)parent).getLValue(), false);
            if (lValue instanceof GrReferenceExpression) {
                type = ((GrReferenceExpression)lValue).getNominalType();
            }
        } else if (parent instanceof GrVariable) {
            type = ((GrVariable)parent).getDeclaredType();
        } else if (parent instanceof GrNamedArgument) {
            for (PsiType expected : GroovyExpectedTypesProvider.getDefaultExpectedTypes(expression)) {
                if ((expected = LiteralConstructorReference.filterOutTrashTypes(expected)) == null) continue;
                return (PsiClassType)expected;
            }
        } else {
            GrControlFlowOwner controlFlowOwner = ControlFlowUtils.findControlFlowOwner(expression);
            if (controlFlowOwner instanceof GrOpenBlock && controlFlowOwner.getParent() instanceof GrMethod && ControlFlowUtils.isReturnValue(expression, controlFlowOwner) && (PsiType.BOOLEAN.equals((Object)TypesUtil.unboxPrimitiveTypeWrapper(type = ((GrMethod)controlFlowOwner.getParent()).getReturnType())) || TypesUtil.isEnum(type) || PsiUtil.isCompileStatic(expression) || TypesUtil.isClassType(type, "java.lang.String") || TypesUtil.isClassType(type, "java.lang.Class"))) {
                type = null;
            }
        }
        if (PsiType.BOOLEAN.equals((Object)type)) {
            type = TypesUtil.boxPrimitiveType(type, expression.getManager(), expression.getResolveScope());
        }
        return LiteralConstructorReference.filterOutTrashTypes(type);
    }

    @Nullable
    private static PsiClassType filterOutTrashTypes(PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        if (type.equalsToText("java.lang.Object")) {
            return null;
        }
        if (TypesUtil.resolvesTo(type, "java.lang.Class")) {
            return null;
        }
        if (TypesUtil.resolvesTo(type, "java.util.Map")) {
            return null;
        }
        if (TypesUtil.resolvesTo(type, "java.util.HashMap")) {
            return null;
        }
        if (TypesUtil.resolvesTo(type, "java.util.List")) {
            return null;
        }
        PsiType erased = TypeConversionUtil.erasure((PsiType)type);
        if (erased == null || erased.equalsToText("java.lang.Object")) {
            return null;
        }
        return (PsiClassType)type;
    }

    @NotNull
    public GrExpression[] getCallArguments() {
        GrListOrMap literal = (GrListOrMap)this.getElement();
        if (literal.isMap()) {
            GrNamedArgument argument = literal.findNamedArgument("super");
            if (argument != null) {
                GrExpression expression = argument.getExpression();
                if (expression instanceof GrListOrMap && !((GrListOrMap)expression).isMap()) {
                    GrExpression[] grExpressionArray = ((GrListOrMap)expression).getInitializers();
                    if (grExpressionArray == null) {
                        LiteralConstructorReference.$$$reportNull$$$0(3);
                    }
                    return grExpressionArray;
                }
                if (expression != null) {
                    GrExpression[] grExpressionArray = new GrExpression[]{expression};
                    if (grExpressionArray == null) {
                        LiteralConstructorReference.$$$reportNull$$$0(4);
                    }
                    return grExpressionArray;
                }
                if (GrExpression.EMPTY_ARRAY == null) {
                    LiteralConstructorReference.$$$reportNull$$$0(5);
                }
                return GrExpression.EMPTY_ARRAY;
            }
            GrExpression[] grExpressionArray = new GrExpression[]{literal};
            if (grExpressionArray == null) {
                LiteralConstructorReference.$$$reportNull$$$0(6);
            }
            return grExpressionArray;
        }
        GrExpression[] grExpressionArray = literal.getInitializers();
        if (grExpressionArray == null) {
            LiteralConstructorReference.$$$reportNull$$$0(7);
        }
        return grExpressionArray;
    }

    @NotNull
    private PsiType[] getCallArgumentTypes() {
        Object[] arguments = this.getCallArguments();
        PsiType[] psiTypeArray = (PsiType[])ContainerUtil.map2Array((Object[])arguments, PsiType.class, (Function)((NullableFunction)grExpression -> grExpression.getType()));
        if (psiTypeArray == null) {
            LiteralConstructorReference.$$$reportNull$$$0(8);
        }
        return psiTypeArray;
    }

    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        GroovyResolveResult result;
        PsiClassType type = this.getConstructedClassType();
        if (type == null) {
            if (GroovyResolveResult.EMPTY_ARRAY == null) {
                LiteralConstructorReference.$$$reportNull$$$0(9);
            }
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        PsiClassType.ClassResolveResult classResolveResult = type.resolveGenerics();
        GroovyResolveResult[] constructorCandidates = PsiUtil.getConstructorCandidates(type, this.getCallArgumentTypes(), (GroovyPsiElement)this.getElement());
        if (constructorCandidates.length == 0 && (result = GroovyResolveResultImpl.from(classResolveResult)) != EmptyGroovyResolveResult.INSTANCE) {
            GroovyResolveResult[] groovyResolveResultArray = new GroovyResolveResult[]{result};
            if (groovyResolveResultArray == null) {
                LiteralConstructorReference.$$$reportNull$$$0(10);
            }
            return groovyResolveResultArray;
        }
        if (constructorCandidates == null) {
            LiteralConstructorReference.$$$reportNull$$$0(11);
        }
        return constructorCandidates;
    }

    @NotNull
    public Object[] getVariants() {
        if (EMPTY_ARRAY == null) {
            LiteralConstructorReference.$$$reportNull$$$0(12);
        }
        return EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/findUsages/LiteralConstructorReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/findUsages/LiteralConstructorReference";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallArguments";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallArgumentTypes";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTargetConversionType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

