/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.SmartCompletionDecorator;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.filters.getters.MembersGetter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import org.jetbrains.plugins.groovy.lang.completion.GrMainCompletionProvider;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

class GroovyMembersGetter
extends MembersGetter {
    private final PsiClassType myExpectedType;

    GroovyMembersGetter(PsiClassType expectedType, CompletionParameters parameters) {
        super(GrMainCompletionProvider.completeStaticMembers(parameters), parameters.getPosition());
        this.myExpectedType = (PsiClassType)JavaCompletionUtil.originalize((PsiType)expectedType);
    }

    public void processMembers(boolean searchInheritors, Consumer<LookupElement> results2) {
        this.processMembers(results2, this.myExpectedType.resolve(), PsiTreeUtil.getParentOfType((PsiElement)this.myPlace, GrAnnotation.class) == null, searchInheritors);
    }

    protected LookupElement createFieldElement(PsiField field) {
        if (!this.isSuitableType(field.getType())) {
            return null;
        }
        return GrMainCompletionProvider.createGlobalMemberElement((PsiMember)field, field.getContainingClass(), false);
    }

    protected LookupElement createMethodElement(PsiMethod method) {
        PsiSubstitutor substitutor = SmartCompletionDecorator.calculateMethodReturnTypeSubstitutor((PsiMethod)method, (PsiType)this.myExpectedType);
        PsiType type = substitutor.substitute(method.getReturnType());
        if (!this.isSuitableType(type)) {
            return null;
        }
        return GrMainCompletionProvider.createGlobalMemberElement((PsiMember)method, method.getContainingClass(), false);
    }

    private boolean isSuitableType(PsiType type) {
        return type != null && TypesUtil.isAssignableByMethodCallConversion((PsiType)this.myExpectedType, type, this.myPlace);
    }
}

