/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.stubs.DefaultStubBuilder;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrFileStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrStubUtils;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnnotatedMemberIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFullScriptNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrScriptClassNameIndex;

public class GrStubFileElementType
extends IStubFileElementType<GrFileStub> {
    public static final int STUB_VERSION = 38;

    public GrStubFileElementType(Language language) {
        super(language);
    }

    public StubBuilder getBuilder() {
        return new DefaultStubBuilder(){

            @NotNull
            protected StubElement createStubForFile(@NotNull PsiFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file instanceof GroovyFile) {
                    GrFileStub grFileStub = new GrFileStub((GroovyFile)file);
                    if (grFileStub == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return grFileStub;
                }
                StubElement stubElement = super.createStubForFile(file);
                if (stubElement == null) {
                    1.$$$reportNull$$$0(2);
                }
                return stubElement;
            }

            public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent, @NotNull ASTNode node) {
                if (parent == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (node == null) {
                    1.$$$reportNull$$$0(4);
                }
                IElementType childType = node.getElementType();
                IElementType parentType = parent.getElementType();
                if (childType == GroovyElementTypes.PARAMETER && parentType != GroovyElementTypes.PARAMETERS_LIST) {
                    return true;
                }
                if (childType == GroovyElementTypes.PARAMETERS_LIST && !(parent.getPsi() instanceof GrMethod)) {
                    return true;
                }
                if (childType == GroovyElementTypes.MODIFIERS) {
                    if (parentType == GroovyElementTypes.CLASS_INITIALIZER) {
                        return true;
                    }
                    if (parentType == GroovyElementTypes.VARIABLE_DEFINITION && !GroovyElementTypes.VARIABLE_DEFINITION.shouldCreateStub(parent)) {
                        return true;
                    }
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrStubFileElementType$1";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parent";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrStubFileElementType$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createStubForFile";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createStubForFile";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "skipChildProcessingWhenBuildingStubs";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public int getStubVersion() {
        return super.getStubVersion() + 38;
    }

    @NotNull
    public String getExternalId() {
        if ("groovy.FILE" == null) {
            GrStubFileElementType.$$$reportNull$$$0(0);
        }
        return "groovy.FILE";
    }

    public void serialize(@NotNull GrFileStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            GrStubFileElementType.$$$reportNull$$$0(1);
        }
        if (dataStream == null) {
            GrStubFileElementType.$$$reportNull$$$0(2);
        }
        dataStream.writeName(stub.getName().toString());
        dataStream.writeBoolean(stub.isScript());
        GrStubUtils.writeStringArray(dataStream, stub.getAnnotations());
    }

    @NotNull
    public GrFileStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            GrStubFileElementType.$$$reportNull$$$0(3);
        }
        StringRef name = dataStream.readName();
        boolean isScript = dataStream.readBoolean();
        GrFileStub grFileStub = new GrFileStub(name, isScript, GrStubUtils.readStringArray(dataStream));
        if (grFileStub == null) {
            GrStubFileElementType.$$$reportNull$$$0(4);
        }
        return grFileStub;
    }

    public void indexStub(@NotNull GrFileStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            GrStubFileElementType.$$$reportNull$$$0(5);
        }
        if (sink == null) {
            GrStubFileElementType.$$$reportNull$$$0(6);
        }
        String name = stub.getName().toString();
        if (stub.isScript() && name != null) {
            sink.occurrence(GrScriptClassNameIndex.KEY, (Object)name);
            String pName = GrStubUtils.getPackageName(stub);
            String fqn = StringUtil.isEmpty((String)pName) ? name : pName + "." + name;
            sink.occurrence(GrFullScriptNameIndex.KEY, (Object)fqn.hashCode());
        }
        for (String anno : stub.getAnnotations()) {
            sink.occurrence(GrAnnotatedMemberIndex.KEY, (Object)anno);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrStubFileElementType";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrStubFileElementType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

