/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import java.beans.Introspector;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00062\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0000\u001a\u0012\u0010\u000b\u001a\u00020\u0003*\u00020\u00012\u0006\u0010\f\u001a\u00020\u0003\u001a\u000e\u0010\r\u001a\u00020\b*\u0004\u0018\u00010\u000eH\u0002\u001a\f\u0010\u000f\u001a\u00020\b*\u00020\u0003H\u0000\u00a8\u0006\u0010"}, d2={"getKindByAccessorName", "Lcom/intellij/lang/java/beans/PropertyKind;", "accessorName", "", "getKindInternal", "getNameAndKind", "Lkotlin/Pair;", "checkKind", "", "Lcom/intellij/psi/PsiMethod;", "kind", "getAccessorName", "propertyName", "isBooleanOrBoxed", "Lcom/intellij/psi/PsiType;", "isPropertyName", "intellij.groovy.psi"})
public final class PropertyUtilKt {
    @Nullable
    public static final PropertyKind getKindByAccessorName(@NotNull String accessorName) {
        Intrinsics.checkParameterIsNotNull((Object)accessorName, (String)"accessorName");
        PropertyKind propertyKind = PropertyUtilKt.getKindInternal(accessorName);
        if (propertyKind == null) {
            return null;
        }
        PropertyKind propertyKind2 = propertyKind;
        int prefixLength = propertyKind2.prefix.length();
        char c = accessorName.charAt(prefixLength);
        if (Character.isUpperCase(c)) {
            return propertyKind2;
        }
        if (accessorName.length() > prefixLength + 1 && Character.isUpperCase(c = accessorName.charAt(prefixLength + 1))) {
            return propertyKind2;
        }
        return null;
    }

    @Nullable
    public static final Pair<PropertyKind, String> getNameAndKind(@NotNull String accessorName) {
        Intrinsics.checkParameterIsNotNull((Object)accessorName, (String)"accessorName");
        PropertyKind propertyKind = PropertyUtilKt.getKindByAccessorName(accessorName);
        if (propertyKind == null) {
            return null;
        }
        PropertyKind propertyKind2 = propertyKind;
        String string = accessorName;
        int n = propertyKind2.prefix.length();
        String string2 = string.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        String propertyName = Introspector.decapitalize(string2);
        return TuplesKt.to((Object)propertyKind2, (Object)propertyName);
    }

    private static final PropertyKind getKindInternal(String accessorName) {
        for (PropertyKind kind : PropertyKind.values()) {
            String prefix = kind.prefix;
            int prefixLength = prefix.length();
            String string = prefix;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"prefix");
            if (!StringsKt.startsWith$default((String)accessorName, (String)string, (boolean)false, (int)2, null) || accessorName.length() <= prefixLength) continue;
            return kind;
        }
        return null;
    }

    public static final boolean checkKind(@NotNull PsiMethod $receiver, @NotNull PropertyKind kind) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        int expectedParamCount = kind == PropertyKind.SETTER ? 1 : 0;
        PsiParameterList psiParameterList = $receiver.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"parameterList");
        if (psiParameterList.getParametersCount() != expectedParamCount) {
            return false;
        }
        if (Intrinsics.areEqual((Object)kind, (Object)PropertyKind.GETTER) && Intrinsics.areEqual((Object)$receiver.getReturnType(), (Object)PsiType.VOID)) {
            return false;
        }
        return !Intrinsics.areEqual((Object)kind, (Object)PropertyKind.BOOLEAN_GETTER) || PropertyUtilKt.isBooleanOrBoxed($receiver.getReturnType());
    }

    private static final boolean isBooleanOrBoxed(@Nullable PsiType $receiver) {
        return Intrinsics.areEqual((Object)$receiver, (Object)PsiType.BOOLEAN) || Intrinsics.areEqual((Object)PsiPrimitiveType.getUnboxedType((PsiType)$receiver), (Object)PsiType.BOOLEAN);
    }

    public static final boolean isPropertyName(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return GroovyPropertyUtils.isPropertyName($receiver);
    }

    @NotNull
    public static final String getAccessorName(@NotNull PropertyKind $receiver, @NotNull String propertyName) {
        char c;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        String suffix = propertyName.length() > 1 && Character.isUpperCase(c = propertyName.charAt(1)) ? propertyName : StringsKt.capitalize((String)propertyName);
        return $receiver.prefix + suffix;
    }
}

