/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiTreeUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.ClassResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.ElementGroovyResult;
import org.jetbrains.plugins.groovy.lang.resolve.GrCodeReferenceResolverKt;
import org.jetbrains.plugins.groovy.lang.resolve.GrReferenceResolveRunner;
import org.jetbrains.plugins.groovy.lang.resolve.OwnerKt;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.CodeFieldProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolverProcessorBuilder;
import org.jetbrains.plugins.groovy.lang.resolve.processors.LocalVariableProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ReferenceExpressionClassProcessor;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000P\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u000e\u0010\u0006\u001a\u0004\u0018\u00010\u0005*\u00020\u0007H\u0002\u001a!\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t*\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\r\u001a\u000e\u0010\u000e\u001a\u0004\u0018\u00010\n*\u00020\u0007H\u0002\u001a \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0010*\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001\u001a\u0012\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0010*\u00020\u0007H\u0002\u001a \u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00150\u0010*\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a \u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00150\u0010*\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b*\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u001d"}, d2={"checkCurrentClass", "", "field", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrField;", "place", "Lcom/intellij/psi/PsiElement;", "doResolvePackageOrClass", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "getCallVariants", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "upToArgument", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;)[Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "resolvePackageOrClass", "resolveReferenceExpression", "", "forceRValue", "incomplete", "resolveStatic", "resolveToField", "Lorg/jetbrains/plugins/groovy/lang/resolve/ElementGroovyResult;", "name", "", "resolveToLocalVariable", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrVariable;", "resolveUnqualifiedType", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/ClassResolveResult;", "intellij.groovy.psi"})
public final class GrReferenceResolveRunnerKt {
    @NotNull
    public static final GroovyResolveResult[] getCallVariants(@NotNull GrReferenceExpression $receiver, @Nullable GrExpression upToArgument) {
        GroovyResolverProcessor processor;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        GroovyResolverProcessor groovyResolverProcessor = processor = GroovyResolverProcessorBuilder.builder().setAllVariants(true).setUpToArgument(upToArgument).build($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)groovyResolverProcessor, (String)"processor");
        new GrReferenceResolveRunner($receiver, groovyResolverProcessor).resolveReferenceExpression();
        GroovyResolveResult[] groovyResolveResultArray = processor.getCandidatesArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)groovyResolveResultArray, (String)"processor.candidatesArray");
        return groovyResolveResultArray;
    }

    @NotNull
    public static final Collection<GroovyResolveResult> resolveReferenceExpression(@NotNull GrReferenceExpression $receiver, boolean forceRValue, boolean incomplete) {
        GroovyResolverProcessor processor;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        GroovyResolveResult groovyResolveResult = GrReferenceResolveRunnerKt.resolvePackageOrClass($receiver);
        if (groovyResolveResult != null) {
            GroovyResolveResult groovyResolveResult2;
            GroovyResolveResult it = groovyResolveResult2 = groovyResolveResult;
            return CollectionsKt.listOf((Object)it);
        }
        Collection<GroovyResolveResult> staticResults = GrReferenceResolveRunnerKt.resolveStatic($receiver);
        Collection<GroovyResolveResult> it = staticResults;
        if (!it.isEmpty()) {
            return staticResults;
        }
        if (!ResolveUtil.canResolveToMethod($receiver) && ResolveUtil.isDefinitelyKeyOfMap($receiver)) {
            return CollectionsKt.emptyList();
        }
        GroovyResolverProcessor groovyResolverProcessor = processor = GroovyResolverProcessorBuilder.builder().setForceRValue(forceRValue).setIncomplete(incomplete).build($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)groovyResolverProcessor, (String)"processor");
        new GrReferenceResolveRunner($receiver, groovyResolverProcessor).resolveReferenceExpression();
        List<GroovyResolveResult> list = processor.getCandidates();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"processor.candidates");
        return list;
    }

    private static final GroovyResolveResult resolvePackageOrClass(@NotNull GrReferenceExpression $receiver) {
        GroovyResolveResultImpl groovyResolveResultImpl;
        PsiElement psiElement = GrReferenceResolveRunnerKt.doResolvePackageOrClass($receiver);
        if (psiElement != null) {
            PsiElement psiElement2;
            PsiElement it = psiElement2 = psiElement;
            groovyResolveResultImpl = new GroovyResolveResultImpl(it, true);
        } else {
            groovyResolveResultImpl = null;
        }
        return groovyResolveResultImpl;
    }

    private static final PsiElement doResolvePackageOrClass(@NotNull GrReferenceExpression $receiver) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)$receiver.getProject());
        GlobalSearchScope scope = $receiver.getResolveScope();
        Function1<GrReferenceExpression, PsiClass> resolveClass$ = new Function1<GrReferenceExpression, PsiClass>(facade, scope){
            final /* synthetic */ JavaPsiFacade $facade;
            final /* synthetic */ GlobalSearchScope $scope;

            @Nullable
            public final PsiClass invoke(@NotNull GrReferenceExpression $receiver) {
                char c;
                String name;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                if ($receiver.getParent() instanceof GrMethodCall) {
                    return null;
                }
                String string = $receiver.getReferenceName();
                if (string == null) {
                    return null;
                }
                String string2 = name = string;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
                CharSequence charSequence = string2;
                if (charSequence.length() == 0 || !Character.isUpperCase(c = StringsKt.first((CharSequence)name))) {
                    return null;
                }
                String string3 = $receiver.getQualifiedReferenceName();
                if (string3 == null) {
                    return null;
                }
                String qname = string3;
                return this.$facade.findClass(qname, this.$scope);
            }
            {
                this.$facade = javaPsiFacade;
                this.$scope = globalSearchScope;
                super(1);
            }
        };
        if ($receiver.isQualified()) {
            PsiClass psiClass = resolveClass$.invoke($receiver);
            if (psiClass != null) {
                PsiClass psiClass2;
                PsiClass it = psiClass2 = psiClass;
                return (PsiElement)it;
            }
        }
        for (PsiElement parent : SequencesKt.drop((Sequence)com.intellij.psi.util.PsiTreeUtilKt.parents((PsiElement)$receiver), (int)1)) {
            if (!(parent instanceof GrReferenceExpression)) {
                return null;
            }
            if (resolveClass$.invoke((GrReferenceExpression)parent) == null) continue;
            String string = $receiver.getQualifiedReferenceName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String qname = string;
            return (PsiElement)facade.findPackage(qname);
        }
        return null;
    }

    private static final Collection<GroovyResolveResult> resolveStatic(@NotNull GrReferenceExpression $receiver) {
        String string = $receiver.getReferenceName();
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String name = string;
        GrExpression qualifier = (GrExpression)$receiver.getQualifier();
        if (qualifier == null) {
            PsiElement psiElement = $receiver;
            String string2 = name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
            Collection<GroovyResolveResult> locals = GrReferenceResolveRunnerKt.resolveToLocalVariable(psiElement, string2);
            if (locals.size() == 1) {
                return locals;
            }
        }
        if (!($receiver.getParent() instanceof GrMethodCall)) {
            if (qualifier == null || PsiUtilKt.isThisExpression(qualifier)) {
                PsiElement psiElement = $receiver;
                String string3 = name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"name");
                Collection<GroovyResolveResult> fields = GrReferenceResolveRunnerKt.resolveToField(psiElement, string3);
                ElementGroovyResult field = (ElementGroovyResult)CollectionsKt.singleOrNull((Iterable)fields);
                if (field != null && GrReferenceResolveRunnerKt.checkCurrentClass((GrField)field.getElement(), $receiver)) {
                    return fields;
                }
            }
            if (qualifier == null) {
                PsiElement psiElement = $receiver;
                String string4 = name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"name");
                List<ClassResolveResult> classes2 = GrReferenceResolveRunnerKt.resolveUnqualifiedType(psiElement, string4);
                Collection collection = classes2;
                if (!collection.isEmpty()) {
                    return classes2;
                }
            }
        }
        return CollectionsKt.emptyList();
    }

    private static final Collection<ElementGroovyResult<GrVariable>> resolveToLocalVariable(@NotNull PsiElement $receiver, String name) {
        return PsiTreeUtilKt.treeWalkUpAndGet($receiver, new LocalVariableProcessor(name));
    }

    private static final Collection<ElementGroovyResult<GrField>> resolveToField(@NotNull PsiElement $receiver, String name) {
        return PsiTreeUtilKt.treeWalkUpAndGet($receiver, new CodeFieldProcessor(name, $receiver));
    }

    private static final boolean checkCurrentClass(GrField field, PsiElement place) {
        PsiClass psiClass = field.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        PsiClass containingClass = psiClass;
        return Intrinsics.areEqual((Object)containingClass, (Object)OwnerKt.getOwner(place));
    }

    private static final List<ClassResolveResult> resolveUnqualifiedType(@NotNull PsiElement $receiver, String name) {
        ReferenceExpressionClassProcessor processor = new ReferenceExpressionClassProcessor(name, $receiver);
        PsiScopeProcessor psiScopeProcessor = processor;
        ResolveState resolveState = ResolveState.initial();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolveState, (String)"ResolveState.initial()");
        GrCodeReferenceResolverKt.processUnqualified($receiver, psiScopeProcessor, resolveState);
        return processor.getResults();
    }
}

