/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.resolve.AnnotationHint;
import org.jetbrains.plugins.groovy.lang.resolve.ClassResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyImports;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.FindFirstProcessor;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/ClassProcessor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/FindFirstProcessor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/ClassResolveResult;", "name", "", "place", "Lcom/intellij/psi/PsiElement;", "typeArguments", "", "Lcom/intellij/psi/PsiType;", "annotationResolve", "", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;[Lcom/intellij/psi/PsiType;Z)V", "[Lcom/intellij/psi/PsiType;", "result", "element", "state", "Lcom/intellij/psi/ResolveState;", "intellij.groovy.psi"})
public class ClassProcessor
extends FindFirstProcessor<ClassResolveResult> {
    private final PsiElement place;
    private final PsiType[] typeArguments;

    @Override
    @Nullable
    protected ClassResolveResult result(@NotNull PsiElement element, @NotNull ResolveState state) {
        String elementName;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        PsiElement psiElement = element;
        if (!(psiElement instanceof PsiClass)) {
            psiElement = null;
        }
        PsiClass psiClass = (PsiClass)psiElement;
        if (psiClass == null) {
            return null;
        }
        PsiClass clazz = psiClass;
        if (clazz instanceof PsiTypeParameter) {
            return null;
        }
        String string = (String)state.get(GroovyImports.getImportedNameKey());
        if (string == null) {
            string = elementName = ((PsiClass)element).getName();
        }
        if (Intrinsics.areEqual((Object)elementName, (Object)this.getName()) ^ true) {
            return null;
        }
        PsiSubstitutor psiSubstitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
        if (psiSubstitutor == null) {
            PsiSubstitutor psiSubstitutor2 = PsiSubstitutor.EMPTY;
            psiSubstitutor = psiSubstitutor2;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor2, (String)"PsiSubstitutor.EMPTY");
        }
        PsiSubstitutor substitutor = psiSubstitutor;
        PsiElement psiElement2 = (PsiElement)state.get(ClassHint.RESOLVE_CONTEXT);
        PsiSubstitutor psiSubstitutor3 = substitutor.putAll(clazz, this.typeArguments);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor3, (String)"substitutor.putAll(clazz, typeArguments)");
        return new ClassResolveResult(clazz, this.place, psiElement2, psiSubstitutor3);
    }

    public ClassProcessor(@NotNull String name, @Nullable PsiElement place, @NotNull PsiType[] typeArguments, boolean annotationResolve) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)typeArguments, (String)"typeArguments");
        super(name);
        this.place = place;
        this.typeArguments = typeArguments;
        this.hint(ElementClassHint.KEY, ClassHint.CLASSES);
        if (annotationResolve) {
            this.hint(AnnotationHint.HINT_KEY, AnnotationHint.ANNOTATION_RESOLVE);
        }
    }

    public /* synthetic */ ClassProcessor(String string, PsiElement psiElement, PsiType[] psiTypeArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Intrinsics.checkExpressionValueIsNotNull((Object)PsiType.EMPTY_ARRAY, (String)"PsiType.EMPTY_ARRAY");
            psiTypeArray = PsiType.EMPTY_ARRAY;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(string, psiElement, psiTypeArray, bl);
    }
}

