/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.resolve.GrMethodComparator;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolveKind;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolverProcessor;

class GroovyResolverProcessorImpl
extends GroovyResolverProcessor
implements GrMethodComparator.Context {
    private final boolean myIsPartOfFqn;

    GroovyResolverProcessorImpl(@NotNull GrReferenceExpression ref, @NotNull EnumSet<GroovyResolveKind> kinds, boolean forceRValue) {
        if (ref == null) {
            GroovyResolverProcessorImpl.$$$reportNull$$$0(0);
        }
        if (kinds == null) {
            GroovyResolverProcessorImpl.$$$reportNull$$$0(1);
        }
        super(ref, kinds, null, forceRValue);
        this.myIsPartOfFqn = ResolveUtil.isPartOfFQN(ref);
    }

    @Override
    @NotNull
    public List<GroovyResolveResult> getCandidates() {
        List<GroovyResolveResult> candidates = this.getCandidates(GroovyResolveKind.VARIABLE);
        if (!candidates.isEmpty()) {
            List<GroovyResolveResult> list = candidates;
            if (list == null) {
                GroovyResolverProcessorImpl.$$$reportNull$$$0(2);
            }
            return list;
        }
        candidates = this.getCandidates(GroovyResolveKind.METHOD);
        if (!candidates.isEmpty()) {
            List<GroovyResolveResult> results2 = this.filterMethodCandidates(candidates);
            List<GroovyResolveResult> list = this.myRef.hasMemberPointer() ? ResolveUtil.collapseReflectedMethods(results2) : results2;
            if (list == null) {
                GroovyResolverProcessorImpl.$$$reportNull$$$0(3);
            }
            return list;
        }
        candidates = this.getCandidates(GroovyResolveKind.ENUM_CONST);
        if (!candidates.isEmpty()) {
            List<GroovyResolveResult> list = candidates;
            if (list == null) {
                GroovyResolverProcessorImpl.$$$reportNull$$$0(4);
            }
            return list;
        }
        if (this.myIsPartOfFqn && !(candidates = this.getCandidates(GroovyResolveKind.PACKAGE, GroovyResolveKind.CLASS)).isEmpty()) {
            List<GroovyResolveResult> list = candidates;
            if (list == null) {
                GroovyResolverProcessorImpl.$$$reportNull$$$0(5);
            }
            return list;
        }
        candidates = this.getCandidates(GroovyResolveKind.PROPERTY);
        if (!candidates.isEmpty()) {
            List<GroovyResolveResult> list = candidates.size() <= 1 ? candidates : ContainerUtil.newSmartList((Object)candidates.get(0));
            if (list == null) {
                GroovyResolverProcessorImpl.$$$reportNull$$$0(6);
            }
            return list;
        }
        candidates = this.getCandidates(GroovyResolveKind.FIELD);
        if (!candidates.isEmpty()) {
            List<GroovyResolveResult> list = candidates;
            if (list == null) {
                GroovyResolverProcessorImpl.$$$reportNull$$$0(7);
            }
            return list;
        }
        candidates = this.getCandidates(GroovyResolveKind.PACKAGE, GroovyResolveKind.CLASS);
        if (!candidates.isEmpty()) {
            List<GroovyResolveResult> list = candidates;
            if (list == null) {
                GroovyResolverProcessorImpl.$$$reportNull$$$0(8);
            }
            return list;
        }
        candidates = this.getCandidates(GroovyResolveKind.PROPERTY);
        if (!candidates.isEmpty()) {
            List<GroovyResolveResult> list = candidates;
            if (list == null) {
                GroovyResolverProcessorImpl.$$$reportNull$$$0(9);
            }
            return list;
        }
        candidates = this.getCandidates(GroovyResolveKind.BINDING);
        if (!candidates.isEmpty()) {
            List<GroovyResolveResult> list = candidates;
            if (list == null) {
                GroovyResolverProcessorImpl.$$$reportNull$$$0(10);
            }
            return list;
        }
        for (GroovyResolveKind kind : this.myAcceptableKinds) {
            List<GroovyResolveResult> results3 = this.getCandidates(false, kind);
            if (results3.isEmpty()) continue;
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])ResolveUtil.filterSameSignatureCandidates(this.filterCorrectParameterCount(results3)));
            if (arrayList == null) {
                GroovyResolverProcessorImpl.$$$reportNull$$$0(11);
            }
            return arrayList;
        }
        List<GroovyResolveResult> list = Collections.emptyList();
        if (list == null) {
            GroovyResolverProcessorImpl.$$$reportNull$$$0(12);
        }
        return list;
    }

    private List<GroovyResolveResult> filterCorrectParameterCount(Collection<GroovyResolveResult> candidates) {
        PsiType[] argumentTypes = (PsiType[])this.myArgumentTypes.getValue();
        if (argumentTypes == null) {
            return ContainerUtil.newArrayList(candidates);
        }
        List result = ContainerUtil.newSmartList();
        for (GroovyResolveResult candidate : candidates) {
            if (candidate instanceof GroovyMethodResult) {
                if (((GroovyMethodResult)candidate).getElement().getParameterList().getParametersCount() != argumentTypes.length) continue;
                result.add(candidate);
                continue;
            }
            result.add(candidate);
        }
        if (!result.isEmpty()) {
            return result;
        }
        return ContainerUtil.newArrayList(candidates);
    }

    private List<GroovyResolveResult> filterMethodCandidates(List<GroovyResolveResult> candidates) {
        if (candidates.size() <= 1) {
            return candidates;
        }
        ArrayList results2 = ContainerUtil.newArrayList();
        Iterator<GroovyResolveResult> itr = candidates.iterator();
        results2.add(itr.next());
        block0: while (itr.hasNext()) {
            GroovyResolveResult resolveResult = itr.next();
            if (resolveResult instanceof GroovyMethodResult) {
                Iterator iterator2 = results2.iterator();
                while (iterator2.hasNext()) {
                    GroovyResolveResult otherResolveResult = (GroovyResolveResult)iterator2.next();
                    if (!(otherResolveResult instanceof GroovyMethodResult)) continue;
                    int res = GrMethodComparator.compareMethods((GroovyMethodResult)resolveResult, (GroovyMethodResult)otherResolveResult, this);
                    if (res > 0) continue block0;
                    if (res >= 0) continue;
                    iterator2.remove();
                }
            }
            results2.add(resolveResult);
        }
        return results2;
    }

    @Override
    @Nullable
    public PsiType[] getArgumentTypes() {
        return (PsiType[])this.myArgumentTypes.getValue();
    }

    @Override
    @Nullable
    public PsiType[] getTypeArguments() {
        return this.myTypeArguments;
    }

    @Override
    @Nullable
    public PsiType getThisType() {
        return this.myThisType;
    }

    @Override
    @NotNull
    public PsiElement getPlace() {
        GrReferenceExpression grReferenceExpression = this.myRef;
        if (grReferenceExpression == null) {
            GroovyResolverProcessorImpl.$$$reportNull$$$0(13);
        }
        return grReferenceExpression;
    }

    @Override
    public boolean isConstructor() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidates";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

