/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.typing;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.DelegatesToInfo;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToUtilKt;
import org.jetbrains.plugins.groovy.lang.typing.GrTypeCalculator;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/groovy/lang/typing/GrClosureOwnerDelegateTypeCalculator;", "Lorg/jetbrains/plugins/groovy/lang/typing/GrTypeCalculator;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "()V", "getType", "Lcom/intellij/psi/PsiType;", "expression", "intellij.groovy.psi"})
public final class GrClosureOwnerDelegateTypeCalculator
implements GrTypeCalculator<GrReferenceExpression> {
    @Override
    @Nullable
    public PsiType getType(@NotNull GrReferenceExpression expression) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        PsiElement psiElement = expression.resolve();
        if (!(psiElement instanceof PsiMethod)) {
            psiElement = null;
        }
        PsiMethod psiMethod = (PsiMethod)psiElement;
        if (psiMethod == null) {
            return null;
        }
        PsiMethod method = psiMethod;
        String methodName = method.getName();
        boolean delegate = Intrinsics.areEqual((Object)"getDelegate", (Object)methodName);
        if (!delegate && Intrinsics.areEqual((Object)"getOwner", (Object)methodName) ^ true) {
            return null;
        }
        PsiParameterList psiParameterList = method.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
        if (psiParameterList.getParametersCount() != 0) {
            return null;
        }
        PsiClass closureClass = JavaPsiFacade.getInstance((Project)expression.getProject()).findClass("groovy.lang.Closure", expression.getResolveScope());
        if (closureClass == null || Intrinsics.areEqual((Object)closureClass, (Object)method.getContainingClass()) ^ true) {
            return null;
        }
        GrClosableBlock grClosableBlock = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)expression, GrClosableBlock.class);
        if (grClosableBlock == null) {
            return null;
        }
        GrClosableBlock closure = grClosableBlock;
        if (delegate) {
            GrClosableBlock grClosableBlock2 = closure;
            Intrinsics.checkExpressionValueIsNotNull((Object)grClosableBlock2, (String)"closure");
            DelegatesToInfo delegatesToInfo = GrDelegatesToUtilKt.getDelegatesToInfo(grClosableBlock2);
            object = delegatesToInfo != null ? delegatesToInfo.getTypeToDelegate() : null;
        } else {
            GrClosableBlock grClosableBlock3 = closure;
            Intrinsics.checkExpressionValueIsNotNull((Object)grClosableBlock3, (String)"closure");
            object = grClosableBlock3.getOwnerType();
        }
        return object;
    }
}

