/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.ThreadLocalCachedByteArray;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.text.StringFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import org.iq80.snappy.CorruptionException;
import org.iq80.snappy.Snappy;
import org.jetbrains.annotations.NotNull;

public class CompressionUtil {
    private static final int COMPRESSION_THRESHOLD = 64;
    private static final ThreadLocalCachedByteArray spareBufferLocal = new ThreadLocalCachedByteArray();
    private static final AtomicInteger myCompressionRequests = new AtomicInteger();
    private static final AtomicLong myCompressionTime = new AtomicLong();
    private static final AtomicInteger myDecompressionRequests = new AtomicInteger();
    private static final AtomicLong myDecompressionTime = new AtomicLong();
    private static final AtomicLong myDecompressedSize = new AtomicLong();
    private static final AtomicLong mySizeBeforeCompression = new AtomicLong();
    private static final AtomicLong mySizeAfterCompression = new AtomicLong();
    public static final boolean DUMP_COMPRESSION_STATS = SystemProperties.getBooleanProperty("idea.dump.compression.stats", false);
    public static final boolean USE_SNAPPY = SystemProperties.getBooleanProperty("idea.use.snappy", false);
    private static final int STRING_COMPRESSION_THRESHOLD = 1024;

    public static int writeCompressed(@NotNull DataOutput out, @NotNull byte[] bytes, int start, int length) throws IOException {
        byte[] compressedOutputBuffer;
        int compressedSize;
        if (out == null) {
            CompressionUtil.$$$reportNull$$$0(0);
        }
        if (bytes == null) {
            CompressionUtil.$$$reportNull$$$0(1);
        }
        if (length > 64 && (compressedSize = Snappy.compress((byte[])bytes, (int)start, (int)length, (byte[])(compressedOutputBuffer = spareBufferLocal.getBuffer(Snappy.maxCompressedLength((int)length))), (int)0)) < length) {
            DataInputOutputUtil.writeINT(out, -compressedSize);
            out.write(compressedOutputBuffer, 0, compressedSize);
            return compressedSize;
        }
        DataInputOutputUtil.writeINT(out, length);
        out.write(bytes, start, length);
        return length;
    }

    public static int writeCompressedWithoutOriginalBufferLength(@NotNull DataOutput out, @NotNull byte[] bytes, int length) throws IOException {
        int compressedSize;
        byte[] compressedOutputBuffer;
        long started;
        if (out == null) {
            CompressionUtil.$$$reportNull$$$0(2);
        }
        if (bytes == null) {
            CompressionUtil.$$$reportNull$$$0(3);
        }
        long l = started = DUMP_COMPRESSION_STATS ? System.nanoTime() : 0L;
        if (USE_SNAPPY) {
            compressedOutputBuffer = spareBufferLocal.getBuffer(Snappy.maxCompressedLength((int)length));
            compressedSize = Snappy.compress((byte[])bytes, (int)0, (int)length, (byte[])compressedOutputBuffer, (int)0);
        } else {
            LZ4Compressor compressor = LZ4Factory.fastestJavaInstance().fastCompressor();
            compressedOutputBuffer = spareBufferLocal.getBuffer(compressor.maxCompressedLength(length));
            compressedSize = compressor.compress(bytes, 0, length, compressedOutputBuffer, 0);
        }
        long time = (DUMP_COMPRESSION_STATS ? System.nanoTime() : 0L) - started;
        mySizeAfterCompression.addAndGet(compressedSize);
        mySizeBeforeCompression.addAndGet(length);
        int requests = myCompressionRequests.incrementAndGet();
        long l2 = myCompressionTime.addAndGet(time);
        if (DUMP_COMPRESSION_STATS && (requests & 0x1FFF) == 0) {
            System.out.println("Compressed " + requests + " times, size:" + mySizeBeforeCompression + "->" + mySizeAfterCompression + " for " + l2 / 1000000L + "ms");
        }
        DataInputOutputUtil.writeINT(out, compressedSize);
        out.write(compressedOutputBuffer, 0, compressedSize);
        return compressedSize;
    }

    @NotNull
    public static byte[] readCompressedWithoutOriginalBufferLength(@NotNull DataInput in, int originalBufferLength) throws IOException {
        if (in == null) {
            CompressionUtil.$$$reportNull$$$0(4);
        }
        int size = DataInputOutputUtil.readINT(in);
        byte[] bytes = spareBufferLocal.getBuffer(size);
        in.readFully(bytes, 0, size);
        int decompressedRequests = myDecompressionRequests.incrementAndGet();
        long started = DUMP_COMPRESSION_STATS ? System.nanoTime() : 0L;
        byte[] decompressedResult = USE_SNAPPY ? Snappy.uncompress((byte[])bytes, (int)0, (int)size) : LZ4Factory.fastestJavaInstance().fastDecompressor().decompress(bytes, 0, originalBufferLength);
        long doneTime = (DUMP_COMPRESSION_STATS ? System.nanoTime() : 0L) - started;
        long decompressedSize = myDecompressedSize.addAndGet(size);
        long decompressedTime = myDecompressionTime.addAndGet(doneTime);
        if (DUMP_COMPRESSION_STATS && (decompressedRequests & 0x1FFF) == 0) {
            System.out.println("Decompressed " + decompressedRequests + " times, size: " + decompressedSize + " for " + decompressedTime / 1000000L + "ms");
        }
        if (decompressedResult == null) {
            CompressionUtil.$$$reportNull$$$0(5);
        }
        return decompressedResult;
    }

    @NotNull
    public static byte[] readCompressed(@NotNull DataInput in) throws IOException {
        int size;
        if (in == null) {
            CompressionUtil.$$$reportNull$$$0(6);
        }
        if ((size = DataInputOutputUtil.readINT(in)) < 0) {
            byte[] bytes = spareBufferLocal.getBuffer(-size);
            in.readFully(bytes, 0, -size);
            byte[] byArray = Snappy.uncompress((byte[])bytes, (int)0, (int)(-size));
            if (byArray == null) {
                CompressionUtil.$$$reportNull$$$0(7);
            }
            return byArray;
        }
        byte[] bytes = new byte[size];
        in.readFully(bytes);
        if (bytes == null) {
            CompressionUtil.$$$reportNull$$$0(8);
        }
        return bytes;
    }

    @NotNull
    public static CharSequence uncompressCharSequence(@NotNull Object string, @NotNull Charset charset) {
        String string2;
        block6: {
            if (string == null) {
                CompressionUtil.$$$reportNull$$$0(9);
            }
            if (charset == null) {
                CompressionUtil.$$$reportNull$$$0(10);
            }
            if (string instanceof CharSequence) {
                CharSequence charSequence = (CharSequence)string;
                if (charSequence == null) {
                    CompressionUtil.$$$reportNull$$$0(11);
                }
                return charSequence;
            }
            byte[] b = (byte[])string;
            try {
                int uncompressedLength = Snappy.getUncompressedLength((byte[])b, (int)0);
                byte[] bytes = spareBufferLocal.getBuffer(uncompressedLength);
                int bytesLength = Snappy.uncompress((byte[])b, (int)0, (int)b.length, (byte[])bytes, (int)0);
                string2 = new String(bytes, 0, bytesLength, charset);
                if (string2 != null) break block6;
            }
            catch (CorruptionException ex) {
                throw new RuntimeException(ex);
            }
            CompressionUtil.$$$reportNull$$$0(12);
        }
        return string2;
    }

    @NotNull
    public static Object compressCharSequence(@NotNull CharSequence string, @NotNull Charset charset) {
        byte[] byArray;
        if (string == null) {
            CompressionUtil.$$$reportNull$$$0(13);
        }
        if (charset == null) {
            CompressionUtil.$$$reportNull$$$0(14);
        }
        if (string.length() < 1024) {
            if (string instanceof CharBuffer && ((CharBuffer)string).capacity() > 1024) {
                string = string.toString();
            }
            CharSequence charSequence = string;
            if (charSequence == null) {
                CompressionUtil.$$$reportNull$$$0(15);
            }
            return charSequence;
        }
        try {
            byArray = Snappy.compress((byte[])string.toString().getBytes(charset));
        }
        catch (CorruptionException ex) {
            ex.printStackTrace();
            CharSequence charSequence = string;
            if (charSequence == null) {
                CompressionUtil.$$$reportNull$$$0(17);
            }
            return charSequence;
        }
        if (byArray == null) {
            CompressionUtil.$$$reportNull$$$0(16);
        }
        return byArray;
    }

    @NotNull
    public static Object compressStringRawBytes(@NotNull CharSequence string) {
        Object object;
        int length;
        if (string == null) {
            CompressionUtil.$$$reportNull$$$0(18);
        }
        if ((length = string.length()) < 1024) {
            if (string instanceof CharBuffer && ((CharBuffer)string).capacity() > 1024) {
                string = string.toString();
            }
            CharSequence charSequence = string;
            if (charSequence == null) {
                CompressionUtil.$$$reportNull$$$0(19);
            }
            return charSequence;
        }
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream(length);
            DataOutputStream out = new DataOutputStream(bytes);
            DataInputOutputUtil.writeINT(out, length);
            for (int i = 0; i < length; ++i) {
                char c = string.charAt(i);
                DataInputOutputUtil.writeINT(out, c);
            }
            byte[] compressedBytes = Snappy.compress((byte[])bytes.toByteArray());
            object = compressedBytes.length < length * 2 ? compressedBytes : (Object)string;
        }
        catch (CorruptionException ex) {
            ex.printStackTrace();
            CharSequence charSequence = string;
            if (charSequence == null) {
                CompressionUtil.$$$reportNull$$$0(21);
            }
            return charSequence;
        }
        catch (IOException e) {
            e.printStackTrace();
            CharSequence charSequence = string;
            if (charSequence == null) {
                CompressionUtil.$$$reportNull$$$0(22);
            }
            return charSequence;
        }
        if (object == null) {
            CompressionUtil.$$$reportNull$$$0(20);
        }
        return object;
    }

    @NotNull
    public static CharSequence uncompressStringRawBytes(@NotNull Object compressed) {
        String string;
        if (compressed == null) {
            CompressionUtil.$$$reportNull$$$0(23);
        }
        if (compressed instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)compressed;
            if (charSequence == null) {
                CompressionUtil.$$$reportNull$$$0(24);
            }
            return charSequence;
        }
        byte[] b = (byte[])compressed;
        try {
            int uncompressedLength = Snappy.getUncompressedLength((byte[])b, (int)0);
            byte[] bytes = spareBufferLocal.getBuffer(uncompressedLength);
            int bytesLength = Snappy.uncompress((byte[])b, (int)0, (int)b.length, (byte[])bytes, (int)0);
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes, 0, bytesLength);
            DataInputStream in = new DataInputStream(byteStream);
            int len = DataInputOutputUtil.readINT(in);
            char[] chars = new char[len];
            for (int i = 0; i < len; ++i) {
                int c = DataInputOutputUtil.readINT(in);
                chars[i] = (char)c;
            }
            string = StringFactory.createShared(chars);
        }
        catch (CorruptionException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (string == null) {
            CompressionUtil.$$$reportNull$$$0(25);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/CompressionUtil";
                break;
            }
            case 9: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compressed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/CompressionUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readCompressedWithoutOriginalBufferLength";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "readCompressed";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "uncompressCharSequence";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "compressCharSequence";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "compressStringRawBytes";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "uncompressStringRawBytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeCompressed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeCompressedWithoutOriginalBufferLength";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readCompressedWithoutOriginalBufferLength";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readCompressed";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "uncompressCharSequence";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "compressCharSequence";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "compressStringRawBytes";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "uncompressStringRawBytes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

