/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.accessibility;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ReflectionUtil;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccessBridgeUtil {
    private static final Logger LOG = Logger.getInstance("#" + AccessBridgeUtil.class.getName());
    private static final String ACCESS_BRIDGE_CLASS_NAME = "com.sun.java.accessibility.AccessBridge";
    private static InstanceMethodEntry ourFocusGainedMethod;

    public static void sendFocusGainedEvent(@Nullable Component focusOwner) {
        if (focusOwner == null) {
            return;
        }
        if (ourFocusGainedMethod == null) {
            ourFocusGainedMethod = AccessBridgeUtil.createFocusGainedMethod();
        }
        try {
            FocusEvent event = new FocusEvent(focusOwner, 1004, false, null);
            ourFocusGainedMethod.invoke(event);
        }
        catch (Throwable e) {
            LOG.warn("Unexpected error invoking focusGained on the AccessBridge class", e);
        }
    }

    @NotNull
    private static InstanceMethodEntry createFocusGainedMethod() {
        InstanceMethodEntry instanceMethodEntry;
        block8: {
            Object theAccessBridge;
            Class accessBridgeClass;
            block7: {
                InstanceMethodEntry instanceMethodEntry2;
                accessBridgeClass = AccessBridgeUtil.findAccessBridgeClass();
                if (accessBridgeClass == null) {
                    InstanceMethodEntry instanceMethodEntry3 = InstanceMethodEntry.Empty;
                    if (instanceMethodEntry3 == null) {
                        AccessBridgeUtil.$$$reportNull$$$0(0);
                    }
                    return instanceMethodEntry3;
                }
                try {
                    Field theAccessBridgeField = ReflectionUtil.findField(accessBridgeClass, null, "theAccessBridge");
                    theAccessBridge = theAccessBridgeField.get(null);
                    if (theAccessBridge != null) break block7;
                    instanceMethodEntry2 = InstanceMethodEntry.Empty;
                }
                catch (Throwable e) {
                    LOG.warn("Unexpected error looking for the AccessBridge class", e);
                    InstanceMethodEntry instanceMethodEntry4 = InstanceMethodEntry.Empty;
                    if (instanceMethodEntry4 == null) {
                        AccessBridgeUtil.$$$reportNull$$$0(3);
                    }
                    return instanceMethodEntry4;
                }
                if (instanceMethodEntry2 == null) {
                    AccessBridgeUtil.$$$reportNull$$$0(1);
                }
                return instanceMethodEntry2;
            }
            Field eventHandlerField = ReflectionUtil.findField(accessBridgeClass, null, "eventHandler");
            Object eventHandler = eventHandlerField.get(theAccessBridge);
            Method method = ReflectionUtil.getMethod(eventHandler.getClass(), "focusGained", FocusEvent.class);
            instanceMethodEntry = new InstanceMethodEntry(eventHandler, method);
            if (instanceMethodEntry != null) break block8;
            AccessBridgeUtil.$$$reportNull$$$0(2);
        }
        return instanceMethodEntry;
    }

    @Nullable
    private static Class findAccessBridgeClass() {
        Method findLoadedClass = ReflectionUtil.getDeclaredMethod(ClassLoader.class, "findLoadedClass", String.class);
        for (ClassLoader cl = ClassLoader.getSystemClassLoader(); cl != null; cl = cl.getParent()) {
            try {
                Class cls = (Class)findLoadedClass.invoke((Object)cl, ACCESS_BRIDGE_CLASS_NAME);
                if (cls == null) continue;
                return cls;
            }
            catch (Throwable e) {
                LOG.warn("Unexpected error looking for the AccessBridge class", e);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/accessibility/AccessBridgeUtil", "createFocusGainedMethod"));
    }

    private static class InstanceMethodEntry {
        public static final InstanceMethodEntry Empty = new InstanceMethodEntry(null, null);
        private final Object myInstance;
        private final Method myMethod;

        public InstanceMethodEntry(@Nullable Object instance, @Nullable Method method) {
            this.myInstance = instance;
            this.myMethod = method;
        }

        public void invoke(@NotNull FocusEvent event) throws InvocationTargetException, IllegalAccessException {
            if (event == null) {
                InstanceMethodEntry.$$$reportNull$$$0(0);
            }
            if (this.myMethod == null) {
                return;
            }
            this.myMethod.invoke(this.myInstance, event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/ui/accessibility/AccessBridgeUtil$InstanceMethodEntry", "invoke"));
        }
    }
}

