/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.api;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.function.Function;

public class ApkOutputFile
implements OutputFile,
Serializable {
    private final Collection<FilterData> filters;
    private final Collection<String> filterTypes;
    private final OutputFile.OutputType outputType;
    private final Callable<File> outputFile;

    public ApkOutputFile(OutputFile.OutputType outputType, Collection<FilterData> filters, Callable<File> outputFile) {
        this.outputType = outputType;
        this.outputFile = outputFile;
        this.filters = filters;
        ImmutableList.Builder filterTypes = ImmutableList.builder();
        for (FilterData filter : filters) {
            filterTypes.add((Object)filter.getFilterType());
        }
        this.filterTypes = filterTypes.build();
    }

    public OutputFile.OutputType getType() {
        return this.outputType;
    }

    public File getOutputFile() {
        try {
            return this.outputFile.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getSplitIdentifiers(char separatorChar) {
        return Joiner.on((char)separatorChar).join(Iterables.transform(this.filters, FilterData::getIdentifier));
    }

    public Collection<FilterData> getFilters() {
        return this.filters;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("OutputType", (Object)this.outputType).add("Filters", (Object)Joiner.on((char)',').join(this.filters, (Object)new Function<FilterData, String>(){

            @Override
            public String apply(FilterData splitData) {
                return '[' + splitData.getFilterType() + ':' + splitData.getIdentifier() + ']';
            }
        }, new Object[0])).add("File", (Object)this.getOutputFile().getAbsolutePath()).toString();
    }

    public String getOutputType() {
        return this.outputType.name();
    }

    public Collection<String> getFilterTypes() {
        return this.filterTypes;
    }

    public String getFilterByType(OutputFile.FilterType filterType) {
        for (FilterData filter : this.filters) {
            if (!filter.getFilterType().equals(filterType.name())) continue;
            return filter.getIdentifier();
        }
        return null;
    }

    public String getFilter(String filterType) {
        return this.getFilterByType(OutputFile.FilterType.valueOf((String)filterType));
    }
}

