/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.builder.dependency.level2.Dependency;
import com.android.builder.dependency.level2.DependencyContainer;
import com.android.builder.dependency.level2.DependencyNode;
import com.android.builder.dependency.level2.JavaDependency;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.internal.graph.GraphRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.util.GUtil;

public class AndroidAsciiReportRenderer
extends TextReportRenderer {
    private boolean hasConfigs;
    private boolean hasCyclicDependencies;
    private GraphRenderer renderer;
    private Project project;

    public void startProject(Project project) {
        this.project = project;
        super.startProject(project);
        this.hasConfigs = false;
        this.hasCyclicDependencies = false;
    }

    public void completeProject(Project project) {
        if (!this.hasConfigs) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println((Object)"No dependencies");
        }
        super.completeProject(project);
    }

    public void startVariant(final BaseVariantData variantData) {
        if (this.hasConfigs) {
            this.getTextOutput().println();
        }
        this.hasConfigs = true;
        this.renderer = new GraphRenderer(this.getTextOutput());
        this.renderer.visit((Action)new Action<StyledTextOutput>(){

            public void execute(StyledTextOutput styledTextOutput) {
                AndroidAsciiReportRenderer.this.getTextOutput().withStyle(StyledTextOutput.Style.Identifier).text((Object)variantData.getVariantConfiguration().getFullName());
                AndroidAsciiReportRenderer.this.getTextOutput().withStyle(StyledTextOutput.Style.Description).text((Object)"");
            }
        }, true);
    }

    private String getDescription(Configuration configuration) {
        return GUtil.isTrue((Object)configuration.getDescription()) ? " - " + configuration.getDescription() : "";
    }

    public void render(BaseVariantData variantData) throws IOException {
        VariantDependencies variantDependency = variantData.getVariantDependency();
        this.renderNow(variantDependency.getCompileDependencies());
    }

    void renderNow(DependencyContainer compileDependencies) {
        ImmutableList dependencies = compileDependencies.getDependencies();
        if (dependencies.isEmpty()) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).text((Object)"No dependencies");
            this.getTextOutput().println();
            return;
        }
        this.renderChildren((List<DependencyNode>)dependencies, (Map<Object, Dependency>)compileDependencies.getDependencyMap());
    }

    public void complete() {
        if (this.hasCyclicDependencies) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println((Object)"\n(*) - dependencies omitted (listed previously)");
        }
        super.complete();
    }

    private void render(DependencyNode node, Map<Object, Dependency> dependencyMap, boolean lastChild) {
        this.renderer.visit(styledTextOutput -> {
            JavaDependency javaDependency;
            String name = node.getAddress().toString();
            Dependency dependency = (Dependency)dependencyMap.get(name);
            if (dependency instanceof JavaDependency && (javaDependency = (JavaDependency)dependency).isLocal()) {
                String path;
                name = path = FileUtils.relativePath((File)javaDependency.getArtifactFile(), (File)this.project.getProjectDir());
            }
            this.getTextOutput().text((Object)name);
        }, lastChild);
        this.renderChildren((List<DependencyNode>)node.getDependencies(), dependencyMap);
    }

    private void renderChildren(List<DependencyNode> dependencyNodes, Map<Object, Dependency> dependencyMap) {
        this.renderer.startChildren();
        int count = dependencyNodes.size();
        for (int i = 0; i < count; ++i) {
            DependencyNode node = dependencyNodes.get(i);
            this.render(node, dependencyMap, i == count - 1);
        }
        this.renderer.completeChildren();
    }
}

