/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.dependency.DependencyGraph;
import com.android.build.gradle.internal.dependency.MutableDependencyDataMap;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.tasks.PrepareDependenciesTask;
import com.android.build.gradle.internal.tasks.PrepareLibraryTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.builder.core.ErrorReporter;
import com.android.builder.dependency.MavenCoordinatesImpl;
import com.android.builder.dependency.level2.AndroidDependency;
import com.android.builder.dependency.level2.AtomDependency;
import com.android.builder.dependency.level2.DependencyNode;
import com.android.builder.dependency.level2.JavaDependency;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.sdk.SdkLibData;
import com.android.builder.utils.FileCache;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.SelfResolvingDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Specs;
import org.gradle.util.GUtil;

public class DependencyManager {
    private static final boolean DEBUG_DEPENDENCY = false;
    public static final String EXPLODED_AAR = "exploded-aar";
    private final Project project;
    private final ExtraModelInfo extraModelInfo;
    private final ILogger logger;
    private final SdkHandler sdkHandler;
    private SdkLibData sdkLibData = SdkLibData.dontDownload();
    private boolean repositoriesUpdated = false;
    private final Map<String, PrepareLibraryTask> prepareLibTaskMap = Maps.newHashMap();

    public DependencyManager(Project project, ExtraModelInfo extraModelInfo, SdkHandler sdkHandler) {
        this.project = project;
        this.extraModelInfo = extraModelInfo;
        this.sdkHandler = sdkHandler;
        this.logger = new LoggerWrapper(Logging.getLogger(DependencyManager.class));
    }

    public void addDependenciesToPrepareTask(TaskFactory tasks, BaseVariantData<? extends BaseVariantOutputData> variantData, AndroidTask<PrepareDependenciesTask> prepareDependenciesTask) {
        VariantDependencies variantDeps = variantData.getVariantDependency();
        AndroidTask<DefaultTask> preBuildTask = variantData.getScope().getPreBuildTask();
        ImmutableList compileLibraries = variantDeps.getCompileDependencies().getAllAndroidDependencies();
        ImmutableList packageLibraries = variantDeps.getPackageDependencies().getAllAndroidDependencies();
        ArrayList prepareLibraryTasks = Lists.newArrayListWithCapacity((int)(compileLibraries.size() + packageLibraries.size()));
        for (AndroidDependency dependency : Iterables.concat((Iterable)compileLibraries, (Iterable)packageLibraries)) {
            PrepareLibraryTask prepareLibTask;
            if (dependency.getProjectPath() != null || (prepareLibTask = this.prepareLibTaskMap.get(dependency.getCoordinates().toString())) == null) continue;
            prepareLibraryTasks.add(prepareLibTask);
            prepareLibTask.dependsOn(new Object[]{preBuildTask.getName()});
        }
        if (!prepareLibraryTasks.isEmpty()) {
            prepareDependenciesTask.dependsOn(tasks, prepareLibraryTasks.toArray());
        }
    }

    public Set<AndroidDependency> resolveDependencies(VariantDependencies variantDeps, String testedProjectPath) {
        Set libsToExplode = Sets.newIdentityHashSet();
        this.resolveDependencies(variantDeps, testedProjectPath, libsToExplode);
        return libsToExplode;
    }

    public void processLibraries(Set<AndroidDependency> libsToExplode) {
        for (AndroidDependency lib : libsToExplode) {
            this.maybeCreatePrepareLibraryTask(lib, this.project);
        }
    }

    private PrepareLibraryTask maybeCreatePrepareLibraryTask(AndroidDependency library, Project project) {
        if (library.isSubModule()) {
            throw new RuntimeException("Creating PrepareLib task for submodule: " + library.getCoordinates());
        }
        String key = library.getCoordinates().toString();
        PrepareLibraryTask prepareLibraryTask = this.prepareLibTaskMap.get(key);
        if (prepareLibraryTask == null) {
            String bundleName = GUtil.toCamelCase((CharSequence)library.getName().replaceAll("\\:", " "));
            prepareLibraryTask = (PrepareLibraryTask)project.getTasks().create("prepare" + bundleName + "Library", PrepareLibraryTask.class);
            prepareLibraryTask.setDescription("Prepare " + library.getName());
            prepareLibraryTask.setVariantName("");
            prepareLibraryTask.init(library.getArtifactFile(), library.getExtractedFolder(), AndroidGradleOptions.getBuildCache(project), library.getCoordinates());
            this.prepareLibTaskMap.put(key, prepareLibraryTask);
        }
        return prepareLibraryTask;
    }

    private void resolveDependencies(VariantDependencies variantDeps, String testedProjectPath, Set<AndroidDependency> libsToExplodeOut) {
        boolean needPackageScope = true;
        if (AndroidGradleOptions.buildModelOnly(this.project)) {
            Integer modelLevelInt = AndroidGradleOptions.buildModelOnlyVersion(this.project);
            int modelLevel = 0;
            if (modelLevelInt != null) {
                modelLevel = modelLevelInt;
            }
            if (modelLevel > 2) {
                needPackageScope = AndroidGradleOptions.buildModelWithFullDependencies(this.project);
            }
        }
        Configuration compileClasspath = variantDeps.getCompileConfiguration();
        Configuration packageClasspath = variantDeps.getPackageConfiguration();
        HashSet currentUnresolvedDependencies = Sets.newHashSet();
        HashSet artifactSet = Sets.newHashSet();
        DependencyGraph packagedGraph = needPackageScope ? this.resolveConfiguration(packageClasspath, variantDeps, libsToExplodeOut, currentUnresolvedDependencies, testedProjectPath, artifactSet, ScopeType.PACKAGE) : DependencyGraph.getEmpty();
        ScopeType scopeType = needPackageScope ? ScopeType.COMPILE : ScopeType.COMPILE_ONLY;
        DependencyGraph compileDependencies = this.resolveConfiguration(compileClasspath, variantDeps, libsToExplodeOut, currentUnresolvedDependencies, testedProjectPath, artifactSet, scopeType);
        if (this.extraModelInfo.getMode() != ErrorReporter.EvaluationMode.STANDARD && compileClasspath.getResolvedConfiguration().hasError()) {
            for (String dependency : currentUnresolvedDependencies) {
                this.extraModelInfo.handleSyncError(dependency, 2, String.format("Unable to resolve dependency '%s'", dependency));
            }
        }
        variantDeps.setDependencies(compileDependencies, packagedGraph, needPackageScope);
    }

    private DependencyGraph resolveConfiguration(Configuration configuration, VariantDependencies variantDeps, Set<AndroidDependency> libsToExplodeOut, Set<String> currentUnresolvedDependencies, String testedProjectPath, Set<String> artifactSet, ScopeType scopeType) {
        HashMap artifacts = Maps.newHashMap();
        configuration = this.collectArtifacts(configuration, artifacts);
        HashMap foundNodes = Maps.newHashMap();
        HashMap dependencyMap = Maps.newHashMap();
        ArrayList dependencies = Lists.newArrayList();
        Set dependencyResultSet = configuration.getIncoming().getResolutionResult().getRoot().getDependencies();
        MutableDependencyDataMap mutableDependencyContainer = MutableDependencyDataMap.newInstance();
        for (DependencyResult dependencyResult : dependencyResultSet) {
            ComponentSelector attempted;
            if (dependencyResult instanceof ResolvedDependencyResult) {
                this.addDependency(mutableDependencyContainer, ((ResolvedDependencyResult)dependencyResult).getSelected(), variantDeps, dependencyMap, dependencies, foundNodes, artifacts, libsToExplodeOut, currentUnresolvedDependencies, testedProjectPath, Collections.emptyList(), artifactSet, scopeType, false, 0);
                continue;
            }
            if (!(dependencyResult instanceof UnresolvedDependencyResult) || (attempted = ((UnresolvedDependencyResult)dependencyResult).getAttempted()) == null) continue;
            currentUnresolvedDependencies.add(attempted.toString());
        }
        for (Dependency dependency : configuration.getAllDependencies()) {
            if (!(dependency instanceof SelfResolvingDependency) || dependency instanceof ProjectDependency) continue;
            Set files = ((SelfResolvingDependency)dependency).resolve();
            for (File localJarFile : files) {
                if (!localJarFile.getName().toLowerCase(Locale.getDefault()).endsWith(".jar")) {
                    variantDeps.getChecker().handleIssue(localJarFile.getAbsolutePath(), 5, 2, String.format("Project %s: Only Jar-type local dependencies are supported. Cannot handle: %s", this.project.getName(), localJarFile.getAbsolutePath()));
                    continue;
                }
                JavaDependency localJar = new JavaDependency(localJarFile);
                switch (scopeType) {
                    case PACKAGE: {
                        artifactSet.add(localJar.getCoordinates().getVersionlessId());
                        break;
                    }
                    case COMPILE: {
                        if (artifactSet.contains(localJar.getCoordinates().getVersionlessId())) break;
                        mutableDependencyContainer.setProvided((com.android.builder.dependency.level2.Dependency)localJar);
                        break;
                    }
                    case COMPILE_ONLY: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("unsupported ProvidedComputationAction");
                    }
                }
                dependencyMap.put(localJar.getAddress(), localJar);
                DependencyNode node = new DependencyNode(localJar.getAddress(), DependencyNode.NodeType.JAVA, (List)ImmutableList.of(), null);
                dependencies.add(node);
            }
        }
        return new DependencyGraph(dependencyMap, dependencies, mutableDependencyContainer);
    }

    private Configuration collectArtifacts(Configuration configuration, Map<ModuleVersionIdentifier, List<ResolvedArtifact>> artifacts) {
        Set allArtifacts;
        Configuration configurationCopy = configuration.copyRecursive();
        Set unresolvedDependencies = configuration.getResolvedConfiguration().getLenientConfiguration().getUnresolvedModuleDependencies();
        if (unresolvedDependencies.isEmpty()) {
            allArtifacts = configuration.getResolvedConfiguration().getResolvedArtifacts();
        } else {
            if (!this.repositoriesUpdated && this.sdkLibData.useSdkDownload()) {
                ArrayList<String> repositoryPaths = new ArrayList<String>();
                for (Object dependency : unresolvedDependencies) {
                    if (!this.isGoogleOwnedDependency(dependency.getSelector())) continue;
                    repositoryPaths.add(DependencyManager.getRepositoryPath(dependency.getSelector()));
                }
                this.sdkLibData.setNeedsCacheReset(this.sdkHandler.checkResetCache());
                List updatedRepositories = this.sdkHandler.getSdkLoader().updateRepositories(repositoryPaths, this.sdkLibData, this.logger);
                for (File updatedRepository : updatedRepositories) {
                    this.project.getRepositories().maven(newRepo -> {
                        newRepo.setName("Updated " + updatedRepository.getPath());
                        newRepo.setUrl((Object)updatedRepository.toURI());
                        newRepo.artifactUrls(new Object[]{this.project.getRootProject().file((Object)"sdk-manager")});
                    });
                }
                this.repositoriesUpdated = true;
            }
            allArtifacts = this.extraModelInfo.getMode() != ErrorReporter.EvaluationMode.STANDARD ? configurationCopy.getResolvedConfiguration().getLenientConfiguration().getArtifacts(Specs.satisfyAll()) : configurationCopy.getResolvedConfiguration().getResolvedArtifacts();
            configuration = configurationCopy;
        }
        for (ResolvedArtifact artifact : allArtifacts) {
            ModuleVersionIdentifier id = artifact.getModuleVersion().getId();
            ArrayList moduleArtifacts = artifacts.get(id);
            if (moduleArtifacts == null) {
                moduleArtifacts = Lists.newArrayList();
                artifacts.put(id, moduleArtifacts);
            }
            if (moduleArtifacts.contains(artifact)) continue;
            moduleArtifacts.add(artifact);
        }
        return configuration;
    }

    private static String getRepositoryPath(ModuleVersionSelector selector) {
        return DetailsTypes.MavenType.getRepositoryPath((String)selector.getGroup(), (String)selector.getName(), (String)selector.getVersion());
    }

    private boolean isGoogleOwnedDependency(ModuleVersionSelector selector) {
        return selector.getGroup().startsWith("com.android.") || selector.getGroup().startsWith("com.google.android.") || selector.getGroup().startsWith("com.google.firebase.");
    }

    private static void printIndent(int indent, String message) {
        for (int i = 0; i < indent; ++i) {
            System.out.print("\t");
        }
        System.out.println(message);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addDependency(MutableDependencyDataMap mutableDependencyDataMap, ResolvedComponentResult resolvedComponentResult, VariantDependencies configDependencies, Map<Object, com.android.builder.dependency.level2.Dependency> outDependencyMap, List<DependencyNode> outDependencies, Map<ModuleVersionIdentifier, List<DependencyNode>> alreadyFoundNodes, Map<ModuleVersionIdentifier, List<ResolvedArtifact>> artifacts, Set<AndroidDependency> libsToExplodeOut, Set<String> currentUnresolvedDependencies, String testedProjectPath, List<String> projectChain, Set<String> artifactSet, ScopeType scopeType, boolean forceProvided, int indent) {
        ArrayList nodesForThisModule;
        ModuleVersionIdentifier moduleVersion = resolvedComponentResult.getModuleVersion();
        if (configDependencies.getChecker().checkForExclusion(moduleVersion)) {
            return;
        }
        if (moduleVersion.getName().equals("support-annotations") && moduleVersion.getGroup().equals("com.android.support")) {
            configDependencies.setAnnotationsPresent(true);
        }
        if ((nodesForThisModule = alreadyFoundNodes.get(moduleVersion)) != null) {
            outDependencies.addAll(nodesForThisModule);
            return;
        } else {
            ComponentIdentifier id = resolvedComponentResult.getId();
            String gradlePath = id instanceof ProjectComponentIdentifier ? ((ProjectComponentIdentifier)id).getProjectPath() : null;
            boolean childForceProvided = forceProvided;
            if (scopeType == ScopeType.COMPILE && testedProjectPath != null && testedProjectPath.equals(gradlePath)) {
                childForceProvided = true;
            }
            Set dependencies = resolvedComponentResult.getDependencies();
            ArrayList transitiveDependencies = Lists.newArrayListWithExpectedSize((int)dependencies.size());
            for (DependencyResult dependencyResult : dependencies) {
                ComponentSelector attempted;
                if (dependencyResult instanceof ResolvedDependencyResult) {
                    ResolvedComponentResult selected = ((ResolvedDependencyResult)dependencyResult).getSelected();
                    ArrayList newProjectChain = projectChain;
                    ComponentIdentifier identifier = selected.getId();
                    if (identifier instanceof ProjectComponentIdentifier) {
                        String projectPath = ((ProjectComponentIdentifier)identifier).getProjectPath();
                        int index = projectChain.indexOf(projectPath);
                        if (index != -1) {
                            projectChain.add(projectPath);
                            String path = Joiner.on((String)" -> ").join(projectChain.subList(index, projectChain.size()));
                            throw new CircularReferenceException("Circular reference between projects: " + path);
                        }
                        newProjectChain = Lists.newArrayList();
                        newProjectChain.addAll(projectChain);
                        newProjectChain.add(projectPath);
                    }
                    this.addDependency(mutableDependencyDataMap, selected, configDependencies, outDependencyMap, transitiveDependencies, alreadyFoundNodes, artifacts, libsToExplodeOut, currentUnresolvedDependencies, testedProjectPath, newProjectChain, artifactSet, scopeType, childForceProvided, indent + 1);
                    continue;
                }
                if (!(dependencyResult instanceof UnresolvedDependencyResult) || (attempted = ((UnresolvedDependencyResult)dependencyResult).getAttempted()) == null) continue;
                currentUnresolvedDependencies.add(attempted.toString());
            }
            List<ResolvedArtifact> moduleArtifacts = artifacts.get(moduleVersion);
            if (moduleArtifacts == null) return;
            for (ResolvedArtifact artifact : moduleArtifacts) {
                MavenCoordinatesImpl mavenCoordinates = DependencyManager.createMavenCoordinates(artifact);
                com.android.builder.dependency.level2.Dependency alreadyCreatedDependency = outDependencyMap.get(mavenCoordinates);
                DependencyNode.NodeType nodeType = null;
                if (alreadyCreatedDependency != null) {
                    if (alreadyCreatedDependency instanceof AndroidDependency) {
                        nodeType = DependencyNode.NodeType.ANDROID;
                    } else if (alreadyCreatedDependency instanceof JavaDependency) {
                        nodeType = DependencyNode.NodeType.JAVA;
                    } else {
                        if (!(alreadyCreatedDependency instanceof AtomDependency)) throw new RuntimeException("Unknown type of Dependency");
                        nodeType = DependencyNode.NodeType.ATOM;
                    }
                } else {
                    Project subProject;
                    String variantName;
                    String name;
                    boolean provided = forceProvided;
                    String coordKey = mavenCoordinates.getVersionlessId();
                    if (scopeType == ScopeType.PACKAGE) {
                        artifactSet.add(coordKey);
                    } else if (scopeType == ScopeType.COMPILE) {
                        provided |= !artifactSet.contains(coordKey);
                    }
                    if ("aar".equals(artifact.getExtension())) {
                        AndroidDependency androidDependency;
                        String path = this.computeArtifactPath(moduleVersion, artifact);
                        name = DependencyManager.computeArtifactName(moduleVersion, artifact);
                        variantName = artifact.getClassifier();
                        subProject = null;
                        boolean isSubProject = false;
                        if (gradlePath != null) {
                            subProject = this.project.findProject(gradlePath);
                            boolean bl = isSubProject = subProject.getPlugins().hasPlugin("com.android.library") || subProject.getPlugins().hasPlugin("com.android.model.library");
                        }
                        if (isSubProject) {
                            String pathLeaf = variantName != null ? variantName : "default";
                            File stagingDir = FileUtils.join((File)subProject.getBuildDir(), (String[])new String[]{"intermediates", "bundles", pathLeaf});
                            androidDependency = AndroidDependency.createStagedAarLibrary((File)artifact.getFile(), (MavenCoordinates)mavenCoordinates, (String)name, (String)gradlePath, (File)stagingDir, (String)variantName);
                        } else {
                            File explodedDir;
                            Optional<FileCache> buildCache = AndroidGradleOptions.getBuildCache(this.project);
                            if (PrepareLibraryTask.shouldUseBuildCache(buildCache.isPresent(), (MavenCoordinates)mavenCoordinates)) {
                                try {
                                    explodedDir = buildCache.get().getFileInCache(PrepareLibraryTask.getBuildCacheInputs(artifact.getFile()));
                                }
                                catch (IOException e) {
                                    throw new UncheckedIOException(e);
                                }
                            } else {
                                Preconditions.checkState((!AndroidGradleOptions.isImprovedDependencyResolutionEnabled(this.project) ? 1 : 0) != 0, (Object)"Improved dependency resolution must be used with build cache.");
                                explodedDir = FileUtils.join((File)this.project.getBuildDir(), (String[])new String[]{"intermediates", EXPLODED_AAR, path});
                            }
                            androidDependency = AndroidDependency.createExplodedAarLibrary((File)artifact.getFile(), (MavenCoordinates)mavenCoordinates, (String)name, null, (File)explodedDir);
                        }
                        alreadyCreatedDependency = androidDependency;
                        nodeType = DependencyNode.NodeType.ANDROID;
                        outDependencyMap.put(androidDependency.getAddress(), (com.android.builder.dependency.level2.Dependency)androidDependency);
                        if (!isSubProject) {
                            libsToExplodeOut.add(androidDependency);
                        }
                        if (DependencyManager.containsDirectDependency(transitiveDependencies, DependencyNode.NodeType.ATOM)) {
                            configDependencies.getChecker().handleIssue(DependencyManager.createMavenCoordinates(artifact).toString(), 22, 2, String.format("Module '%s' depends on one or more Android Atoms but is a library", moduleVersion));
                        }
                    } else if ("atombundle".equals(artifact.getExtension())) {
                        if (provided) {
                            configDependencies.getChecker().handleIssue(DependencyManager.createMavenCoordinates(artifact).toString(), 23, 2, String.format("Module '%s' is an Atom, which cannot be a provided dependency", moduleVersion));
                        }
                        if (scopeType == ScopeType.PACKAGE) {
                            DependencyManager.recursiveSkip(mutableDependencyDataMap, transitiveDependencies, outDependencyMap, true, true);
                        }
                        String path = this.computeArtifactPath(moduleVersion, artifact);
                        name = DependencyManager.computeArtifactName(moduleVersion, artifact);
                        variantName = artifact.getClassifier();
                        String pathLeaf = variantName != null ? variantName : "default";
                        subProject = this.project.findProject(gradlePath);
                        File stagingDir = FileUtils.join((File)subProject.getBuildDir(), (String[])new String[]{"intermediates", "atombundles", pathLeaf});
                        AtomDependency atomDependency = new AtomDependency(artifact.getFile(), (MavenCoordinates)mavenCoordinates, name, gradlePath, stagingDir, moduleVersion.getName(), variantName);
                        alreadyCreatedDependency = atomDependency;
                        nodeType = DependencyNode.NodeType.ATOM;
                        outDependencyMap.put(atomDependency.getAddress(), (com.android.builder.dependency.level2.Dependency)atomDependency);
                    } else if ("jar".equals(artifact.getExtension())) {
                        boolean isRootOfSeparateTestedApp;
                        boolean bl = isRootOfSeparateTestedApp = testedProjectPath != null && testedProjectPath.equals(gradlePath);
                        if (DependencyManager.containsDirectDependency(transitiveDependencies, DependencyNode.NodeType.ANDROID) && !isRootOfSeparateTestedApp) {
                            configDependencies.getChecker().handleIssue(DependencyManager.createMavenCoordinates(artifact).toString(), 8, 2, String.format("Module '%s' depends on one or more Android Libraries but is a jar", moduleVersion));
                        }
                        if (DependencyManager.containsDirectDependency(transitiveDependencies, DependencyNode.NodeType.ATOM)) {
                            configDependencies.getChecker().handleIssue(DependencyManager.createMavenCoordinates(artifact).toString(), 21, 2, String.format("Module '%s' depends on one or more Android Atoms but is a jar", moduleVersion));
                        }
                        JavaDependency javaDependency = new JavaDependency(artifact.getFile(), (MavenCoordinates)mavenCoordinates, DependencyManager.computeArtifactName(moduleVersion, artifact), gradlePath);
                        alreadyCreatedDependency = javaDependency;
                        nodeType = DependencyNode.NodeType.JAVA;
                        outDependencyMap.put(javaDependency.getAddress(), (com.android.builder.dependency.level2.Dependency)javaDependency);
                        if (isRootOfSeparateTestedApp) {
                            if (scopeType == ScopeType.PACKAGE) {
                                mutableDependencyDataMap.skip((com.android.builder.dependency.level2.Dependency)javaDependency);
                                DependencyManager.recursiveSkip(mutableDependencyDataMap, transitiveDependencies, outDependencyMap, true, true);
                            } else {
                                DependencyManager.recursiveProvided(mutableDependencyDataMap, transitiveDependencies, outDependencyMap, true, true);
                                provided = true;
                            }
                        }
                    } else if ("apk".equals(artifact.getExtension())) {
                        String name2 = DependencyManager.computeArtifactName(moduleVersion, artifact);
                        configDependencies.getChecker().handleIssue(name2, 3, 2, String.format("Dependency %s on project %s resolves to an APK archive which is not supported as a compilation dependency. File: %s", name2, this.project.getName(), artifact.getFile()));
                    } else if ("apklib".equals(artifact.getExtension())) {
                        String name3 = DependencyManager.computeArtifactName(moduleVersion, artifact);
                        configDependencies.getChecker().handleIssue(name3, 4, 2, String.format("Packaging for dependency %s is 'apklib' and is not supported. Only 'aar' libraries are supported.", name3));
                    } else {
                        String name4 = DependencyManager.computeArtifactName(moduleVersion, artifact);
                        this.logger.warning(String.format("Unrecognized dependency: '%s' (type: '%s', extension: '%s')", name4, artifact.getType(), artifact.getExtension()), new Object[0]);
                    }
                    if (provided && alreadyCreatedDependency != null) {
                        mutableDependencyDataMap.setProvided(alreadyCreatedDependency);
                    }
                }
                if (alreadyCreatedDependency == null) continue;
                DependencyNode node = new DependencyNode(alreadyCreatedDependency.getAddress(), nodeType, (List)transitiveDependencies, null);
                outDependencies.add(node);
                if (nodesForThisModule == null) {
                    nodesForThisModule = Lists.newArrayList((Object[])new DependencyNode[]{node});
                    alreadyFoundNodes.put(moduleVersion, nodesForThisModule);
                    continue;
                }
                nodesForThisModule.add((DependencyNode)node);
            }
        }
    }

    private static MavenCoordinatesImpl createMavenCoordinates(ResolvedArtifact resolvedArtifact) {
        return new MavenCoordinatesImpl(resolvedArtifact.getModuleVersion().getId().getGroup(), resolvedArtifact.getModuleVersion().getId().getName(), resolvedArtifact.getModuleVersion().getId().getVersion(), resolvedArtifact.getExtension(), resolvedArtifact.getClassifier());
    }

    private static boolean containsDirectDependency(List<DependencyNode> dependencies, DependencyNode.NodeType nodeType) {
        return dependencies.stream().anyMatch(dependencyNode -> dependencyNode.getNodeType() == nodeType);
    }

    private static void recursiveSkip(MutableDependencyDataMap mutableDependencyDataMap, List<DependencyNode> nodes, Map<Object, com.android.builder.dependency.level2.Dependency> dependencyMap, boolean skipAndroidDependency, boolean skipJavaDependency) {
        for (DependencyNode node : nodes) {
            com.android.builder.dependency.level2.Dependency dep = dependencyMap.get(node.getAddress());
            if (skipAndroidDependency && dep instanceof AndroidDependency) {
                mutableDependencyDataMap.skip(dep);
            }
            if (skipJavaDependency && dep instanceof JavaDependency) {
                mutableDependencyDataMap.skip(dep);
            }
            DependencyManager.recursiveSkip(mutableDependencyDataMap, (List<DependencyNode>)node.getDependencies(), dependencyMap, skipAndroidDependency, skipJavaDependency);
        }
    }

    private static void recursiveProvided(MutableDependencyDataMap mutableDependencyDataMap, List<DependencyNode> nodes, Map<Object, com.android.builder.dependency.level2.Dependency> dependencyMap, boolean skipAndroidDependency, boolean skipJavaDependency) {
        for (DependencyNode node : nodes) {
            com.android.builder.dependency.level2.Dependency dep = dependencyMap.get(node.getAddress());
            if (skipAndroidDependency && dep instanceof AndroidDependency) {
                mutableDependencyDataMap.setProvided(dep);
            }
            if (skipJavaDependency && dep instanceof JavaDependency) {
                mutableDependencyDataMap.setProvided(dep);
            }
            DependencyManager.recursiveProvided(mutableDependencyDataMap, (List<DependencyNode>)node.getDependencies(), dependencyMap, skipAndroidDependency, skipJavaDependency);
        }
    }

    private String computeArtifactPath(ModuleVersionIdentifier moduleVersion, ResolvedArtifact artifact) {
        StringBuilder pathBuilder = new StringBuilder(moduleVersion.getGroup().length() + moduleVersion.getName().length() + moduleVersion.getVersion().length() + 10);
        pathBuilder.append(DependencyManager.normalize(this.logger, moduleVersion, moduleVersion.getGroup())).append(File.separatorChar).append(DependencyManager.normalize(this.logger, moduleVersion, moduleVersion.getName())).append(File.separatorChar).append(DependencyManager.normalize(this.logger, moduleVersion, moduleVersion.getVersion()));
        if (artifact.getClassifier() != null && !artifact.getClassifier().isEmpty()) {
            pathBuilder.append(File.separatorChar).append(DependencyManager.normalize(this.logger, moduleVersion, artifact.getClassifier()));
        }
        return pathBuilder.toString();
    }

    private static String computeArtifactName(ModuleVersionIdentifier moduleVersion, ResolvedArtifact artifact) {
        StringBuilder nameBuilder = new StringBuilder(moduleVersion.getGroup().length() + moduleVersion.getName().length() + moduleVersion.getVersion().length() + 10);
        nameBuilder.append(moduleVersion.getGroup()).append(':').append(moduleVersion.getName()).append(':').append(moduleVersion.getVersion());
        if (artifact.getClassifier() != null && !artifact.getClassifier().isEmpty()) {
            nameBuilder.append(':').append(artifact.getClassifier());
        }
        return nameBuilder.toString();
    }

    static String normalize(ILogger logger, ModuleVersionIdentifier id, String path) {
        if (path == null || path.isEmpty()) {
            logger.verbose(String.format("When unzipping library '%s:%s:%s, either group, name or version is empty", id.getGroup(), id.getName(), id.getVersion()), new Object[0]);
            return path;
        }
        String normalizedPath = path.replaceAll("[%<>:\"/?*\\\\]", "@");
        if (normalizedPath == null || normalizedPath.isEmpty()) {
            logger.verbose(String.format("When unzipping library '%s:%s:%s, the normalized '%s' is empty", id.getGroup(), id.getName(), id.getVersion(), path), new Object[0]);
            return path;
        }
        try {
            int pathPointer;
            String suffix = "";
            for (pathPointer = normalizedPath.length() - 1; pathPointer >= 0 && (normalizedPath.charAt(pathPointer) == '.' || normalizedPath.charAt(pathPointer) == ' '); --pathPointer) {
                suffix = suffix + "@";
            }
            if (pathPointer < 0) {
                throw new RuntimeException(String.format("When unzipping library '%s:%s:%s, the path '%s' cannot be transformed into a valid directory name", id.getGroup(), id.getName(), id.getVersion(), path));
            }
            return normalizedPath.substring(0, pathPointer + 1) + suffix;
        }
        catch (Exception e) {
            logger.error((Throwable)e, String.format("When unzipping library '%s:%s:%s', Path normalization failed for input %s", id.getGroup(), id.getName(), id.getVersion(), path), new Object[0]);
            return path;
        }
    }

    public void setSdkLibData(SdkLibData sdkLibData) {
        this.sdkLibData = sdkLibData;
    }

    static enum ScopeType {
        PACKAGE,
        COMPILE,
        COMPILE_ONLY;

    }
}

