/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.DependencyManager;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.AtomPackagingScope;
import com.android.build.gradle.internal.scope.BaseAtomPackagingScope;
import com.android.build.gradle.internal.scope.DefaultGradlePackagingScope;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantOutputScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.InstantAppVariantData;
import com.android.build.gradle.tasks.GenerateInstantAppMetadata;
import com.android.build.gradle.tasks.MergeDexAtomResClass;
import com.android.build.gradle.tasks.PackageAtom;
import com.android.build.gradle.tasks.PackageInstantApp;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.build.gradle.tasks.ProcessInstantAppResources;
import com.android.build.gradle.tasks.factory.AndroidJavaCompile;
import com.android.build.gradle.tasks.factory.AtomResClassJavaCompileConfigAction;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.dependency.level2.AtomDependency;
import com.android.builder.dependency.level2.Dependency;
import com.android.builder.dependency.level2.DependencyContainer;
import com.android.builder.dependency.level2.DependencyNode;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.builder.profile.Recorder;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class InstantAppTaskManager
extends TaskManager {
    public InstantAppTaskManager(Project project, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, NdkHandler ndkHandler, DependencyManager dependencyManager, ToolingModelBuilderRegistry toolingRegistry, Recorder threadRecorder) {
        super(project, androidBuilder, dataBindingBuilder, extension, sdkHandler, ndkHandler, dependencyManager, toolingRegistry, threadRecorder);
    }

    @Override
    public void createTasksForVariantData(TaskFactory tasks, BaseVariantData<? extends BaseVariantOutputData> variantData) {
        assert (variantData instanceof InstantAppVariantData);
        String projectPath = this.project.getPath();
        String variantName = variantData.getName();
        VariantScope variantScope = variantData.getScope();
        ProcessProfileWriter.getProject((String)projectPath).setAtoms((long)variantData.getVariantConfiguration().getFlatAndroidAtomsDependencies().size());
        this.createAnchorTasks(tasks, variantScope);
        this.createCheckManifestTask(tasks, variantScope);
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.INSTANTAPP_TASK_MANAGER_CREATE_MERGE_MANIFEST_TASK, projectPath, variantName, () -> this.createMergeAppManifestsTask(tasks, variantScope));
        AndroidTask lastPackageAtom = (AndroidTask)this.recorder.record(GradleBuildProfileSpan.ExecutionType.INSTANTAPP_TASK_MANAGER_CREATE_ATOM_PACKAGING_TASKS, projectPath, variantName, () -> this.createAtomPackagingTasks(tasks, variantScope));
        if (lastPackageAtom == null) {
            return;
        }
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.INSTANTAPP_TASK_MANAGER_CREATE_PROCESS_RES_TASK, projectPath, variantName, () -> this.createInstantAppProcessResTask(tasks, variantScope, lastPackageAtom));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.INSTANTAPP_TASK_MANAGER_CREATE_PACKAGING_TASK, projectPath, variantName, () -> this.createInstantAppPackagingTasks(tasks, variantScope));
    }

    private AndroidTask<PackageAtom> createAtomPackagingTasks(TaskFactory tasks, VariantScope variantScope) {
        VariantOutputScope variantOutputScope = variantScope.getVariantData().getMainOutput().getScope();
        DependencyContainer packageDependencies = variantScope.getVariantConfiguration().getPackageDependencies();
        ImmutableList directNodes = packageDependencies.getDependencies();
        List atomNodes = directNodes.stream().filter(node -> node.getNodeType() == DependencyNode.NodeType.ATOM).collect(Collectors.toList());
        AndroidTask<PackageAtom> previousPackagingTask = null;
        ArrayList<AtomDependency> previousAtoms = new ArrayList<AtomDependency>();
        for (DependencyNode atomNode : atomNodes) {
            previousPackagingTask = this.createAtomPackagingTasks(tasks, variantOutputScope, atomNode, (Map<Object, Dependency>)packageDependencies.getDependencyMap(), previousAtoms, previousPackagingTask);
        }
        return previousPackagingTask;
    }

    private AndroidTask<PackageAtom> createAtomPackagingTasks(TaskFactory tasks, VariantOutputScope variantOutputScope, DependencyNode atomNode, Map<Object, Dependency> dependencyMap, List<AtomDependency> previousAtoms, AndroidTask<PackageAtom> previousPackagingTask) {
        VariantScope variantScope = variantOutputScope.getVariantScope();
        BaseVariantData<? extends BaseVariantOutputData> variantData = variantScope.getVariantData();
        GlobalScope globalScope = variantScope.getGlobalScope();
        AtomDependency atomDependency = (AtomDependency)dependencyMap.get(atomNode.getAddress());
        if (previousAtoms.contains(atomDependency)) {
            return previousPackagingTask;
        }
        List childrenAtoms = atomNode.getDependencies().stream().filter(node -> node.getNodeType() == DependencyNode.NodeType.ATOM).collect(Collectors.toList());
        for (DependencyNode atom : childrenAtoms) {
            previousPackagingTask = this.createAtomPackagingTasks(tasks, variantOutputScope, atom, dependencyMap, previousAtoms, previousPackagingTask);
        }
        if (previousPackagingTask == null) {
            BaseAtomPackagingScope packagingScope = new BaseAtomPackagingScope(variantOutputScope, atomDependency);
            AndroidTask<PackageAtom> packageAtom = this.getAndroidTasks().create(tasks, new PackageAtom.ConfigAction(packagingScope));
            packageAtom.dependsOn(tasks, variantScope.getPrepareDependenciesTask());
            previousAtoms.add(atomDependency);
            return packageAtom;
        }
        variantData.calculateFilters(globalScope.getExtension().getSplits());
        AndroidTask<ProcessAndroidResources> processAtomResources = this.getAndroidTasks().create(tasks, new ProcessAndroidResources.AtomConfigAction(variantOutputScope, FileUtils.join((File)globalScope.getIntermediatesDir(), (String[])new String[]{"symbols", atomDependency.getAtomName(), variantData.getVariantConfiguration().getDirName()}), atomNode, atomDependency, dependencyMap, previousAtoms));
        processAtomResources.dependsOn(tasks, previousPackagingTask);
        AndroidTask<AndroidJavaCompile> javaCompile = this.getAndroidTasks().create(tasks, new AtomResClassJavaCompileConfigAction(variantScope, atomDependency));
        javaCompile.dependsOn(tasks, processAtomResources);
        AndroidTask<MergeDexAtomResClass> dexAtom = this.getAndroidTasks().create(tasks, new MergeDexAtomResClass.ConfigAction(variantScope, atomDependency));
        dexAtom.dependsOn(tasks, javaCompile);
        AtomPackagingScope packagingScope = new AtomPackagingScope(variantOutputScope, atomDependency);
        AndroidTask<PackageAtom> packageAtom = this.getAndroidTasks().create(tasks, new PackageAtom.ConfigAction(packagingScope));
        packageAtom.dependsOn(tasks, dexAtom);
        previousAtoms.add(atomDependency);
        return packageAtom;
    }

    private void createInstantAppProcessResTask(TaskFactory tasks, VariantScope variantScope, AndroidTask<PackageAtom> lastPackageAtom) {
        VariantOutputScope variantOutputScope = variantScope.getVariantData().getMainOutput().getScope();
        AndroidTask<ProcessInstantAppResources> processInstantAppResourcesTask = this.getAndroidTasks().create(tasks, new ProcessInstantAppResources.ConfigAction(variantOutputScope));
        variantOutputScope.setProcessInstantAppResourcesTask(processInstantAppResourcesTask);
        processInstantAppResourcesTask.dependsOn(tasks, lastPackageAtom);
        processInstantAppResourcesTask.dependsOn(tasks, variantOutputScope.getManifestProcessorTask());
    }

    private void createInstantAppPackagingTasks(TaskFactory tasks, VariantScope variantScope) {
        BaseVariantOutputData variantOutputData = variantScope.getVariantData().getOutputs().get(0);
        VariantOutputScope variantOutputScope = variantOutputData.getScope();
        AndroidTask<GenerateInstantAppMetadata> generateInstantAppMetadataTask = this.getAndroidTasks().create(tasks, new GenerateInstantAppMetadata.ConfigAction(variantOutputScope));
        generateInstantAppMetadataTask.dependsOn(tasks, variantScope.getPrepareDependenciesTask());
        DefaultGradlePackagingScope packagingScope = new DefaultGradlePackagingScope(variantOutputScope);
        AndroidTask<PackageInstantApp> packageInstantApp = this.getAndroidTasks().create(tasks, new PackageInstantApp.ConfigAction(packagingScope));
        packageInstantApp.configure(tasks, (Action<PackageInstantApp>)((Action)task -> {
            variantOutputData.packageAndroidArtifactTask = task;
        }));
        packageInstantApp.dependsOn(tasks, (Object)generateInstantAppMetadataTask, (Object)variantOutputScope.getProcessInstantAppResourcesTask());
        variantScope.getAssembleTask().dependsOn(tasks, packageInstantApp);
    }

    @Override
    protected Set<QualifiedContent.Scope> getResMergingScopes(VariantScope variantScope) {
        return TransformManager.EMPTY_SCOPES;
    }
}

