/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.internal.DependencyManager;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.CopyLintConfigAction;
import com.android.build.gradle.internal.tasks.LibraryJarTransform;
import com.android.build.gradle.internal.tasks.LibraryJniLibsTransform;
import com.android.build.gradle.internal.tasks.MergeFileTask;
import com.android.build.gradle.internal.tasks.MergeProguardFilesConfigAction;
import com.android.build.gradle.internal.tasks.PackageRenderscriptConfigAction;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.LibVariantOutputData;
import com.android.build.gradle.internal.variant.LibraryVariantData;
import com.android.build.gradle.internal.variant.VariantHelper;
import com.android.build.gradle.tasks.ExtractAnnotations;
import com.android.build.gradle.tasks.MergeResources;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.dependency.level2.AndroidDependency;
import com.android.builder.profile.Recorder;
import com.android.utils.FileUtils;
import com.android.utils.StringHelper;
import com.google.common.collect.Sets;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class LibraryTaskManager
extends TaskManager {
    public static final String ANNOTATIONS = "annotations";
    private Task assembleDefault;

    public LibraryTaskManager(Project project, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, NdkHandler ndkHandler, DependencyManager dependencyManager, ToolingModelBuilderRegistry toolingRegistry, Recorder recorder) {
        super(project, androidBuilder, dataBindingBuilder, extension, sdkHandler, ndkHandler, dependencyManager, toolingRegistry, recorder);
    }

    @Override
    public void createTasksForVariantData(final TaskFactory tasks, BaseVariantData<? extends BaseVariantOutputData> variantData) {
        final boolean generateSourcesOnly = AndroidGradleOptions.generateSourcesOnly(this.project);
        LibraryVariantData libVariantData = (LibraryVariantData)variantData;
        final GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
        final CoreBuildType buildType = (CoreBuildType)variantConfig.getBuildType();
        final VariantScope variantScope = variantData.getScope();
        GlobalScope globalScope = variantScope.getGlobalScope();
        File intermediatesDir = globalScope.getIntermediatesDir();
        Collection variantDirectorySegments = variantConfig.getDirectorySegments();
        final File variantBundleDir = variantScope.getBaseBundleDir();
        String projectPath = this.project.getPath();
        String variantName = variantData.getName();
        this.createAnchorTasks(tasks, variantScope);
        this.createDependencyStreams(tasks, variantScope);
        this.createCheckManifestTask(tasks, variantScope);
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_GENERATE_RES_VALUES_TASK, projectPath, variantName, () -> this.createGenerateResValuesTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_MERGE_MANIFEST_TASK, projectPath, variantName, () -> this.createMergeLibManifestsTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_CREATE_RENDERSCRIPT_TASK, projectPath, variantName, () -> this.createRenderscriptTask(tasks, variantScope));
        AndroidTask packageRes = (AndroidTask)this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_MERGE_RESOURCES_TASK, projectPath, variantName, () -> this.createMergeResourcesTask(tasks, variantData, variantScope, variantBundleDir));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_MERGE_ASSETS_TASK, projectPath, variantName, () -> this.createMergeAssetsTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_BUILD_CONFIG_TASK, projectPath, variantName, () -> this.createBuildConfigTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_PROCESS_RES_TASK, projectPath, variantName, () -> {
            this.createProcessResTask(tasks, variantScope, variantBundleDir, false);
            this.createProcessJavaResTasks(tasks, variantScope);
        });
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_AIDL_TASK, projectPath, variantName, () -> this.createAidlTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_SHADER_TASK, projectPath, variantName, () -> this.createShaderTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_COMPILE_TASK, projectPath, variantName, () -> {
            this.createDataBindingMergeArtifactsTaskIfNecessary(tasks, variantScope);
            AndroidTask<? extends JavaCompile> javacTask = this.createJavacTask(tasks, variantScope);
            LibraryTaskManager.addJavacClassesStream(variantScope);
            TaskManager.setJavaCompilerTask(javacTask, tasks, variantScope);
        });
        this.createDataBindingTasksIfNecessary(tasks, variantScope);
        if (!this.isComponentModelPlugin) {
            this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_NDK_TASK, projectPath, variantName, () -> this.createNdkTasks(tasks, variantScope));
        }
        variantScope.setNdkBuildable(this.getNdkBuildable(variantData));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_EXTERNAL_NATIVE_BUILD_TASK, projectPath, variantName, () -> {
            this.createExternalNativeBuildJsonGenerators(variantScope);
            this.createExternalNativeBuildTasks(tasks, variantScope);
        });
        this.createMergeJniLibFoldersTasks(tasks, variantScope);
        LibraryTaskManager.createStripNativeLibraryTask(tasks, variantScope);
        AndroidTask packageRenderscriptTask = (AndroidTask)this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_PACKAGING_TASK, projectPath, variantName, () -> this.getAndroidTasks().create(tasks, new PackageRenderscriptConfigAction(variantScope)));
        AndroidTask mergeProguardFilesTask = (AndroidTask)this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_MERGE_PROGUARD_FILE_TASK, projectPath, variantName, () -> this.createMergeFileTask(tasks, variantScope));
        AndroidTask<Copy> copyLintTask = this.getAndroidTasks().create(tasks, new CopyLintConfigAction(variantScope));
        copyLintTask.dependsOn(tasks, (Object)"compileLint");
        final Zip bundle = (Zip)this.project.getTasks().create(variantScope.getTaskName("bundle"), Zip.class);
        if (AndroidGradleOptions.isImprovedDependencyResolutionEnabled(this.project) || variantData.getVariantDependency().isAnnotationsPresent()) {
            AndroidTask<ExtractAnnotations> extractAnnotationsTask = this.getAndroidTasks().create(tasks, new ExtractAnnotations.ConfigAction(this.project, this.getExtension(), variantScope));
            extractAnnotationsTask.dependsOn(tasks, libVariantData.getScope().getJavacTask());
            if (!generateSourcesOnly) {
                bundle.dependsOn(new Object[]{extractAnnotationsTask.getName()});
            }
        }
        final boolean instrumented = ((CoreBuildType)variantConfig.getBuildType()).isTestCoverageEnabled();
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_POST_COMPILATION_TASK, projectPath, variantName, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                String packageName;
                TransformManager transformManager = variantScope.getTransformManager();
                if (instrumented) {
                    LibraryTaskManager.this.createJacocoTransform(tasks, variantScope);
                }
                List<Transform> customTransforms = LibraryTaskManager.this.extension.getTransforms();
                List<List<Object>> customTransformsDependencies = LibraryTaskManager.this.extension.getTransformsDependencies();
                int count = customTransforms.size();
                for (int i = 0; i < count; ++i) {
                    Transform transform = customTransforms.get(i);
                    Sets.SetView difference = Sets.difference((Set)transform.getScopes(), TransformManager.SCOPE_FULL_LIBRARY);
                    if (!difference.isEmpty()) {
                        String scopes = difference.toString();
                        LibraryTaskManager.this.androidBuilder.getErrorReporter().handleSyncError("", 0, String.format("Transforms with scopes '%s' cannot be appliedto library projects.", scopes));
                    }
                    List<Object> deps = customTransformsDependencies.get(i);
                    transformManager.addTransform(tasks, variantScope, transform).ifPresent(t -> {
                        if (!deps.isEmpty()) {
                            t.dependsOn(tasks, (Object)deps);
                        }
                        if (transform.getScopes().isEmpty()) {
                            variantScope.getAssembleTask().dependsOn(tasks, (AndroidTask<?>)t);
                        }
                    });
                }
                if (buildType.isMinifyEnabled()) {
                    LibraryTaskManager.this.createMinifyTransform(tasks, variantScope, false);
                }
                if ((packageName = variantConfig.getPackageFromManifest()) == null) {
                    throw new BuildException("Failed to read manifest", null);
                }
                LibraryJarTransform transform = new LibraryJarTransform(new File(variantBundleDir, "classes.jar"), new File(variantBundleDir, "libs"), variantScope.getTypedefFile(), packageName, LibraryTaskManager.this.getExtension().getPackageBuildConfig());
                LibraryTaskManager.this.excludeDataBindingClassesIfNecessary(variantScope, transform);
                Optional<AndroidTask<TransformTask>> jarPackagingTask = transformManager.addTransform(tasks, variantScope, transform);
                if (!generateSourcesOnly) {
                    jarPackagingTask.ifPresent(t -> bundle.dependsOn(new Object[]{t.getName()}));
                }
                LibraryJniLibsTransform jniTransform = new LibraryJniLibsTransform(new File(variantBundleDir, "jni"));
                Optional<AndroidTask<TransformTask>> jniPackagingTask = transformManager.addTransform(tasks, variantScope, jniTransform);
                if (!generateSourcesOnly) {
                    jniPackagingTask.ifPresent(t -> bundle.dependsOn(new Object[]{t.getName()}));
                }
                return null;
            }
        });
        bundle.dependsOn(new Object[]{packageRes.getName(), packageRenderscriptTask.getName(), copyLintTask.getName(), mergeProguardFilesTask.getName(), variantScope.getAidlCompileTask().getName(), variantScope.getMergeAssetsTask().getName(), variantData.getMainOutput().getScope().getManifestProcessorTask().getName()});
        if (!generateSourcesOnly) {
            bundle.dependsOn(new Object[]{variantScope.getNdkBuildable()});
        }
        bundle.setDescription("Assembles a bundle containing the library in " + variantConfig.getFullName() + ".");
        bundle.setDestinationDir(variantScope.getOutputBundleFile().getParentFile());
        bundle.setArchiveName(variantScope.getOutputBundleFile().getName());
        bundle.setExtension("aar");
        bundle.from(new Object[]{variantBundleDir});
        bundle.from(new Object[]{FileUtils.join((File)intermediatesDir, (Iterable)StringHelper.toStrings((Object[])new Object[]{ANNOTATIONS, variantDirectorySegments}))});
        LibVariantOutputData variantOutputData = (LibVariantOutputData)libVariantData.getMainOutput();
        variantOutputData.packageLibTask = bundle;
        variantScope.getAssembleTask().dependsOn(tasks, (Object)bundle);
        variantOutputData.getScope().setAssembleTask(variantScope.getAssembleTask());
        variantOutputData.assembleTask = variantData.assembleVariantTask;
        if (this.getExtension().getDefaultPublishConfig().equals(variantConfig.getFullName())) {
            VariantHelper.setupDefaultConfig(this.project, variantData.getVariantDependency().getPackageConfiguration());
            this.project.getArtifacts().add("default", (Object)bundle);
            this.getAssembleDefault().dependsOn(new Object[]{variantScope.getAssembleTask().getName()});
        }
        if (this.getExtension().getPublishNonDefault()) {
            this.project.getArtifacts().add(variantData.getVariantDependency().getPublishConfiguration().getName(), (Object)bundle);
            bundle.setClassifier(variantData.getVariantDependency().getPublishConfiguration().getName());
        }
        variantConfig.setOutput(AndroidDependency.createLocalTestedAarLibrary((File)bundle.getArchivePath(), (String)variantData.getName(), (String)this.project.getPath(), (File)variantBundleDir));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_LINT_TASK, projectPath, variantName, () -> this.createLintTasks(tasks, variantScope));
    }

    private AndroidTask<MergeFileTask> createMergeFileTask(TaskFactory tasks, VariantScope variantScope) {
        return this.getAndroidTasks().create(tasks, new MergeProguardFilesConfigAction(this.project, variantScope));
    }

    private AndroidTask<MergeResources> createMergeResourcesTask(TaskFactory tasks, BaseVariantData<? extends BaseVariantOutputData> variantData, VariantScope variantScope, File variantBundleDir) {
        AndroidTask<MergeResources> mergeResourceTask = this.basicCreateMergeResourcesTask(tasks, variantScope, "package", FileUtils.join((File)variantBundleDir, (String[])new String[]{"res"}), false, false);
        if (AndroidGradleOptions.isImprovedDependencyResolutionEnabled(this.project) || variantData.getVariantDependency().hasNonOptionalLibraries()) {
            this.createMergeResourcesTask(tasks, variantScope, false);
        }
        mergeResourceTask.configure(tasks, (Action<MergeResources>)((Action)task -> task.setPublicFile(FileUtils.join((File)variantBundleDir, (String[])new String[]{"public.txt"}))));
        return mergeResourceTask;
    }

    private void excludeDataBindingClassesIfNecessary(final VariantScope variantScope, LibraryJarTransform transform) {
        if (!this.extension.getDataBinding().isEnabled()) {
            return;
        }
        transform.addExcludeListProvider(new LibraryJarTransform.ExcludeListProvider(){

            @Override
            public List<String> getExcludeList() {
                File excludeFile = variantScope.getVariantData().getType().isExportDataBindingClassList() ? variantScope.getGeneratedClassListOutputFileForDataBinding() : null;
                return LibraryTaskManager.this.dataBindingBuilder.getJarExcludeList(variantScope.getVariantData().getLayoutXmlProcessor(), excludeFile);
            }
        });
    }

    @Override
    protected Set<QualifiedContent.Scope> getResMergingScopes(VariantScope variantScope) {
        if (variantScope.getTestedVariantData() != null) {
            return TransformManager.SCOPE_FULL_PROJECT;
        }
        return TransformManager.SCOPE_FULL_LIBRARY;
    }

    private Task getAssembleDefault() {
        if (this.assembleDefault == null) {
            this.assembleDefault = (Task)this.project.getTasks().findByName("assembleDefault");
        }
        return this.assembleDefault;
    }
}

