/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.ide.common.res2.MergingException;
import com.android.utils.ILogger;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class LoggerWrapper
implements ILogger {
    private static final LogLevel ILOGGER_ERROR = LogLevel.ERROR;
    private static final LogLevel ILOGGER_WARNING = LogLevel.WARN;
    private static final LogLevel ILOGGER_INFO = LogLevel.LIFECYCLE;
    private static final LogLevel ILOGGER_VERBOSE = LogLevel.INFO;
    private final Logger logger;

    public static LoggerWrapper getLogger(Class<?> klass) {
        return new LoggerWrapper(Logging.getLogger(klass));
    }

    public LoggerWrapper(Logger logger) {
        this.logger = logger;
    }

    public void error(Throwable throwable, String s, Object ... objects) {
        if (throwable instanceof MergingException) {
            return;
        }
        if (!this.logger.isEnabled(ILOGGER_ERROR)) {
            return;
        }
        if (s == null) {
            s = "[no message defined]";
        } else if (objects != null && objects.length > 0) {
            s = String.format(s, objects);
        }
        if (throwable == null) {
            this.logger.log(ILOGGER_ERROR, s);
        } else {
            this.logger.log(ILOGGER_ERROR, s, throwable);
        }
    }

    public void warning(String s, Object ... objects) {
        this.log(ILOGGER_WARNING, s, objects);
    }

    public void info(String s, Object ... objects) {
        this.log(ILOGGER_INFO, s, objects);
    }

    public void verbose(String s, Object ... objects) {
        this.log(ILOGGER_VERBOSE, s, objects);
    }

    private void log(LogLevel logLevel, String s, Object[] objects) {
        if (!this.logger.isEnabled(logLevel)) {
            return;
        }
        if (objects == null || objects.length == 0) {
            this.logger.log(logLevel, s);
        } else {
            this.logger.log(logLevel, String.format(s, objects));
        }
    }
}

