/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.MutableDependencyDataMap;
import com.android.builder.dependency.level2.AndroidDependency;
import com.android.builder.dependency.level2.AtomDependency;
import com.android.builder.dependency.level2.Dependency;
import com.android.builder.dependency.level2.DependencyContainer;
import com.android.builder.dependency.level2.DependencyNode;
import com.android.builder.dependency.level2.JavaDependency;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DependencyContainerImpl
implements DependencyContainer {
    private final ImmutableMap<Object, Dependency> dependencyMap;
    private final ImmutableList<DependencyNode> dependencies;
    private final MutableDependencyDataMap mutableDependencyDataMap;
    private final ImmutableList<Dependency> allDependencies;
    private final ImmutableList<Dependency> directDependencies;
    private final AtomDependency baseAtom;
    private ImmutableList<Dependency> allPackagedDependencies;
    private ImmutableList<JavaDependency> allJavaDependencies;
    private ImmutableList<AndroidDependency> allAndroidDependencies;
    private ImmutableList<AtomDependency> allAtomDependencies;
    private ImmutableList<JavaDependency> directJavaDependencies;
    private ImmutableList<JavaDependency> directLocalJavaDependencies;
    private ImmutableList<AndroidDependency> directAndroidDependencies;
    private ImmutableList<AtomDependency> directAtomDependencies;
    private static final DependencyContainerImpl EMPTY = new DependencyContainerImpl((Map<Object, Dependency>)ImmutableMap.of(), (List<DependencyNode>)ImmutableList.of(), MutableDependencyDataMap.EMPTY, (List<Dependency>)ImmutableList.of(), (List<Dependency>)ImmutableList.of(), null);

    DependencyContainerImpl(Map<Object, Dependency> dependencyMap, List<DependencyNode> dependencies, MutableDependencyDataMap mutableDependencyDataMap, List<Dependency> allDependencies, List<Dependency> directDependencies, AtomDependency baseAtom) {
        this.dependencyMap = ImmutableMap.copyOf(dependencyMap);
        this.dependencies = ImmutableList.copyOf(dependencies);
        this.mutableDependencyDataMap = mutableDependencyDataMap;
        this.allDependencies = ImmutableList.copyOf(allDependencies);
        this.directDependencies = ImmutableList.copyOf(directDependencies);
        this.baseAtom = baseAtom;
    }

    public static DependencyContainer empty() {
        return EMPTY;
    }

    public ImmutableMap<Object, Dependency> getDependencyMap() {
        return this.dependencyMap;
    }

    public ImmutableList<DependencyNode> getDependencies() {
        return this.dependencies;
    }

    public boolean isSkipped(Dependency dependency) {
        return this.mutableDependencyDataMap.isSkipped(dependency);
    }

    public boolean isProvided(Dependency dependency) {
        return this.mutableDependencyDataMap.isProvided(dependency);
    }

    public List<String> getProvidedList() {
        return this.mutableDependencyDataMap.getProvidedList();
    }

    public List<String> getSkippedList() {
        return this.mutableDependencyDataMap.getSkippedList();
    }

    public ImmutableList<Dependency> getAllDependencies() {
        return this.allDependencies;
    }

    public ImmutableList<Dependency> getAllPackagedDependencies() {
        if (this.allPackagedDependencies == null) {
            this.allPackagedDependencies = ImmutableList.copyOf((Collection)this.allDependencies.stream().filter(it -> !(it instanceof AtomDependency)).collect(Collectors.toCollection(() -> new ArrayList(this.allDependencies.size()))));
        }
        return this.allPackagedDependencies;
    }

    public ImmutableList<JavaDependency> getAllJavaDependencies() {
        if (this.allJavaDependencies == null) {
            this.allJavaDependencies = ImmutableList.copyOf((Collection)this.allDependencies.stream().filter(it -> it instanceof JavaDependency).map(dependency -> (JavaDependency)dependency).collect(Collectors.toCollection(() -> new ArrayList(this.allDependencies.size()))));
        }
        return this.allJavaDependencies;
    }

    public ImmutableList<AndroidDependency> getAllAndroidDependencies() {
        if (this.allAndroidDependencies == null) {
            this.allAndroidDependencies = ImmutableList.copyOf((Collection)this.allDependencies.stream().filter(it -> it instanceof AndroidDependency).map(dependency -> (AndroidDependency)dependency).collect(Collectors.toCollection(() -> new ArrayList(this.allDependencies.size()))));
        }
        return this.allAndroidDependencies;
    }

    public ImmutableList<AtomDependency> getAllAtomDependencies() {
        if (this.allAtomDependencies == null) {
            this.allAtomDependencies = ImmutableList.copyOf((Collection)this.allDependencies.stream().filter(it -> it instanceof AtomDependency).map(dependency -> (AtomDependency)dependency).collect(Collectors.toCollection(() -> new ArrayList(this.allDependencies.size()))));
        }
        return this.allAtomDependencies;
    }

    public ImmutableList<JavaDependency> getDirectJavaDependencies() {
        if (this.directJavaDependencies == null) {
            this.directJavaDependencies = ImmutableList.copyOf((Collection)this.directDependencies.stream().filter(it -> it instanceof JavaDependency).map(dependency -> (JavaDependency)dependency).collect(Collectors.toCollection(() -> new ArrayList(this.allDependencies.size()))));
        }
        return this.directJavaDependencies;
    }

    public ImmutableList<JavaDependency> getDirectLocalJavaDependencies() {
        if (this.directLocalJavaDependencies == null) {
            this.directLocalJavaDependencies = ImmutableList.copyOf((Collection)this.getDirectJavaDependencies().stream().filter(JavaDependency::isLocal).collect(Collectors.toCollection(() -> new ArrayList(this.allDependencies.size()))));
        }
        return this.directLocalJavaDependencies;
    }

    public ImmutableList<AndroidDependency> getDirectAndroidDependencies() {
        if (this.directAndroidDependencies == null) {
            this.directAndroidDependencies = ImmutableList.copyOf((Collection)this.directDependencies.stream().filter(it -> it instanceof AndroidDependency).map(dependency -> (AndroidDependency)dependency).collect(Collectors.toCollection(() -> new ArrayList(this.allDependencies.size()))));
        }
        return this.directAndroidDependencies;
    }

    public ImmutableList<AtomDependency> getDirectAtomDependencies() {
        if (this.directAtomDependencies == null) {
            this.directAtomDependencies = ImmutableList.copyOf((Collection)this.directDependencies.stream().filter(it -> it instanceof AtomDependency).map(dependency -> (AtomDependency)dependency).collect(Collectors.toCollection(() -> new ArrayList(this.allDependencies.size()))));
        }
        return this.directAtomDependencies;
    }

    public AtomDependency getBaseAtom() {
        return this.baseAtom;
    }
}

